/*
# PostgreSQL Database Modeler (pgModeler)
#
# Copyright 2006-2021 - Raphael Araújo e Silva <raphael@pgmodeler.io>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3.
#
# This program is distributed in the hope that it will be useful),
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# The complete text of GPLv3 is at LICENSE file on source code root directory.
# Also), you can get the complete GNU General Public License at <http://www.gnu.org/licenses/>
*/

#include "attributes.h"

namespace Attributes {
	const QString
	Action("action"),
	ActiveLayers("active-layers"),
	AdminOption("admin-option"),
	AdminRoles("admin-roles"),
	Alias("alias"),
	Alignment("alignment"),
	AlignObjsToGrid("align-objs-to-grid"),
	AllowConns("allow-conns"),
	AllVersions("all"),
	AlterCmds("alter-cmds"),
	AnalyzeFunc("analyze"),
	AncestorTable("ancestor-table"),
	AppendAtEod("append-at-eod"),
	AppendedSql("appended-sql"),
	Application("application"),
	ApplyOnServer="apply-on-server",
	ArgCount("arg-count"),
	ArgDefaults("arg-defaults"),
	ArgDefCount("arg-def-count"),
	ArgModes("arg-modes"),
	ArgNames("arg-names"),
	ArgTypes("arg-types"),
	Arguments("arguments"),
	AscOrder("asc-order"),
	Assignment("assignment"),
	AttribsPage("attribs-page"),
	AttribsPerPage("attribs-per-page"),
	Attribute("attribute"),
	AutoBrowseDb("auto-browse-db"),
	AutoSaveInterval("autosave-interval"),
	BackgroundColor("background-color"),
	BaseType("base"),
	Before("before"),
	BehaviorType("behavior-type"),
	Bold("bold"),
	BorderColor("border-color"),
	Bottom("bottom"),
	Buffering("buffering"),
	BypassRls("bypassrls"),
	ByValue("by-value"),
	Cache("cache"),
	CanonicalFunc("canonical"),
	CanvasColor("canvas-color"),
	CanvasCornerMove("canvas-corner-move"),
	CaptureNearby("capture-nearby"),
	Cascade("cascade"),
	CaseSensitive("case-sensitive"),
	CastType("cast-type"),
	Category("category"),
	Change("change"),
	Changelog("changelog"),
	CheckExp("check-exp"),
	CheckUpdate("check-update"),
	CheckVersions("check-versions"),
	CkConstr("ck-constr"),
	ClientEncoding("client-encoding"),
	CodeCompletion("code-completion"),
	CodeFont("code-font"),
	CodeFontSize("code-font-size"),
	CodeTabWidth("code-tab-width"),
	ColIndexes("col-indexes"),
	ColIsIdentity("col-is-identity"),
	CollapseMode("collapse-mode"),
	Collatable("collatable"),
	Collation("collation"),
	Collations("collations"),
	Color("color"),
	Colors("colors"),
	ColsComment("cols-comment"),
	Column("column"),
	ColumnAlias("column-alias"),
	Columns("columns"),
	Command("command"),
	Commands("commands"),
	Comment("comment"),
	CommutatorOp("commutator-op"),
	CompactView("compact-view"),
	CompareToDatabase="compare-to-db",
	ComparisonType("comparison-type"),
	CompletionTrigger("completion-trigger"),
	CompositeType("composite"),
	Concurrent("concurrent"),
	Condition("condition"),
	ConfigFile("config-file"),
	ConfigParam("confparam"),
	ConfigParams("config-params"),
	Configuration("configuration"),
	ConfirmValidation("confirm-validation"),
	ConnectCenterPnts("center-pnts"),
	ConnectFkToPk("fk-to-pk"),
	Connection("connection"),
	Connections("connections"),
	ConnectionTimeout("connection-timeout"),
	ConnectPriv("connect"),
	ConnectTableEdges("table-edges"),
	ConnLimit("connlimit"),
	Constraint("constraint"),
	Constraints("constraints"),
	ConstrDefs("constr-defs"),
	ConstrIndexes("constr-indexes"),
	ConstrSqlDisabled("constr-sql-disabled"),
	Contents("contents"),
	CopyMode("copy-mode"),
	CopyOptions("copy-options"),
	CopyTable("copy-table"),
	Create("create"),
	CreateCmds("create-cmds"),
	Created("created"),
	CreateDb("createdb"),
	CreatePriv("create"),
	CreateRole("createrole"),
	CrowsFoot("crows-foot"),
	CteExpression("cte-exp"),
	CurIdentityType("cur-identity-type"),
	CurrentModel="current-model",
	CurVersion("cur-version"),
	CustomColor("custom-color"),
	CustomFilter("custom-filter"),
	CustomIdxs("customidxs"),
	Cycle("cycle"),
	Database("database"),
	DataDirectory("data-directory"),
	Date("date"),
	DbModel("dbmodel"),
	DdlEndToken("-- ddl-end --"),
	DeadRowsAmount("dead-rows-amount"),
	Declaration("declaration"),
	DeclInTable("decl-in-table"),
	Default("default"),
	DefaultCollation("default-collation"),
	DefaultForOps("default-for-ops"),
	DefaultOwner("default-owner"),
	DefaultSchema("default-schema"),
	DefaultTablespace("default-tablespace"),
	DefaultValue("default-value"),
	Deferrable("deferrable"),
	DeferType("defer-type"),
	Definition("definition"),
	DelAction("del-action"),
	Deleted("deleted"),
	DeletePriv("delete"),
	DelEvent("del-event"),
	Delimiter("delimiter"),
	DelimitersColor("delimiters-color"),
	DestType("destiny-type"),
	Deterministic("deterministic"),
	Diff("diff"),
	Dimension("dimension"),
	Directory("directory"),
	DisableSmoothness("disable-smoothness"),
	DisplayLineNumbers("display-line-numbers"),
	DockWidgets("dock-widgets"),
	DomConstraint("domconstraint"),
	DontDropMissingObjs="dont-drop-missing-objs",
	Drop("drop"),
	DropCmds("drop-cmds"),
	DropMissingColsConstrs="drop-missing-cols-constrs",
	DropTruncCascade="drop-trunc-cascade",
	DstColPattern("dst-col-pattern"),
	DstColumns("dst-columns"),
	DstEncoding("dst-encoding"),
	DstFkPattern("dst-fk-pattern"),
	DstLabel("dst-label"),
	DstRequired("dst-required"),
	DstTable("dst-table"),
	DstType("dst-type"),
	DynamicLibraryPath("dynamic-library-path"),
	DynamicSharedMemory("dynamic-shared-memory-type"),
	Element("element"),
	Elements("elements"),
	ElementsCount("elements-count"),
	EmptyPassword("empty-password"),
	Encoding("encoding"),
	Encrypted("encrypted"),
	EndExp("end-exp"),
	EnumType("enumeration"),
	Entry("entry"),
	EscapeComment("escape-comment"),
	Event("event"),
	Events("events"),
	EventType("event-type"),
	ExactMatch("exact-match"),
	ExcBuiltinArrays("exc-builtin-arrays"),
	ExcludeElement("excelement"),
	ExConstr("ex-constr"),
	ExecType("exec-type"),
	ExecutionCost("execution-cost"),
	ExecutPriv("execute"),
	ExistingValue("existing-value"),
	Explicit("explicit"),
	Export("export"),
	ExportToFile("export-to-file"),
	Expression("expression"),
	Expressions("expressions"),
	ExtAttribsPage("ext-attribs-page"),
	ExtAttribsPerPage("ext-attribs-per-page"),
	ExtObjOids("ext-obj-oids"),
	ExtraCondition("extra-condition"),
	Factor("factor"),
	FadedOut("faded-out"),
	FadeInObjects("fadein-objects"),
	False("false"),
	Family("family"),
	FastUpdate("fast-update"),
	Fdw("fdw"),
	File("file"),
	FileAssociated("file-associated"),
	FillColor("fill-color"),
	Filter("filter"),
	FilterOids("filter-oids"),
	FilterTableTypes("filter-tab-types"),
	FinalFunc("final"),
	FiringType("firing-type"),
	FkColumn("fk-column"),
	FkConstr("fk-constr"),
	FkDefs("fk-defs"),
	Font("font"),
	FontSize("font-size"),
	ForceObjsRecreation="force-objs-recreation",
	ForegroundColor("foreground-color"),
	ForeignKeys("foreign-keys"),
	ForeignTableTogglerButtons("foreigntable-toggler-btns"),
	ForeignTableTogglerBody("foreigntable-toggler-body"),
	ForeignTableBody("foreigntable-body"),
	ForeignTableExtBody("foreigntable-ext-body"),
	ForeignTableName("foreigntable-name"),
	ForeignTableSchemaName("foreigntable-schema-name"),
	ForeignTableTitle("foreigntable-title"),
	FormatName("format-name"),
	FromExp("from-exp"),
	FromSqlFunc("fromsql"),
	Function("function"),
	FunctionType("function-type"),
	GenAlterCmds("gen-alter-cmds"),
	General("general"),
	Generated("generated"),
	Global("global"),
	GrantOp("grant-op"),
	GridSize("grid-size"),
	GridColor("grid-color"),
	Group("group"),
	HandlerFunc("handler"),
	HandlesType("handles-type"),
	HasChanges("has-changes"),
	Hashes("hashes"),
	HbaFile("hba-file"),
	Height("height"),
	HideExtAttribs("hide-ext-attribs"),
	HideRelName("hide-rel-name"),
	HideSchNameUserTypes("hide-schema-names-of-types"),
	HideTableTags("hide-table-tags"),
	HighlightLines("highlight-lines"),
	HighlightOrder("highlight-order"),
	HistoryMaxLength("history-max-length"),
	Icon("icon"),
	Id("id"),
	IdentFile("ident-file"),
	Identifier("identifier"),
	IdentityType("identity-type"),
	IgnoredChars("ignored-chars"),
	IgnoreDuplicErrors="ignore-duplic-errors",
	IgnoreErrorCodes="ignore-error-codes",
	IgnoreImportErrors="ignore-import-errors",
	Implicit("implicit"),
	Import("import"),
	ImportExtObjs="import-ext-objs",
	ImportSysObjs="import-sys-objs",
	Increment("increment"),
	Index("index"),	
	IndexElement("idxelement"),
	Indexes("indexes"),
	IndexType("index-type"),
	Info("info"),
	IncludedCols("include-cols"),
	InhColumn("inh-column"),
	InhColumns("inh-columns"),
	Inherit("inherit"),
	Inherited("inherited"),
	InitialCond("initial-cond"),
	InitialData("initial-data"),
	InitialExp("initial-exp"),
	InlineFunc("inline"),
	InputDatabase="input-db",
	InputFunc("input"),
	InsertPriv("insert"),
	InsEvent("ins-event"),
	InternalLength("internal-length"),
	IntervalType("interval-type"),
	InvertRangeSelTrigger("invert-rangesel-trigger"),
	IoCast("io-cast"),
	IsPartitioned("is-partitioned"),
	IsTemplate("is-template"),
	Italic("italic"),
	Item("item"),
	Items("items"),
	JoinFunc("join"),
	KeepClusterObjs="keep-cluster-objs",
	KeepObjsPerms="keep-objs-perms",
	Label("label"),
	Labels("labels"),
	LabelsPos("labels-pos"),
	Landscape("landscape"),
	Language("language"),
	LastAnalyze("last-analyze"),
	LastAutovacuum("last-autovacuum"),
	LastPosition("last-position"),
	LastSysOid("last-sys-oid"),
	LastVacuum("last-vacuum"),
	LastValue("last-value"),
	LastZoom("last-zoom"),
	Layer("layer"),
	LayerNameColors("layer-name-colors"),
	LayerRectColors("layer-rect-colors"),
	Layers("layers"),
	LcCollate("lc-collate"),
	LcCtype("lc-ctype"),
	LcCollateMod("lc-collate-mod"),
	LcCtypeMod("lc-ctype-mod"),
	LeakProof("leakproof"),
	Left("left"),
	LeftType("left-type"),
	Length("length"),
	Library("library"),
	LikeType("like-type"),
	Line("line"),
	LineHighlightColor("line-highlight-color"),
	LineNumbersBgColor("line-numbers-bg-color"),
	LineNumbersColor("line-numbers-color"),
	Link("link"),
	ListenAddresses("listen-addresses"),
	Locale("locale"),
	LocaleMod("locale-mod"),
	LockerArc("locker-arc"),
	LockerBody("locker-body"),
	Login("login"),
	LookaheadChar("lookahead-char"),
	LowVerbosity("low-verbosity"),
	Materialized("materialized"),
	MaxConnections("max-connections"),
	Maximized("maximized"),
	MaxObjCount("max-obj-count"),
	MaxValue("max-value"),
	Member("member"),
	MemberRoles("member-roles"),
	Merges("merges"),
	Metadata("metadata"),
	MinObjectOpacity("min-object-opacity"),
	MinValue("min-value"),
	Mode("mode"),
	ModelAuthor("author"),
	Name("name"),
	NameFilter("name-filter"),
	NameLabel("name-label"),
	NamePatterns("name-patterns"),
	Names("names"),
	NegatorOp("negator-op"),
	NewIdentityType("new-identity-type"),
	NewName("new-name"),
	NewTableName("new-table-name"),
	NewVersion("new-version"),
	Next("next"),
	NnColumn("nn-column"),
	NoInherit("no-inherit"),
	None("none"),
	NotExtObject("not-ext-object"),
	NotNull("not-null"),
	NullsFirst("nulls-first"),
	Object("object"),
	ObjectFinder("objectfinder"),
	ObjectId("object-id"),
	Objects("objects"),
	ObjectType("object-type"),
	ObjCount("objcount"),
	ObjSelection("obj-selection"),
	Oid("oid"),
	OidFilterOp("oid-filter-op"),
	Oids("oids"),
	OldName("old-name"),
	OldTableName("old-table-name"),
	OldVersion("old-version"),
	OpClass("opclass"),
	OpClasses("opclasses"),
	Operator("operator"),
	OperatorFunc("operfunc"),
	Operators("operators"),
	OpFamily("opfamily"),
	OpListSize("op-list-size"),
	Options("options"),
	OriginalPk("original-pk"),
	OutputFunc("output"),
	Owner("owner"),
	OwnerColumn("owner-col"),
	Pagination("pagination"),
	PaperCustomSize("paper-custom-size"),
	PaperMargin("paper-margin"),
	PaperOrientation("paper-orientation"),
	PaperType("paper-type"),
	ParallelType("parallel-type"),
	Parameter("parameter"),
	Parameters("parameters"),
	ParamIn("in"),
	ParamOut("out"),
	ParamVariadic("variadic"),
	Parent("parent"),
	ParentType("parent-type"),
	Parents("parents"),
	Parsable("parsable"),
	PartialMatch("partial-match"),
	PartitionBoundExpr("partition-bound-expr"),
	PartitionedTable("partitioned-table"),
	PartitionTables("partition-tables"),
	Partitioning("partitioning"),
	PartitionKey("partitionkey"),
	PartKeyColls("part-key-colls"),
	PartKeyCols("part-key-cols"),
	PartKeyExprs("part-key-exprs"),
	PartKeyOpCls("part-key-opcls"),
	Password("password"),
	PasswordEncryption("password-encryption"),
	Path("path"),
	Patterns("patterns"),
	Permission("permission"),
	Permissive("permissive"),
	PerRow("per-line"),
	PgModelerVersion("pgmodeler-ver"),
	PgSqlBaseType("basetype"),
	PgSqlVersion("pgsql-ver"),
	PkColPattern("pk-col-pattern"),
	PkColumn("pk-column"),
	PkConstr("pk-constr"),
	PkPattern("pk-pattern"),
	Placeholder("placeholder"),
	Placeholders("placeholders"),
	Points("points"),
	Port("port"),
	Portrait("portrait"),
	Position("position"),
	PositionInfo("pos-info"),
	Precision("precision"),
	Predicate("predicate"),
	Preferred("preferred"),
	PrependAtBod("prepend-at-bod"),
	PrependedSql("prepended-sql"),
	PreserveDbName("preserve-db-name"),
	PrependSchema("prepend-schema"),
	Preset("preset"),
	Previous("previous"),
	PrintGrid("print-grid"),
	PrintPgNum("print-pg-num"),
	Privileges("privileges"),
	PrivilegesGop("privileges-gop"),
	ProtColumn("prot-column"),
	Protected("protected"),
	Provider("provider"),
	RangeAttribs("range-attribs"),
	RangeType("range"),
	Recent("recent"),
	RecentModels("recent-models"),
	RecreateUnmodObjs="recreate-unmod-objs",
	RectVisible("rect-visible"),
	Recursive("recursive"),
	RecvFunc("receive"),
	ReducedForm("reduced-form"),
	RefAlias("ref-alias"),
	RefColumn("ref-column"),
	RefColumns("ref-columns"),
	Refer("refer"),
	Reference("reference"),
	ReferenceFk("reference-fk"),
	References("references"),
	ReferencesPriv("references"),
	Referrers("referrers"),
	RefName("ref-name"),
	RefTable("ref-table"),
	RefTables("ref-tables"),
	RefTableTag("reftable"),
	RefType("ref-type"),
	RegularExp("regexp"),
	RelatedForeignKey("related-foreign-key"),
	Relationship("relationship"),
	Relationship11("rel11"),
	Relationship1n("rel1n"),
	RelationshipDep("reldep"),
	RelationshipFk("relfk"),
	RelationshipGen("relgen"),
	RelationshipNn("relnn"),
	RelationshipPart("relpart"),
	RelationshipTabView("reltv"),
	Rename("rename"),
	Replication("replication"),
	RestartSeq("restart-seq"),
	RestrictionFunc("restriction"),
	ReturnsSetOf("returns-setof"),
	ReturnTable("return-table"),
	ReturnType("return-type"),
	ReuseSequences("reuse-sequences"),
	Revoke("revoke"),
	Right("right"),
	RightType("right-type"),
	RlsEnabled("rls-enabled"),
	RlsForced("rls-forced"),
	Role("role"),
	Roles("roles"),
	RoleMembers("rolemembers"),
	RoleType("role-type"),
	RowAmount("row-amount"),
	Rules("rules"),
	SaveLastPosition("save-last-position"),
	SaveRestoreGeometry("save-restore-geometry"),
	Schema("schema"),
	SchemaOid("schema-oid"),
	SearchPath("search-path"),
	SecurityType("security-type"),
	SelectExp("select-exp"),
	SelectObjects("select-objects"),
	SelectPriv("select"),
	SendFunc("send"),
	Sequence("sequence"),
	Server("server"),
	ServerEncoding("server-encoding"),
	ServerPid("server-pid"),
	ServerProtocol("server-protocol"),
	ServerVersion("server-version"),
	SessionOpts("sessionopts"),
	SetPerms("set-perms"),
	SharedObj("shared-obj"),
	ShellTypes("shell-types"),
	ShowAttributesGrid("show-attributes-grid"),
	ShowCanvasGrid("show-canvas-grid"),
	ShowLayerNames("show-layer-names"),
	ShowLayerRects("show-layer-rects"),
	ShowMainMenu("show-main-menu"),
	ShowPageDelimiters("show-page-delimiters"),
	ShowSourcePane("show-source-pane"),
	Signature("signature"),
	SimpleExp("simple-exp"),
	SimplifiedObjCreation("simplified-obj-creation"),
	SinglePkColumn("single-pk-col"),
	Size("size"),
	Snippet("snippet"),
	SortOp("sort-op"),
	SourceEditorApp("source-editor-app"),
	SourceEditorArgs("source-editor-args"),
	SourceType("source-type"),
	SpatialType("spatial-type"),
	SpecialPkCols("special-pk-cols"),
	Split("split"),
	SqlDisabled("sql-disabled"),
	SqlObject("sql-object"),
	SqlTool("sqltool"),
	SqlValidation("sql-validation"),
	SrcColPattern("src-col-pattern"),
	SrcColumns("src-columns"),
	SrcEncoding("src-encoding"),
	SrcFkPattern("src-fk-pattern"),
	SrcLabel("src-label"),
	SrcRequired("src-required"),
	SrcTable("src-table"),
	SrcType("src-type"),
	Srid("srid"),
	Ssl("ssl"),
	SslCaFile("ssl-ca-file"),
	SslCertFile("ssl-cert-file"),
	SslCrlFile("ssl-crl-file"),
	SslKeyFile("ssl-key-file"),
	Start("start"),
	StableBeta("stablebeta"),
	StableOnly("stableonly"),
	StateType("state-type"),
	Storage("storage"),
	StorageParams("stg-params"),
	StoreInFile="store-in-file",
	StrategyNum("stg-number"),
	Stikeout("strikeout"),
	Style("style"),
	Styles("styles"),
	Subtype("subtype"),
	SubtypeDiffFunc("subtypediff"),
	Superuser("superuser"),
	Symbol("symbol"),
	Table("table"),
	TableTogglerButtons("table-toggler-btns"),
	TableTogglerBody("table-toggler-body"),
	TableBody("table-body"),
	TableExtBody("table-ext-body"),
	TableName("table-name"),
	TableObject("table-obj"),
	TableSchemaName("table-schema-name"),
	Tablespace("tablespace"),
	TableTitle("table-title"),
	TableType("table-type"),
	Tag("tag"),
	TemplateDb("template"),
	TemporaryPriv("temporary"),
	Top("top"),
	ToSqlFunc("tosql"),
	TpmodInFunc("tpmodin"),
	TpmodOutFunc("tpmodout"),
	TransformTypes("transform-types"),
	TransitionFunc("transition"),
	TriggerFunc("trigger-func"),
	TriggerPriv("trigger"),
	Triggers("triggers"),
	True("true"),
	Truncate("truncate"),
	TruncatePriv("truncate"),
	TruncEvent("trunc-event"),
	Trusted("trusted"),
	TuplesDel("tuples-del"),
	TuplesIns("tuples-ins"),
	Type("type"),
	TypeAttribute("typeattrib"),
	TypeClass("type-class"),
	TypeOid("type-oid"),
	Types("types"),
	TyplesUpd("tuples-upd"),
	UiLanguage("ui-language"),
	Undefined("undefined"),
	Underline("underline"),
	Unique("unique"),
	Unlogged("unlogged"),
	Unset("unset"),
	UnsetPerms("unset-perms"),
	UpdAction("upd-action"),
	Updated("updated"),
	UpdatePriv("update"),
	UpdEvent("upd-event"),
	UqColumn("uq-column"),
	UqConstr("uq-constr"),
	UqPattern("uq-pattern"),
	UsagePriv("usage"),
	UseChangelog("use-changelog"),
	UseCurvedLines("use-curved-lines"),
	UsePlaceholders("use-placeholders"),
	UseSignature("use-signature"),
	UseSorting("use-sorting"),
	UseUniqueNames("use-unique-names"),
	UsingExp("using-exp"),
	Validation("validation"),
	Validator("validator"),
	ValidatorFunc("validator"),
	Validity("validity"),
	Value("value"),
	Values("values"),
	Variable("variable"),
	Variation("variation"),
	Version("version"),
	ViewTogglerButtons("view-toggler-btns"),
	ViewTogglerBody("view-toggler-body"),
	ViewBody("view-body"),
	ViewExtBody("view-ext-body"),
	ViewName("view-name"),
	ViewSchemaName("view-schema-name"),
	ViewTitle("view-title"),
	Visible("visible"),
	Widget("widget"),
	WidgetsGeometry("widgets-geometry"),
	Width("width"),
	Wildcard("wildcard"),
	WindowFunc("window-func"),
	WithNoData("with-no-data"),
	WithoutOids("without-oids"),
	WithTimezone("with-timezone"),
	WordDelimiters("word-delimiters"),
	WordSeparators("word-separators"),
	WorkingDir("working-dir"),
	XPos("x"),
	YPos("y"),
	Year("year"),
	ZValue("z-value");
}

