/*	Processing_Event

PIRL CVS ID: Processing_Event.java,v 1.9 2012/04/16 06:04:10 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package	PIRL.Conductor;

import	java.util.EventObject;


/**	A <i>Processing_Event</i> is used to notify a Conductor manager
	that a Conductor processing event occured.
<p>
	@author		Bradford Castalia - UA/PIRL
	@version	1.9
	@see		Processing_Changes
*/
public class Processing_Event
	extends EventObject
{
/**	Class identification name with source code version and date.
*/
public static final String
	ID = "PIRL.Conductor.Processing_Event (1.9 2012/04/16 06:04:10)";

/**	The processing changes that have occured as a result of the event.
*/
public Processing_Changes
	Changes;

/*==============================================================================
	Constructors
*/
/**	Constructs a Processing_Event.
<p>
	@param	management	The source Management object where the
		event occurred. This may be a Conductor a proxy - such as a
		Remote_Theater Messenger system - to a Conductor.
	@param	changes	The Conductor Processing_Changes that describes
		the new processing state.
*/
public Processing_Event
	(
	Management			management,
	Processing_Changes	changes
	)
{
super (management);
Changes = changes;
}

}

