/*	Password_Dialog

PIRL CVS ID: Password_Dialog.java,v 1.6 2012/04/16 06:22:59 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

package	PIRL.Viewers;

import	javax.swing.JDialog;
import	javax.swing.JPanel;
import	javax.swing.JPasswordField;
import	javax.swing.JLabel;
import	javax.swing.JButton;
import	javax.swing.Box;
import	java.awt.Frame;
import	java.awt.Container;
import	java.awt.GridBagLayout;
import	java.awt.GridBagConstraints;
import	java.awt.Insets;
import	java.awt.BorderLayout;
import	java.awt.event.ActionListener;
import	java.awt.event.ActionEvent;

/**	A <i>Password_Dialog</i> is a simple dialog box to obtain a password.
<p>
	The dialog box contains a prompt ("Password" by default) preceeding
	a JPasswordField where the password may be entered. Below this is
	a "Cancel" button in the left corner and an "Accept" button in the
	right corner.
<p>
	@author		Bradford Castalia, UA/PIRL
	@version	1.6
*/
public class Password_Dialog
	extends JDialog
{
/**	Class name and version identification.
*/
public static final String
	ID = "PIRL.Viewers.Password_Dialog (1.6 2012/04/16 06:22:59)";

private JPasswordField
	Password_Field				= new JPasswordField ("", 10);

private char[]
	Password					= null;

/*==============================================================================
	Constructors
*/
/**	Constructs a Password_Dialog.
<p>
	@param	title	The title String for the dialog window. If null,
		"Password" will be used by default.
	@param	prompt	The text preceding the password input field. If
		null, "Password" will be used by default.
	@param	parent	The Frame with which the dialog is associated,
		which may be null.
	@param	modal	If true, the dialog will be modal; if false, the
		dialog will not be modal.
*/
public Password_Dialog
	(
	String		title,
	String		prompt,
	Frame		parent,
	boolean		modal
	)
{
super (parent, (title == null ? "Password" : title), modal);

JPanel
	panel = new JPanel (new GridBagLayout ());
GridBagConstraints
	location = new GridBagConstraints ();

if (prompt == null)
	prompt = "Password";
location.anchor		= GridBagConstraints.EAST;
location.fill		= GridBagConstraints.NONE;
location.insets		= new Insets (10, 10, 0, 5);
panel.add (new JLabel(prompt + ':'), location);

location.gridwidth	= GridBagConstraints.REMAINDER;
location.fill		= GridBagConstraints.HORIZONTAL;
location.weightx	= 1.0;
location.insets		= new Insets (10, 0, 0, 10);
panel.add (Password_Field, location);

JPanel
	button_panel = new JPanel (new GridBagLayout ());
JButton
	button;
button				= new JButton ("Cancel");
button.setMnemonic ('C');
button.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event)
		{Accept (false);}});
location.anchor		= GridBagConstraints.WEST;
location.fill		= GridBagConstraints.NONE;
location.gridwidth	= 1;
location.weightx	= 0.0;
location.insets		= new Insets (0, 0, 0, 0);
button_panel.add (button, location);

location.anchor		= GridBagConstraints.CENTER;
location.fill		= GridBagConstraints.HORIZONTAL;
location.weightx	= 1.0;
button_panel.add (Box.createHorizontalGlue (), location);

button				= new JButton ("Accept");
button.setMnemonic ('A');
button.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event)
		{Accept (true);}});
button.setDefaultCapable (true);
getRootPane ().setDefaultButton (button);
location.anchor		= GridBagConstraints.EAST;
location.fill		= GridBagConstraints.NONE;
location.gridwidth	= GridBagConstraints.REMAINDER;
location.weightx	= 0.0;
button_panel.add (button, location);

location.anchor		= GridBagConstraints.CENTER;
location.fill		= GridBagConstraints.HORIZONTAL;
location.weightx	= 1.0;
location.insets		= new Insets (10, 10, 10, 10);
panel.add (button_panel, location);

getContentPane ().add (panel, BorderLayout.CENTER);
pack ();
}

/**	Constructs a modal Password_Dialog with the default prompt
	and no parent.
<p>
	@param	title	The title String for the dialog window. If null,
		"Password" will be used by default.
*/
public Password_Dialog
	(
	String		title
	)
{this (title, null, null, true);}

/**	Constructs a modal Password_Dialog with no parent.
<p>
	The dialog will have no parent and will be modal.
<p>
	@param	title	The title String for the dialog window. If null,
		"Password" will be used by default.
	@param	prompt	The text preceding the password input field. If
		null, "Password" will be used by default.
*/
public Password_Dialog
	(
	String		title,
	String		prompt
	)
{this (title, prompt, null, true);}

/**	Constructs a modal Password_Dialog.
<p>
	@param	title	The title String for the dialog window. If null,
		"Password" will be used by default.
	@param	prompt	The text preceding the password input field. If
		null, "Password" will be used by default.
	@param	parent	The Frame with which the dialog is associated,
		which may be null.
*/
public Password_Dialog
	(
	String		title,
	String		prompt,
	Frame		parent
	)
{this (title, prompt, parent, true);}

/**	Constructs a Password_Dialog with no parent.
<p>
	@param	title	The title String for the dialog window. If null,
		"Password" will be used by default.
	@param	prompt	The text preceding the password input field. If
		null, "Password" will be used by default.
	@param	modal	If true, the dialog will be modal; if false, the
		dialog will not be modal.
*/
public Password_Dialog
	(
	String		title,
	String		prompt,
	boolean		modal
	)
{this (title, prompt, null, modal);}

/*==============================================================================
	Static use.
*/
public static String Get_Password
	(
	String		title,
	String		prompt,
	Frame		parent
	)
{
final Password_Dialog
	password_dialog = new Password_Dialog
		(title, prompt, parent);
password_dialog.setVisible (true);

char[]
	password = password_dialog.Password ();
String
	password_string = null;
if (password != null)
	{
	password_string = new String (password);
	password_dialog.Erase_Password ();
	}
password_dialog.setVisible (false);
return password_string;
}

/*==============================================================================
	Action
*/
private void Accept
	(
	boolean	accepted
	)
{
if (accepted)
	Password = Password_Field.getPassword ();
else
	Password = null;
setVisible (false);
}

/*==============================================================================
	Accessors
*/
/**	Get the password.
<p>
	For improved password security {@link #Erase_Password() erase} the
	password after it has been used.
<p>
	@return	A char array containing the password characters. This will be
		null if the Cancel button was pressed the last time the dialog
		was used, or if the password has been (@link #Erase_Password()
		erased}.
*/
public char[] Password ()
{return Password;}

/**	Erase the stored password.
<p>
	The password stored in the dialog is obliterated.
*/
public void Erase_Password ()
{
if (Password != null)
	for (int
			index = 0;
			index < Password.length;
			index++)
		Password[index] = 0;
Password = null;
}


}
