/*
 * This file is part of the planetblupi source code
 * Copyright (C) 1997, Daniel Roux & EPSITEC SA
 * Copyright (C) 2017, Mathieu Schroeter
 * https://epsitec.ch; https://www.blupi.org; https://github.com/blupi-games
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://gnu.org/licenses
 */

#include <stdio.h>
#include <stdlib.h>

#include "action.h"
#include "def.h"
#include "misc.h"

#define MAXICON (1 + 50)
#define MAXMOVE (2 + 30 * 3)
#define MAXSOUND (1 + 50)

struct DescAction {
  Sint16 action;
  Sint16 channel;
  Sint16 icons[8][MAXICON]; // nb, icones,
  Sint16 moves[8][MAXMOVE]; // nb, nb, x,y,
  Sint16 sounds[MAXSOUND];  // nb, sons,
};

// clang-format off
static const DescAction action_table[] =
{
    {
        ACTION_STOP,
        CHBLUPI,
        {
            {1, 48},    // e
            {1, 49},    // se
            {1, 50},    // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_STOPTIRED,
        CHBLUPI,
        {
            {1, 69},    // e
            {1, 72},    // se
            {1, 75},    // s
            {1, 78},    // so
            {1, 81},    // o
            {1, 84},    // no
            {1, 87},    // n
            {1, 90},    // ne
        },
        {
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_STOPb,
        CHBLUPI,
        {
            {1, 48},    // e
            {1, 49},    // se
            {1, 50},    // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
            {   10, 10, 0, 0, +1, 0, 0, +1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0
            },
            {   10, 10, 0, 0, +1, 0, 0, +1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0
            },
            {   10, 10, 0, 0, +1, 0, 0, +1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0
            },
            {   10, 10, 0, 0, +1, 0, 0, +1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0
            },
            {   10, 10, 0, 0, +1, 0, 0, +1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0
            },
            {   10, 10, 0, 0, +1, 0, 0, +1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0
            },
            {   10, 10, 0, 0, +1, 0, 0, +1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0
            },
            {   10, 10, 0, 0, +1, 0, 0, +1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0
            },
        },
        {0},
    },
    {
        ACTION_STOPJEEP,
        CHBLUPI,
        {
            {1, 48},    // e
            {1, 49},    // se
            {1, 50},    // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_STOPARMOR,
        CHBLUPI,
        {
            {1, 322},   // e
            {1, 325},   // se
            {1, 328},   // s
            {1, 331},   // so
            {1, 334},   // o
            {1, 337},   // no
            {1, 340},   // n
            {1, 343},   // ne
        },
        {
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_ENERGY,
        CHBLUPI,
        {
            {1, 48},    // e
            {1, 49},    // se
            {1, 50},    // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
            {2, 2, 0, 0, -2, 0, 0, +2},
            {2, 2, 0, 0, -2, 0, 0, +2},
            {2, 2, 0, 0, -2, 0, 0, +2},
            {2, 2, 0, 0, -2, 0, 0, +2},
            {2, 2, 0, 0, -2, 0, 0, +2},
            {2, 2, 0, 0, -2, 0, 0, +2},
            {2, 2, 0, 0, -2, 0, 0, +2},
            {2, 2, 0, 0, -2, 0, 0, +2},
        },
        {0},
    },
    {
        ACTION_WALK,
        CHBLUPI,
        {
            {6, 0, 1, 2, 3, 4, 5},      // e
            {6, 6, 7, 8, 9, 10, 11},    // se
            {6, 12, 13, 14, 15, 16, 17}, // s
            {6, 18, 19, 20, 21, 22, 23}, // so
            {6, 24, 25, 26, 27, 28, 29}, // o
            {6, 30, 31, 32, 33, 34, 35}, // no
            {6, 36, 37, 38, 39, 40, 41}, // n
            {6, 42, 43, 44, 45, 46, 47}, // ne
        },
        {
#if 1
            {10, 1, +300, +150, 0},     // e
            {15, 1,    0, +200, 0},     // se
            {10, 1, -300, +150, 0},     // s
            {15, 1, -400,   0, 0},      // so
            {10, 1, -300, -150, 0},     // o
            {15, 1,    0, -200, 0},     // no
            {10, 1, +300, -150, 0},     // n
            {15, 1, +400,   0, 0},      // ne
#else
            {15, 1, +200, +100, 0},     // e
            {20, 1,    0, +150, 0},     // se
            {15, 1, -200, +100, 0},     // s
            {20, 1, -300,   0, 0},      // so
            {15, 1, -200, -100, 0},     // o
            {20, 1,    0, -150, 0},     // no
            {15, 1, +200, -100, 0},     // n
            {20, 1, +300,   0, 0},      // ne
#endif
        },
        {0},
    },
    {
        ACTION_WALKTIRED,
        CHBLUPI,
        {
            {8, 69, 69, 70, 70, 69, 69, 71, 71}, // e
            {8, 72, 72, 73, 73, 72, 72, 74, 74}, // se
            {8, 75, 75, 76, 76, 75, 75, 77, 77}, // s
            {8, 78, 78, 79, 79, 78, 78, 80, 80}, // so
            {8, 81, 81, 82, 82, 81, 81, 83, 83}, // o
            {8, 84, 84, 85, 85, 84, 84, 86, 86}, // no
            {8, 87, 87, 88, 88, 87, 87, 89, 89}, // n
            {8, 90, 90, 91, 91, 90, 90, 92, 92}, // ne
        },
        {
            {20, 2, 0, 0, 0, +300, +150, 0}, // e
            {30, 2, 0, 0, 0,    0, +200, 0}, // se
            {20, 2, 0, 0, 0, -300, +150, 0}, // s
            {30, 2, 0, 0, 0, -400,   0, 0}, // so
            {20, 2, 0, 0, 0, -300, -150, 0}, // o
            {30, 2, 0, 0, 0,    0, -200, 0}, // no
            {20, 2, 0, 0, 0, +300, -150, 0}, // n
            {30, 2, 0, 0, 0, +400,   0, 0}, // ne
        },
        {0},
    },
    {
        ACTION_MARCHEb,
        CHBLUPI,
        {
            {1, 48},    // e
            {1, 49},    // se
            {1, 50},    // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
#if 0
            {   20, 10, +150, +75, +1, +150, +75, +1, +150, +75, +1,
                +150, +75, 0, +150, +75, 0, +150, +75, 0, +150, +75, 0,
                +150, +75, -1, +150, +75, -1, +150, +75, -1
            },
            {   30, 10, 0, +100, +1, 0, +100, +1, 0, +100, +1,
                0, +100, 0, 0, +100, 0, 0, +100, 0, 0, +100, 0,
                0, +100, -1, 0, +100, -1, 0, +100, -1
            },
            {   20, 10, -150, +75, +1, -150, +75, +1, -150, +75, +1,
                -150, +75, 0, -150, +75, 0, -150, +75, 0, -150, +75, 0,
                -150, +75, -1, -150, +75, -1, -150, +75, -1
            },
            {   30, 10, -200, 0, +1, -200, 0, +1, -200, 0, +1,
                -200, 0, 0, -200, 0, 0, -200, 0, 0, -200, 0, 0,
                -200, 0, -1, -200, 0, -1, -200, 0, -1
            },
            {   20, 10, -150, -75, +1, -150, -75, +1, -150, -75, +1,
                -150, -75, 0, -150, -75, 0, -150, -75, 0, -150, -75, 0,
                -150, -75, -1, -150, -75, -1, -150, -75, -1
            },
            {   30, 10, 0, -100, +1, 0, -100, +1, 0, -100, +1,
                0, -100, 0, 0, -100, 0, 0, -100, 0, 0, -100, 0,
                0, -100, -1, 0, -100, -1, 0, -100, -1
            },
            {   20, 10, +150, -75, +1, +150, -75, +1, +150, -75, +1,
                +150, -75, 0, +150, -75, 0, +150, -75, 0, +150, -75, 0,
                +150, -75, -1, +150, -75, -1, +150, -75, -1
            },
            {   30, 10, +200, 0, +1, +200, 0, +1, +200, 0, +1,
                +200, 0, 0, +200, 0, 0, +200, 0, 0, +200, 0, 0,
                +200, 0, -1, +200, 0, -1, +200, 0, -1
            },
#else
            { 5, 5, +600, +300, +1, +600, +300, +1, +600, +300, 0, +600, +300, -1, +600, +300, -1},
            {10, 5,    0, +300, +1,    0, +300, +1,    0, +300, 0,    0, +300, -1,    0, +300, -1},
            { 5, 5, -600, +300, +1, -600, +300, +1, -600, +300, 0, -600, +300, -1, -600, +300, -1},
            {10, 5, -600,   0, +1, -600,   0, +1, -600,   0, 0, -600,   0, -1, -600,   0, -1},
            { 5, 5, -600, -300, +1, -600, -300, +1, -600, -300, 0, -600, -300, -1, -600, -300, -1},
            {10, 5,    0, -300, +1,    0, -300, +1,    0, -300, 0,    0, -300, -1,    0, -300, -1},
            { 5, 5, +600, -300, +1, +600, -300, +1, +600, -300, 0, +600, -300, -1, +600, -300, -1},
            {10, 5, +600,   0, +1, +600,   0, +1, +600,   0, 0, +600,   0, -1, +600,   0, -1},
#endif
        },
        {   20, -1, -1, SOUND_BOAT, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
        },
    },
    {
        ACTION_WALKJEEP,
        CHBLUPI,
        {
            {1, 48},    // e
            {1, 49},    // se
            {1, 50},    // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
            {5, 1, +600, +300, 0},
            {7, 1,    0, +429, 0},
            {5, 1, -600, +300, 0},
            {7, 1, -858,   0, 0},
            {5, 1, -600, -300, 0},
            {7, 1,    0, -429, 0},
            {5, 1, +600, -300, 0},
            {7, 1, +858,   0, 0},
        },
        {   20, -1, -1, SOUND_JEEP, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
        },
    },
    {
        ACTION_WALKARMOR,
        CHBLUPI,
        {
            {8, 322, 322, 323, 323, 322, 322, 324, 324}, // e
            {8, 325, 325, 326, 326, 325, 325, 327, 327}, // se
            {8, 328, 328, 329, 329, 328, 328, 330, 330}, // s
            {8, 331, 331, 332, 332, 331, 331, 333, 333}, // so
            {8, 334, 334, 335, 335, 334, 334, 336, 336}, // o
            {8, 337, 337, 338, 338, 337, 337, 339, 339}, // no
            {8, 340, 340, 341, 341, 340, 340, 342, 342}, // n
            {8, 343, 343, 344, 344, 343, 343, 345, 345}, // ne
        },
        {
            {10, 2, 0, 0, 0, +600, +300, 0}, // e
            {16, 2, 0, 0, 0,    0, +375, 0}, // se
            {10, 2, 0, 0, 0, -600, +300, 0}, // s
            {16, 2, 0, 0, 0, -750,   0, 0}, // so
            {10, 2, 0, 0, 0, -600, -300, 0}, // o
            {16, 2, 0, 0, 0,    0, -375, 0}, // no
            {10, 2, 0, 0, 0, +600, -300, 0}, // n
            {16, 2, 0, 0, 0, +750,   0, 0}, // ne
        },
        {0},
    },
    {
        ACTION_JUMPJEEP,
        CHBLUPI,
        {
            {   15, 106, 106, 106, 106, 106, 136, 136, 136, 136, 136,
                136, 106, 106, 106, 106
            },  // e
            {1, 6},         // se
            {   15, 133, 133, 133, 133, 133, 137, 137, 137, 137, 137,
                137, 133, 133, 133, 133
            },  // s
            {1, 18},        // so
            {   15, 134, 134, 134, 134, 134, 138, 138, 138, 138, 138,
                138, 134, 134, 134, 134
            },  // o
            {1, 30},        // no
            {   15, 135, 135, 135, 135, 135, 139, 139, 139, 139, 139,
                139, 135, 135, 135, 135
            },  // n
            {1, 42},        // ne
        },
        {
            {   15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                +300, +150, -5, +300, +150, -5, +300, +150, -5,
                +300, +150, -5, +300, +150, -2,
                +300, +150, +2, +300, +150, +5, +300, +150, +5,
                +300, +150, +5, +300, +150, +5
            },    // e
            {1, 1, 0, 0, 0},    // se
            {   15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                -300, +150, -5, -300, +150, -5, -300, +150, -5,
                -300, +150, -5, -300, +150, -2,
                -300, +150, +2, -300, +150, +5, -300, +150, +5,
                -300, +150, +5, -300, +150, +5
            },    // s
            {1, 1, 0, 0, 0},    // so
            {   15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                -300, -150, -5, -300, -150, -5, -300, -150, -5,
                -300, -150, -5, -300, -150, -2,
                -300, -150, +2, -300, -150, +5, -300, -150, +5,
                -300, -150, +5, -300, -150, +5
            },    // o
            {1, 1, 0, 0, 0},    // no
            {   15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                +300, -150, -5, +300, -150, -5, +300, -150, -5,
                +300, -150, -5, +300, -150, -2,
                +300, -150, +2, +300, -150, +5, +300, -150, +5,
                +300, -150, +5, +300, -150, +5
            },    // n
            {1, 1, 0, 0, 0},    // ne
        },
        {   15, SOUND_HOP, -1, -1, -1,
            SOUND_JUMP, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            SOUND_COUPTOC
        },
    },
    {
        ACTION_JUMP2,
        CHBLUPI,
        {
            {   15, 106, 106, 106, 106, 106, 136, 136, 136, 136, 136,
                136, 106, 106, 106, 106
            },  // e
            {1, 6},         // se
            {   15, 133, 133, 133, 133, 133, 137, 137, 137, 137, 137,
                137, 133, 133, 133, 133
            },  // s
            {1, 18},        // so
            {   15, 134, 134, 134, 134, 134, 138, 138, 138, 138, 138,
                138, 134, 134, 134, 134
            },  // o
            {1, 30},        // no
            {   15, 135, 135, 135, 135, 135, 139, 139, 139, 139, 139,
                139, 135, 135, 135, 135
            },  // n
            {1, 42},        // ne
        },
        {
            {   15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                +600, +300, -5, +600, +300, -5, +600, +300, -5,
                +600, +300, -5, +600, +300, -2,
                +600, +300, +2, +600, +300, +5, +600, +300, +5,
                +600, +300, +5, +600, +300, +5
            },    // e
            {1, 1, 0, 0, 0},    // se
            {   15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                -600, +300, -5, -600, +300, -5, -600, +300, -5,
                -600, +300, -5, -600, +300, -2,
                -600, +300, +2, -600, +300, +5, -600, +300, +5,
                -600, +300, +5, -600, +300, +5
            },    // s
            {1, 1, 0, 0, 0},    // so
            {   15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                -600, -300, -5, -600, -300, -5, -600, -300, -5,
                -600, -300, -5, -600, -300, -2,
                -600, -300, +2, -600, -300, +5, -600, -300, +5,
                -600, -300, +5, -600, -300, +5
            },    // o
            {1, 1, 0, 0, 0},    // no
            {   15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                +600, -300, -5, +600, -300, -5, +600, -300, -5,
                +600, -300, -5, +600, -300, -2,
                +600, -300, +2, +600, -300, +5, +600, -300, +5,
                +600, -300, +5, +600, -300, +5
            },    // n
            {1, 1, 0, 0, 0},    // ne
        },
        {   15, SOUND_HOP, -1, -1, -1,
            SOUND_JUMP, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            SOUND_COUPTOC
        },
    },
    {
        ACTION_JUMP3,
        CHBLUPI,
        {
            {   20, 106, 106, 106, 106, 106, 136, 136, 136, 136, 136,
                136, 136, 136, 136, 136, 136, 106, 106, 106, 106
            },  // e
            {1, 6},         // se
            {   20, 133, 133, 133, 133, 133, 137, 137, 137, 137, 137,
                137, 137, 137, 137, 137, 137, 133, 133, 133, 133
            },  // s
            {1, 18},        // so
            {   20, 134, 134, 134, 134, 134, 138, 138, 138, 138, 138,
                138, 138, 138, 138, 138, 138, 134, 134, 134, 134
            },  // o
            {1, 30},        // no
            {   20, 135, 135, 135, 135, 135, 139, 139, 139, 139, 139,
                139, 139, 139, 139, 139, 139, 135, 135, 135, 135
            },  // n
            {1, 42},        // ne
        },
        {
            {   20, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                +600, +300, -5, +600, +300, -5, +600, +300, -5,
                +600, +300, -5, +600, +300, -5, +600, +300, -5,
                +600, +300, -2, +600, +300, 0, +600, +300, +2,
                +600, +300, +5, +600, +300, +5, +600, +300, +5,
                +600, +300, +5, +600, +300, +5, +600, +300, +5
            },  // e
            {1, 1, 0, 0, 0},    // se
            {   20, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                -600, +300, -5, -600, +300, -5, -600, +300, -5,
                -600, +300, -5, -600, +300, -5, -600, +300, -5,
                -600, +300, -2, -600, +300, 0, -600, +300, +2,
                -600, +300, +5, -600, +300, +5, -600, +300, +5,
                -600, +300, +5, -600, +300, +5, -600, +300, +5
            },  // s
            {1, 1, 0, 0, 0},    // so
            {   20, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                -600, -300, -5, -600, -300, -5, -600, -300, -5,
                -600, -300, -5, -600, -300, -5, -600, -300, -5,
                -600, -300, -2, -600, -300, 0, -600, -300, +2,
                -600, -300, +5, -600, -300, +5, -600, -300, +5,
                -600, -300, +5, -600, -300, +5, -600, -300, +5
            },  // o
            {1, 1, 0, 0, 0},    // no
            {   20, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                +600, -300, -5, +600, -300, -5, +600, -300, -5,
                +600, -300, -5, +600, -300, -5, +600, -300, -5,
                +600, -300, -2, +600, -300, 0, +600, -300, +2,
                +600, -300, +5, +600, -300, +5, +600, -300, +5,
                +600, -300, +5, +600, -300, +5, +600, -300, +5
            },  // n
            {1, 1, 0, 0, 0},    // ne
        },
        {   20, SOUND_HOP, -1, -1, -1,
            SOUND_JUMP, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1,
            SOUND_COUPTOC
        },
    },
    {
        ACTION_JUMP4,
        CHBLUPI,
        {
            {   25, 106, 106, 106, 106, 106, 136, 136, 136, 136, 136,
                136, 136, 136, 136, 136, 136, 136, 136, 136, 136,
                136, 106, 106, 106, 106
            },  // e
            {1, 6},         // se
            {   25, 133, 133, 133, 133, 133, 137, 137, 137, 137, 137,
                137, 137, 137, 137, 137, 137, 137, 137, 137, 137,
                137, 133, 133, 133, 133
            },  // s
            {1, 18},        // so
            {   25, 134, 134, 134, 134, 134, 138, 138, 138, 138, 138,
                138, 138, 138, 138, 138, 138, 138, 138, 138, 138,
                138, 134, 134, 134, 134
            },  // o
            {1, 30},        // no
            {   25, 135, 135, 135, 135, 135, 139, 139, 139, 139, 139,
                139, 139, 139, 139, 139, 139, 139, 139, 139, 139,
                139, 135, 135, 135, 135
            },  // n
            {1, 42},        // ne
        },
        {
            {   25, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                +600, +300, -5, +600, +300, -5, +600, +300, -5,
                +600, +300, -5, +600, +300, -5, +600, +300, -5,
                +600, +300, -5, +600, +300, -5, +600, +300, -5,
                +600, +300, -2, +600, +300, +2,
                +600, +300, +5, +600, +300, +2, +600, +300, +5,
                +600, +300, +5, +600, +300, +5, +600, +300, +5,
                +600, +300, +5, +600, +300, +5, +600, +300, +5
            },  // e
            {1, 1, 0, 0, 0},    // se
            {   25, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                -600, +300, -5, -600, +300, -5, -600, +300, -5,
                -600, +300, -5, -600, +300, -5, -600, +300, -5,
                -600, +300, -5, -600, +300, -5, -600, +300, -5,
                -600, +300, -2, -600, +300, +2,
                -600, +300, +5, -600, +300, +5, -600, +300, +5,
                -600, +300, +5, -600, +300, +5, -600, +300, +5,
                -600, +300, +5, -600, +300, +5, -600, +300, +5
            },  // s
            {1, 1, 0, 0, 0},    // so
            {   25, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                -600, -300, -5, -600, -300, -5, -600, -300, -5,
                -600, -300, -5, -600, -300, -5, -600, -300, -5,
                -600, -300, -5, -600, -300, -5, -600, -300, -5,
                -600, -300, -2, -600, -300, +2,
                -600, -300, +5, -600, -300, +5, -600, -300, +5,
                -600, -300, +5, -600, -300, +5, -600, -300, +5,
                -600, -300, +5, -600, -300, +5, -600, -300, +5
            },  // o
            {1, 1, 0, 0, 0},    // no
            {   25, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                +600, -300, -5, +600, -300, -5, +600, -300, -5,
                +600, -300, -5, +600, -300, -5, +600, -300, -5,
                +600, -300, -5, +600, -300, -5, +600, -300, -5,
                +600, -300, -2, +600, -300, +2,
                +600, -300, +5, +600, -300, +5, +600, -300, +5,
                +600, -300, +5, +600, -300, +5, +600, -300, +5,
                +600, -300, +5, +600, -300, +5, +600, -300, +5
            },  // n
            {1, 1, 0, 0, 0},    // ne
        },
        {   25, SOUND_HOP, -1, -1, -1,
            SOUND_JUMP, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1,
            SOUND_COUPTOC
        },
    },
    {
        ACTION_JUMP5,
        CHBLUPI,
        {
            {   30, 106, 106, 106, 106, 106, 136, 136, 136, 136, 136,
                136, 136, 136, 136, 136, 136, 136, 136, 136, 136,
                136, 136, 136, 136, 136, 136, 106, 106, 106, 106
            },  // e
            {1, 6},         // se
            {   30, 133, 133, 133, 133, 133, 137, 137, 137, 137, 137,
                137, 137, 137, 137, 137, 137, 137, 137, 137, 137,
                137, 137, 137, 137, 137, 137, 133, 133, 133, 133
            },  // s
            {1, 18},        // so
            {   30, 134, 134, 134, 134, 134, 138, 138, 138, 138, 138,
                138, 138, 138, 138, 138, 138, 138, 138, 138, 138,
                138, 138, 138, 138, 138, 138, 134, 134, 134, 134
            },  // o
            {1, 30},        // no
            {   30, 135, 135, 135, 135, 135, 139, 139, 139, 139, 139,
                139, 139, 139, 139, 139, 139, 139, 139, 139, 139,
                139, 139, 139, 139, 139, 139, 135, 135, 135, 135
            },  // n
            {1, 42},        // ne
        },
        {
            {   30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                +600, +300, -5, +600, +300, -5, +600, +300, -5,
                +600, +300, -5, +600, +300, -5, +600, +300, -5,
                +600, +300, -5, +600, +300, -5, +600, +300, -5,
                +600, +300, -5, +600, +300, -2, +600, +300, -2,
                +600, +300, 0, +600, +300, +2, +600, +300, +2,
                +600, +300, +5, +600, +300, +2, +600, +300, +5,
                +600, +300, +5, +600, +300, +5, +600, +300, +5,
                +600, +300, +5, +600, +300, +5, +600, +300, +5,
                +600, +300, +5
            },  // e
            {1, 1, 0, 0, 0},    // se
            {   30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                -600, +300, -5, -600, +300, -5, -600, +300, -5,
                -600, +300, -5, -600, +300, -5, -600, +300, -5,
                -600, +300, -5, -600, +300, -5, -600, +300, -5,
                -600, +300, -5, -600, +300, -2, -600, +300, -2,
                -600, +300, 0, -600, +300, +2, -600, +300, +2,
                -600, +300, +5, -600, +300, +5, -600, +300, +5,
                -600, +300, +5, -600, +300, +5, -600, +300, +5,
                -600, +300, +5, -600, +300, +5, -600, +300, +5,
                -600, +300, +5
            },  // s
            {1, 1, 0, 0, 0},    // so
            {   30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                -600, -300, -5, -600, -300, -5, -600, -300, -5,
                -600, -300, -5, -600, -300, -5, -600, -300, -5,
                -600, -300, -5, -600, -300, -5, -600, -300, -5,
                -600, -300, -5, -600, -300, -2, -600, -300, -2,
                -600, -300, 0, -600, -300, +2, -600, -300, +2,
                -600, -300, +5, -600, -300, +5, -600, -300, +5,
                -600, -300, +5, -600, -300, +5, -600, -300, +5,
                -600, -300, +5, -600, -300, +5, -600, -300, +5,
                -600, -300, +5
            },  // o
            {1, 1, 0, 0, 0},    // no
            {   30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                +600, -300, -5, +600, -300, -5, +600, -300, -5,
                +600, -300, -5, +600, -300, -5, +600, -300, -5,
                +600, -300, -5, +600, -300, -5, +600, -300, -5,
                +600, -300, -5, +600, -300, -2, +600, -300, -2,
                +600, -300, 0, +600, -300, +2, +600, -300, +2,
                +600, -300, +5, +600, -300, +5, +600, -300, +5,
                +600, -300, +5, +600, -300, +5, +600, -300, +5,
                +600, -300, +5, +600, -300, +5, +600, -300, +5,
                +600, -300, +5
            },  // n
            {1, 1, 0, 0, 0},    // ne
        },
        {   30, SOUND_HOP, -1, -1, -1,
            SOUND_JUMP, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1,
            SOUND_COUPTOC
        },
    },
    {
        ACTION_SLIDE,
        CHBLUPI,
        {
            {8, 48, 49, 50, 51, 52, 53, 54, 55}, // e
            {8, 49, 50, 51, 52, 53, 54, 55, 48}, // se
            {8, 50, 51, 52, 53, 54, 55, 48, 49}, // s
            {8, 51, 52, 53, 54, 55, 48, 49, 50}, // so
            {8, 52, 53, 54, 55, 48, 49, 50, 51}, // o
            {8, 53, 54, 55, 48, 49, 50, 51, 52}, // no
            {8, 54, 55, 48, 49, 50, 51, 52, 53}, // n
            {8, 55, 48, 49, 50, 51, 52, 53, 54}, // ne
        },
        {
            {10, 1, +300, +150, 0},     // e
            {15, 1,    0, +200, 0},     // se
            {10, 1, -300, +150, 0},     // s
            {15, 1, -400,   0, 0},      // so
            {10, 1, -300, -150, 0},     // o
            {15, 1,    0, -200, 0},     // no
            {10, 1, +300, -150, 0},     // n
            {15, 1, +400,   0, 0},      // ne
        },
        {0},
    },
    {
        ACTION_BUILD,
        CHBLUPI,
        {
            {1, 100},                   // e
            {1, 100},                   // se
            {4, 103, 104, 105, 105},    // s
            {1, 100},                   // so
            {4, 100, 101, 102, 102},    // o
            {1, 100},                   // no
            {1, 100},                   // n
            {1, 100},                   // ne
        },
        {
            {40, 1, 0, 0, 0},           // e
            {40, 1, 0, 0, 0},           // se
            {40, 1, 0, 0, 0},           // s
            {40, 1, 0, 0, 0},           // so
            {40, 1, 0, 0, 0},           // o
            {40, 1, 0, 0, 0},           // no
            {40, 1, 0, 0, 0},           // n
            {40, 1, 0, 0, 0},           // ne
        },
        {   40, -1, -1, SOUND_COUPTOC, -1, -1, -1, SOUND_COUPTOC, -1,
            -1, -1, SOUND_COUPTOC, -1, -1, -1, SOUND_COUPTOC, -1,
            -1, -1, SOUND_COUPTOC, -1, -1, -1, SOUND_COUPTOC, -1,
            -1, -1, SOUND_COUPTOC, -1, -1, -1, SOUND_COUPTOC, -1,
            -1, -1, SOUND_COUPTOC, -1, -1, -1, SOUND_COUPTOC, -1
        },
    },
    {
        ACTION_BUILDBREF,
        CHBLUPI,
        {
            {1, 100},                   // e
            {1, 100},                   // se
            {4, 103, 104, 105, 105},    // s
            {1, 100},                   // so
            {4, 100, 101, 102, 102},    // o
            {1, 100},                   // no
            {1, 100},                   // n
            {1, 100},                   // ne
        },
        {
            {40, 1, 0, 0, 0},           // e
            {40, 1, 0, 0, 0},           // se
            {40, 1, 0, 0, 0},           // s
            {40, 1, 0, 0, 0},           // so
            {40, 1, 0, 0, 0},           // o
            {40, 1, 0, 0, 0},           // no
            {40, 1, 0, 0, 0},           // n
            {40, 1, 0, 0, 0},           // ne
        },
        {   40, -1, -1, SOUND_COUPBREF, -1, -1, -1, SOUND_COUPBREF, -1,
            -1, -1, SOUND_COUPBREF, -1, -1, -1, SOUND_COUPBREF, -1,
            -1, -1, SOUND_COUPBREF, -1, -1, -1, SOUND_COUPBREF, -1,
            -1, -1, SOUND_COUPBREF, -1, -1, -1, SOUND_COUPBREF, -1,
            -1, -1, SOUND_COUPBREF, -1, -1, -1, SOUND_COUPBREF, -1
        },
    },
    {
        ACTION_BUILDSEC,
        CHBLUPI,
        {
            {1, 100},                   // e
            {1, 100},                   // se
            {4, 103, 104, 105, 105},    // s
            {1, 100},                   // so
            {4, 100, 101, 102, 102},    // o
            {1, 100},                   // no
            {1, 100},                   // n
            {1, 100},                   // ne
        },
        {
            {40, 1, 0, 0, 0},           // e
            {40, 1, 0, 0, 0},           // se
            {40, 1, 0, 0, 0},           // s
            {40, 1, 0, 0, 0},           // so
            {40, 1, 0, 0, 0},           // o
            {40, 1, 0, 0, 0},           // no
            {40, 1, 0, 0, 0},           // n
            {40, 1, 0, 0, 0},           // ne
        },
        {   40, -1, -1, SOUND_COUPSEC, -1, -1, -1, SOUND_COUPSEC2, -1,
            -1, -1, SOUND_COUPSEC, -1, -1, -1, SOUND_COUPSEC2, -1,
            -1, -1, SOUND_COUPSEC, -1, -1, -1, SOUND_COUPSEC2, -1,
            -1, -1, SOUND_COUPSEC, -1, -1, -1, SOUND_COUPSEC2, -1,
            -1, -1, SOUND_COUPSEC, -1, -1, -1, SOUND_COUPSEC2, -1
        },
    },
    {
        ACTION_BUILDSOURD,
        CHBLUPI,
        {
            {1, 100},                   // e
            {1, 100},                   // se
            {4, 103, 104, 105, 105},    // s
            {1, 100},                   // so
            {4, 100, 101, 102, 102},    // o
            {1, 100},                   // no
            {1, 100},                   // n
            {1, 100},                   // ne
        },
        {
            {40, 1, 0, 0, 0},           // e
            {40, 1, 0, 0, 0},           // se
            {40, 1, 0, 0, 0},           // s
            {40, 1, 0, 0, 0},           // so
            {40, 1, 0, 0, 0},           // o
            {40, 1, 0, 0, 0},           // no
            {40, 1, 0, 0, 0},           // n
            {40, 1, 0, 0, 0},           // ne
        },
        {   40, -1, -1, SOUND_COUPSOURD, -1, -1, -1, SOUND_COUPSOURD, -1,
            -1, -1, SOUND_COUPSOURD, -1, -1, -1, SOUND_COUPSOURD, -1,
            -1, -1, SOUND_COUPSOURD, -1, -1, -1, SOUND_COUPSOURD, -1,
            -1, -1, SOUND_COUPSOURD, -1, -1, -1, SOUND_COUPSOURD, -1,
            -1, -1, SOUND_COUPSOURD, -1, -1, -1, SOUND_COUPSOURD, -1
        },
    },
    {
        ACTION_BUILDPIERRE,
        CHBLUPI,
        {
            {1, 100},                   // e
            {1, 100},                   // se
            {4, 103, 104, 105, 105},    // s
            {1, 100},                   // so
            {4, 100, 101, 102, 102},    // o
            {1, 100},                   // no
            {1, 100},                   // n
            {1, 100},                   // ne
        },
        {
            {40, 1, 0, 0, 0},           // e
            {40, 1, 0, 0, 0},           // se
            {40, 1, 0, 0, 0},           // s
            {40, 1, 0, 0, 0},           // so
            {40, 1, 0, 0, 0},           // o
            {40, 1, 0, 0, 0},           // no
            {40, 1, 0, 0, 0},           // n
            {40, 1, 0, 0, 0},           // ne
        },
        {   40, -1, -1, SOUND_COUPPIERRE, -1, -1, -1, SOUND_COUPPIERRE, -1,
            -1, -1, SOUND_COUPPIERRE, -1, -1, -1, SOUND_COUPPIERRE, -1,
            -1, -1, SOUND_COUPPIERRE, -1, -1, -1, SOUND_COUPPIERRE, -1,
            -1, -1, SOUND_COUPPIERRE, -1, -1, -1, SOUND_COUPPIERRE, -1,
            -1, -1, SOUND_COUPPIERRE, -1, -1, -1, SOUND_COUPPIERRE, -1
        },
    },
    {
        ACTION_PICKAXE,
        CHBLUPI,
        {
            {   16 + 4 + 16 + 4,
                93, 93, 94, 94, 95, 95, 94, 94, 93, 93, 94, 94, 95, 95, 94, 94,
                93, 93, 96, 96,
                97, 97, 98, 98, 99, 99, 98, 98, 97, 97, 98, 98, 99, 99, 98, 98,
                97, 97, 96, 96
            },
            {0}
        },
        {
            { (16 + 4 + 16 + 4) * 1, 1, 0, 0, 0},
        },
        {   16 + 4 + 16 + 4, -1, -1, -1, -1, SOUND_COUPTERRE, -1, -1, -1,
            -1, -1, -1, -1, SOUND_COUPTERRE, -1, -1, -1,
            -1, -1, -1, -1,
            -1, -1, -1, -1, SOUND_COUPTERRE, -1, -1, -1,
            -1, -1, -1, -1, SOUND_COUPTERRE, -1, -1, -1,
            -1, -1, -1, -1
        },
    },
    {
        ACTION_PIOCHESOURD,
        CHBLUPI,
        {
            {   16 + 4 + 16 + 4,
                93, 93, 94, 94, 95, 95, 94, 94, 93, 93, 94, 94, 95, 95, 94, 94,
                93, 93, 96, 96,
                97, 97, 98, 98, 99, 99, 98, 98, 97, 97, 98, 98, 99, 99, 98, 98,
                97, 97, 96, 96
            },
            {0}
        },
        {
            { (16 + 4 + 16 + 4) * 1, 1, 0, 0, 0},
        },
        {   16 + 4 + 16 + 4, -1, -1, -1, -1, SOUND_COUPSOURD, -1, -1, -1,
            -1, -1, -1, -1, SOUND_COUPSOURD, -1, -1, -1,
            -1, -1, -1, -1,
            -1, -1, -1, -1, SOUND_COUPSOURD, -1, -1, -1,
            -1, -1, -1, -1, SOUND_COUPSOURD, -1, -1, -1,
            -1, -1, -1, -1
        },
    },
    {
        ACTION_PIOCHEPIERRE,
        CHBLUPI,
        {
            {   16 + 4 + 16 + 4,
                93, 93, 94, 94, 95, 95, 94, 94, 93, 93, 94, 94, 95, 95, 94, 94,
                93, 93, 96, 96,
                97, 97, 98, 98, 99, 99, 98, 98, 97, 97, 98, 98, 99, 99, 98, 98,
                97, 97, 96, 96
            },
            {0}
        },
        {
            { (16 + 4 + 16 + 4) * 1, 1, 0, 0, 0},
        },
        {   16 + 4 + 16 + 4, -1, -1, -1, -1, SOUND_COUPPIERRE, -1, -1, -1,
            -1, -1, -1, -1, SOUND_COUPPIERRE, -1, -1, -1,
            -1, -1, -1, -1,
            -1, -1, -1, -1, SOUND_COUPPIERRE, -1, -1, -1,
            -1, -1, -1, -1, SOUND_COUPPIERRE, -1, -1, -1,
            -1, -1, -1, -1
        },
    },
    {
        ACTION_ARROSE,
        CHBLUPI,
        {
            {10, 286, 286, 287, 287, 287, 287, 286, 286, 287, 287},
            {0}
        },
        {
            {40, 1, 0, 0, 0},
        },
        {   20, SOUND_ARROSE, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
        },
    },
    {
        ACTION_BECHE,
        CHBLUPI,
        {
            {   20, 288, 288, 288, 289, 289, 288, 288, 289, 289, 289,
                289, 289, 288, 288, 288, 288, 289, 289, 289, 289
            },
            {0}
        },
        {
            {40, 1, 0, 0, 0},
        },
        {   20, -1, -1, -1, SOUND_BECHE, -1, -1, -1, SOUND_BECHE, -1, -1,
            -1, -1, -1, -1, -1, -1, SOUND_BECHE, -1, -1, -1
        },
    },
    {
        ACTION_SAW,
        CHBLUPI,
        {
            {1, 100},                   // e
            {1, 100},                   // se
            {8, 107, 108, 108, 109, 109, 108, 108, 107}, // s
            {1, 100},                   // so
            {1, 100},                   // o
            {1, 100},                   // no
            {1, 100},                   // n
            {1, 100},                   // ne
        },
        {
            {40, 1, 0, 0, 0},           // e
            {40, 1, 0, 0, 0},           // se
            {40, 1, 0, 0, 0},           // s
            {40, 1, 0, 0, 0},           // so
            {40, 1, 0, 0, 0},           // o
            {40, 1, 0, 0, 0},           // no
            {40, 1, 0, 0, 0},           // n
            {40, 1, 0, 0, 0},           // ne
        },
        {   40, -1, -1, -1, SOUND_SAW, -1, -1, -1, -1,
            -1, -1, -1, SOUND_SAW, -1, -1, -1, -1,
            -1, -1, -1, SOUND_SAW, -1, -1, -1, -1,
            -1, -1, -1, SOUND_SAW, -1, -1, -1, -1,
            -1, -1, -1, SOUND_SAW, -1, -1, -1, -1
        },
    },
    {
        ACTION_CUEILLE1,
        CHBLUPI,
        {
            {   20, 48, 194, 194, 194, 196, 196, 196, 196, 194, 194,
                194, 194, 196, 196, 196, 196, 48, 48, 48, 48
            },  // e
            {1, 49},                    // se
            {   20, 50, 195, 195, 195, 197, 197, 197, 197, 195, 195,
                195, 195, 197, 197, 197, 197, 50, 50, 50, 50
            },  // s
            {1, 51},                    // so
            {1, 52},                    // o
            {1, 53},                    // no
            {1, 54},                    // n
            {1, 55},                    // ne
        },
        {
            {20, 1, 0, 0, 0},           // e
            {20, 1, 0, 0, 0},           // se
            {20, 1, 0, 0, 0},           // s
            {20, 1, 0, 0, 0},           // so
            {20, 1, 0, 0, 0},           // o
            {20, 1, 0, 0, 0},           // no
            {20, 1, 0, 0, 0},           // n
            {20, 1, 0, 0, 0},           // ne
        },
        {0},
    },
    {
        ACTION_CUEILLE2,
        CHBLUPI,
        {
            {   20, 48, 194, 194, 194, 198, 198, 198, 198, 194, 194,
                194, 194, 198, 198, 198, 198, 48, 48, 48, 48
            },  // e
            {1, 49},                    // se
            {   20, 50, 195, 195, 195, 199, 199, 199, 199, 195, 195,
                195, 195, 199, 199, 199, 199, 50, 50, 50, 50
            },  // s
            {1, 51},                    // so
            {1, 52},                    // o
            {1, 53},                    // no
            {1, 54},                    // n
            {1, 55},                    // ne
        },
        {
            {20, 1, 0, 0, 0},           // e
            {20, 1, 0, 0, 0},           // se
            {20, 1, 0, 0, 0},           // s
            {20, 1, 0, 0, 0},           // so
            {20, 1, 0, 0, 0},           // o
            {20, 1, 0, 0, 0},           // no
            {20, 1, 0, 0, 0},           // n
            {20, 1, 0, 0, 0},           // ne
        },
        {0},
    },
    {
        ACTION_CUEILLE3,
        CHBLUPI,
        {
            {   20, 48, 194, 194, 194, 306, 306, 306, 306, 194, 194,
                194, 194, 306, 306, 306, 306, 48, 48, 48, 48
            },  // e
            {1, 49},                    // se
            {   20, 50, 195, 195, 195, 307, 307, 307, 307, 195, 195,
                195, 195, 307, 307, 307, 307, 50, 50, 50, 50
            },  // s
            {1, 51},                    // so
            {1, 52},                    // o
            {1, 53},                    // no
            {1, 54},                    // n
            {1, 55},                    // ne
        },
        {
            {20, 1, 0, 0, 0},           // e
            {20, 1, 0, 0, 0},           // se
            {20, 1, 0, 0, 0},           // s
            {20, 1, 0, 0, 0},           // so
            {20, 1, 0, 0, 0},           // o
            {20, 1, 0, 0, 0},           // no
            {20, 1, 0, 0, 0},           // n
            {20, 1, 0, 0, 0},           // ne
        },
        {0},
    },
    {
        ACTION_LABO,
        CHBLUPI,
        {
            {1, 48},
            {0}
        },
        {
            {90, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_MECHE,
        CHBLUPI,
        {
            {   36, 106, 106, 106, 106, 194, 194, 194, 194, 194, 194,
                194, 194, 194, 194, 194, 194, 194, 194, 194, 194,
                194, 194, 194, 194, 194, 194, 194, 194, 194, 194,
                110, 110, 110, 110, 110, 110
            },
            {0}
        },
        {
            {36, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_DYNAMITE,
        CHBLUPI,
        {
            {1, 48},
            {0}
        },
        {
            {12, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_DELAY,
        CHBLUPI,
        {
            {1, 48},    // e
            {1, 49},    // se
            {1, 50},    // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_BRIDGE,
        CHBLUPI,
        {
            {8, 48, 49, 50, 51, 52, 53, 54, 55}, // e
            {1, 49},                        // se
            {8, 50, 49, 48, 55, 54, 53, 52, 51}, // s
            {1, 51},                        // so
            {8, 52, 51, 50, 49, 48, 55, 54, 53}, // o
            {1, 53},                        // no
            {8, 54, 55, 48, 49, 50, 51, 52, 53}, // n
            {1, 55},                        // ne
        },
        {
            {30, 1, 0, 0, 0},           // e
            {30, 1, 0, 0, 0},           // se
            {30, 1, 0, 0, 0},           // s
            {30, 1, 0, 0, 0},           // so
            {30, 1, 0, 0, 0},           // o
            {30, 1, 0, 0, 0},           // no
            {30, 1, 0, 0, 0},           // n
            {30, 1, 0, 0, 0},           // ne
        },
        {   30, SOUND_HOP, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
        },
    },
    {
        ACTION_CARRY,
        CHBLUPI,
        {
            {   2 + 6 + 15, 106, 106, 48, 48, 48, 48, 48, 48, 106,
                48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48
            },
            {1, 49},
            {   2 + 6 + 15, 133, 133, 50, 50, 50, 50, 50, 50, 133,
                50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50
            },
            {1, 51},
            {1, 52},
            {1, 53},
            {1, 54},
            {1, 55},
        },
        {
            {   2 + 6 + 15, 2 + 6 + 15,
                0, 0, 0, 0, 0, 0,
                0, 0, -8, 0, 0, -5, 0, 0, -2, 0, 0, +2, 0, 0, +5, 0, 0, +8,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            },
            {1, 1, 0, 0, 0},
            {   2 + 6 + 15, 2 + 6 + 15,
                0, 0, 0, 0, 0, 0,
                0, 0, -8, 0, 0, -5, 0, 0, -2, 0, 0, +2, 0, 0, +5, 0, 0, +8,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            },
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
        },
        {   2 + 6 + 15, SOUND_HOP,     -1, -1, -1, -1, -1, -1, -1,
            SOUND_JUMP,    -1, -1, -1, -1, -1, -1, -1, -1,
            SOUND_COUPTOC, -1, -1, -1, -1, -1
        },
    },
    {
        ACTION_DROP,
        CHBLUPI,
        {
            {10, 106, 106, 106, 106, 106, 48, 48, 48, 48, 48},
            {1, 49},
            {10, 133, 133, 133, 133, 133, 50, 50, 50, 50, 50},
            {1, 51},
            {1, 52},
            {1, 53},
            {1, 54},
            {1, 55},
        },
        {
            {10, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {10, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
        },
        {   10, SOUND_HOP,    -1, -1, -1, -1, -1, -1, -1, -1,
            SOUND_COUPTERRE,
        },
    },
    {
        ACTION_BURN,
        CHBLUPI,
        {
            {8, 48, 49, 50, 51, 52, 53, 54, 55},
            {0}
        },
        {
            {40, 1, 0, 0, -10},
        },
        {0},
    },
    {
        ACTION_TCHAO,
        CHBLUPI,
        {
            {   48, 308, 308, 308, 308, 308, 308, 308, 308,
                308, 308, 308, 308, 309, 309, 309, 309,
                309, 309, 309, 309, 309, 309, 309, 309,
                310, 310, 310, 310, 310, 310, 311, 311,
                311, 311, 311, 311, 312, 312, 312, 312,
                312, 312, 313, 313, 313, 313, 313, 313
            },
            {0}
        },
        {
            {48, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_ELECTRO,
        CHBLUPI,
        {
            {4, 270, 271, 272, 271},
            {0}
        },
        {
            {60, 1, 0, 0, 0},
        },
        {   30, SOUND_BURN, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            SOUND_BURN, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            SOUND_BURN, -1, -1, -1, -1, -1, -1, -1, -1, -1
        },
    },
    {
        ACTION_GRILL1,
        CHBLUPI,
        {
            {   40, 273, 273, 273, 273, 273, 273, 273, 273, 273, 274,
                273, 273, 273, 274, 273, 273, 273, 273, 273, 273,
                273, 273, 273, 273, 273, 273, 273, 273, 273, 273,
                273, 274, 273, 273, 273, 273, 273, 273, 273, 273
            },
            {0}
        },
        {
            {40, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_GRILL2,
        CHBLUPI,
        {
            {   12, 275, 273, 275,
                276, 275, 276,
                277, 276, 277,
                278, 277, 278
            },
            {0}
        },
        {
            {12, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_GRILL3,
        CHBLUPI,
        {
            {   50, 279, 280, 279, 280, 280, 279, 280, 279, 279, 280,
                280, 280, 279, 280, 279, 279, 280, 279, 280, 280,
                279, -1, 279, 280, 280, 279, 280, 279, 279, 280,
                279, 280, 279, 280, -1, 280, 279, 280, -1, 280,
                279, -1, 279, 280, -1, 279, -1, 279, -1, 280
            },
            {0}
        },
        {
            {50, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_EAT,
        CHBLUPI,
        {
            {   39, 113, 114, 114, 113, 113, 113, 114, 114, 113, 114,
                113, 114, 114, 113, 113, 113, 114, 114, 113, 114,
                113, 114, 114, 113, 113, 113, 114, 114, 113, 114,
                48, 48, 48, 48, 48, 48, 48, 48, 48
            },
            {0}
        },
        {
            {39, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_DRINK,
        CHBLUPI,
        {
            {1, 193},
            {0}
        },
        {
            {40, 2, 0, 0, -3, 0, 0, +3},
        },
        {0},
    },
    {
        ACTION_HAPPY,
        CHBLUPI,
        {
            {1, 48},    // e
            {1, 49},    // se
            {1, 50},    // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
            {20, 4, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, +2},
            {20, 4, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, +2},
            {20, 4, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, +2},
            {20, 4, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, +2},
            {20, 4, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, +2},
            {20, 4, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, +2},
            {20, 4, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, +2},
            {20, 4, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, +2},
        },
        {0},
    },
    {
        ACTION_BORN,
        CHBLUPI,
        {
            {   20 + 9,  115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
                115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
                48, 49, 50, 51, 52, 53, 54, 55, 48
            },
            {0}
        },
        {
            {   20 + 9, 20 + 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, -10, 0, 0, -10, 0, 0, -8,  0, 0, -3,
                0, 0, +3,  0, 0, +8,  0, 0, +10, 0, 0, +10,
                0, 0, 0
            },
        },
        {   20 + 9,  SOUND_BORN, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            SOUND_BORN, -1, -1, -1, -1, -1, -1, -1,
            SOUND_COUPTOC
        },
    },
    {
        ACTION_TELEPORTE1,
        CHBLUPI,
        {
            {   16, 318, 318, 319, 319, 318, 319, 319, 318,
                318, 319, 319, 318, 318, 319, 319, 318
            },
            {0}
        },
        {
            {32, 4, -100, 0, 0, +100, 0, 0, +100, 0, 0, -100, 0, 0},
        },
        {0},
    },
    {
        ACTION_TELEPORTE2,
        CHBLUPI,
        {
            {   16, 320, 318, 319, 321, 318, 320, 319, 318,
                318, 321, 319, 318, 320, 319, 321, 318
            },
            {0}
        },
        {
            {32, 4, -100, 0, 0, +100, 0, 0, +100, 0, 0, -100, 0, 0},
        },
        {0},
    },
    {
        ACTION_TELEPORTE3,
        CHBLUPI,
        {
            {   32, 320, 320, 321, 321, 320, 321, 321, 320,
                320, 321, 321, 320, -1, 321, 321, 320,
                320, -1, 321, 321, -1, 321, 321, -1,
                320, -1, -1, 320, -1, 321, -1, 320
            },
            {0}
        },
        {
            {32, 4, 0, 0, 0, 0, 0, -1, 0, 0, +1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_MISC1,       // hausse les épaules
        CHBLUPI,
        {
            {1, 140},   // e
            {1, 141},   // se
            {1, 142},   // s
            {1, 143},   // so
            {1, 144},   // o
            {1, 145},   // no
            {1, 146},   // n
            {1, 147},   // ne
        },
        {
            {3, 1, 0, 0, 0},
            {3, 1, 0, 0, 0},
            {3, 1, 0, 0, 0},
            {3, 1, 0, 0, 0},
            {3, 1, 0, 0, 0},
            {3, 1, 0, 0, 0},
            {3, 1, 0, 0, 0},
            {3, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_MISC2,       // grat-grat
        CHBLUPI,
        {
            {6, 154, 154, 154, 154, 155, 155}, // e
            {1, 49},                        // se
            {6, 156, 156, 156, 156, 157, 157}, // s
            {1, 51},                        // so
            {1, 52},                        // o
            {1, 53},                        // no
            {1, 54},                        // n
            {6, 158, 158, 158, 158, 159, 159}, // ne
        },
        {
            {24, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            {24, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            {24, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_MISC3,       // yoyo
        CHBLUPI,
        {
            {8, 148, 148, 149, 149, 150, 150, 149, 149}, // e
            {1, 49},    // se
            {8, 151, 151, 152, 152, 153, 153, 152, 152}, // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
            {32, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            {32, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_MISC4,       // ferme les yeux
        CHBLUPI,
        {
            {1, 281},   // e
            {1, 282},   // se
            {1, 283},   // s
            {1, 284},   // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 285},   // ne
        },
        {
            {2, 1, 0, 0, 0},
            {2, 1, 0, 0, 0},
            {2, 1, 0, 0, 0},
            {2, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {2, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_MISC5,       // ohé
        CHBLUPI,
        {
            {8, 110, 110, 111, 111, 110, 110, 112, 112},
            {1, 49},    // se
            {1, 50},    // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
            {16, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_MISC6,       // diabolo
        CHBLUPI,
        {
            {1, 48},    // e
            {1, 49},    // se
            {6, 361, 362, 363, 364, 365, 363}, // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            {36, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
            { 1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_MISC1f,
        CHBLUPI,
        {
            {12, 69, 69, 69, 72, 72, 72, 69, 69, 69, 90, 90, 90}, // e
            {12, 72, 72, 72, 75, 75, 75, 72, 72, 72, 69, 69, 69}, // se
            {12, 75, 75, 75, 78, 78, 78, 75, 75, 75, 72, 72, 72}, // s
            {12, 78, 78, 78, 81, 81, 81, 78, 78, 78, 75, 75, 75}, // so
            {12, 81, 81, 81, 84, 84, 84, 81, 81, 81, 78, 78, 78}, // o
            {12, 84, 84, 84, 87, 87, 87, 84, 84, 84, 81, 81, 81}, // no
            {12, 87, 87, 87, 90, 90, 90, 87, 87, 87, 84, 84, 84}, // n
            {12, 90, 90, 90, 69, 69, 69, 90, 90, 90, 87, 87, 87}, // ne
        },
        {
            {12, 1, 0, 0, 0},
            {12, 1, 0, 0, 0},
            {12, 1, 0, 0, 0},
            {12, 1, 0, 0, 0},
            {12, 1, 0, 0, 0},
            {12, 1, 0, 0, 0},
            {12, 1, 0, 0, 0},
            {12, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_ARMOROPEN,
        CHBLUPI,
        {
            {1, 346},
            {0}
        },
        {
            {15, 1, 0, 0, 0},
        },
        {   15, SOUND_ARMUREOPEN, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1
        },
    },
    {
        ACTION_ARMORCLOSE,
        CHBLUPI,
        {
            {1, 346},
            {0}
        },
        {
            {15, 1, 0, 0, 0},
        },
        {   15, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, SOUND_ARMURECLOSE
        },
    },

    // Disciple :

    {
        ACTION_D_STOP,
        CHBLUPI,
        {
            {1, 48},    // e
            {1, 49},    // se
            {1, 50},    // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_D_WALK,
        CHBLUPI,
        {
            {1, 48},    // e
            {1, 49},    // se
            {1, 50},    // s
            {1, 51},    // so
            {1, 52},    // o
            {1, 53},    // no
            {1, 54},    // n
            {1, 55},    // ne
        },
        {
            {5, 1, +600, +300, 0},
            {7, 1,    0, +429, 0},
            {5, 1, -600, +300, 0},
            {7, 1, -858,   0, 0},
            {5, 1, -600, -300, 0},
            {7, 1,    0, -429, 0},
            {5, 1, +600, -300, 0},
            {7, 1, +858,   0, 0},
        },
        {0},
    },
    {
        ACTION_D_BUILD,
        CHBLUPI,
        {
            {4, 290, 304, 290, 292},    // e
            {4, 292, 290, 292, 294},    // se
            {4, 294, 292, 294, 296},    // s
            {4, 296, 294, 296, 298},    // so
            {4, 298, 296, 298, 300},    // o
            {4, 300, 298, 300, 302},    // no
            {4, 302, 300, 302, 304},    // n
            {4, 304, 302, 304, 290},    // ne
        },
        {
            {40, 1, 0, 0, 0},           // e
            {40, 1, 0, 0, 0},           // se
            {40, 1, 0, 0, 0},           // s
            {40, 1, 0, 0, 0},           // so
            {40, 1, 0, 0, 0},           // o
            {40, 1, 0, 0, 0},           // no
            {40, 1, 0, 0, 0},           // n
            {40, 1, 0, 0, 0},           // ne
        },
        {0},
    },
    {
        ACTION_D_SAW,
        CHBLUPI,
        {
            {1, 290},       // e
            {1, 292},       // se
            {1, 294},       // s
            {1, 296},       // so
            {1, 298},       // o
            {1, 300},       // no
            {1, 302},       // n
            {1, 304},       // ne
        },
        {
            {40, 4, 0, 0, -2, 0, 0, -2, 0, 0, +2, 0, 0, +2},
            {40, 4, 0, 0, -2, 0, 0, -2, 0, 0, +2, 0, 0, +2},
            {40, 4, 0, 0, -2, 0, 0, -2, 0, 0, +2, 0, 0, +2},
            {40, 4, 0, 0, -2, 0, 0, -2, 0, 0, +2, 0, 0, +2},
            {40, 4, 0, 0, -2, 0, 0, -2, 0, 0, +2, 0, 0, +2},
            {40, 4, 0, 0, -2, 0, 0, -2, 0, 0, +2, 0, 0, +2},
            {40, 4, 0, 0, -2, 0, 0, -2, 0, 0, +2, 0, 0, +2},
            {40, 4, 0, 0, -2, 0, 0, -2, 0, 0, +2, 0, 0, +2},
        },
        {0},
    },
    {
        ACTION_D_ARROSE,
        CHBLUPI,
        {
            {12, 290, 290, 290, 304, 304, 304, 290, 290, 290, 292, 292, 292}, // e
            {12, 292, 292, 292, 290, 290, 290, 292, 292, 292, 294, 294, 294}, // se
            {12, 294, 294, 294, 292, 292, 292, 294, 294, 294, 296, 296, 296}, // s
            {12, 296, 296, 296, 294, 294, 294, 296, 296, 296, 298, 298, 298}, // so
            {12, 298, 298, 298, 296, 296, 296, 298, 298, 298, 300, 300, 300}, // o
            {12, 300, 300, 300, 298, 298, 298, 300, 300, 300, 302, 302, 302}, // no
            {12, 302, 302, 302, 300, 300, 300, 302, 302, 302, 304, 304, 304}, // n
            {12, 304, 304, 304, 302, 302, 302, 304, 304, 304, 290, 290, 290}, // ne
        },
        {
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_D_BECHE,
        CHBLUPI,
        {
            {1, 290},       // e
            {1, 292},       // se
            {1, 294},       // s
            {1, 296},       // so
            {1, 298},       // o
            {1, 300},       // no
            {1, 302},       // n
            {1, 304},       // ne
        },
        {
            {40, 4, 0, 0, 0, 0, 0, -2, 0, 0, +2, 0, 0, 0},
            {40, 4, 0, 0, 0, 0, 0, -2, 0, 0, +2, 0, 0, 0},
            {40, 4, 0, 0, 0, 0, 0, -2, 0, 0, +2, 0, 0, 0},
            {40, 4, 0, 0, 0, 0, 0, -2, 0, 0, +2, 0, 0, 0},
            {40, 4, 0, 0, 0, 0, 0, -2, 0, 0, +2, 0, 0, 0},
            {40, 4, 0, 0, 0, 0, 0, -2, 0, 0, +2, 0, 0, 0},
            {40, 4, 0, 0, 0, 0, 0, -2, 0, 0, +2, 0, 0, 0},
            {40, 4, 0, 0, 0, 0, 0, -2, 0, 0, +2, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_D_PICKAXE,
        CHBLUPI,
        {
            {8, 290, 290, 304, 304, 290, 290, 292, 292}, // e
            {8, 292, 292, 290, 290, 292, 292, 294, 294}, // se
            {8, 294, 294, 292, 292, 294, 294, 296, 296}, // s
            {8, 296, 296, 294, 294, 296, 296, 298, 298}, // so
            {8, 298, 298, 296, 296, 298, 298, 300, 300}, // o
            {8, 300, 300, 298, 298, 300, 300, 302, 302}, // no
            {8, 302, 302, 300, 300, 302, 302, 304, 304}, // n
            {8, 304, 304, 302, 302, 304, 304, 290, 290}, // ne
        },
        {
            {40, 1, 0, 0, 0},           // e
            {40, 1, 0, 0, 0},           // se
            {40, 1, 0, 0, 0},           // s
            {40, 1, 0, 0, 0},           // so
            {40, 1, 0, 0, 0},           // o
            {40, 1, 0, 0, 0},           // no
            {40, 1, 0, 0, 0},           // n
            {40, 1, 0, 0, 0},           // ne
        },
        {0},
    },
    {
        ACTION_D_CUEILLE1,
        CHBLUPI,
        {
            {12, 290, 290, 290, 304, 304, 304, 290, 290, 290, 292, 292, 292}, // e
            {12, 292, 292, 292, 290, 290, 290, 292, 292, 292, 294, 294, 294}, // se
            {12, 294, 294, 294, 292, 292, 292, 294, 294, 294, 296, 296, 296}, // s
            {12, 296, 296, 296, 294, 294, 294, 296, 296, 296, 298, 298, 298}, // so
            {12, 298, 298, 298, 296, 296, 296, 298, 298, 298, 300, 300, 300}, // o
            {12, 300, 300, 300, 298, 298, 298, 300, 300, 300, 302, 302, 302}, // no
            {12, 302, 302, 302, 300, 300, 300, 302, 302, 302, 304, 304, 304}, // n
            {12, 304, 304, 304, 302, 302, 302, 304, 304, 304, 290, 290, 290}, // ne
        },
        {
            {20, 1, 0, 0, 0},           // e
            {20, 1, 0, 0, 0},           // se
            {20, 1, 0, 0, 0},           // s
            {20, 1, 0, 0, 0},           // so
            {20, 1, 0, 0, 0},           // o
            {20, 1, 0, 0, 0},           // no
            {20, 1, 0, 0, 0},           // n
            {20, 1, 0, 0, 0},           // ne
        },
        {0},
    },
    {
        ACTION_D_CUEILLE2,
        CHBLUPI,
        {
            {12, 290, 290, 290, 304, 304, 304, 290, 290, 290, 292, 292, 292}, // e
            {12, 292, 292, 292, 290, 290, 290, 292, 292, 292, 294, 294, 294}, // se
            {12, 294, 294, 294, 292, 292, 292, 294, 294, 294, 296, 296, 296}, // s
            {12, 296, 296, 296, 294, 294, 294, 296, 296, 296, 298, 298, 298}, // so
            {12, 298, 298, 298, 296, 296, 296, 298, 298, 298, 300, 300, 300}, // o
            {12, 300, 300, 300, 298, 298, 298, 300, 300, 300, 302, 302, 302}, // no
            {12, 302, 302, 302, 300, 300, 300, 302, 302, 302, 304, 304, 304}, // n
            {12, 304, 304, 304, 302, 302, 302, 304, 304, 304, 290, 290, 290}, // ne
        },
        {
            {20, 1, 0, 0, 0},           // e
            {20, 1, 0, 0, 0},           // se
            {20, 1, 0, 0, 0},           // s
            {20, 1, 0, 0, 0},           // so
            {20, 1, 0, 0, 0},           // o
            {20, 1, 0, 0, 0},           // no
            {20, 1, 0, 0, 0},           // n
            {20, 1, 0, 0, 0},           // ne
        },
        {0},
    },
    {
        ACTION_D_MECHE,
        CHBLUPI,
        {
            {1, 290},       // e
            {1, 292},       // se
            {1, 294},       // s
            {1, 296},       // so
            {1, 298},       // o
            {1, 300},       // no
            {1, 302},       // n
            {1, 304},       // ne
        },
        {
            {36, 2, 0, 0, -2, 0, 0, +2},
            {36, 2, 0, 0, -2, 0, 0, +2},
            {36, 2, 0, 0, -2, 0, 0, +2},
            {36, 2, 0, 0, -2, 0, 0, +2},
            {36, 2, 0, 0, -2, 0, 0, +2},
            {36, 2, 0, 0, -2, 0, 0, +2},
            {36, 2, 0, 0, -2, 0, 0, +2},
            {36, 2, 0, 0, -2, 0, 0, +2},
        },
        {0},
    },
    {
        ACTION_D_TCHAO,
        CHBLUPI,
        {
            {4, 290, 304, 290, 292},    // e
            {4, 292, 290, 292, 294},    // se
            {4, 294, 292, 294, 296},    // s
            {4, 296, 294, 296, 298},    // so
            {4, 298, 296, 298, 300},    // o
            {4, 300, 298, 300, 302},    // no
            {4, 302, 300, 302, 304},    // n
            {4, 304, 302, 304, 290},    // ne
        },
        {
            {8 * 6, 1, 0, 0, 0},
            {8 * 6, 1, 0, 0, 0},
            {8 * 6, 1, 0, 0, 0},
            {8 * 6, 1, 0, 0, 0},
            {8 * 6, 1, 0, 0, 0},
            {8 * 6, 1, 0, 0, 0},
            {8 * 6, 1, 0, 0, 0},
            {8 * 6, 1, 0, 0, 0},
        },
        {0},
    },

    // Araignée :

    {
        ACTION_S_STOP,
        CHBLUPI,
        {
            {4, 116, 117, 117, 116}, // e
            {4, 118, 119, 119, 118}, // se
            {4, 120, 121, 121, 120}, // s
            {4, 122, 123, 123, 122}, // so
            {4, 124, 125, 125, 124}, // o
            {4, 126, 127, 127, 126}, // no
            {4, 128, 129, 129, 128}, // n
            {4, 130, 131, 131, 130}, // ne
        },
        {
            {4, 4, 0, 0, 0, 0, 0, -5, 0, 0, +5, 0, 0, 0},
            {4, 4, 0, 0, 0, 0, 0, -5, 0, 0, +5, 0, 0, 0},
            {4, 4, 0, 0, 0, 0, 0, -5, 0, 0, +5, 0, 0, 0},
            {4, 4, 0, 0, 0, 0, 0, -5, 0, 0, +5, 0, 0, 0},
            {4, 4, 0, 0, 0, 0, 0, -5, 0, 0, +5, 0, 0, 0},
            {4, 4, 0, 0, 0, 0, 0, -5, 0, 0, +5, 0, 0, 0},
            {4, 4, 0, 0, 0, 0, 0, -5, 0, 0, +5, 0, 0, 0},
            {4, 4, 0, 0, 0, 0, 0, -5, 0, 0, +5, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_S_WALK,
        CHBLUPI,
        {
            {10, 117, 117, 117, 117, 117, 117, 117, 117, 116, 116},
            {10, 119, 119, 119, 119, 119, 119, 119, 119, 118, 118},
            {10, 121, 121, 121, 121, 121, 121, 121, 121, 120, 120},
            {10, 123, 123, 123, 123, 123, 123, 123, 123, 122, 122},
            {10, 125, 125, 125, 125, 125, 125, 125, 125, 124, 124},
            {10, 127, 127, 127, 127, 127, 127, 127, 127, 126, 126},
            {10, 129, 129, 129, 129, 129, 129, 129, 129, 128, 128},
            {10, 131, 131, 131, 131, 131, 131, 131, 131, 130, 130},
        },
        {
            {   10, 10, +300, +150, -10, +300, +150, -10, +300, +150, -10, +300, +150, -8, +300, +150, -2,
                +300, +150, +2, +300, +150, +8, +300, +150, +10, +300, +150, +10, +300, +150, +10
            },
            {   10, 10, 0, +300, -10, 0, +300, -10, 0, +300, -10, 0, +300, -8, 0, +300, -2,
                0, +300, +2, 0, +300, +8, 0, +300, +10, 0, +300, +10, 0, +300, +10
            },
            {   10, 10, -300, +150, -10, -300, +150, -10, -300, +150, -10, -300, +150, -8, -300, +150, -2,
                -300, +150, +2, -300, +150, +8, -300, +150, +10, -300, +150, +10, -300, +150, +10
            },
            {   10, 10, -600, 0, -10, -600, 0, -10, -600, 0, -10, -600, 0, -8, -600, 0, -2,
                -600, 0, +2, -600, 0, +8, -600, 0, +10, -600, 0, +10, -600, 0, +10
            },
            {   10, 10, -300, -150, -10, -300, -150, -10, -300, -150, -10, -300, -150, -8, -300, -150, -2,
                -300, -150, +2, -300, -150, +8, -300, -150, +10, -300, -150, +10, -300, -150, +10
            },
            {   10, 10, 0, -300, -10, 0, -300, -10, 0, -300, -10, 0, -300, -8, 0, -300, -2,
                0, -300, +2, 0, -300, +8, 0, -300, +10, 0, -300, +10, 0, -300, +10
            },
            {   10, 10, +300, -150, -10, +300, -150, -10, +300, -150, -10, +300, -150, -8, +300, -150, -2,
                +300, -150, +2, +300, -150, +8, +300, -150, +10, +300, -150, +10, +300, -150, +10
            },
            {   10, 10, +600, 0, -10, +600, 0, -10, +600, 0, -10, +600, 0, -8, +600, 0, -2,
                +600, 0, +2, +600, 0, +8, +600, 0, +10, +600, 0, +10, +600, 0, +10
            },
        },
        {10, -1, -1, -1, -1, -1, -1, -1, -1, -1, SOUND_S_JUMP},
    },
    {
        ACTION_S_GRILL,
        CHBLUPI,
        {
            {   40, 165, 165, 166, 165, 165, 166, 165, 166, 165, 165,
                166, 166, 167, 166, 167, 167, 166, 166, 167, 166,
                167, 167, 167, 168, 167, 167, 167, 168, 167, 167,
                168, 167, 168, 168, 168, 168, 167, 168, 168, 168
            },
            {0}
        },
        {
            {40, 1, 0, 0, 0},
        },
        {   30, SOUND_RAYON1, -1, -1, -1, -1,
            SOUND_RAYON1, -1, -1, -1, -1,
            SOUND_RAYON1, -1, -1, -1, -1,
            SOUND_RAYON1, -1, -1, -1, -1,
            SOUND_RAYON1, -1, -1, -1, -1,
            SOUND_RAYON1, -1, -1, -1, -1
        },
    },
    {
        ACTION_S_POISON,
        CHBLUPI,
        {
            {8, 117, 119, 121, 123, 125, 127, 129, 131},
            {0}
        },
        {
            {32, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_S_DEAD1,
        CHBLUPI,
        {
            {6, 314, 315, 316, 317, 316, 315},
            {0}
        },
        {
            {30, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_S_DEAD2,
        CHBLUPI,
        {
            {   50, 314, 314, 314, 314, 314, 315, 316, 315, 315, 316,
                317, 317, 317, 316, 317, 317, 317, 317, 317, 317,
                316, 315, 314, 314, 314, 315, 316, 315, 315, 315,
                316, 316, 316, 316, 316, 316, 316, 316, 316, 316,
                316, 315, 314, 314, 314, 314, 314, 314, 317, 314
            },
            {0}
        },
        {
            {100, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_S_DEAD3,
        CHBLUPI,
        {
            {1, 317},
            {0}
        },
        {
            {100, 1, 0, 0, 0},
        },
        {0},
    },

    // Virus :

    {
        ACTION_V_STOP,
        CHBLUPI,
        {
            {10, 160, 161, 162, 163, 161, 160, 162, 161, 163, 162},
            {0}
        },
        {
            {10, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_V_WALK,
        CHBLUPI,
        {
            {10, 160, 161, 162, 163, 161, 160, 162, 161, 163, 162},
            {10, 160, 161, 162, 163, 161, 160, 162, 161, 163, 162},
            {10, 160, 161, 162, 163, 161, 160, 162, 161, 163, 162},
            {10, 160, 161, 162, 163, 161, 160, 162, 161, 163, 162},
            {10, 160, 161, 162, 163, 161, 160, 162, 161, 163, 162},
            {10, 160, 161, 162, 163, 161, 160, 162, 161, 163, 162},
            {10, 160, 161, 162, 163, 161, 160, 162, 161, 163, 162},
            {10, 160, 161, 162, 163, 161, 160, 162, 161, 163, 162},
        },
        {
            {50, 1, +60, +30, 0},   // e
            {75, 1,   0, +40, 0},   // se
            {50, 1, -60, +30, 0},   // s
            {75, 1, -80,  0, 0},    // so
            {50, 1, -60, -30, 0},   // o
            {75, 1,   0, -40, 0},   // no
            {50, 1, +60, -30, 0},   // n
            {75, 1, +80,  0, 0},    // ne
        },
        {0},
    },
    {
        ACTION_V_GRILL,
        CHBLUPI,
        {
            {5, 164, 160, 164, 164, 160},
            {0}
        },
        {
            {40, 1, 0, 0, 0},
        },
        {   30, SOUND_RAYON1, -1, -1, -1, -1,
            SOUND_RAYON1, -1, -1, -1, -1,
            SOUND_RAYON1, -1, -1, -1, -1,
            SOUND_RAYON1, -1, -1, -1, -1,
            SOUND_RAYON1, -1, -1, -1, -1,
            SOUND_RAYON1, -1, -1, -1, -1
        },
    },


    // Tracks :

    {
        ACTION_T_STOP,
        CHBLUPI,
        {
            {1, 200},   // e
            {1, 202},   // se
            {1, 204},   // s
            {1, 206},   // so
            {1, 208},   // o
            {1, 210},   // no
            {1, 212},   // n
            {1, 214},   // ne
        },
        {
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_T_WALK,
        CHBLUPI,
        {
            {1, 200},   // e
            {1, 202},   // se
            {1, 204},   // s
            {1, 206},   // so
            {1, 208},   // o
            {1, 210},   // no
            {1, 212},   // n
            {1, 214},   // ne
        },
        {
            {10, 1, +300, +150, 0},     // e
            {15, 1,    0, +200, 0},     // se
            {10, 1, -300, +150, 0},     // s
            {15, 1, -400,   0, 0},      // so
            {10, 1, -300, -150, 0},     // o
            {15, 1,    0, -200, 0},     // no
            {10, 1, +300, -150, 0},     // n
            {15, 1, +400,   0, 0},      // ne
        },
        {5, SOUND_T_ENGINE, -1, -1, -1, -1},
    },
    {
        ACTION_T_CRUSHED,
        CHBLUPI,
        {
            {8, 200, 201, 201, 200, 200, 215, 215, 200}, // e
            {8, 202, 203, 203, 202, 202, 201, 201, 202}, // se
            {8, 204, 205, 205, 204, 204, 203, 203, 204}, // s
            {8, 206, 207, 207, 206, 206, 205, 205, 206}, // so
            {8, 208, 209, 209, 208, 208, 207, 207, 208}, // o
            {8, 210, 211, 211, 210, 210, 209, 209, 210}, // no
            {8, 212, 213, 213, 212, 212, 211, 211, 212}, // n
            {8, 214, 215, 215, 214, 214, 213, 213, 214}, // ne
        },
        {
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
        },
        {0},
    },

    // Robot :

    {
        ACTION_R_STOP,
        CHBLUPI,
        {
            {1, 216},   // e
            {1, 218},   // se
            {1, 220},   // s
            {1, 222},   // so
            {1, 224},   // o
            {1, 226},   // no
            {1, 228},   // n
            {1, 230},   // ne
        },
        {
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_R_WALK,
        CHBLUPI,
        {
            {1, 216},   // e
            {1, 218},   // se
            {1, 220},   // s
            {1, 222},   // so
            {1, 224},   // o
            {1, 226},   // no
            {1, 228},   // n
            {1, 230},   // ne
        },
        {
#if 0
            {20, 1, +150, +75, 0},      // e
            {30, 1,    0, +100, 0},     // se
            {20, 1, -150, +75, 0},      // s
            {30, 1, -200,   0, 0},      // so
            {20, 1, -150, -75, 0},      // o
            {30, 1,    0, -100, 0},     // no
            {20, 1, +150, -75, 0},      // n
            {30, 1, +200,   0, 0},      // ne
#else
            {   20, 20,  +20, +10, 0,  +80, +40, 0, +140, +70, 0, +180, +90, 0,
                +180, +90, 0, +180, +90, 0, +180, +90, 0, +180, +90, 0,
                +180, +90, 0, +180, +90, 0, +180, +90, 0, +180, +90, 0,
                +180, +90, 0, +180, +90, 0, +180, +90, 0, +180, +90, 0,
                +180, +90, 0, +140, +70, 0,  +80, +40, 0,  +20, +10, 0
            },
            {   30, 30, 0, +10, 0, 0, +20, 0, 0, +60, 0, 0, +90, 0, 0, +120, 0,
                0, +120, 0, 0, +120, 0, 0, +120, 0, 0, +120, 0, 0, +120, 0,
                0, +120, 0, 0, +120, 0, 0, +120, 0, 0, +120, 0, 0, +120, 0,
                0, +120, 0, 0, +120, 0, 0, +120, 0, 0, +120, 0, 0, +120, 0,
                0, +120, 0, 0, +120, 0, 0, +120, 0, 0, +120, 0, 0, +120, 0,
                0, +120, 0, 0, +90, 0, 0, +60, 0, 0, +20, 0, 0, +10, 0
            },
            {   20, 20,  -20, +10, 0,  -80, +40, 0, -140, +70, 0, -180, +90, 0,
                -180, +90, 0, -180, +90, 0, -180, +90, 0, -180, +90, 0,
                -180, +90, 0, -180, +90, 0, -180, +90, 0, -180, +90, 0,
                -180, +90, 0, -180, +90, 0, -180, +90, 0, -180, +90, 0,
                -180, +90, 0, -140, +70, 0,  -80, +40, 0,  -20, +10, 0
            },
            {   30, 30,  -20, 0, 0,  -40, 0, 0, -120, 0, 0, -180, 0, 0, -240, 0, 0,
                -240, 0, 0, -240, 0, 0, -240, 0, 0, -240, 0, 0, -240, 0, 0,
                -240, 0, 0, -240, 0, 0, -240, 0, 0, -240, 0, 0, -240, 0, 0,
                -240, 0, 0, -240, 0, 0, -240, 0, 0, -240, 0, 0, -240, 0, 0,
                -240, 0, 0, -240, 0, 0, -240, 0, 0, -240, 0, 0, -240, 0, 0,
                -240, 0, 0, -180, 0, 0, -120, 0, 0,  -40, 0, 0,  -20, 0, 0
            },
            {   20, 20,  -20, -10, 0,  -80, -40, 0, -140, -70, 0, -180, -90, 0,
                -180, -90, 0, -180, -90, 0, -180, -90, 0, -180, -90, 0,
                -180, -90, 0, -180, -90, 0, -180, -90, 0, -180, -90, 0,
                -180, -90, 0, -180, -90, 0, -180, -90, 0, -180, -90, 0,
                -180, -90, 0, -140, -70, 0,  -80, -40, 0,  -20, -10, 0
            },
            {   30, 30, 0, -10, 0, 0, -20, 0, 0, -60, 0, 0, -90, 0, 0, -120, 0,
                0, -120, 0, 0, -120, 0, 0, -120, 0, 0, -120, 0, 0, -120, 0,
                0, -120, 0, 0, -120, 0, 0, -120, 0, 0, -120, 0, 0, -120, 0,
                0, -120, 0, 0, -120, 0, 0, -120, 0, 0, -120, 0, 0, -120, 0,
                0, -120, 0, 0, -120, 0, 0, -120, 0, 0, -120, 0, 0, -120, 0,
                0, -120, 0, 0, -90, 0, 0, -60, 0, 0, -20, 0, 0, -10, 0
            },
            {   20, 20,  +20, -10, 0,  +80, -40, 0, +140, -70, 0, +180, -90, 0,
                +180, -90, 0, +180, -90, 0, +180, -90, 0, +180, -90, 0,
                +180, -90, 0, +180, -90, 0, +180, -90, 0, +180, -90, 0,
                +180, -90, 0, +180, -90, 0, +180, -90, 0, +180, -90, 0,
                +180, -90, 0, +140, -70, 0,  +80, -40, 0,  +20, -10, 0
            },
            {   30, 30,  +20, 0, 0,  +40, 0, 0, +120, 0, 0, +180, 0, 0, +240, 0, 0,
                +240, 0, 0, +240, 0, 0, +240, 0, 0, +240, 0, 0, +240, 0, 0,
                +240, 0, 0, +240, 0, 0, +240, 0, 0, +240, 0, 0, +240, 0, 0,
                +240, 0, 0, +240, 0, 0, +240, 0, 0, +240, 0, 0, +240, 0, 0,
                +240, 0, 0, +240, 0, 0, +240, 0, 0, +240, 0, 0, +240, 0, 0,
                +240, 0, 0, +180, 0, 0, +120, 0, 0,  +40, 0, 0,  +20, 0, 0
            },
#endif
        },
        {   20, -1, -1, SOUND_R_ENGINE, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
        },
    },
    {
        ACTION_R_APLAT,
        CHBLUPI,
        {
            {1, 216},   // e
            {1, 218},   // se
            {1, 220},   // s
            {1, 222},   // so
            {1, 224},   // o
            {1, 226},   // no
            {1, 228},   // n
            {1, 230},   // ne
        },
        {
            {40, 2, 0, 0, -2, 0, 0, +2},
            {40, 2, 0, 0, -2, 0, 0, +2},
            {40, 2, 0, 0, -2, 0, 0, +2},
            {40, 2, 0, 0, -2, 0, 0, +2},
            {40, 2, 0, 0, -2, 0, 0, +2},
            {40, 2, 0, 0, -2, 0, 0, +2},
            {40, 2, 0, 0, -2, 0, 0, +2},
            {40, 2, 0, 0, -2, 0, 0, +2},
        },
        {   30, -1, SOUND_R_APLAT, -1, -1, -1, SOUND_R_APLAT, -1, -1,
            -1, SOUND_R_APLAT, -1, -1, -1, SOUND_R_APLAT, -1, -1,
            -1, SOUND_R_APLAT, -1, -1, -1, SOUND_R_APLAT, -1, -1,
            -1, SOUND_R_APLAT, -1, -1, -1, SOUND_R_APLAT
        },
    },
    {
        ACTION_R_BUILD,
        CHBLUPI,
        {
            {8, 216, 231, 231, 216, 216, 217, 217, 216}, // e
            {8, 218, 217, 217, 218, 218, 219, 219, 218}, // se
            {8, 220, 219, 219, 220, 220, 221, 221, 220}, // s
            {8, 222, 221, 221, 222, 222, 223, 223, 222}, // so
            {8, 224, 223, 223, 224, 224, 225, 225, 224}, // o
            {8, 226, 225, 225, 226, 226, 227, 227, 226}, // no
            {8, 228, 227, 227, 228, 228, 229, 229, 228}, // n
            {8, 230, 229, 229, 230, 230, 231, 231, 230}, // ne
        },
        {
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
        },
        {   30, -1, SOUND_R_ROTATE, -1, -1, -1, SOUND_R_ROTATE, -1, -1,
            -1, SOUND_R_ROTATE, -1, -1, -1, SOUND_R_ROTATE, -1, -1,
            -1, SOUND_R_ROTATE, -1, -1, -1, SOUND_R_ROTATE, -1, -1,
            -1, SOUND_R_ROTATE, -1, -1, -1, SOUND_R_ROTATE
        },
    },
    {
        ACTION_R_DELAY,
        CHBLUPI,
        {
            {1, 216},   // e
            {1, 218},   // se
            {1, 220},   // s
            {1, 222},   // so
            {1, 224},   // o
            {1, 226},   // no
            {1, 228},   // n
            {1, 230},   // ne
        },
        {
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
            {40, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_R_LOAD,
        CHBLUPI,
        {
            {1, 216},   // e
            {1, 218},   // se
            {1, 220},   // s
            {1, 222},   // so
            {1, 224},   // o
            {1, 226},   // no
            {1, 228},   // n
            {1, 230},   // ne
        },
        {
            {40, 2, 0, 0, -1, 0, 0, +1},
            {40, 2, 0, 0, -1, 0, 0, +1},
            {40, 2, 0, 0, -1, 0, 0, +1},
            {40, 2, 0, 0, -1, 0, 0, +1},
            {40, 2, 0, 0, -1, 0, 0, +1},
            {40, 2, 0, 0, -1, 0, 0, +1},
            {40, 2, 0, 0, -1, 0, 0, +1},
            {40, 2, 0, 0, -1, 0, 0, +1},
        },
        {0},
    },
    {
        ACTION_R_CRUSHED,
        CHBLUPI,
        {
            {8, 216, 217, 217, 216, 216, 231, 231, 216}, // e
            {8, 218, 219, 219, 218, 218, 217, 217, 218}, // se
            {8, 220, 221, 221, 220, 220, 219, 219, 220}, // s
            {8, 222, 223, 223, 222, 222, 221, 221, 222}, // so
            {8, 224, 225, 225, 224, 224, 223, 223, 224}, // o
            {8, 226, 227, 227, 226, 226, 225, 225, 226}, // no
            {8, 228, 229, 229, 228, 228, 227, 227, 228}, // n
            {8, 230, 231, 231, 230, 230, 229, 229, 230}, // ne
        },
        {
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
            {16, 1, 0, 0, 0},
        },
        {0},
    },

    // Bombe :

    {
        ACTION_B_STOP,
        CHBLUPI,
        {
            {1, 232},   // e
            {1, 232},   // se
            {1, 232},   // s
            {1, 232},   // so
            {1, 232},   // o
            {1, 232},   // no
            {1, 232},   // n
            {1, 232},   // ne
        },
        {
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_B_WALK,
        CHBLUPI,
        {
            {10, 233, 233, 233, 233, 232, 232, 232, 232, 232, 232},
            {10, 233, 233, 233, 233, 232, 232, 232, 232, 232, 232},
            {10, 233, 233, 233, 233, 232, 232, 232, 232, 232, 232},
            {10, 233, 233, 233, 233, 232, 232, 232, 232, 232, 232},
            {10, 233, 233, 233, 233, 232, 232, 232, 232, 232, 232},
            {10, 233, 233, 233, 233, 232, 232, 232, 232, 232, 232},
            {10, 233, 233, 233, 233, 232, 232, 232, 232, 232, 232},
            {10, 233, 233, 233, 233, 232, 232, 232, 232, 232, 232},
        },
        {
#if 0
            {   20, 10, +150, +75, -4, +150, +75, -3, +150, +75, -2, +150, +75, -1,
                +150, +75, 0, +150, +75, 0,
                +150, +75, +1, +150, +75, +2, +150, +75, +3, +150, +75, +4
            },
            {   30, 10, 0, +100, -4, 0, +100, -3, 0, +100, -2, 0, +100, -1,
                0, +100, 0, 0, +100, 0,
                0, +100, +1, 0, +100, +2, 0, +100, +3, 0, +100, +4
            },
            {   20, 10, -150, +75, -4, -150, +75, -3, -150, +75, -2, -150, +75, -1,
                -150, +75, 0, -150, +75, 0,
                -150, +75, +1, -150, +75, +2, -150, +75, +3, -150, +75, +4
            },
            {   30, 10, -200, 0, -4, -200, 0, -3, -200, 0, -2, -200, 0, -1,
                -200, 0, 0, -200, 0, 0,
                -200, 0, +1, -200, 0, +2, -200, 0, +3, -200, 0, +4
            },
            {   20, 10, -150, -75, -4, -150, -75, -3, -150, -75, -2, -150, -75, -1,
                -150, -75, 0, -150, -75, 0,
                -150, -75, +1, -150, -75, +2, -150, -75, +3, -150, -75, +4
            },
            {   30, 10, 0, -100, -4, 0, -100, -3, 0, -100, -2, 0, -100, -1,
                0, -100, 0, 0, -100, 0,
                0, -100, +1, 0, -100, +2, 0, -100, +3, 0, -100, +4
            },
            {   20, 10, +150, -75, -4, +150, -75, -3, +150, -75, -2, +150, -75, -1,
                +150, -75, 0, +150, -75, 0,
                +150, -75, +1, +150, -75, +2, +150, -75, +3, +150, -75, +4
            },
            {   30, 10, +200, 0, -4, +200, 0, -3, +200, 0, -2, +200, 0, -1,
                +200, 0, 0, +200, 0, 0,
                +200, 0, +1, +200, 0, +2, +200, 0, +3, +200, 0, +4
            },
#else
            {   20, 10, 0, 0, +3, 0, 0, +4, 0, 0, -4, 0, 0, -3, +150, +75, -2, +300, +150, -1,
                +300, +150, 0, +300, +150, 0,
                +300, +150, +1, +150, +75, +2
            },
            {   30, 10, 0, 0, +3, 0, 0, +4, 0, 0, -4, 0, 0, -3, 0, +100, -2, 0, +200, -1,
                0, +200, 0, 0, +200, 0,
                0, +200, +1, 0, +100, +2
            },
            {   20, 10, 0, 0, +3, 0, 0, +4, 0, 0, -4, 0, 0, -3, -150, +75, -2, -300, +150, -1,
                -300, +150, 0, -300, +150, 0,
                -300, +150, +1, -150, +75, +2
            },
            {   30, 10, 0, 0, +3, 0, 0, +4, 0, 0, -4, 0, 0, -3, -200, 0, -2, -400, 0, -1,
                -400, 0, 0, -400, 0, 0,
                -400, 0, +1, -200, 0, +2
            },
            {   20, 10, 0, 0, +3, 0, 0, +4, 0, 0, -4, 0, 0, -3, -150, -75, -2, -300, -150, -1,
                -300, -150, 0, -300, -150, 0,
                -300, -150, +1, -150, -75, +2
            },
            {   30, 10, 0, 0, +3, 0, 0, +4, 0, 0, -4, 0, 0, -3, 0, -100, -2, 0, -200, -1,
                0, -200, 0, 0, -200, 0,
                0, -200, +1, 0, -100, +2
            },
            {   20, 10, 0, 0, +3, 0, 0, +4, 0, 0, -4, 0, 0, -3, +150, -75, -2, +300, -150, -1,
                +300, -150, 0, +300, -150, 0,
                +300, -150, +1, +150, -75, +2
            },
            {   30, 10, 0, 0, +3, 0, 0, +4, 0, 0, -4, 0, 0, -3, +200, 0, -2, +400, 0, -1,
                +400, 0, 0, +400, 0, 0,
                +400, 0, +1, +200, 0, +2
            },
#endif
        },
        {   30, -1, -1, SOUND_B_JUMP, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, SOUND_B_JUMP, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, SOUND_B_JUMP, -1, -1, -1, -1, -1, -1, -1
        },
    },

    // Détonnateur de mine.

    {
        ACTION_D_DELAY,
        CHBLUPI,
        {
            {1, 0},
            {0}
        },
        {
            {15, 1, 0, 0, 0},
        },
        {0},
    },

    // Electro :

    {
        ACTION_E_STOP,
        CHBLUPI,
        {
            {1, 266},   // e
            {1, 266},   // se
            {1, 266},   // s
            {1, 266},   // so
            {1, 266},   // o
            {1, 266},   // no
            {1, 266},   // n
            {1, 266},   // ne
        },
        {
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
            {1, 1, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_E_WALK,
        CHBLUPI,
        {
            {1, 266},
            {1, 266},
            {1, 266},
            {1, 266},
            {1, 266},
            {1, 266},
            {1, 266},
            {1, 266},
        },
        {
            {5, 1, +600, +300, 0},
            {7, 1,    0, +429, 0},
            {5, 1, -600, +300, 0},
            {7, 1, -858,   0, 0},
            {5, 1, -600, -300, 0},
            {7, 1,    0, -429, 0},
            {5, 1, +600, -300, 0},
            {7, 1, +858,   0, 0},
        },
        {0},
    },
    {
        ACTION_E_BEGIN,
        CHBLUPI,
        {
            {1, 266},
            {1, 266},
            {1, 266},
            {1, 266},
            {1, 266},
            {1, 266},
            {1, 266},
            {1, 266},
        },
        {
            {8, 8, 0, 0, -3, 0, 0, -2, 0, 0, -1, 0, 0, 0, 0, 0, +1, 0, 0, +2, 0, 0, +3, 0, 0, 0},
            {8, 8, 0, 0, -3, 0, 0, -2, 0, 0, -1, 0, 0, 0, 0, 0, +1, 0, 0, +2, 0, 0, +3, 0, 0, 0},
            {8, 8, 0, 0, -3, 0, 0, -2, 0, 0, -1, 0, 0, 0, 0, 0, +1, 0, 0, +2, 0, 0, +3, 0, 0, 0},
            {8, 8, 0, 0, -3, 0, 0, -2, 0, 0, -1, 0, 0, 0, 0, 0, +1, 0, 0, +2, 0, 0, +3, 0, 0, 0},
            {8, 8, 0, 0, -3, 0, 0, -2, 0, 0, -1, 0, 0, 0, 0, 0, +1, 0, 0, +2, 0, 0, +3, 0, 0, 0},
            {8, 8, 0, 0, -3, 0, 0, -2, 0, 0, -1, 0, 0, 0, 0, 0, +1, 0, 0, +2, 0, 0, +3, 0, 0, 0},
            {8, 8, 0, 0, -3, 0, 0, -2, 0, 0, -1, 0, 0, 0, 0, 0, +1, 0, 0, +2, 0, 0, +3, 0, 0, 0},
            {8, 8, 0, 0, -3, 0, 0, -2, 0, 0, -1, 0, 0, 0, 0, 0, +1, 0, 0, +2, 0, 0, +3, 0, 0, 0},
        },
        {0},
    },
    {
        ACTION_E_RAYON,
        CHBLUPI,
        {
            {4, 266, 267, 268, 269},
            {4, 266, 267, 268, 269},
            {4, 266, 267, 268, 269},
            {4, 266, 267, 268, 269},
            {4, 266, 267, 268, 269},
            {4, 266, 267, 268, 269},
            {4, 266, 267, 268, 269},
            {4, 266, 267, 268, 269},
        },
        {
            {8, 1, 0, 0, 0},
            {8, 1, 0, 0, 0},
            {8, 1, 0, 0, 0},
            {8, 1, 0, 0, 0},
            {8, 1, 0, 0, 0},
            {8, 1, 0, 0, 0},
            {8, 1, 0, 0, 0},
            {8, 1, 0, 0, 0},
        },
        {0},
    },

    {
        -1
    }
};
// clang-format on

// Calcule l'action suivante.
// Retourne false lorsque l'action est terminée.

bool
Action (
  Sint16 action, Sint16 direct, Sint16 & phase, Sint16 & step, Sint16 & channel,
  Sint16 & icon, Point & pos, Sint16 & posZ, Sounds & sound)
{
  const auto * pTable = action_table;
  Sint16       nbIcon, nbPhase, nbMove, nbSound, i;

  pos.x = 0;
  pos.y = 0;
  posZ  = 0;

  while (pTable->action != -1)
  {
    if (action == pTable->action)
    {
      if (pTable->icons[1][0] == 0)
        direct = 0;

      nbIcon  = pTable->icons[direct / 16][0];
      nbPhase = pTable->moves[direct / 16][0];
      nbMove  = pTable->moves[direct / 16][1];
      nbSound = pTable->sounds[0];

      channel = pTable->channel;
      icon    = pTable->icons[direct / 16][1 + step % nbIcon];

      if (nbSound == 0 || step >= nbSound)
        sound = SOUND_NONE;
      else
        sound =
          static_cast<Sounds> (pTable->sounds[1 + step % nbSound]); // FIXME

      for (i = 0; i < phase; i++)
      {
        pos.x += pTable->moves[direct / 16][2 + (i % nbMove) * 3 + 0];
        pos.y += pTable->moves[direct / 16][2 + (i % nbMove) * 3 + 1];
        posZ += pTable->moves[direct / 16][2 + (i % nbMove) * 3 + 2];
      }

      pos.x /= 100;
      pos.y /= 100;

      if (phase >= nbPhase)
        return false;

      phase++;
      step++;

      return true;
    }

    pTable++;
  }

  return false;
}

// clang-format off
static const Sint16 rotate_table[] =
{
  0, 6, 12, 18, 24, 30, 36, 42,
  1, 7, 13, 19, 25, 31, 37, 43,
  2, 8, 14, 20, 26, 32, 38, 44,
  3, 9, 15, 21, 27, 33, 39, 45,
  4, 10, 16, 22, 28, 34, 40, 46,
  5, 11, 17, 23, 29, 35, 41, 47,

  48, 49, 50, 51, 52, 53, 54, 55,

  69, 72, 75, 78, 81, 84, 87, 90,
  70, 73, 76, 79, 82, 85, 88, 91,
  71, 74, 77, 80, 83, 86, 89, 92,

  116, 118, 120, 122, 124, 126, 128, 130,
  117, 119, 121, 123, 125, 127, 129, 131,

  322, 325, 328, 331, 334, 337, 340, 343,
  323, 326, 329, 332, 335, 338, 341, 344,
  324, 327, 330, 333, 336, 339, 342, 345,

  -1
};
// clang-format on

// Tourne une icône dans une direction donnée.

bool
Rotate (Sint16 & icon, Sint16 direct)
{
  const auto * pTable = rotate_table;
  Sint16       i;
  Sint16       offset = 0;

  if (icon >= 200 && icon <= 215) // tracks ?
  {
    icon = (direct / 8) + 200;
    return true;
  }

  if (icon >= 216 && icon <= 231) // robot ?
  {
    icon = (direct / 8) + 216;
    return true;
  }

  if (icon >= 290 && icon <= 305) // disciple ?
  {
    icon = (direct / 8) + 290;
    return true;
  }

  if (icon >= 234 && icon <= 249) // blupi en bateau ?
  {
    icon = (direct / 8) + 234;
    return true;
  }

  if (icon >= 250 && icon <= 265) // blupi en jeep ?
  {
    icon = (direct / 8) + 250;
    return true;
  }

  if (icon >= 169 && icon <= 192) // blupi malade ?
  {
    icon -= 100;
    offset = 100;
  }

  while (pTable[0] != -1)
  {
    for (i = 0; i < 8; i++)
    {
      if (icon == pTable[i])
      {
        icon = pTable[direct / 16] + offset;
        return true;
      }
    }

    pTable += 8;
  }

  return false;
}

// Retourne la direction d'une icône.

Sint32
GetIconDirect (Sint16 icon)
{
  const auto * pTable = rotate_table;
  Sint16       i;

  if (icon >= 169 && icon <= 192) // blupi malade ?
    icon -= 100;

  if (icon >= 234 && icon <= 249) // blupi en bateau ?
    return ((icon - 234) / 2) * 16;

  if (icon >= 250 && icon <= 265) // blupi en jeep ?
    return ((icon - 250) / 2) * 16;

  if (icon >= 290 && icon <= 305) // disciple ?
    return ((icon - 290) / 2) * 16;

  while (pTable[0] != -1)
  {
    for (i = 0; i < 8; i++)
      if (icon == pTable[i])
        return i * 16;

    pTable += 8;
  }

  return -1;
}

// Retourne l'amplitude d'une action, en nombre
// de cellules.

Sint32
GetAmplitude (Sint16 action)
{
  switch (action)
  {
  case ACTION_JUMP2:
    return 2;
  case ACTION_JUMP3:
    return 3;
  case ACTION_JUMP4:
    return 4;
  case ACTION_JUMP5:
    return 5;
  }

  return 1;
}
