/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "arbreidentifiant.h"

Resultat arbreidentifiant_initialisation(ArbreIdentifiant *arbreidentifiant)
{
	/* Cre un arbreidentifiant.
	 */
	*arbreidentifiant=NULL;
	return RESULTAT_OK;
}

Resultat arbreidentifiant_ajout_identifiant(ArbreIdentifiant *arbreidentifiant , Chaine identifiant , Chaine detection)
{
	/* Ajoute un identifiant que s'il ne s'y trouve pas dj.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */
	Entier comparaison;
	DEBUTZONESECURISEE
	if((*arbreidentifiant)==NULL)
	{
		if(((*arbreidentifiant)=(MaillonIdentifiant*)(malloc(sizeof(MaillonIdentifiant))))==NULL)
			return RESULTAT_ERREUR_MEMOIRE;
		(*arbreidentifiant)->inferieur=NULL;
		(*arbreidentifiant)->superieur=NULL;
//		if((((*arbreidentifiant)->identifiant)=(Chaine)(strdup((char*)(identifiant))))==NULL)
//			return RESULTAT_ERREUR_MEMOIRE;
		(*arbreidentifiant)->identifiant=identifiant;
		(*arbreidentifiant)->detection=detection;
	}
	else
	{
		comparaison=(Entier)(strcmp((char*)(identifiant),(char*)((*arbreidentifiant)->identifiant)));
		if(comparaison<0)
		{
			SECURISE(arbreidentifiant_ajout_identifiant(&((*arbreidentifiant)->inferieur),identifiant,detection));
		}
		else
		{
			if(comparaison>0)
				SECURISE(arbreidentifiant_ajout_identifiant(&((*arbreidentifiant)->superieur),identifiant,detection));
		}
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat arbreidentifiant_vide(ArbreIdentifiant *arbreidentifiant , Booleen *vide)
{
	/* Renvoie VRAI si l'arbre est vide.
	 */
	*vide=(*arbreidentifiant)==NULL;
	return RESULTAT_OK;
}

Resultat arbreidentifiant_retrait_identifiant(ArbreIdentifiant *arbreidentifiant , Chaine *identifiant , Chaine *detection)
{
	/* Retire le plus petit lment de l'arbre.
	 * Renvoie RESULTAT_ERREUR_NONTROUVE si l'arbre est vide.
	 */
	DEBUTZONESECURISEE
	if((*arbreidentifiant)==NULL)
		return RESULTAT_ERREUR_NONTROUVE;
	if((*arbreidentifiant)->inferieur!=NULL)
	{
		SECURISE(arbreidentifiant_retrait_identifiant(&((*arbreidentifiant)->inferieur),identifiant,detection));
	}
	else
	{
		ArbreIdentifiant superieur=(*arbreidentifiant)->superieur;
		*identifiant=(*arbreidentifiant)->identifiant;
		*detection=(*arbreidentifiant)->detection;
		free(*arbreidentifiant);
		*arbreidentifiant=superieur;
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat arbreidentifiant_copie(ArbreIdentifiant *arbreidentifiant , ArbreIdentifiant *copie)
{
	/* Effectue une copie non intelligente de l'arbre.
	 * Il faut liberer la copie avant la copie !
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */ 
	DEBUTZONESECURISEE
	if((*arbreidentifiant)==NULL)
	{
		*copie=NULL;
	}
	else
	{
		if(((*copie)=(MaillonIdentifiant*)(malloc(sizeof(MaillonIdentifiant))))==NULL)
			return RESULTAT_ERREUR_MEMOIRE;
		if((((*copie)->identifiant)=(Chaine)(strdup((char*)((*arbreidentifiant)->identifiant))))==NULL)
			return RESULTAT_ERREUR_MEMOIRE;
		if((*arbreidentifiant)->detection!=NULL)
		{
			if((((*copie)->detection)=(Chaine)(strdup((char*)((*arbreidentifiant)->detection))))==NULL)
				return RESULTAT_ERREUR_MEMOIRE;
		}
		else
		{
			(*copie)->detection=NULL;
		}
		SECURISE(arbreidentifiant_copie(&((*arbreidentifiant)->inferieur),&((*copie)->inferieur)));
		SECURISE(arbreidentifiant_copie(&((*arbreidentifiant)->superieur),&((*copie)->superieur)));
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat arbreidentifiant_destruction(ArbreIdentifiant *arbreidentifiant)
{
	/* Dtruit un arbreidentifiant.
	 */ 
	DEBUTZONESECURISEE
	if((*arbreidentifiant)==NULL)
		return RESULTAT_OK;
	if((*arbreidentifiant)->identifiant!=NULL)
		free((*arbreidentifiant)->identifiant);
	if((*arbreidentifiant)->detection!=NULL)
		free((*arbreidentifiant)->detection);
	SECURISE(arbreidentifiant_destruction(&((*arbreidentifiant)->inferieur)));
	SECURISE(arbreidentifiant_destruction(&((*arbreidentifiant)->superieur)));
	free(*arbreidentifiant);
	*arbreidentifiant=NULL;
	FINZONESECURISEE
	return RESULTAT_OK;
}

