/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditor;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyDialog;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode1;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeDisplayEvent;
import weka.gui.treevisualizer.TreeDisplayListener;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.VisualizePanel;
import weka.gui.visualize.VisualizePanelEvent;
import weka.gui.visualize.VisualizePanelListener;

public class UserClassifier
extends Classifier
implements Drawable,
TreeDisplayListener,
VisualizePanelListener,
TechnicalInformationHandler {
    static final long serialVersionUID = 6483901103562809843L;
    private static final int LEAF = 0;
    private static final int RECTANGLE = 1;
    private static final int POLYGON = 2;
    private static final int POLYLINE = 3;
    private static final int VLINE = 5;
    private static final int HLINE = 6;
    private transient TreeVisualizer m_tView = null;
    private transient VisualizePanel m_iView = null;
    private TreeClass m_top = null;
    private TreeClass m_focus;
    private int m_nextId = 0;
    private transient JTabbedPane m_reps;
    private transient JFrame m_mainWin;
    private boolean m_built = false;
    private GenericObjectEditor m_classifiers;
    private PropertyDialog m_propertyDialog;

    public static void main(String[] argv) {
        UserClassifier.runClassifier(new UserClassifier(), argv);
    }

    public String toString() {
        if (!this.m_built) {
            return "Tree Not Built";
        }
        StringBuffer text = new StringBuffer();
        try {
            this.m_top.toString(0, text);
            this.m_top.objectStrings(text);
        }
        catch (Exception e) {
            System.out.println("error: " + e.getMessage());
        }
        return text.toString();
    }

    public void userCommand(TreeDisplayEvent e) {
        if (this.m_propertyDialog != null) {
            this.m_propertyDialog.dispose();
            this.m_propertyDialog = null;
        }
        try {
            if (this.m_iView == null || this.m_tView == null) {
                // empty if block
            }
            if (e.getCommand() != 0) {
                int well;
                if (e.getCommand() == 1) {
                    if (this.m_top == null) {
                        System.out.println("Error : Received event from a TreeDisplayer that is unknown to the classifier.");
                    } else {
                        this.m_tView.setHighlight(e.getID());
                        this.m_focus = this.m_top.getNode(e.getID());
                        this.m_iView.setInstances(this.m_focus.m_training);
                        if (this.m_focus.m_attrib1 >= 0) {
                            this.m_iView.setXIndex(this.m_focus.m_attrib1);
                        }
                        if (this.m_focus.m_attrib2 >= 0) {
                            this.m_iView.setYIndex(this.m_focus.m_attrib2);
                        }
                        this.m_iView.setColourIndex(this.m_focus.m_training.classIndex());
                        if (((Double)((FastVector)this.m_focus.m_ranges.elementAt(0)).elementAt(0)).intValue() != 0) {
                            this.m_iView.setShapes(this.m_focus.m_ranges);
                        }
                    }
                } else if (e.getCommand() == 2) {
                    this.m_focus = this.m_top.getNode(e.getID());
                    this.m_iView.setInstances(this.m_focus.m_training);
                    if (this.m_focus.m_attrib1 >= 0) {
                        this.m_iView.setXIndex(this.m_focus.m_attrib1);
                    }
                    if (this.m_focus.m_attrib2 >= 0) {
                        this.m_iView.setYIndex(this.m_focus.m_attrib2);
                    }
                    this.m_iView.setColourIndex(this.m_focus.m_training.classIndex());
                    if (((Double)((FastVector)this.m_focus.m_ranges.elementAt(0)).elementAt(0)).intValue() != 0) {
                        this.m_iView.setShapes(this.m_focus.m_ranges);
                    }
                    this.m_focus.m_set1 = null;
                    this.m_focus.m_set2 = null;
                    this.m_focus.setInfo(this.m_focus.m_attrib1, this.m_focus.m_attrib2, null);
                    this.m_tView = new TreeVisualizer((TreeDisplayListener)this, this.graph(), (NodePlace)new PlaceNode2());
                    this.m_reps.setComponentAt(0, this.m_tView);
                    this.m_tView.setHighlight(this.m_focus.m_identity);
                } else if (e.getCommand() == 4) {
                    Classifier classifierAtNode;
                    this.m_focus = this.m_top.getNode(e.getID());
                    this.m_iView.setInstances(this.m_focus.m_training);
                    if (this.m_focus.m_attrib1 >= 0) {
                        this.m_iView.setXIndex(this.m_focus.m_attrib1);
                    }
                    if (this.m_focus.m_attrib2 >= 0) {
                        this.m_iView.setYIndex(this.m_focus.m_attrib2);
                    }
                    this.m_iView.setColourIndex(this.m_focus.m_training.classIndex());
                    if (((Double)((FastVector)this.m_focus.m_ranges.elementAt(0)).elementAt(0)).intValue() != 0) {
                        this.m_iView.setShapes(this.m_focus.m_ranges);
                    }
                    if ((classifierAtNode = this.m_focus.getClassifier()) != null) {
                        this.m_classifiers.setValue(classifierAtNode);
                    }
                    this.m_propertyDialog = new PropertyDialog((Frame)null, (PropertyEditor)this.m_classifiers, this.m_mainWin.getLocationOnScreen().x, this.m_mainWin.getLocationOnScreen().y);
                    this.m_propertyDialog.setVisible(true);
                    this.m_tView.setHighlight(this.m_focus.m_identity);
                } else if (e.getCommand() == 3 && (well = JOptionPane.showConfirmDialog(this.m_mainWin, "Are You Sure...\nClick Yes To Accept The Tree\n Click No To Return", "Accept Tree", 0)) == 0) {
                    this.m_mainWin.setDefaultCloseOperation(2);
                    this.m_mainWin.dispose();
                    this.blocker(false);
                }
            }
        }
        catch (Exception er) {
            System.out.println("Error : " + er);
            System.out.println("Part of user input so had to catch here");
            er.printStackTrace();
        }
    }

    public void userDataEvent(VisualizePanelEvent e) {
        if (this.m_propertyDialog != null) {
            this.m_propertyDialog.dispose();
            this.m_propertyDialog = null;
        }
        try {
            if (this.m_focus != null) {
                double wdom = e.getInstances1().numInstances() + e.getInstances2().numInstances();
                if (wdom == 0.0) {
                    wdom = 1.0;
                }
                TreeClass tmp = this.m_focus;
                this.m_focus.m_set1 = new TreeClass(null, e.getAttribute1(), e.getAttribute2(), this.m_nextId, (double)e.getInstances1().numInstances() / wdom, e.getInstances1(), this.m_focus);
                this.m_focus.m_set2 = new TreeClass(null, e.getAttribute1(), e.getAttribute2(), this.m_nextId, (double)e.getInstances2().numInstances() / wdom, e.getInstances2(), this.m_focus);
                this.m_focus.setInfo(e.getAttribute1(), e.getAttribute2(), e.getValues());
                this.m_tView = new TreeVisualizer((TreeDisplayListener)this, this.graph(), (NodePlace)new PlaceNode2());
                this.m_reps.setComponentAt(0, this.m_tView);
                this.m_focus = this.m_focus.m_set2;
                this.m_tView.setHighlight(this.m_focus.m_identity);
                this.m_iView.setInstances(this.m_focus.m_training);
                if (tmp.m_attrib1 >= 0) {
                    this.m_iView.setXIndex(tmp.m_attrib1);
                }
                if (tmp.m_attrib2 >= 0) {
                    this.m_iView.setYIndex(tmp.m_attrib2);
                }
                this.m_iView.setColourIndex(this.m_focus.m_training.classIndex());
                if (((Double)((FastVector)this.m_focus.m_ranges.elementAt(0)).elementAt(0)).intValue() != 0) {
                    this.m_iView.setShapes(this.m_focus.m_ranges);
                }
            } else {
                System.out.println("Somehow the focus is null");
            }
        }
        catch (Exception er) {
            System.out.println("Error : " + er);
            System.out.println("Part of user input so had to catch here");
        }
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        StringBuffer text = new StringBuffer();
        text.append("digraph UserClassifierTree {\nnode [fontsize=10]\nedge [fontsize=10 style=bold]\n");
        this.m_top.toDotty(text);
        return text.toString() + "}\n";
    }

    private synchronized void blocker(boolean tf) {
        if (tf) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public String globalInfo() {
        return "Interactively classify through visual means. You are Presented with a scatter graph of the data against two user selectable attributes, as well as a view of the decision tree. You can create binary splits by creating polygons around data plotted on the scatter graph, as well as by allowing another classifier to take over at points in the decision tree should you see fit.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Malcolm Ware and Eibe Frank and Geoffrey Holmes and Mark Hall and Ian H. Witten");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.TITLE, "Interactive machine learning: letting users build classifiers");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Int. J. Hum.-Comput. Stud.");
        result.setValue(TechnicalInformation.Field.VOLUME, "55");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        result.setValue(TechnicalInformation.Field.PAGES, "281-292");
        result.setValue(TechnicalInformation.Field.PS, "http://www.cs.waikato.ac.nz/~ml/publications/2000/00MW-etal-Interactive-ML.ps");
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    public void buildClassifier(Instances i) throws Exception {
        this.getCapabilities().testWithFail(i);
        i = new Instances(i);
        i.deleteWithMissingClass();
        this.m_classifiers = new GenericObjectEditor(true);
        this.m_classifiers.setClassType(Classifier.class);
        this.m_classifiers.setValue(new ZeroR());
        ((GenericObjectEditor.GOEPanel)this.m_classifiers.getCustomEditor()).addOkListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ((UserClassifier)UserClassifier.this).m_focus.m_set1 = null;
                    ((UserClassifier)UserClassifier.this).m_focus.m_set2 = null;
                    UserClassifier.this.m_focus.setInfo(((UserClassifier)UserClassifier.this).m_focus.m_attrib1, ((UserClassifier)UserClassifier.this).m_focus.m_attrib2, null);
                    UserClassifier.this.m_focus.setClassifier((Classifier)UserClassifier.this.m_classifiers.getValue());
                    UserClassifier.this.m_tView = new TreeVisualizer((TreeDisplayListener)UserClassifier.this, UserClassifier.this.graph(), (NodePlace)new PlaceNode2());
                    UserClassifier.this.m_tView.setHighlight(((UserClassifier)UserClassifier.this).m_focus.m_identity);
                    UserClassifier.this.m_reps.setComponentAt(0, UserClassifier.this.m_tView);
                    UserClassifier.this.m_iView.setShapes(null);
                }
                catch (Exception er) {
                    System.out.println("Error : " + er);
                    System.out.println("Part of user input so had to catch here");
                    JOptionPane.showMessageDialog(null, "Unable to use " + UserClassifier.this.m_focus.getClassifier().getClass().getName() + " at this node.\n" + "This exception was produced:\n" + er.toString(), "UserClassifier", 0);
                }
            }
        });
        this.m_built = false;
        this.m_mainWin = new JFrame();
        this.m_mainWin.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                int well = JOptionPane.showConfirmDialog(UserClassifier.this.m_mainWin, "Are You Sure...\nClick Yes To Accept The Tree\n Click No To Return", "Accept Tree", 0);
                if (well == 0) {
                    UserClassifier.this.m_mainWin.setDefaultCloseOperation(2);
                    UserClassifier.this.blocker(false);
                } else {
                    UserClassifier.this.m_mainWin.setDefaultCloseOperation(0);
                }
            }
        });
        this.m_reps = new JTabbedPane();
        this.m_mainWin.getContentPane().add(this.m_reps);
        Instances te = new Instances(i, i.numInstances());
        for (int noa = 0; noa < i.numInstances(); ++noa) {
            te.add(i.instance(noa));
        }
        te.deleteWithMissingClass();
        this.m_focus = this.m_top = new TreeClass(null, 0, 0, this.m_nextId, 1.0, te, null);
        this.m_tView = new TreeVisualizer((TreeDisplayListener)this, this.graph(), (NodePlace)new PlaceNode1());
        this.m_reps.add("Tree Visualizer", this.m_tView);
        this.m_tView.setHighlight(this.m_top.m_identity);
        this.m_iView = new VisualizePanel(this);
        this.m_iView.setInstances(this.m_top.m_training);
        this.m_iView.setColourIndex(te.classIndex());
        this.m_reps.add("Data Visualizer", this.m_iView);
        this.m_mainWin.setSize(560, 420);
        this.m_mainWin.setVisible(true);
        this.blocker(true);
        if (this.m_propertyDialog != null) {
            this.m_propertyDialog.dispose();
            this.m_propertyDialog = null;
        }
        this.m_classifiers = null;
        this.m_built = true;
    }

    public double[] distributionForInstance(Instance i) throws Exception {
        int noa;
        if (!this.m_built) {
            return null;
        }
        double[] res = this.m_top.calcClassType(i);
        if (this.m_top.m_training.classAttribute().isNumeric()) {
            return res;
        }
        double most_likely = 0.0;
        double highest = -1.0;
        double count = 0.0;
        for (noa = 0; noa < this.m_top.m_training.numClasses(); ++noa) {
            count += res[noa];
            if (!(res[noa] > highest)) continue;
            most_likely = noa;
            highest = res[noa];
        }
        if (count <= 0.0) {
            return null;
        }
        for (noa = 0; noa < this.m_top.m_training.numClasses(); ++noa) {
            res[noa] = res[noa] / count;
        }
        return res;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5535 $");
    }

    static {
        GenericObjectEditor.registerEditors();
    }

    private class TreeClass
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 595663560871347434L;
        public FastVector m_ranges;
        public int m_attrib1;
        public int m_attrib2;
        public TreeClass m_set1 = null;
        public TreeClass m_set2 = null;
        public TreeClass m_parent;
        public String m_identity;
        public double m_weight;
        public Instances m_training;
        public Classifier m_classObject;
        public Filter m_filter;

        public TreeClass(FastVector r, int a1, int a2, int id, double w, Instances i, TreeClass p) throws Exception {
            this.m_ranges = r;
            this.m_classObject = null;
            this.m_filter = null;
            this.m_training = i;
            this.m_attrib1 = a1;
            this.m_attrib2 = a2;
            this.m_identity = "N" + String.valueOf(id);
            this.m_weight = w;
            this.m_parent = p;
            UserClassifier.this.m_nextId++;
            if (this.m_ranges == null) {
                this.setLeaf();
            }
        }

        public void setClassifier(Classifier c) throws Exception {
            this.m_classObject = c;
            this.m_classObject.buildClassifier(this.m_training);
        }

        public Classifier getClassifier() {
            return this.m_classObject;
        }

        public void setInfo(int at1, int at2, FastVector ar) throws Exception {
            this.m_classObject = null;
            this.m_filter = null;
            this.m_attrib1 = at1;
            this.m_attrib2 = at2;
            this.m_ranges = ar;
            if (this.m_ranges == null) {
                this.setLeaf();
            }
        }

        private void setLeaf() throws Exception {
            if (this.m_training != null) {
                if (this.m_training.classAttribute().isNominal()) {
                    int noa;
                    this.m_ranges = new FastVector(1);
                    this.m_ranges.addElement(new FastVector(this.m_training.numClasses() + 1));
                    FastVector tmp = (FastVector)this.m_ranges.elementAt(0);
                    tmp.addElement(new Double(0.0));
                    for (noa = 0; noa < this.m_training.numClasses(); ++noa) {
                        tmp.addElement(new Double(0.0));
                    }
                    for (noa = 0; noa < this.m_training.numInstances(); ++noa) {
                        tmp.setElementAt(new Double((Double)tmp.elementAt((int)this.m_training.instance(noa).classValue() + 1) + this.m_training.instance(noa).weight()), (int)this.m_training.instance(noa).classValue() + 1);
                    }
                } else {
                    this.m_ranges = new FastVector(1);
                    double t1 = 0.0;
                    for (int noa = 0; noa < this.m_training.numInstances(); ++noa) {
                        t1 += this.m_training.instance(noa).classValue();
                    }
                    if (this.m_training.numInstances() != 0) {
                        t1 /= (double)this.m_training.numInstances();
                    }
                    double t2 = 0.0;
                    for (int noa = 0; noa < this.m_training.numInstances(); ++noa) {
                        t2 += Math.pow(this.m_training.instance(noa).classValue() - t1, 2.0);
                    }
                    if (this.m_training.numInstances() != 0) {
                        t1 = Math.sqrt(t2 / (double)this.m_training.numInstances());
                        this.m_ranges.addElement(new FastVector(2));
                        FastVector tmp = (FastVector)this.m_ranges.elementAt(0);
                        tmp.addElement(new Double(0.0));
                        tmp.addElement(new Double(t1));
                    } else {
                        this.m_ranges.addElement(new FastVector(2));
                        FastVector tmp = (FastVector)this.m_ranges.elementAt(0);
                        tmp.addElement(new Double(0.0));
                        tmp.addElement(new Double(Double.NaN));
                    }
                }
            }
        }

        public double[] calcClassType(Instance i) throws Exception {
            double x = 0.0;
            double y = 0.0;
            if (this.m_attrib1 >= 0) {
                x = i.value(this.m_attrib1);
            }
            if (this.m_attrib2 >= 0) {
                y = i.value(this.m_attrib2);
            }
            double[] rt = this.m_training.classAttribute().isNominal() ? new double[this.m_training.numClasses()] : new double[1];
            if (this.m_classObject != null) {
                if (this.m_training.classAttribute().isNominal()) {
                    rt[(int)this.m_classObject.classifyInstance((Instance)i)] = 1.0;
                } else if (this.m_filter != null) {
                    this.m_filter.input(i);
                    rt[0] = this.m_classObject.classifyInstance(this.m_filter.output());
                } else {
                    rt[0] = this.m_classObject.classifyInstance(i);
                }
                return rt;
            }
            if (((Double)((FastVector)this.m_ranges.elementAt(0)).elementAt(0)).intValue() == 0) {
                int noa;
                if (this.m_training.classAttribute().isNumeric()) {
                    this.setLinear();
                    this.m_filter.input(i);
                    rt[0] = this.m_classObject.classifyInstance(this.m_filter.output());
                    return rt;
                }
                int totaler = 0;
                FastVector tmp = (FastVector)this.m_ranges.elementAt(0);
                for (noa = 0; noa < this.m_training.numClasses(); ++noa) {
                    rt[noa] = (Double)tmp.elementAt(noa + 1);
                    totaler = (int)((double)totaler + rt[noa]);
                }
                for (noa = 0; noa < this.m_training.numClasses(); ++noa) {
                    rt[noa] = rt[noa] / (double)totaler;
                }
                return rt;
            }
            for (int noa = 0; noa < this.m_ranges.size(); ++noa) {
                FastVector tmp = (FastVector)this.m_ranges.elementAt(noa);
                if (((Double)tmp.elementAt(0)).intValue() == 5 && !Instance.isMissingValue(x) || ((Double)tmp.elementAt(0)).intValue() == 6 && !Instance.isMissingValue(y)) continue;
                if (Instance.isMissingValue(x) || Instance.isMissingValue(y)) {
                    rt = this.m_set1.calcClassType(i);
                    double[] tem = this.m_set2.calcClassType(i);
                    if (this.m_training.classAttribute().isNominal()) {
                        for (int nob = 0; nob < this.m_training.numClasses(); ++nob) {
                            int n = nob;
                            rt[n] = rt[n] * this.m_set1.m_weight;
                            int n2 = nob;
                            rt[n2] = rt[n2] + tem[nob] * this.m_set2.m_weight;
                        }
                    } else {
                        rt[0] = rt[0] * this.m_set1.m_weight;
                        rt[0] = rt[0] + tem[0] * this.m_set2.m_weight;
                    }
                    return rt;
                }
                if (((Double)tmp.elementAt(0)).intValue() == 1) {
                    if (!(x >= (Double)tmp.elementAt(1)) || !(x <= (Double)tmp.elementAt(3)) || !(y <= (Double)tmp.elementAt(2)) || !(y >= (Double)tmp.elementAt(4))) continue;
                    rt = this.m_set1.calcClassType(i);
                    return rt;
                }
                if (((Double)tmp.elementAt(0)).intValue() == 2) {
                    if (!this.inPoly(tmp, x, y)) continue;
                    rt = this.m_set1.calcClassType(i);
                    return rt;
                }
                if (((Double)tmp.elementAt(0)).intValue() != 3 || !this.inPolyline(tmp, x, y)) continue;
                rt = this.m_set1.calcClassType(i);
                return rt;
            }
            if (this.m_set2 != null) {
                rt = this.m_set2.calcClassType(i);
            }
            return rt;
        }

        private void setLinear() throws Exception {
            boolean[] attributeList = new boolean[this.m_training.numAttributes()];
            for (int noa = 0; noa < this.m_training.numAttributes(); ++noa) {
                attributeList[noa] = false;
            }
            TreeClass temp = this;
            attributeList[this.m_training.classIndex()] = true;
            while (temp != null) {
                attributeList[temp.m_attrib1] = true;
                attributeList[temp.m_attrib2] = true;
                temp = temp.m_parent;
            }
            int classind = 0;
            for (int noa = 0; noa < this.m_training.classIndex(); ++noa) {
                if (!attributeList[noa]) continue;
                ++classind;
            }
            int count = 0;
            for (int noa = 0; noa < this.m_training.numAttributes(); ++noa) {
                if (!attributeList[noa]) continue;
                ++count;
            }
            int[] attributeList2 = new int[count];
            count = 0;
            for (int noa = 0; noa < this.m_training.numAttributes(); ++noa) {
                if (!attributeList[noa]) continue;
                attributeList2[count] = noa;
                ++count;
            }
            this.m_filter = new Remove();
            ((Remove)this.m_filter).setInvertSelection(true);
            ((Remove)this.m_filter).setAttributeIndicesArray(attributeList2);
            this.m_filter.setInputFormat(this.m_training);
            Instances temp2 = Filter.useFilter(this.m_training, this.m_filter);
            temp2.setClassIndex(classind);
            this.m_classObject = new LinearRegression();
            this.m_classObject.buildClassifier(temp2);
        }

        private boolean inPolyline(FastVector ob, double x, double y) {
            double y2;
            double y1;
            int countx = 0;
            for (int noa = 1; noa < ob.size() - 4; noa += 2) {
                double change;
                y1 = (Double)ob.elementAt(noa + 1);
                y2 = (Double)ob.elementAt(noa + 3);
                double x1 = (Double)ob.elementAt(noa);
                double x2 = (Double)ob.elementAt(noa + 2);
                double vecy = y2 - y1;
                double vecx = x2 - x1;
                if (noa == 1 && noa == ob.size() - 6) {
                    if (vecy == 0.0 || !(vecx * (change = (y - y1) / vecy) + x1 >= x)) continue;
                    ++countx;
                    continue;
                }
                if (noa == 1) {
                    if (!(y < y2 && vecy > 0.0) && (!(y > y2) || !(vecy < 0.0)) || !(vecx * (change = (y - y1) / vecy) + x1 >= x)) continue;
                    ++countx;
                    continue;
                }
                if (noa == ob.size() - 6) {
                    if (!(y <= y1 && vecy < 0.0) && (!(y >= y1) || !(vecy > 0.0)) || !(vecx * (change = (y - y1) / vecy) + x1 >= x)) continue;
                    ++countx;
                    continue;
                }
                if (!(y1 <= y && y < y2) && (!(y2 < y) || !(y <= y1)) || vecy == 0.0 || !(vecx * (change = (y - y1) / vecy) + x1 >= x)) continue;
                ++countx;
            }
            y1 = (Double)ob.elementAt(ob.size() - 2);
            if (y1 > (y2 = ((Double)ob.elementAt(ob.size() - 1)).doubleValue())) {
                if (y1 >= y && y > y2) {
                    ++countx;
                }
            } else if (y1 >= y || y > y2) {
                ++countx;
            }
            return countx % 2 == 1;
        }

        private boolean inPoly(FastVector ob, double x, double y) {
            int count = 0;
            for (int noa = 1; noa < ob.size() - 2; noa += 2) {
                double change;
                double vecy;
                double y1 = (Double)ob.elementAt(noa + 1);
                double y2 = (Double)ob.elementAt(noa + 3);
                if (!((y1 <= y && y < y2 || y2 < y && y <= y1) && (vecy = y2 - y1) != 0.0)) continue;
                double x1 = (Double)ob.elementAt(noa);
                double x2 = (Double)ob.elementAt(noa + 2);
                double vecx = x2 - x1;
                if (!(vecx * (change = (y - y1) / vecy) + x1 >= x)) continue;
                ++count;
            }
            return count % 2 == 1;
        }

        public TreeClass getNode(String id) {
            TreeClass tmp;
            if (id.equals(this.m_identity)) {
                return this;
            }
            if (this.m_set1 != null && (tmp = this.m_set1.getNode(id)) != null) {
                return tmp;
            }
            if (this.m_set2 != null && (tmp = this.m_set2.getNode(id)) != null) {
                return tmp;
            }
            return null;
        }

        public void getAlternateLabel(StringBuffer s) throws Exception {
            FastVector tmp = (FastVector)this.m_ranges.elementAt(0);
            if (this.m_classObject != null && this.m_training.classAttribute().isNominal()) {
                s.append("Classified by " + this.m_classObject.getClass().getName());
            } else if (((Double)tmp.elementAt(0)).intValue() == 0) {
                if (this.m_training.classAttribute().isNominal()) {
                    double high = -1000.0;
                    int num = 0;
                    double count = 0.0;
                    for (int noa = 0; noa < this.m_training.classAttribute().numValues(); ++noa) {
                        if ((Double)tmp.elementAt(noa + 1) > high) {
                            high = (Double)tmp.elementAt(noa + 1);
                            num = noa + 1;
                        }
                        count += ((Double)tmp.elementAt(noa + 1)).doubleValue();
                    }
                    s.append(this.m_training.classAttribute().value(num - 1) + "(" + count);
                    if (count > high) {
                        s.append("/" + (count - high));
                    }
                    s.append(")");
                } else {
                    if (this.m_classObject == null && ((Double)tmp.elementAt(0)).intValue() == 0) {
                        this.setLinear();
                    }
                    s.append("Standard Deviation = " + Utils.doubleToString((Double)tmp.elementAt(1), 6));
                }
            } else {
                s.append("Split on ");
                s.append(this.m_training.attribute(this.m_attrib1).name() + " AND ");
                s.append(this.m_training.attribute(this.m_attrib2).name());
            }
        }

        public void getLabel(StringBuffer s) throws Exception {
            FastVector tmp = (FastVector)this.m_ranges.elementAt(0);
            if (this.m_classObject != null && this.m_training.classAttribute().isNominal()) {
                s.append("Classified by\\n" + this.m_classObject.getClass().getName());
            } else if (((Double)tmp.elementAt(0)).intValue() == 0) {
                if (this.m_training.classAttribute().isNominal()) {
                    boolean first = true;
                    for (int noa = 0; noa < this.m_training.classAttribute().numValues(); ++noa) {
                        if (!((Double)tmp.elementAt(noa + 1) > 0.0)) continue;
                        if (first) {
                            s.append("[" + this.m_training.classAttribute().value(noa));
                            first = false;
                        } else {
                            s.append("\\n[" + this.m_training.classAttribute().value(noa));
                        }
                        s.append(", " + (Double)tmp.elementAt(noa + 1) + "]");
                    }
                } else {
                    if (this.m_classObject == null && ((Double)tmp.elementAt(0)).intValue() == 0) {
                        this.setLinear();
                    }
                    s.append("Standard Deviation = " + Utils.doubleToString((Double)tmp.elementAt(1), 6));
                }
            } else {
                s.append("Split on\\n");
                s.append(this.m_training.attribute(this.m_attrib1).name() + " AND\\n");
                s.append(this.m_training.attribute(this.m_attrib2).name());
            }
        }

        public void toDotty(StringBuffer t) throws Exception {
            t.append(this.m_identity + " [label=\"");
            this.getLabel(t);
            t.append("\" ");
            if (((Double)((FastVector)this.m_ranges.elementAt(0)).elementAt(0)).intValue() == 0) {
                t.append("shape=box ");
            } else {
                t.append("shape=ellipse ");
            }
            t.append("style=filled color=gray95]\n");
            if (this.m_set1 != null) {
                t.append(this.m_identity + "->");
                t.append(this.m_set1.m_identity + " [label=\"True\"]\n");
                this.m_set1.toDotty(t);
            }
            if (this.m_set2 != null) {
                t.append(this.m_identity + "->");
                t.append(this.m_set2.m_identity + " [label=\"False\"]\n");
                this.m_set2.toDotty(t);
            }
        }

        public void objectStrings(StringBuffer t) {
            if (this.m_classObject != null) {
                t.append("\n\n" + this.m_identity + " {\n" + this.m_classObject.toString() + "\n}");
            }
            if (this.m_set1 != null) {
                this.m_set1.objectStrings(t);
            }
            if (this.m_set2 != null) {
                this.m_set2.objectStrings(t);
            }
        }

        public void toString(int l, StringBuffer t) throws Exception {
            int noa;
            if (((Double)((FastVector)this.m_ranges.elementAt(0)).elementAt(0)).intValue() == 0) {
                t.append(": " + this.m_identity + " ");
                this.getAlternateLabel(t);
            }
            if (this.m_set1 != null) {
                t.append("\n");
                for (noa = 0; noa < l; ++noa) {
                    t.append("|   ");
                }
                this.getAlternateLabel(t);
                t.append(" (In Set)");
                this.m_set1.toString(l + 1, t);
            }
            if (this.m_set2 != null) {
                t.append("\n");
                for (noa = 0; noa < l; ++noa) {
                    t.append("|   ");
                }
                this.getAlternateLabel(t);
                t.append(" (Not in Set)");
                this.m_set2.toString(l + 1, t);
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5535 $");
        }
    }
}

