#include "spectrumwidget.h"
#include "qsstvglobal.h"
#include "ui_spectrumwidget.h"
#include "utils/supportfunctions.h"
#include "utils/logging.h"
#include "markerwidget.h"

spectrumWidget::spectrumWidget(QWidget *parent) :
  QFrame(parent),
  ui(new Ui::spectrumWidget)
{
  ui->setupUi(this);
  readSettings();
  connect(ui->maxDbSpinbox,SIGNAL(valueChanged(int)),SLOT(slotMaxDbChanged(int)));
  connect(ui->rangeSpinBox,SIGNAL(valueChanged(int)),SLOT(slotRangeChanged(int)));
}

spectrumWidget::~spectrumWidget()
{
  writeSettings();
  delete ui;
}

void spectrumWidget::init(int size,int slices,int isamplingrate)
{
  addToLog(QString("Size: %1, Slices %2, Samplingrate %3").arg(size).arg(slices).arg(isamplingrate),LOGFFT);
  ui->fftFrame->init(size,slices,isamplingrate);
//  ui->fftFrame->setMarkerLabel(ui->markerLabel);
//  ui->fftFrame->setSize(ui->fftFrame->width(),ui->fftFrame->height());
}
void spectrumWidget::realFFT(short int *iBuffer)
{
  ui->fftFrame->realFFT(iBuffer);
}
void spectrumWidget::realFFT(float *iBuffer)
{
  ui->fftFrame->realFFT(iBuffer);
}

void spectrumWidget::realFFT(double *iBuffer)
{
  ui->fftFrame->realFFT(iBuffer);
}




void spectrumWidget::slotMaxDbChanged(int mb)
{
  ui->fftFrame->setMaxDb(mb);
  maxdb=mb;
}
void spectrumWidget::slotRangeChanged(int rg)
{
  ui->fftFrame->setRange(rg);
  range=rg;
}

void spectrumWidget::readSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("SPECTRUM");
  maxdb=qSettings.value("maxdb",0).toInt();
  slotMaxDbChanged(maxdb);
  range=qSettings.value("range",35).toInt();
  slotRangeChanged(range);
  qSettings.endGroup();
  setParams();
}


void spectrumWidget::writeSettings()
{
  QSettings qSettings;
  getParams();
  qSettings.beginGroup("SPECTRUM");
  qSettings.setValue( "maxdb",maxdb);
  qSettings.setValue( "range",range);
  qSettings.endGroup();
}

void spectrumWidget::getParams()
{
  getValue(maxdb,ui->maxDbSpinbox);
  getValue(range,ui->rangeSpinBox);
}

void spectrumWidget::setParams()
{
  setValue(maxdb,ui->maxDbSpinbox);
  setValue(range,ui->rangeSpinBox);
  slotMaxDbChanged(maxdb);
  slotRangeChanged(range);
}

void spectrumWidget::displaySettings(bool wf, bool drm)
{
  ui->fftFrame->displayWaterfall(wf);
  if(drm)
  {
      ui->fftFrame->setMarkers(725,1475,1850);
      ui->markerLabel->setMarkers(725,1475,1850);
    }
  else
    {
      ui->fftFrame->setMarkers(1200,1500,2300);
      ui->markerLabel->setMarkers(1200,1500,2300);
    }
}


