% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KIC.snapclust.R
\name{KIC}
\alias{KIC}
\alias{KIC.snapclust}
\title{snapclust's Kullback Information Criterion (KIC)}
\usage{
KIC(object, ...)

\method{KIC}{snapclust}(object, ...)
}
\arguments{
\item{object}{An object returned by the function \code{\link{snapclust}}.}

\item{...}{Further arguments for compatibility with the \code{AIC} generic
(currently not used).}
}
\description{
This function computes Kullback Information Criterion (KIC) for
\code{snapclust} results.
}
\references{
Beugin M-P, Gayet T, Pontier D, Devillard S, Jombart T. A fast
    likelihood solution to the genetic clustering problem. Methods Ecol
    Evol. 2018;00:1–11. \url{https://doi.org/10.1111/2041-210X.12968}
}
\seealso{
\itemize{
 \item \code{\link{snapclust}}: to identify clusters

 \item \code{\link{snapclust.choose.k}}: to find the number of clusters

 \item \code{\link{AIC.snapclust}}: AIC computation

 \item \code{\link{AICc.snapclust}}: AICc computation

 \item \code{\link{BIC.snapclust}}: BIC computation

}
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
