% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_effects.R
\name{conditional_effects.brmsfit}
\alias{conditional_effects.brmsfit}
\alias{marginal_effects}
\alias{marginal_effects.brmsfit}
\alias{conditional_effects}
\alias{plot.brms_conditional_effects}
\title{Display Conditional Effects of Predictors}
\usage{
\method{conditional_effects}{brmsfit}(
  x,
  effects = NULL,
  conditions = NULL,
  int_conditions = NULL,
  re_formula = NA,
  robust = TRUE,
  probs = c(0.025, 0.975),
  method = "pp_expect",
  spaghetti = FALSE,
  surface = FALSE,
  categorical = FALSE,
  ordinal = FALSE,
  transform = NULL,
  resolution = 100,
  select_points = 0,
  too_far = 0,
  ...
)

conditional_effects(x, ...)

\method{plot}{brms_conditional_effects}(
  x,
  ncol = NULL,
  points = FALSE,
  rug = FALSE,
  mean = TRUE,
  jitter_width = 0,
  stype = c("contour", "raster"),
  line_args = list(),
  cat_args = list(),
  errorbar_args = list(),
  surface_args = list(),
  spaghetti_args = list(),
  point_args = list(),
  rug_args = list(),
  facet_args = list(),
  theme = NULL,
  ask = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{brmsfit}.}

\item{effects}{An optional character vector naming effects
(main effects or interactions) for which to compute conditional plots.
Interactions are specified by a \code{:} between variable names.
If \code{NULL} (the default), plots are generated for all main effects
and two-way interactions estimated in the model. When specifying
\code{effects} manually, \emph{all} two-way interactions may be plotted
even if not originally modeled.}

\item{conditions}{An optional \code{data.frame} containing variable values
to condition on. Each effect defined in \code{effects} will
be plotted separately for each row of \code{conditions}. Values in the 
\code{cond__} column will be used as titles of the subplots. If \code{cond__} 
is not given, the row names will be used for this purpose instead.
It is recommended to only define a few rows in order to keep the plots clear.
See \code{\link{make_conditions}} for an easy way to define conditions.
If \code{NULL} (the default), numeric variables will be conditionalized by
using their means and factors will get their reference level assigned.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{int_conditions}{An optional named \code{list} whose elements are numeric
vectors of values of the second variables in two-way interactions. 
At these values, predictions are evaluated. The names of 
\code{int_conditions} have to match the variable names exactly.
Additionally, the elements of the numeric vectors may be named themselves,
in which case their names appear as labels for the conditions in the plots.
Instead of vectors, functions returning vectors may be passed and are
applied on the original values of the corresponding variable.
If \code{NULL} (the default), predictions are evaluated at the 
\eqn{mean} and at \eqn{mean +/- sd}.}

\item{re_formula}{A formula containing random effects to be considered 
in the conditional predictions. If \code{NULL}, include all random effects; 
if \code{NA} (default), include no random effects.}

\item{robust}{If \code{TRUE} (the default) the median is used as the 
measure of central tendency. If \code{FALSE} the mean is used instead.}

\item{probs}{The quantiles to be used in the computation of credible
intervals (defaults to 2.5 and 97.5 percent quantiles)}

\item{method}{Method use to obtain predictions. Either
\code{"pp_expect"} (the default) or \code{"posterior_predict"}.}

\item{spaghetti}{Logical. Indicates if predictions should
be visualized via spaghetti plots. Only applied for numeric
predictors. If \code{TRUE}, it is recommended 
to set argument \code{nsamples} to a relatively small value 
(e.g. \code{100}) in order to reduce computation time.}

\item{surface}{Logical. Indicates if interactions or 
two-dimensional smooths should be visualized as a surface. 
Defaults to \code{FALSE}. The surface type can be controlled 
via argument \code{stype} of the related plotting method.}

\item{categorical}{Logical. Indicates if effects of categorical 
or ordinal models should be shown in terms of probabilities
of response categories. Defaults to \code{FALSE}.}

\item{ordinal}{Deprecated! Please use argument \code{categorical}.
Logical. Indicates if effects in ordinal models
should be visualized as a raster with the response categories
on the y-axis. Defaults to \code{FALSE}.}

\item{transform}{A function or a character string naming 
a function to be applied on the predicted responses
before summary statistics are computed. Only allowed
if \code{method = "posterior_predict"}.}

\item{resolution}{Number of support points used to generate 
the plots. Higher resolution leads to smoother plots. 
Defaults to \code{100}. If \code{surface} is \code{TRUE},
this implies \code{10000} support points for interaction terms,
so it might be necessary to reduce \code{resolution} 
when only few RAM is available.}

\item{select_points}{Positive number. 
Only relevant if \code{points} or \code{rug} are set to \code{TRUE}: 
Actual data points of numeric variables that 
are too far away from the values specified in \code{conditions} 
can be excluded from the plot. Values are scaled into 
the unit interval and then points more than \code{select_points} 
from the values in \code{conditions} are excluded. 
By default, all points are used.}

\item{too_far}{Positive number. 
For surface plots only: Grid points that are too 
far away from the actual data points can be excluded from the plot. 
\code{too_far} determines what is too far. The grid is scaled into 
the unit square and then grid points more than \code{too_far} 
from the predictor variables are excluded. By default, all
grid points are used. Ignored for non-surface plots.}

\item{...}{Further arguments such as \code{subset} or \code{nsamples}
passed to \code{\link[brms:posterior_predict.brmsfit]{posterior_predict}} or 
\code{\link[brms:pp_expect.brmsfit]{pp_expect}}.}

\item{ncol}{Number of plots to display per column for each effect.
If \code{NULL} (default), \code{ncol} is computed internally based
on the number of rows of \code{conditions}.}

\item{points}{Logical; indicating whether the original data points
should be added via \code{\link[ggplot2:geom_jitter]{geom_jitter}}.
Default is \code{FALSE}. Note that only those data points will be added
that match the specified conditions defined in \code{conditions}.
For categorical predictors, the conditions have to match exactly. 
For numeric predictors, argument \code{select_points} is used to
determine, which points do match a condition.}

\item{rug}{Logical; indicating whether a rug representation of predictor
values should be added via \code{\link[ggplot2:geom_rug]{geom_rug}}.
Default is \code{FALSE}. Depends on \code{select_points} in the same
way as \code{points} does.}

\item{mean}{Logical; only relevant for spaghetti plots.
If \code{TRUE} (the default), display the mean regression 
line on top of the regression lines for each sample.}

\item{jitter_width}{Only used if \code{points = TRUE}: 
Amount of horizontal jittering of the data points.
Mainly useful for ordinal models. Defaults to \code{0} that 
is no jittering.}

\item{stype}{Indicates how surface plots should be displayed.
Either \code{"contour"} or \code{"raster"}.}

\item{line_args}{Only used in plots of continuous predictors:
A named list of arguments passed to 
\code{\link[ggplot2:geom_smooth]{geom_smooth}}.}

\item{cat_args}{Only used in plots of categorical predictors:
A named list of arguments passed to 
\code{\link[ggplot2:geom_point]{geom_point}}.}

\item{errorbar_args}{Only used in plots of categorical predictors:
A named list of arguments passed to 
\code{\link[ggplot2:geom_errorbar]{geom_errorbar}}.}

\item{surface_args}{Only used in surface plots:
A named list of arguments passed to 
\code{\link[ggplot2:geom_contour]{geom_contour}} or
\code{\link[ggplot2:geom_raster]{geom_raster}}
(depending on argument \code{stype}).}

\item{spaghetti_args}{Only used in spaghetti plots:
A named list of arguments passed to 
\code{\link[ggplot2:geom_smooth]{geom_smooth}}.}

\item{point_args}{Only used if \code{points = TRUE}: 
A named list of arguments passed to 
\code{\link[ggplot2:geom_jitter]{geom_jitter}}.}

\item{rug_args}{Only used if \code{rug = TRUE}: 
A named list of arguments passed to 
\code{\link[ggplot2:geom_rug]{geom_rug}}.}

\item{facet_args}{Only used if if multiple condtions are provided: 
A named list of arguments passed to 
\code{\link[ggplot2:facet_wrap]{facet_wrap}}.}

\item{theme}{A \code{\link[ggplot2:theme]{theme}} object 
modifying the appearance of the plots. 
For some basic themes see \code{\link[ggplot2:ggtheme]{ggtheme}}
and \code{\link[bayesplot:theme_default]{theme_default}}.}

\item{ask}{Logical; indicates if the user is prompted 
before a new page is plotted. 
Only used if \code{plot} is \code{TRUE}.}

\item{plot}{Logical; indicates if plots should be
plotted directly in the active graphic device.
Defaults to \code{TRUE}.}
}
\value{
An object of class \code{'brms_conditional_effects'}, which is a
  named list with one data.frame per effect containing all information
  required to generate conditional effects plots. Among others, these
  data.frames contain some special variables, namely \code{estimate__}
  (predicted values of the response), \code{se__} (standard error of the
  predicted response), \code{lower__} and \code{upper__} (lower and upper
  bounds of the uncertainty interval of the response), as well as
  \code{cond__} (used in faceting when \code{conditions} contains multiple
  rows).
  
  The corresponding \code{plot} method returns a named 
  list of \code{\link[ggplot2:ggplot]{ggplot}} objects, which can be further 
  customized using the \pkg{ggplot2} package.
}
\description{
Display conditional effects of one or more numeric and/or categorical 
predictors including two-way interaction effects.
}
\details{
When creating \code{conditional_effects} for a particular predictor 
  (or interaction of two predictors), one has to choose the values of all 
  other predictors to condition on. 
  By default, the mean is used for continuous variables
  and the reference category is used for factors, but you may change these
  values via argument \code{conditions}. 
  This also has an implication for the \code{points} argument: 
  In the created plots, only those points will be shown that correspond 
  to the factor levels actually used in the conditioning, in order not 
  to create the false impression of bad model fit, where it is just 
  due to conditioning on certain factor levels.
  
  To fully change colors of the created plots, 
  one has to amend both \code{scale_colour} and \code{scale_fill}.
  See \code{\link[ggplot2:scale_colour_grey]{scale_colour_grey}} or
  \code{\link[ggplot2:scale_colour_gradient]{scale_colour_gradient}}
  for more details.
}
\examples{
\dontrun{
fit <- brm(count ~ zAge + zBase * Trt + (1 | patient),
           data = epilepsy, family = poisson()) 
           
## plot all conditional effects
plot(conditional_effects(fit), ask = FALSE)

## change colours to grey scale
library(ggplot2)
me <- conditional_effects(fit, "zBase:Trt")
plot(me, plot = FALSE)[[1]] + 
  scale_color_grey() +
  scale_fill_grey()

## only plot the conditional interaction effect of 'zBase:Trt'
## for different values for 'zAge'
conditions <- data.frame(zAge = c(-1, 0, 1))
plot(conditional_effects(fit, effects = "zBase:Trt", 
                         conditions = conditions))
                      
## also incorporate random effects variance over patients
## also add data points and a rug representation of predictor values
plot(conditional_effects(fit, effects = "zBase:Trt", 
                         conditions = conditions, re_formula = NULL), 
     points = TRUE, rug = TRUE)
 
## change handling of two-way interactions
int_conditions <- list(
  zBase = setNames(c(-2, 1, 0), c("b", "c", "a"))
)
conditional_effects(fit, effects = "Trt:zBase",
                    int_conditions = int_conditions)
conditional_effects(fit, effects = "Trt:zBase",
                    int_conditions = list(zBase = quantile))        
     
## fit a model to illustrate how to plot 3-way interactions
fit3way <- brm(count ~ zAge * zBase * Trt, data = epilepsy)
conditions <- make_conditions(fit3way, "zAge")
conditional_effects(fit3way, "zBase:Trt", conditions = conditions)
## only include points close to the specified values of zAge
me <- conditional_effects(
  fit3way, "zBase:Trt", conditions = conditions, 
  select_points = 0.1
)
plot(me, points = TRUE)
}

}
