% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{add_criterion}
\alias{add_criterion}
\alias{add_criterion.brmsfit}
\title{Add model fit criteria to model objects}
\usage{
add_criterion(x, ...)

\method{add_criterion}{brmsfit}(
  x,
  criterion,
  model_name = NULL,
  overwrite = FALSE,
  file = NULL,
  force_save = FALSE,
  ...
)
}
\arguments{
\item{x}{An \R object typically of class \code{brmsfit}.}

\item{...}{Further arguments passed to the underlying
functions computing the model fit criteria.}

\item{criterion}{Names of model fit criteria
to compute. Currently supported are \code{"loo"},
\code{"waic"}, \code{"kfold"}, \code{"loo_subsample"},
\code{"bayes_R2"} (Bayesian R-squared),
\code{"loo_R2"} (LOO-adjusted R-squared), and
\code{"marglik"} (log marginal likelihood).}

\item{model_name}{Optional name of the model. If \code{NULL}
(the default) the name is taken from the call to \code{x}.}

\item{overwrite}{Logical; Indicates if already stored fit
indices should be overwritten. Defaults to \code{FALSE}.}

\item{file}{Either \code{NULL} or a character string. In the latter case, the
fitted model object including the newly added criterion values is saved via
\code{\link{saveRDS}} in a file named after the string supplied in
\code{file}. The \code{.rds} extension is added automatically. If \code{x}
was already stored in a file before, the file name will be reused
automatically (with a message) unless overwritten by \code{file}. In any
case, \code{file} only applies if new criteria were actually added via
\code{add_criterion} or if \code{force_save} was set to \code{TRUE}.}

\item{force_save}{Logical; only relevant if \code{file} is specified and
ignored otherwise. If \code{TRUE}, the fitted model object will be saved
regardless of whether new criteria were added via \code{add_criterion}.}
}
\value{
An object of the same class as \code{x}, but
  with model fit criteria added for later usage.
}
\description{
Add model fit criteria to model objects
}
\details{
Functions \code{add_loo} and \code{add_waic} are aliases of
  \code{add_criterion} with fixed values for the \code{criterion} argument.
}
\examples{
\dontrun{
fit <- brm(count ~ Trt, data = epilepsy)
# add both LOO and WAIC at once
fit <- add_criterion(fit, c("loo", "waic"))
print(fit$criteria$loo)
print(fit$criteria$waic)
}

}
