

#' Chloroplast alignment
#' 
#' Amino acid alignment of 15 genes of 19 different chloroplast.
#' 
#' 
#' @name chloroplast
#' @docType data
#' @keywords datasets
#' @examples
#' 
#' data(chloroplast)
#' chloroplast
#' 
NULL





#' Laurasiatherian data (AWCMEE)
#' 
#' Laurasiatherian RNA sequence data
#' 
#' 
#' @name Laurasiatherian
#' @docType data
#' @source Data have been taken from \url{http://www.allanwilsoncentre.ac.nz/}
#' and were converted to R format by \email{klaus.schliep@gmail.com}.
#' @keywords datasets
#' @examples
#' 
#' data(Laurasiatherian)
#' str(Laurasiatherian)
#' 
NULL





#' Phylogenetic analysis in R
#' 
#' Phylogenetic analysis in R (Estimation of phylogenetic trees and networks
#' using Maximum Likelihood, Maximum Parsimony, Distance methods & Hadamard
#' conjugation)
#' 
#' The complete list of functions can be displayed with \code{library(help =
#' phangorn)}.
#' 
#' Further information is available in several vignettes. To show the available
#' vignettes in an HTML browser type \code{browseVignettes("phangorn")}.
#' \tabular{ll}{ \code{Trees} \tab Constructing phylogenetic trees (source,
#' pdf) \cr \code{phangorn-specials} \tab Advanced features (source, pdf) \cr
#' \code{Ancestral} \tab Ancestral sequence reconstruction (source, pdf) \cr
#' \code{Networx} \tab Splits and Networx (source, html) \cr } The first
#' vignette (to display type \code{vignette('Trees')}) gives an introduction in
#' phylogenetic analysis with phangorn. The second vignette (phangorn-special)
#' covers more advanced feature like defining special character spaces and
#' things which fit nowhere else.  More information on \bold{phangorn} can be
#' found on \url{http://www.phangorn.org}.
#' 
#' 
#' @name phangorn-package
#' @aliases phangorn-package phangorn
#' @docType package
#' @author Klaus Schliep
#' 
#' Maintainer: Klaus Schliep <klaus.schliep@@gmail.com>
#' @references Schliep K.P. (2011) phangorn: Phylogenetic analysis in R.
#' \emph{Bioinformatics}, 27(4) 592-593
#' @keywords package
NULL


#' Internal phangorn Functions
#' 
#' Internal \pkg{phangorn} functions.
#' 
#' @name phangorn-internal
#' @aliases phangorn-internal threshStateC coords map_duplicates
#' @keywords internal
NULL

#' Yeast alignment (Rokas et al.)
#' 
#' Alignment of 106 genes of 8 different species of yeast.
#' 
#' 
#' @name yeast
#' @docType data
#' @references Rokas, A., Williams, B. L., King, N., and Carroll, S. B. (2003)
#' Genome-scale approaches to resolving incongruence in molecular phylogenies.
#' \emph{Nature}, \bold{425}(6960): 798--804
#' @keywords datasets
#' @examples
#' 
#' data(yeast)
#' str(yeast)
#' 
NULL



