% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidden.R
\name{hidden}
\alias{hidden}
\title{Initialize a Shiny tag as hidden}
\usage{
hidden(...)
}
\arguments{
\item{...}{Shiny tag (or tagList or list of of tags) to make invisible}
}
\value{
The tag (or tags) that was given as an argument in a hidden state.
}
\description{
Create a Shiny tag that is invisible when the Shiny app starts. The tag can
be made visible later with \code{shinyjs::toggle} or \code{shinyjs::show}.
}
\note{
\code{shinyjs} must be initialized with a call to \code{useShinyjs()}
in the app's ui.
}
\examples{
if (interactive()) {
  library(shiny)
  shinyApp(
    ui = fluidPage(
      useShinyjs(),  # Set up shinyjs
      actionButton("btn", "Click me"),
      hidden(
        p(id = "element", "I was born invisible")
      )
    ),
    server = function(input, output) {
      observeEvent(input$btn, {
        show("element")
      })
    }
  )
}

library(shiny)
hidden(span(id = "a"), div(id = "b"))
hidden(tagList(span(id = "a"), div(id = "b")))
hidden(list(span(id = "a"), div(id = "b")))
}
\seealso{
\code{\link[shinyjs]{useShinyjs}},
\code{\link[shinyjs]{toggle}},
\code{\link[shinyjs]{show}},
\code{\link[shinyjs]{hide}}
}

