% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rimpoly.R
\name{rimpoly}
\alias{rimpoly}
\title{Random point generation inside polygon}
\usage{
rimpoly(n, z, w = NULL, correction = 1.1, maxpass = 50)
}
\arguments{
\item{n}{Number of points to generate.}

\item{z}{A pixel image of class \code{\link[spatstat.geom]{im}} defining the probability density of the points, possibly unnormalised.}

\item{w}{A polygonal window of class \code{\link[spatstat.geom]{owin}}. See `Details'.}

\item{correction}{An adjustment to the number of points generated at the initial pass of the internal loop in an effort to minimise the total number of passes required to reach \eqn{n} points. See `Details'.}

\item{maxpass}{The maximum number of passes allowed before the function exits. If this is reached before \eqn{n} points are found that fall within \code{w}, a warning is issued.}
}
\value{
An object of class \code{\link[spatstat.geom]{ppp}} containing the \code{n} generated points, defined with the polygonal \code{\link[spatstat.geom]{owin}}, \code{w}.
}
\description{
Generates a random point pattern of \eqn{n} iid points with any specified distribution based on a pixel image and a corresponding polygonal window.
}
\details{
This function is a deliberate variant of \code{\link[spatstat.random]{rpoint}} (Baddeley et. al, 2015), to be accessed when the user desires 
a randomly generated point pattern based on a pixel image, but wants the window of the point pattern to be a corresponding irregular polygon, as opposed to a binary
image mask (which, when converted to a polygon directly, gives jagged edges based on the union of the pixels). When the user specifies their own polygonal window, a \code{while} loop is called and repeated as many
times as necessary (up to \code{maxpass} times) to find \code{n} points inside \code{w} (when \code{w = NULL}, then the aforementioned union of the pixels of \code{z}
is used, obtained via \code{as.polygonal(Window(z))}). The loop is necessary because the standard behaviour of \code{\link[spatstat.random]{rpoint}} can (and often does)
yield points that sit in corners of pixels which lie outside the corresponding \code{w}.

The \code{correction} argument is used to determine how many points are generated initially,
which will be \code{ceiling(correction*n)}; to minimise the number of required passes over the loop this is by default set to give a number slightly higher than the requested \code{n}.

An error is thrown if \code{Window(z)} and \code{w} do not overlap.
}
\examples{

data(pbc)
Y <- bivariate.density(pbc,h0=2.5,res=25)

# Direct use of 'rpoint':
A <- rpoint(500,Y$z)
npoints(A)

# Using 'rimpoly' without supplying polygon:
B <- rimpoly(500,Y$z)
npoints(B)

# Using 'rimpoly' with the original pbc polygonal window:
C <- rimpoly(500,Y$z,Window(Y$pp))
npoints(C)

oldpar <- par(mfrow=c(1,3))
plot(A,main="rpoint")
plot(B,main="rimpoly (no polygon supplied)")
plot(C,main="rimpoly (original polygon supplied)")
par(oldpar)

}
\references{
Baddeley, A., Rubak, E. and Turner, R. (2015) \emph{Spatial Point Patterns: Methodology and Applications with R}, Chapman and Hall/CRC Press, UK.
}
\author{
T.M. Davies
}
