% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focus.R
\name{focus}
\alias{focus}
\alias{focus.tbl_graph}
\alias{focus.morphed_tbl_graph}
\alias{unfocus}
\alias{unfocus.tbl_graph}
\alias{unfocus.focused_tbl_graph}
\alias{unfocus.morphed_tbl_graph}
\title{Select specific nodes or edges to compute on}
\usage{
focus(.data, ...)

\method{focus}{tbl_graph}(.data, ...)

\method{focus}{morphed_tbl_graph}(.data, ...)

unfocus(.data, ...)

\method{unfocus}{tbl_graph}(.data, ...)

\method{unfocus}{focused_tbl_graph}(.data, ...)

\method{unfocus}{morphed_tbl_graph}(.data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Expressions that return a
logical value, and are defined in terms of the variables in \code{.data}.
If multiple expressions are included, they are combined with the \code{&} operator.
Only rows for which all conditions evaluate to \code{TRUE} are kept.}
}
\value{
A graph with focus applied
}
\description{
The \code{focus()}/\code{unfocus()} idiom allow you to temporarily tell tidygraph
algorithms to only calculate on a subset of the data, while keeping the full
graph intact. The purpose of this is to avoid having to calculate time
costly measures etc on all nodes or edges of a graph if only a few is needed.
E.g. you might only be interested in the shortest distance from one node to
another so rather than calculating this for all nodes you apply a focus on
one node and perform the calculation. It should be made clear that not all
algorithms will see a performance boost by being applied to a few nodes/edges
since their calculation is applied globally and the result for all
nodes/edges are provided in unison.
}
\note{
focusing is the lowest prioritised operation on a graph. Applying a
\code{\link[=morph]{morph()}} or a \code{\link[=group_by]{group_by()}} operation will unfocus the graph prior to
performing the operation. The same is true for the inverse operations
(\code{\link[=unmorph]{unmorph()}} and \code{\link[=ungroup]{ungroup()}}). Further, unfocusing will happen any time some
graph altering operation is performed, such as the \code{arrange()} and \code{slice()}
operations
}
