use strict;
use warnings;

use RT::Test tests => undef;
my $ticket = RT::Ticket->new(RT::CurrentUser->new('root'));
my ($ok, $msg) = $ticket->Create(Queue => 1, Owner => 'nobody', Subject => 'status changes');
ok($ok);

my ($baseurl, $m) = RT::Test->started_ok;
$m->add_header(Referer => $baseurl);
ok $m->login, 'logged in';

$m->get_ok("/Ticket/Display.html?id=1&Status=RESOLVED");
$m->content_like(qr/Status changed from/,
             "A status change happened");
$m->content_like(qr/Status changed from &#39;new&#39; to &#39;resolved&#39;/,
             "The new status is resolved");

$ticket->Load( $ticket->Id );
is($ticket->Status, 'resolved', "Status is now resolved");

($ok, $msg) = $ticket->SetStatus('open');
ok($ok, "Can set status back to open");

done_testing;
