/* SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Copyright:
 *   2021      Evan Nemerson <evan@nemerson.com>
 */

#define SIMDE_TEST_X86_AVX512_INSN testn

#include <test/x86/avx512/test-avx512.h>
#include <simde/x86/avx512/set.h>
#include <simde/x86/avx512/testn.h>

static int
test_simde_mm512_testn_epi64_mask (SIMDE_MUNIT_TEST_ARGS) {
#if 1
  static const struct {
    const int64_t a[8];
    const int64_t b[8];
    const simde__mmask8 r;
  } test_vec[] = {
    { {  INT64_C( 4508187367566017372), -INT64_C( 6569918542864078877), -INT64_C( 8962991843626193926),  INT64_C( 5940106029300099442),
        -INT64_C( 3474806220522527646), -INT64_C( 8461692430822565366),  INT64_C(  206077686324757234), -INT64_C( 8406745884122882184) },
      {  INT64_C( 5939611601085195705), -INT64_C( 7245777598779645353), -INT64_C( 2024139227130431915),  INT64_C( 7972417749947520834),
         INT64_C( 3474806220522527645), -INT64_C( 6708805109161690720), -INT64_C( 1406406580617291393),  INT64_C( 8406745884122882183) },
      UINT8_C(144) },
    { {  INT64_C(  502440011780718091), -INT64_C( 6158853987843597074),  INT64_C( 8480346530472994281),  INT64_C( 9054718441418449049),
        -INT64_C( 5262948987930223368),  INT64_C( 5817434754285894735),  INT64_C( 5038994455620387643), -INT64_C( 6410086071321220720) },
      { -INT64_C( 6256883783212495956),  INT64_C( 6158853987843597073), -INT64_C( 8480346530472994282),  INT64_C( 1831974856728808061),
         INT64_C( 5262948987930223367), -INT64_C( 5797282151545048028), -INT64_C( 5038994455620387644),  INT64_C( 6410086071321220719) },
      UINT8_C(214) },
    { { -INT64_C(  576688130814031434), -INT64_C( 1611003909097220691), -INT64_C(  859982337976997018),  INT64_C(   63488577835525727),
        -INT64_C( 8877278934273448285), -INT64_C( 5966482186928774029),  INT64_C( 5625287344307916414), -INT64_C( 8025167225870642222) },
      { -INT64_C( 1521877185384271226), -INT64_C( 2333405148534386816),  INT64_C( 8338992646982506338), -INT64_C(   63488577835525728),
         INT64_C( 4130150199787816355),  INT64_C( 5966482186928774028),  INT64_C( 8637754373134207434), -INT64_C( 4212515870200188911) },
      UINT8_C( 40) },
    { { -INT64_C( 5107500865354007352), -INT64_C( 7172652405436439845),  INT64_C( 7466936592040059958),  INT64_C( 5156385719971833639),
        -INT64_C( 1148429196945830273),  INT64_C( 5187442117424490317), -INT64_C( 3727061135569862247),  INT64_C( 7493839429109749816) },
      {  INT64_C( 5107500865354007351),  INT64_C( 7172652405436439844), -INT64_C( 7466936592040059959), -INT64_C( 5156385719971833640),
         INT64_C( 9086446945411128794), -INT64_C( 6401783450134545048),  INT64_C( 3727061135569862246), -INT64_C( 7493839429109749817) },
      UINT8_C(207) },
    { { -INT64_C( 5798513945331171839),  INT64_C( 5428960175976437193),  INT64_C( 6757813930750603122), -INT64_C( 5112048783095745732),
        -INT64_C( 4372678601869856680),  INT64_C( 3629998252239901186), -INT64_C( 6484313291659159634), -INT64_C( 2344923696908176739) },
      { -INT64_C( 1777860332040727659),  INT64_C( 2933009366244146152),  INT64_C( 7209367014820676603), -INT64_C( 2433034198997195791),
         INT64_C( 6831330025702076531), -INT64_C( 3629998252239901187),  INT64_C( 3470093055996161706),  INT64_C( 2344923696908176738) },
      UINT8_C(160) },
    { { -INT64_C( 6908294271050297472),  INT64_C( 8921913121712221078), -INT64_C( 6420116432106797287),  INT64_C( 1432456675824479355),
        -INT64_C( 3610282089748642993), -INT64_C( 1185021928708486906),  INT64_C( 7223262427560527820), -INT64_C(  752967942511614581) },
      { -INT64_C( 2734774782049771346), -INT64_C( 8921913121712221079),  INT64_C(  936150044919129132), -INT64_C( 1432456675824479356),
        -INT64_C( 2111564278826051324),  INT64_C( 5789745815574619276), -INT64_C( 7223262427560527821),  INT64_C(  166602392970991908) },
      UINT8_C( 74) },
    { {  INT64_C( 5016976028114287712), -INT64_C( 1200294191847835227), -INT64_C( 3025277623662505428), -INT64_C( 2013804801763072228),
         INT64_C( 3712337795058573632), -INT64_C(  823518641492363816), -INT64_C( 6729914387693378463), -INT64_C( 7263218271959429465) },
      { -INT64_C( 5016976028114287713), -INT64_C(  598996799044366445),  INT64_C( 3025277623662505427), -INT64_C( 8440351624730350469),
         INT64_C( 2915826315157796827), -INT64_C( 7425147411344599705), -INT64_C( 5178316874887116031),  INT64_C( 7263218271959429464) },
      UINT8_C(133) },
    { { -INT64_C( 3473694996123600275), -INT64_C(   57162890175005889),  INT64_C( 3713233947962996891), -INT64_C( 5822670248827836014),
         INT64_C( 7390313696471364338), -INT64_C( 2518613618650359962), -INT64_C( 1270988866395681138),  INT64_C( 7504489525265874484) },
      {  INT64_C( 1805020628100122495), -INT64_C( 7913049926615503344), -INT64_C( 1095754884881632895), -INT64_C( 5425558594338232362),
        -INT64_C( 6458612020008002158),  INT64_C( 4101134079099438164), -INT64_C( 7780565674210515367), -INT64_C( 8525150306086917177) },
      UINT8_C(  0) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i a = simde_mm512_loadu_epi64(test_vec[i].a);
    simde__m512i b = simde_mm512_loadu_epi64(test_vec[i].b);
    simde__mmask8 r = simde_mm512_testn_epi64_mask(a, b);
    simde_assert_equal_mmask8(r, test_vec[i].r);
  }

  return 0;
#else
  fputc('\n', stdout);
  for (int i = 0 ; i < 8 ; i++) {
    int64_t a_[8];
    int64_t b_[8];
    simde_test_codegen_random_memory(sizeof(a_), HEDLEY_REINTERPRET_CAST(uint8_t*, a_));
    simde_test_codegen_random_memory(sizeof(b_), HEDLEY_REINTERPRET_CAST(uint8_t*, b_));

    for (size_t j = 0 ; j < 8 ; j++)
      if (simde_test_codegen_random_i8() & 1)
        a_[j] = ~b_[j];

    simde__m512i a = simde_mm512_loadu_epi64(a_);
    simde__m512i b = simde_mm512_loadu_epi64(b_);
    simde__mmask8 r = simde_mm512_testn_epi64_mask(a, b);

    simde_test_x86_write_i64x8(2, a, SIMDE_TEST_VEC_POS_FIRST);
    simde_test_x86_write_i64x8(2, b, SIMDE_TEST_VEC_POS_MIDDLE);
    simde_test_x86_write_mmask8(2, r, SIMDE_TEST_VEC_POS_LAST);
  }
  return 1;
#endif
}

SIMDE_TEST_FUNC_LIST_BEGIN
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_testn_epi64_mask)
SIMDE_TEST_FUNC_LIST_END

#include <test/x86/avx512/test-avx512-footer.h>
