#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    se
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/sisu>
#    <https://git.sisudoc.org/projects/sisu-markup>
module SiSU_Clean_Output
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  class CleanOutput
    begin
      require 'fileutils'
        include FileUtils::Verbose
    rescue LoadError
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
        error('fileutils NOT FOUND (LoadError)')
    end
    def initialize(opt)
      @opt=opt
      z=SiSU_Env::FileMap.new(opt)
      zap=z.local_sisu_source
      if opt.cmd =~ /h/i
        zap=Dir.glob(zap).join(' ')
        @zap=if opt.cmd !~ /w/
          zap.gsub(/#{@source_path}\/concordance.html/,'')
        else zap
        end
      end
      @env=SiSU_Env::InfoEnv.new
    end
    def zap
      def deletion(fn)
        if FileTest.file?(fn)==true
          File.delete(fn)
          tell=SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns, 'remove: ' + fn)
          tell.warn unless @opt.cmd =~/q/
        end
      end
      def remove_output
        if @opt.act[:maintenance][:set] == :on
          m=InfoFile.new(@opt.fnc)
          tell=SiSU_Screen::Ansi.new(
            @opt.cmd,@opt.fns,
            'remove maintenance files from: ' + @env.processing_path.ao
          )
          tell.warn unless @opt.cmd =~/q/
          deletion(m.marshal.ao_content)
          deletion(m.marshal.ao_idx_sst_rel_html_seg)
          deletion(m.ao_idx_sst_rel)
          deletion(m.ao_idx_html)
          deletion(m.ao_idx_xhtml)
          deletion(m.ao_metadata)
          deletion(m.ao_map_nametags)
          deletion(m.ao_map_ocn_htmlseg)
          deletion(m.html_tune)
        end
        md=SiSU_Param::Parameters.new(@opt).get
        f=SiSU_Env::FileOp.new(md)
        deletion(f.place_file.html_segtoc.dir)
        deletion(f.place_file.html_scroll.dir)
        deletion(f.place_file.html_book_index.dir)
        deletion(f.place_file.html_concordance.dir)
        deletion(f.place_file.epub.dir)
        deletion("#{f.output_path.pdf.dir}/#{f.base_filename.pdf_p_letter}")
        deletion("#{f.output_path.pdf.dir}/#{f.base_filename.pdf_l_letter}")
        deletion("#{f.output_path.pdf.dir}/#{f.base_filename.pdf_p_a4}")
        deletion("#{f.output_path.pdf.dir}/#{f.base_filename.pdf_l_a4}")
        deletion("#{f.output_path.pdf.dir}/#{f.base_filename.pdf_p_a5}")
        deletion("#{f.output_path.pdf.dir}/#{f.base_filename.pdf_l_a5}")
        deletion("#{f.output_path.pdf.dir}/#{f.base_filename.pdf_p_b5}")
        deletion("#{f.output_path.pdf.dir}/#{f.base_filename.pdf_l_b5}")
        deletion("#{f.output_path.pdf.dir}/#{f.base_filename.pdf_p_legal}")
        deletion("#{f.output_path.pdf.dir}/#{f.base_filename.pdf_p_legal}")
        deletion(f.place_file.odt.dir)
        deletion(f.place_file.xhtml.dir)
        deletion(f.place_file.xml_sax.dir)
        deletion(f.place_file.xml_dom.dir)
        deletion(f.place_file.xml_scaffold_structure_sisu.dir)
        deletion(f.place_file.xml_scaffold_structure_collapse.dir)
        deletion(f.place_file.info.dir)
        deletion(f.place_file.manpage.dir)
        deletion(f.place_file.sqlite_discrete.dir)
        deletion(f.place_file.txt.dir)
        deletion(f.place_file.hash_digest.dir)
        deletion(f.place_file.manifest.dir)
        deletion(f.place_file.qrcode_md.dir)
        deletion(f.place_file.qrcode_title.dir)
        deletion(f.place_file.src.dir)
        deletion(f.place_file.sisupod.dir)
      end
      self
    end
  end
end
__END__
