/*

Copyright (c) 2007 Carl Byington - 510 Software Group, released under
the GPL version 3 or any later version at your choice available at
http://www.gnu.org/licenses/gpl-3.0.txt

*/
#ifndef context_include
#define context_include

typedef map<const char *, const char *, ltstr>  string_map;

struct CONFIG {
    // the only mutable stuff once it has been loaded from the config file
    int         reference_count;    // protected by the global config_mutex
    // all the rest is constant after loading from the config file
    int             generation;
    time_t          load_time;
    string_set      config_files;
    string_map      env_from;           // map senders to archive mailboxes
    string_map      rcpt_to;            // map recipients to archive mailboxes
    string_set      rcpt_remove;        // remove these recipients

    CONFIG();
    ~CONFIG();
    void        add_from(const char *from, const char *target)  {env_from[from] = target;      };
    void        add_to(const char *to, const char *target)      {rcpt_to[to]    = target;      };
    void        add_remove(const char *to)                      {rcpt_remove.insert(to);       };
    const char *find_from(const char *from)                     {return find(from, env_from);  };
    const char *find_to(const char *to)                         {return find(to, rcpt_to);     };
    bool        find_remove(const char *to)                     {return find(to, rcpt_remove); };
    bool        find(const char *needle, string_set &haystack);
    const char *find(const char *needle, string_map &haystack);
    void        dump();
};

extern const char *token_envfrom;
extern const char *token_include;
extern const char *token_lbrace;
extern const char *token_rbrace;
extern const char *token_rcptto;
extern const char *token_remove;
extern const char *token_semi;

extern string_set   all_strings;    // owns all the strings, only modified by the config loader thread

void discard(string_set &s);
const char* register_string(string_set &s, const char *name);
const char* register_string(const char *name);
void  clear_strings();
CONFIG *parse_config(const char *fn);
bool  load_conf(CONFIG &dc, const char *fn);
void  token_init();

#endif
