-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit.WalkStatements)
procedure Wf_Condition
  (Node           : in     STree.SyntaxNode;
   Scope          : in     Dictionary.Scopes;
   Table          : in out RefList.HashTable;
   Component_Data : in out ComponentManager.ComponentData)
is
   Condition_Result : Exp_Record;
   Ref_Var          : SeqAlgebra.Seq;
   Child            : STree.SyntaxNode;
begin
   SeqAlgebra.CreateSeq (TheHeap, Ref_Var);
   Child := Child_Node (Current_Node => Node);
   -- ASSUME Child = expression
   SystemErrors.RT_Assert
     (C       => Syntax_Node_Type (Node => Child) = SP_Symbols.expression,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Child = expression in Wf_Condition");
   Walk_Expression_P.Walk_Expression
     (Exp_Node                => Child,
      Scope                   => Scope,
      Type_Context            => Dictionary.GetPredefinedBooleanType,
      Context_Requires_Static => False,
      Ref_Var                 => Ref_Var,
      Result                  => Condition_Result,
      Component_Data          => Component_Data,
      The_Heap                => TheHeap);
   if not Dictionary.TypeIsBoolean (Condition_Result.Type_Symbol) then
      ErrorHandler.Semantic_Error
        (Err_Num   => 94,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => LexTokenManager.Null_String);
   end if;
   -- add reference variable list to RefList hash table
   RefList.AddRelation (Table, TheHeap, Node, Dictionary.NullSymbol, Ref_Var);
end Wf_Condition;
