-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (SparkLex.Lex)
procedure ApostIntro (Curr_Line : in out Line_Context;
                      Token     :    out SP_Symbols.SP_Terminal) is
   Ch1, Ch2, Ch3, Ch4 : Character;
begin
   LineManager.Accept_Char (Curr_Line => Curr_Line); -- Apostrophe already recognised
   Ch1 := E_Strings.Get_Element (E_Str => Curr_Line.Conts,
                                 Pos   => Curr_Line.Curr_Pos);
   if Graphic_Character (Ch => Ch1) then
      LineManager.Lookahead_Char (Curr_Line => Curr_Line,
                                  Ch        => Ch2);
      if Ch2 = ''' then
         if Ch1 /= '(' then
            LineManager.Accept_Lookahead (Curr_Line => Curr_Line); -- Any character literal except for '('.
            Token := SP_Symbols.character_literal;
         else
            LineManager.Lookahead_Char (Curr_Line => Curr_Line,
                                        Ch        => Ch3);
            if Graphic_Character (Ch => Ch3) then
               LineManager.Lookahead_Char (Curr_Line => Curr_Line,
                                           Ch        => Ch4);
               LineManager.Reject_Lookahead (Curr_Line => Curr_Line);
               if Ch4 = ''' then
                  -- Qualified expression - type_mark'('X'),
                  -- where X is any graphic character.
                  Token := SP_Symbols.apostrophe;
               else
                  LineManager.Accept_Char (Curr_Line => Curr_Line);
                  LineManager.Accept_Char (Curr_Line => Curr_Line); -- The character literal '('.
                  Token := SP_Symbols.character_literal;
               end if;
            else
               LineManager.Reject_Lookahead (Curr_Line => Curr_Line);
               LineManager.Accept_Char (Curr_Line => Curr_Line);
               LineManager.Accept_Char (Curr_Line => Curr_Line); -- The character literal '('.
               Token := SP_Symbols.character_literal;
            end if;
         end if;
      else
         LineManager.Reject_Lookahead (Curr_Line => Curr_Line);
         Token := SP_Symbols.apostrophe;
      end if;
   else
      LineManager.Reject_Lookahead (Curr_Line => Curr_Line);
      Token := SP_Symbols.apostrophe;
   end if;
end ApostIntro;
