-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with ExaminerConstants;
with E_Strings;

--# inherit ExaminerConstants,
--#         E_Strings,
--#         FileSystem;

package SparkFormatCommandLineData
--# own Content : Command_Line_Contents;
is

   Meta_File_Extension : constant String := "smf";

   type Source_File_Entry is record
      Source_Filename : E_Strings.T;
   end record;

   subtype Source_File_Counts is Integer range 0 .. ExaminerConstants.MaxFilesOnCommandLine;
   subtype Source_File_Positions is Integer range 0 .. ExaminerConstants.MaxFilesOnCommandLine;
   type Source_File_Lists is array (Source_File_Positions) of Source_File_Entry;

   type Expand_Or_Compress is (Expand, Compress);
   type Function_Mode_Type is (In_Mode, Unmoded);

   type Command_Line_Contents is record
      Valid                 : Boolean;
      Source_Extension      : E_Strings.T;
      Exclude_Export        : E_Strings.T;
      Number_Source         : Source_File_Counts;
      Source_File_List      : Source_File_Lists;
      Operation             : Expand_Or_Compress;
      Add_Modes             : Boolean;
      Global_Indent         : Natural;
      Export_Indent         : Natural;
      Import_Indent         : Natural;
      Inherit_Indent        : Natural;
      Own_Indent            : Natural;
      Refinement_Indent     : Natural;
      Constituent_Indent    : Natural;
      Initialization_Indent : Natural;
      Properties_Indent     : Natural;
      Separator_Indent      : Natural;
      Help                  : Boolean;
      Version               : Boolean;
      Default_Function_Mode : Function_Mode_Type;
   end record;

   Content : Command_Line_Contents;

   -- 0 is used as a sentinel value to mean "inline" output
   -- of globals, imports, exports and separators.
   Inline : constant Natural := 0;

   procedure Initialize;
   --# global out Content;
   --# derives Content from ;

end SparkFormatCommandLineData;
