/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf;

import uk.ac.bristol.star.cdf.DataType;

public class AttributeEntry {
    private final DataType dataType_;
    private final Object rawValue_;
    private final int nitem_;

    public AttributeEntry(DataType dataType, Object object, int n) {
        this.dataType_ = dataType;
        this.rawValue_ = object;
        this.nitem_ = n;
    }

    public DataType getDataType() {
        return this.dataType_;
    }

    public Object getRawValue() {
        return this.rawValue_;
    }

    public Object getShapedValue() {
        if (this.nitem_ == 0) {
            return null;
        }
        if (this.nitem_ == 1) {
            return this.dataType_.getScalar(this.rawValue_, 0);
        }
        return this.rawValue_;
    }

    public int getItemCount() {
        return this.nitem_;
    }

    public Object getItem(int n) {
        return this.dataType_.getScalar(this.rawValue_, this.dataType_.getArrayIndex(n));
    }

    public String toString() {
        if (this.rawValue_ == null || this.nitem_ == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nitem_; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.dataType_.formatArrayValue(this.rawValue_, this.dataType_.getArrayIndex(i)));
        }
        return stringBuffer.toString();
    }
}

