/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_COMMITITEM_H
#define _SVN_COMMITITEM_H

// sc
#include "svn.h"
#include "Property.h"
#include "CommitItemTypes.h"
#include "util/String.h"

// svn
#include <svn_client.h>



namespace svn
{

/**
 * This class represents subvesions svn_client_commit_item_t struct.
 */

class CommitItem
{
public:

  /**
   * This enum represents subversions svn_client_commit_item_flags.
   */

  enum Flag
  {
    Flag_Add       = SVN_CLIENT_COMMIT_ITEM_ADD,
    Flag_Delete    = SVN_CLIENT_COMMIT_ITEM_DELETE,
    Flag_TextMod   = SVN_CLIENT_COMMIT_ITEM_TEXT_MODS,
    Flag_PropMod   = SVN_CLIENT_COMMIT_ITEM_PROP_MODS,
    Flag_IsCopy    = SVN_CLIENT_COMMIT_ITEM_IS_COPY,
    Flag_LockToken = SVN_CLIENT_COMMIT_ITEM_LOCK_TOKEN
  };

  CommitItem( svn_client_commit_item_t* );

  const sc::String& getPath() const;
  const sc::String& getUrl() const;
  NodeKind getKind() const;
  bool isFile() const;
  bool isDir() const;
  long getFlags() const;

  const Properties& getProperties() const;

  const sc::String getCopyFromUrl() const;
  const Revnumber getCopyFromRev() const;

private:
  sc::String _path;
  sc::String _url;
  NodeKind   _kind;
  long       _flags;

  Properties _props;

  /**
   *  the copyfrom values are only valid if _flags is Flag_IsCopy
   */
  // @{
  sc::String _copyfromUrl;
  Revnumber  _copyfromRev;
  // @} 
};

} // namespace

#endif //  _SVN_COMMITITEM_H

