# - Try to find GiNaC
# Once done this will define
#
#   GINAC_FOUND        - System has GiNaC
#   GINAC_INCLUDE_DIRS - The GiNaC include directories
#   GINAC_LIBRARIES    - The libraries needed to use GiNaC
#   GINAC_VERSION      - GiNaC version string (MAJOR.MINOR.MICRO)

include(FindPkgConfig)
pkg_check_modules(PC_GINAC ginac>=1.4.1)

set(GINAC_VERSION ${PC_GINAC_VERSION})

find_path(GINAC_INCLUDE_DIR ginac/ginac.h
  HINTS ${PC_GINAC_INCLUDEDIR} ${GINAC_DIR}/include $ENV{GINAC_DIR}/include)

find_library(GINAC_LIBRARY ginac
  HINTS ${PC_GINAC_LIBDIR} ${GINAC_DIR}/lib $ENV{GINAC_DIR}/lib)

# GiNaC requires CLN
if (NOT CLN_FOUND)
  find_package(CLN REQUIRED)
endif()

set(GINAC_LIBRARIES ${GINAC_LIBRARY} ${CLN_LIBRARIES})
set(GINAC_INCLUDE_DIRS ${GINAC_INCLUDE_DIR} ${CLN_INCLUDE_DIRS})

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(GiNaC DEFAULT_MSG
  GINAC_LIBRARY GINAC_INCLUDE_DIR)

mark_as_advanced(GINAC_INCLUDE_DIR GINAC_LIBRARY)
