from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1


qt = _Mock()

DEBUG = 0

QTVERSION = '4.8.7'

class McaTable(_Mock):
  pass
  AboveItem = 1
  AllEditTriggers = 31
  AnimatingState = 6
  AnyKeyPressed = 16
  BelowItem = 2
  Box = 1
  CollapsingState = 5
  ContiguousSelection = 4
  CurrentChanged = 1
  DoubleClicked = 2
  DragDrop = 3
  DragOnly = 1
  DragSelectingState = 2
  DraggingState = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  DropOnly = 2
  EditKeyPressed = 8
  EditingState = 3
  EnsureVisible = 0
  ExpandingState = 4
  ExtendedSelection = 3
  HLine = 4
  IgnoreMask = 4
  InternalMove = 4
  MoveDown = 1
  MoveEnd = 5
  MoveHome = 4
  MoveLeft = 2
  MoveNext = 8
  MovePageDown = 7
  MovePageUp = 6
  MovePrevious = 9
  MoveRight = 3
  MoveUp = 0
  MultiSelection = 2
  NoDragDrop = 0
  NoEditTriggers = 0
  NoFrame = 0
  NoSelection = 0
  NoState = 0
  OnItem = 0
  OnViewport = 3
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  PositionAtBottom = 2
  PositionAtCenter = 3
  PositionAtTop = 1
  Raised = 32
  ScrollPerItem = 0
  ScrollPerPixel = 1
  SelectColumns = 2
  SelectItems = 0
  SelectRows = 1
  SelectedClicked = 4
  Shadow_Mask = 240
  Shape_Mask = 15
  SingleSelection = 1
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3

class QString(_Mock):
  pass


class QTable(_Mock):
  pass
  AboveItem = 1
  AllEditTriggers = 31
  AnimatingState = 6
  AnyKeyPressed = 16
  BelowItem = 2
  Box = 1
  CollapsingState = 5
  ContiguousSelection = 4
  CurrentChanged = 1
  DoubleClicked = 2
  DragDrop = 3
  DragOnly = 1
  DragSelectingState = 2
  DraggingState = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  DropOnly = 2
  EditKeyPressed = 8
  EditingState = 3
  EnsureVisible = 0
  ExpandingState = 4
  ExtendedSelection = 3
  HLine = 4
  IgnoreMask = 4
  InternalMove = 4
  MoveDown = 1
  MoveEnd = 5
  MoveHome = 4
  MoveLeft = 2
  MoveNext = 8
  MovePageDown = 7
  MovePageUp = 6
  MovePrevious = 9
  MoveRight = 3
  MoveUp = 0
  MultiSelection = 2
  NoDragDrop = 0
  NoEditTriggers = 0
  NoFrame = 0
  NoSelection = 0
  NoState = 0
  OnItem = 0
  OnViewport = 3
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  PositionAtBottom = 2
  PositionAtCenter = 3
  PositionAtTop = 1
  Raised = 32
  ScrollPerItem = 0
  ScrollPerPixel = 1
  SelectColumns = 2
  SelectItems = 0
  SelectRows = 1
  SelectedClicked = 4
  Shadow_Mask = 240
  Shape_Mask = 15
  SingleSelection = 1
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3

