/* SPDX-License-Identifier: GPL-3.0-only */

#define TF_ERRORS \
	TF_ERROR(SUCCESS, "success"), \
	TF_ERROR(ATOI_OVERFLOW, "value too large"), \
	TF_ERROR(ATOI_NO_DIGITS, "no digits found in string"), \
	TF_ERROR(ATOI_JUNK_AT_END, "further characters after number"), \
	TF_ERROR(LOPSUB, "lopsub error"), \
	TF_ERROR(REGEX, "regular expression error"), \
	TF_ERROR(TXP, "tag expression parse error"), \
	TF_ERROR(LH_EXIST, "item already exists in hash table"), \

/*
 * This is temporarily defined to expand to its first argument (prefixed by
 * 'E_') and gets later redefined to expand to the error text only
 */
#define TF_ERROR(err, msg) E_ ## err
enum tf_error_codes {TF_ERRORS};
#undef TF_ERROR
#define TF_ERROR(err, msg) msg
#define DEFINE_TF_ERRLIST char *tf_errlist[] = {TF_ERRORS}

extern char *tf_errlist[];

/**
 * This bit indicates whether a number is considered a system error number
 * If yes, the system errno is just the result of clearing this bit from
 * the given number.
 */
#define SYSTEM_ERROR_BIT 30

/** Check whether the system error bit is set. */
#define IS_SYSTEM_ERROR(num) (!!((num) & (1 << SYSTEM_ERROR_BIT)))

/** Set the system error bit for the given number. */
#define ERRNO_TO_TF_ERROR(num) ((num) | (1 << SYSTEM_ERROR_BIT))

static inline char *tf_strerror(int num)
{
	assert(num > 0);
	if (IS_SYSTEM_ERROR(num))
		return strerror((num) & ((1 << SYSTEM_ERROR_BIT) - 1));
	else
		return tf_errlist[num];
}

