/*
    Tucnak - VHF contest log
	Functions for mingw32
    Copyright (C) 2011 Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#ifdef __MINGW32__

MUTEX_DEFINE(strerror_r);
MUTEX_DEFINE(strtok_r);
MUTEX_DEFINE(gmtime_r);
FILE *mingw_stderr;


int init_mingw(void){
	WSADATA wsaData;

    mingw_stderr = fopen("_stderr", "wt");
    if (!mingw_stderr) internal_("Can't open file _stderr");

    MessageBox(NULL, "Hello World, I'm Tucnak compiled under mingw", "Info", MB_OK);
	MUTEX_INIT(strerror_r);
	MUTEX_INIT(strtok_r);
	MUTEX_INIT(gmtime_r);

	WSAStartup(MAKEWORD(2, 0), &wsaData);
}

/*int WINAPI WinMain1(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow){
    char **items;
    int argc;
    char *argv[100];

    init_mingw();
    items = g_strsplit(lpCmdLine, " ", 0);
    argv[0]="tucnak.exe";
    for (argc=1; items[argc-1] != 0; argc++){
        argv[argc] = items[argc-1];
    }
    main(argc, argv);
    g_strfreev(items);
} */

char *strerror_r(int err, char *errstr, int size){
	MUTEX_LOCK(strerror_r);
	safe_strncpy(errstr, strerror(err), size);
	MUTEX_UNLOCK(strerror_r);
	return errstr;
}

char *strtok_r(char *str, const char *delim, char **saveptr){
	char *c;
	MUTEX_LOCK(strtok_r);
    c = strtok(str, delim);
	MUTEX_UNLOCK(strtok_r);
	return c;
}

struct tm *gmtime_r(const time_t *timep, struct tm *result){
	struct tm *tm;
	MUTEX_LOCK(gmtime_r);
	tm = gmtime(timep);
	memcpy(result, tm, sizeof(struct tm));
	MUTEX_UNLOCK(gmtime_r);
	return result;
}

time_t timegm(struct tm *tm){
    internal_("mingw timegm() not implemented");
}

int setenv(const char *name, const char *value, int overwrite){
	char buf[1024];
   	snprintf(buf, 1023, "%s=%s", name, value);
	buf[1023] = '\0';
	putenv(buf);
	return 0;
}

void disable_screensaver(void){
}

/* socket */

char *sock_strerror_r(int err_no, char *buf, int size){
	snprintf(buf, size, "Winsock error %d", err_no);
	return buf;
}

#endif
