/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifndef __CIM_MANAGEDELEMENT_H
#define __CIM_MANAGEDELEMENT_H
#include "CimClass.h"
namespace CimClassNamespace
{

	// Class CIM_ManagedElement:
	// ManagedElement is an abstract class that provides a common superclass (or top of the inheritance tree) for the non-association classes in the CIM Schema.
	class CIM_ManagedElement  : public CimClass
	{
	public:
		// type definitions
		typedef CimClassContainer<CIM_ManagedElement> CIM_ManagedElementContainer;

		// static const declarations
		static const string CLASS_NAME;
		static const string CLASS_URI;
		static const string CLASS_NS;
		static const string CLASS_NS_PREFIX;

		// class fields
		// The Caption property is a short textual description (one- line string) of the object.
		string Caption;

		// This field determines whether the Caption field is valid.
		bool CaptionSpecified;

		// The Description property provides a textual description of the object.
		string Description;

		// This field determines whether the Description field is valid.
		bool DescriptionSpecified;

		// A user-friendly name for the object. This property allows each instance to define a user-friendly name IN ADDITION TO its key properties/identity data, and description information.
		// Note that ManagedSystemElement's Name property is also defined as a user-friendly name. But, it is often subclassed to be a Key. It is not reasonable that the same property can convey both identity and a user friendly name, without inconsistencies. Where Name exists and is not a Key (such as for instances of LogicalDevice), the same information MAY be present in both the Name and ElementName properties.
		string ElementName;

		// This field determines whether the ElementName field is valid.
		bool ElementNameSpecified;

		// Class Constructor
		CIM_ManagedElement(
			const string& objName = CIM_ManagedElement::CLASS_NAME,
			const string& uri = CIM_ManagedElement::CLASS_URI,
			const string& ns = CIM_ManagedElement::CLASS_NS,
			const string& nsPrefix = CIM_ManagedElement::CLASS_NS_PREFIX);

		// Class Destructor
		virtual ~CIM_ManagedElement(){}

		// This function appends a serialization of this instance to the given node.
		virtual void SerializeMembers(XMLElement& node) const;

		// This function returns the selector set of this instance.
		virtual NameValuePairs GetSelectorsList() const;

		// This function sets a field value according to the given node.
		virtual void SetValue(const XMLElement& node);

	};
}
#endif
