/***************************************************************************
     filteronlyproxy.cpp  -  Proxy model for filtering without sorting
                             -------------------
    begin                : Tue Nov 11 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "filteronlyproxy.h"

/** */
FilterOnlyProxy::FilterOnlyProxy( QObject * parent ) : QSortFilterProxyModel( parent )
{
	/* nothing */
}

/** */
FilterOnlyProxy::~FilterOnlyProxy()
{
	/* nothing */
}

/** */
void FilterOnlyProxy::sort( int column, Qt::SortOrder order )
{
	sourceModel()->sort( column, order );
}

/** */
bool FilterOnlyProxy::lessThan( const QModelIndex & left, const QModelIndex & right ) const
{
	return left.row() < right.row();
}
