/******************************************************************************
 * Copyright 2010,2014 by Thomas E. Dickey.  All Rights Reserved.             *
 *                                                                            *
 * Permission to use, copy, modify, and distribute this software and its      *
 * documentation for any purpose and without fee is hereby granted, provided  *
 * that the above copyright notice appear in all copies and that both that    *
 * copyright notice and this permission notice appear in supporting           *
 * documentation, and that the name of the above listed copyright holder(s)   *
 * not be used in advertising or publicity pertaining to distribution of the  *
 * software without specific, written prior permission.                       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE ABOVE LISTED COPYRIGHT HOLDER(S) DISCLAIM ALL WARRANTIES WITH REGARD   *
 * TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND  *
 * FITNESS, IN NO EVENT SHALL THE ABOVE LISTED COPYRIGHT HOLDER(S) BE LIABLE  *
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES          *
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN      *
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR *
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.                *
 *                                                                            *
 ******************************************************************************/
/* vile:cmode cts=8
 * $XTermId: gnreight.h,v 1.21 2014/01/31 09:24:29 tom Exp $
 *
 * This is a generated set of single-byte encodings,
 * using all available locales in libc6 2.13-38 - T.E.Dickey
 */
#ifndef GNREIGHT_H
#define GNREIGHT_H 1
/* *INDENT-OFF* */

/* use minimal ctype information to reduce table size */
#ifndef vl_alpha
#define vl_alpha 0x01
#define vl_cntrl 0x02
#define vl_digit 0x04
#define vl_lower 0x08
#define vl_print 0x10
#define vl_punct 0x20
#define vl_space 0x40
#define vl_upper 0x80
#endif

typedef struct {
    unsigned short chmap[128];
    unsigned char lower[128];
    unsigned char upper[128];
    unsigned char ctype[128];
} GNREIGHT_ENC;

typedef struct {
    const char *name;
    const GNREIGHT_ENC *data;
} GNREIGHT_INX;

/* POSIX table for 0-127 */
static const GNREIGHT_ENC encode_POSIX = {
    /* encode_POSIX.chmap */
    {
	     0,   0x1,   0x2,   0x3,   0x4,   0x5,   0x6,   0x7,
	   0x8,   0x9,   0xa,   0xb,   0xc,   0xd,   0xe,   0xf,
	  0x10,  0x11,  0x12,  0x13,  0x14,  0x15,  0x16,  0x17,
	  0x18,  0x19,  0x1a,  0x1b,  0x1c,  0x1d,  0x1e,  0x1f,
	  0x20,  0x21,  0x22,  0x23,  0x24,  0x25,  0x26,  0x27,
	  0x28,  0x29,  0x2a,  0x2b,  0x2c,  0x2d,  0x2e,  0x2f,
	  0x30,  0x31,  0x32,  0x33,  0x34,  0x35,  0x36,  0x37,
	  0x38,  0x39,  0x3a,  0x3b,  0x3c,  0x3d,  0x3e,  0x3f,
	  0x40,  0x41,  0x42,  0x43,  0x44,  0x45,  0x46,  0x47,
	  0x48,  0x49,  0x4a,  0x4b,  0x4c,  0x4d,  0x4e,  0x4f,
	  0x50,  0x51,  0x52,  0x53,  0x54,  0x55,  0x56,  0x57,
	  0x58,  0x59,  0x5a,  0x5b,  0x5c,  0x5d,  0x5e,  0x5f,
	  0x60,  0x61,  0x62,  0x63,  0x64,  0x65,  0x66,  0x67,
	  0x68,  0x69,  0x6a,  0x6b,  0x6c,  0x6d,  0x6e,  0x6f,
	  0x70,  0x71,  0x72,  0x73,  0x74,  0x75,  0x76,  0x77,
	  0x78,  0x79,  0x7a,  0x7b,  0x7c,  0x7d,  0x7e,  0x7f,
    },
    /* encode_POSIX.lower */
    {
	     0,   0x1,   0x2,   0x3,   0x4,   0x5,   0x6,   0x7,
	   0x8,   0x9,   0xa,   0xb,   0xc,   0xd,   0xe,   0xf,
	  0x10,  0x11,  0x12,  0x13,  0x14,  0x15,  0x16,  0x17,
	  0x18,  0x19,  0x1a,  0x1b,  0x1c,  0x1d,  0x1e,  0x1f,
	  0x20,  0x21,  0x22,  0x23,  0x24,  0x25,  0x26,  0x27,
	  0x28,  0x29,  0x2a,  0x2b,  0x2c,  0x2d,  0x2e,  0x2f,
	  0x30,  0x31,  0x32,  0x33,  0x34,  0x35,  0x36,  0x37,
	  0x38,  0x39,  0x3a,  0x3b,  0x3c,  0x3d,  0x3e,  0x3f,
	  0x40,  0x61,  0x62,  0x63,  0x64,  0x65,  0x66,  0x67,
	  0x68,  0x69,  0x6a,  0x6b,  0x6c,  0x6d,  0x6e,  0x6f,
	  0x70,  0x71,  0x72,  0x73,  0x74,  0x75,  0x76,  0x77,
	  0x78,  0x79,  0x7a,  0x5b,  0x5c,  0x5d,  0x5e,  0x5f,
	  0x60,  0x61,  0x62,  0x63,  0x64,  0x65,  0x66,  0x67,
	  0x68,  0x69,  0x6a,  0x6b,  0x6c,  0x6d,  0x6e,  0x6f,
	  0x70,  0x71,  0x72,  0x73,  0x74,  0x75,  0x76,  0x77,
	  0x78,  0x79,  0x7a,  0x7b,  0x7c,  0x7d,  0x7e,  0x7f,
    },
    /* encode_POSIX.upper */
    {
	     0,   0x1,   0x2,   0x3,   0x4,   0x5,   0x6,   0x7,
	   0x8,   0x9,   0xa,   0xb,   0xc,   0xd,   0xe,   0xf,
	  0x10,  0x11,  0x12,  0x13,  0x14,  0x15,  0x16,  0x17,
	  0x18,  0x19,  0x1a,  0x1b,  0x1c,  0x1d,  0x1e,  0x1f,
	  0x20,  0x21,  0x22,  0x23,  0x24,  0x25,  0x26,  0x27,
	  0x28,  0x29,  0x2a,  0x2b,  0x2c,  0x2d,  0x2e,  0x2f,
	  0x30,  0x31,  0x32,  0x33,  0x34,  0x35,  0x36,  0x37,
	  0x38,  0x39,  0x3a,  0x3b,  0x3c,  0x3d,  0x3e,  0x3f,
	  0x40,  0x41,  0x42,  0x43,  0x44,  0x45,  0x46,  0x47,
	  0x48,  0x49,  0x4a,  0x4b,  0x4c,  0x4d,  0x4e,  0x4f,
	  0x50,  0x51,  0x52,  0x53,  0x54,  0x55,  0x56,  0x57,
	  0x58,  0x59,  0x5a,  0x5b,  0x5c,  0x5d,  0x5e,  0x5f,
	  0x60,  0x41,  0x42,  0x43,  0x44,  0x45,  0x46,  0x47,
	  0x48,  0x49,  0x4a,  0x4b,  0x4c,  0x4d,  0x4e,  0x4f,
	  0x50,  0x51,  0x52,  0x53,  0x54,  0x55,  0x56,  0x57,
	  0x58,  0x59,  0x5a,  0x7b,  0x7c,  0x7d,  0x7e,  0x7f,
    },
    /* encode_POSIX.ctype */
    {
	/* 0 */	(vl_cntrl),
	/* 0x1 */	(vl_cntrl),
	/* 0x2 */	(vl_cntrl),
	/* 0x3 */	(vl_cntrl),
	/* 0x4 */	(vl_cntrl),
	/* 0x5 */	(vl_cntrl),
	/* 0x6 */	(vl_cntrl),
	/* 0x7 */	(vl_cntrl),
	/* 0x8 */	(vl_cntrl),
	/* 0x9 */	(vl_cntrl | vl_space),
	/* 0xa */	(vl_cntrl | vl_space),
	/* 0xb */	(vl_cntrl | vl_space),
	/* 0xc */	(vl_cntrl | vl_space),
	/* 0xd */	(vl_cntrl | vl_space),
	/* 0xe */	(vl_cntrl),
	/* 0xf */	(vl_cntrl),
	/* 0x10 */	(vl_cntrl),
	/* 0x11 */	(vl_cntrl),
	/* 0x12 */	(vl_cntrl),
	/* 0x13 */	(vl_cntrl),
	/* 0x14 */	(vl_cntrl),
	/* 0x15 */	(vl_cntrl),
	/* 0x16 */	(vl_cntrl),
	/* 0x17 */	(vl_cntrl),
	/* 0x18 */	(vl_cntrl),
	/* 0x19 */	(vl_cntrl),
	/* 0x1a */	(vl_cntrl),
	/* 0x1b */	(vl_cntrl),
	/* 0x1c */	(vl_cntrl),
	/* 0x1d */	(vl_cntrl),
	/* 0x1e */	(vl_cntrl),
	/* 0x1f */	(vl_cntrl),
	/* 0x20 */	(vl_print | vl_space),
	/* 0x21 */	(vl_print | vl_punct),
	/* 0x22 */	(vl_print | vl_punct),
	/* 0x23 */	(vl_print | vl_punct),
	/* 0x24 */	(vl_print | vl_punct),
	/* 0x25 */	(vl_print | vl_punct),
	/* 0x26 */	(vl_print | vl_punct),
	/* 0x27 */	(vl_print | vl_punct),
	/* 0x28 */	(vl_print | vl_punct),
	/* 0x29 */	(vl_print | vl_punct),
	/* 0x2a */	(vl_print | vl_punct),
	/* 0x2b */	(vl_print | vl_punct),
	/* 0x2c */	(vl_print | vl_punct),
	/* 0x2d */	(vl_print | vl_punct),
	/* 0x2e */	(vl_print | vl_punct),
	/* 0x2f */	(vl_print | vl_punct),
	/* 0x30 */	(vl_digit | vl_print),
	/* 0x31 */	(vl_digit | vl_print),
	/* 0x32 */	(vl_digit | vl_print),
	/* 0x33 */	(vl_digit | vl_print),
	/* 0x34 */	(vl_digit | vl_print),
	/* 0x35 */	(vl_digit | vl_print),
	/* 0x36 */	(vl_digit | vl_print),
	/* 0x37 */	(vl_digit | vl_print),
	/* 0x38 */	(vl_digit | vl_print),
	/* 0x39 */	(vl_digit | vl_print),
	/* 0x3a */	(vl_print | vl_punct),
	/* 0x3b */	(vl_print | vl_punct),
	/* 0x3c */	(vl_print | vl_punct),
	/* 0x3d */	(vl_print | vl_punct),
	/* 0x3e */	(vl_print | vl_punct),
	/* 0x3f */	(vl_print | vl_punct),
	/* 0x40 */	(vl_print | vl_punct),
	/* 0x41 */	(vl_alpha | vl_print | vl_upper),
	/* 0x42 */	(vl_alpha | vl_print | vl_upper),
	/* 0x43 */	(vl_alpha | vl_print | vl_upper),
	/* 0x44 */	(vl_alpha | vl_print | vl_upper),
	/* 0x45 */	(vl_alpha | vl_print | vl_upper),
	/* 0x46 */	(vl_alpha | vl_print | vl_upper),
	/* 0x47 */	(vl_alpha | vl_print | vl_upper),
	/* 0x48 */	(vl_alpha | vl_print | vl_upper),
	/* 0x49 */	(vl_alpha | vl_print | vl_upper),
	/* 0x4a */	(vl_alpha | vl_print | vl_upper),
	/* 0x4b */	(vl_alpha | vl_print | vl_upper),
	/* 0x4c */	(vl_alpha | vl_print | vl_upper),
	/* 0x4d */	(vl_alpha | vl_print | vl_upper),
	/* 0x4e */	(vl_alpha | vl_print | vl_upper),
	/* 0x4f */	(vl_alpha | vl_print | vl_upper),
	/* 0x50 */	(vl_alpha | vl_print | vl_upper),
	/* 0x51 */	(vl_alpha | vl_print | vl_upper),
	/* 0x52 */	(vl_alpha | vl_print | vl_upper),
	/* 0x53 */	(vl_alpha | vl_print | vl_upper),
	/* 0x54 */	(vl_alpha | vl_print | vl_upper),
	/* 0x55 */	(vl_alpha | vl_print | vl_upper),
	/* 0x56 */	(vl_alpha | vl_print | vl_upper),
	/* 0x57 */	(vl_alpha | vl_print | vl_upper),
	/* 0x58 */	(vl_alpha | vl_print | vl_upper),
	/* 0x59 */	(vl_alpha | vl_print | vl_upper),
	/* 0x5a */	(vl_alpha | vl_print | vl_upper),
	/* 0x5b */	(vl_print | vl_punct),
	/* 0x5c */	(vl_print | vl_punct),
	/* 0x5d */	(vl_print | vl_punct),
	/* 0x5e */	(vl_print | vl_punct),
	/* 0x5f */	(vl_print | vl_punct),
	/* 0x60 */	(vl_print | vl_punct),
	/* 0x61 */	(vl_alpha | vl_lower | vl_print),
	/* 0x62 */	(vl_alpha | vl_lower | vl_print),
	/* 0x63 */	(vl_alpha | vl_lower | vl_print),
	/* 0x64 */	(vl_alpha | vl_lower | vl_print),
	/* 0x65 */	(vl_alpha | vl_lower | vl_print),
	/* 0x66 */	(vl_alpha | vl_lower | vl_print),
	/* 0x67 */	(vl_alpha | vl_lower | vl_print),
	/* 0x68 */	(vl_alpha | vl_lower | vl_print),
	/* 0x69 */	(vl_alpha | vl_lower | vl_print),
	/* 0x6a */	(vl_alpha | vl_lower | vl_print),
	/* 0x6b */	(vl_alpha | vl_lower | vl_print),
	/* 0x6c */	(vl_alpha | vl_lower | vl_print),
	/* 0x6d */	(vl_alpha | vl_lower | vl_print),
	/* 0x6e */	(vl_alpha | vl_lower | vl_print),
	/* 0x6f */	(vl_alpha | vl_lower | vl_print),
	/* 0x70 */	(vl_alpha | vl_lower | vl_print),
	/* 0x71 */	(vl_alpha | vl_lower | vl_print),
	/* 0x72 */	(vl_alpha | vl_lower | vl_print),
	/* 0x73 */	(vl_alpha | vl_lower | vl_print),
	/* 0x74 */	(vl_alpha | vl_lower | vl_print),
	/* 0x75 */	(vl_alpha | vl_lower | vl_print),
	/* 0x76 */	(vl_alpha | vl_lower | vl_print),
	/* 0x77 */	(vl_alpha | vl_lower | vl_print),
	/* 0x78 */	(vl_alpha | vl_lower | vl_print),
	/* 0x79 */	(vl_alpha | vl_lower | vl_print),
	/* 0x7a */	(vl_alpha | vl_lower | vl_print),
	/* 0x7b */	(vl_print | vl_punct),
	/* 0x7c */	(vl_print | vl_punct),
	/* 0x7d */	(vl_print | vl_punct),
	/* 0x7e */	(vl_print | vl_punct),
	/* 0x7f */	(vl_cntrl),
    },
};

/*
 * Sorted encodings:
 */

/*   0:1046 */
static const GNREIGHT_ENC encode_1046 = {
    /* encode_1046.chmap */
    {
	0xfe88,  0xd7,  0xf7,0xfeb1,0xfeb5,0xfeb9,0xfebd,0xfe71,
	  0x88,0x25a0,0x2502,0x2500,0x2510,0x250c,0x2514,0x2518,
	0xfe79,0xfe7b,0xfe7d,0xfe7f,0xfe77,0xfe8a,0xfef0,0xfef3,
	0xfef2,0xfece,0xfecf,0xfed0,0xfef6,0xfef8,0xfefa,0xfefc,
	  0xa0,0xfe82,0xfe84,0xfe88,  0xa4,0xfe8e,0xfe8b,0xfe91,
	0xfe97,0xfe9b,0xfe9f,0xfea3, 0x60c,  0xad,0xfea7,0xfeb3,
	 0x660, 0x661, 0x662, 0x663, 0x664, 0x665, 0x666, 0x667,
	 0x668, 0x669,0xfeb7, 0x61b,0xfebb,0xfebf,0xfeca, 0x61f,
	0xfecb, 0x621, 0x622, 0x623, 0x624, 0x625, 0x626, 0x627,
	 0x628, 0x629, 0x62a, 0x62b, 0x62c, 0x62d, 0x62e, 0x62f,
	 0x630, 0x631, 0x632, 0x633, 0x634, 0x635, 0x636, 0x637,
	 0x638, 0x639, 0x63a,0xfecc,0xfe82,0xfe84,0xfe8e,0xfed3,
	 0x640, 0x641, 0x642, 0x643, 0x644, 0x645, 0x646, 0x647,
	 0x648, 0x649, 0x64a, 0x64b, 0x64c, 0x64d, 0x64e, 0x64f,
	 0x650, 0x651, 0x652,0xfed7,0xfedb,0xfedf,0x200b,0xfef5,
	0xfef7,0xfef9,0xfefb,0xfee3,0xfee7,0xfeec,0xfee9,     0
    },
    /* encode_1046.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0x80,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xa1,  0xa2,  0xa5,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_1046.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0x80,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xa1,  0xa2,  0xa5,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_1046.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print),
	/* 0x81 */	(vl_print | vl_punct),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_print),
	/* 0x84 */	(vl_alpha | vl_print),
	/* 0x85 */	(vl_alpha | vl_print),
	/* 0x86 */	(vl_alpha | vl_print),
	/* 0x87 */	(vl_alpha | vl_print),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_print | vl_punct),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_print | vl_punct),
	/* 0x8d */	(vl_print | vl_punct),
	/* 0x8e */	(vl_print | vl_punct),
	/* 0x8f */	(vl_print | vl_punct),
	/* 0x90 */	(vl_alpha | vl_print),
	/* 0x91 */	(vl_alpha | vl_print),
	/* 0x92 */	(vl_alpha | vl_print),
	/* 0x93 */	(vl_alpha | vl_print),
	/* 0x94 */	(vl_alpha | vl_print),
	/* 0x95 */	(vl_alpha | vl_print),
	/* 0x96 */	(vl_alpha | vl_print),
	/* 0x97 */	(vl_alpha | vl_print),
	/* 0x98 */	(vl_alpha | vl_print),
	/* 0x99 */	(vl_alpha | vl_print),
	/* 0x9a */	(vl_alpha | vl_print),
	/* 0x9b */	(vl_alpha | vl_print),
	/* 0x9c */	(vl_alpha | vl_print),
	/* 0x9d */	(vl_alpha | vl_print),
	/* 0x9e */	(vl_alpha | vl_print),
	/* 0x9f */	(vl_alpha | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print),
	/* 0xa2 */	(vl_alpha | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_print),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_alpha | vl_print),
	/* 0xa9 */	(vl_alpha | vl_print),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_alpha | vl_print),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print),
	/* 0xaf */	(vl_alpha | vl_print),
	/* 0xb0 */	(vl_alpha | vl_print),
	/* 0xb1 */	(vl_alpha | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print),
	/* 0xb3 */	(vl_alpha | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print),
	/* 0xb5 */	(vl_alpha | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_print),
	/* 0xbd */	(vl_alpha | vl_print),
	/* 0xbe */	(vl_alpha | vl_print),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_alpha | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	(vl_alpha | vl_print),
	/* 0xdc */	(vl_alpha | vl_print),
	/* 0xdd */	(vl_alpha | vl_print),
	/* 0xde */	(vl_alpha | vl_print),
	/* 0xdf */	(vl_alpha | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_print | vl_punct),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_print | vl_punct),
	/* 0xee */	(vl_print | vl_punct),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_alpha | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_alpha | vl_print),
	/* 0xfb */	(vl_alpha | vl_print),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_alpha | vl_print),
	/* 0xfe */	(vl_alpha | vl_print),
	/* 0xff */	0,
    },
};

/*   1:437 */
static const GNREIGHT_ENC encode_437 = {
    /* encode_437.chmap */
    {
	  0xc7,  0xfc,  0xe9,  0xe2,  0xe4,  0xe0,  0xe5,  0xe7,
	  0xea,  0xeb,  0xe8,  0xef,  0xee,  0xec,  0xc4,  0xc5,
	  0xc9,  0xe6,  0xc6,  0xf4,  0xf6,  0xf2,  0xfb,  0xf9,
	  0xff,  0xd6,  0xdc,  0xa2,  0xa3,  0xa5,0x20a7, 0x192,
	  0xe1,  0xed,  0xf3,  0xfa,  0xf1,  0xd1,  0xaa,  0xba,
	  0xbf,0x2310,  0xac,  0xbd,  0xbc,  0xa1,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
	0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
	0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
	0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	 0x3b1,  0xdf, 0x393, 0x3c0, 0x3a3, 0x3c3,  0xb5, 0x3c4,
	 0x3a6, 0x398, 0x3a9, 0x3b4,0x221e, 0x3c6, 0x3b5,0x2229,
	0x2261,  0xb1,0x2265,0x2264,0x2320,0x2321,  0xf7,0x2248,
	  0xb0,0x2219,  0xb7,0x221a,0x207f,  0xb2,0x25a0,  0xa0
    },
    /* encode_437.lower */
    {
	  0x87,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x84,  0x86,
	  0x82,  0x91,  0x91,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x94,  0x81,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa4,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe5,  0xe5,  0xe6,  0xe7,
	  0xed,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_437.upper */
    {
	  0x80,  0x9a,  0x90,  0x83,  0x8e,  0x85,  0x8f,  0x80,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x92,  0x92,  0x93,  0x99,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa5,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe4,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xe8,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_437.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_alpha | vl_lower | vl_print),
	/* 0x85 */	(vl_alpha | vl_lower | vl_print),
	/* 0x86 */	(vl_alpha | vl_lower | vl_print),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_lower | vl_print),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_lower | vl_print),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_lower | vl_print),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_lower | vl_print),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_print | vl_punct),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*   2:850 */
static const GNREIGHT_ENC encode_850 = {
    /* encode_850.chmap */
    {
	  0xc7,  0xfc,  0xe9,  0xe2,  0xe4,  0xe0,  0xe5,  0xe7,
	  0xea,  0xeb,  0xe8,  0xef,  0xee,  0xec,  0xc4,  0xc5,
	  0xc9,  0xe6,  0xc6,  0xf4,  0xf6,  0xf2,  0xfb,  0xf9,
	  0xff,  0xd6,  0xdc,  0xf8,  0xa3,  0xd8,  0xd7, 0x192,
	  0xe1,  0xed,  0xf3,  0xfa,  0xf1,  0xd1,  0xaa,  0xba,
	  0xbf,  0xae,  0xac,  0xbd,  0xbc,  0xa1,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524,  0xc1,  0xc2,  0xc0,
	  0xa9,0x2563,0x2551,0x2557,0x255d,  0xa2,  0xa5,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,  0xe3,  0xc3,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,  0xa4,
	  0xf0,  0xd0,  0xca,  0xcb,  0xc8, 0x131,  0xcd,  0xce,
	  0xcf,0x2518,0x250c,0x2588,0x2584,  0xa6,  0xcc,0x2580,
	  0xd3,  0xdf,  0xd4,  0xd2,  0xf5,  0xd5,  0xb5,  0xfe,
	  0xde,  0xda,  0xdb,  0xd9,  0xfd,  0xdd,  0xaf,  0xb4,
	  0xad,  0xb1,0x2017,  0xbe,  0xb6,  0xa7,  0xf7,  0xb8,
	  0xb0,  0xa8,  0xb7,  0xb9,  0xb3,  0xb2,0x25a0,  0xa0
    },
    /* encode_850.lower */
    {
	  0x87,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x84,  0x86,
	  0x82,  0x91,  0x91,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x94,  0x81,  0x9b,  0x9c,  0x9b,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa4,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xa0,  0x83,  0x85,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc6,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd0,  0x88,  0x89,  0x8a,  0xd5,  0xa1,  0x8c,
	  0x8b,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0x8d,  0xdf,
	  0xa2,  0xe1,  0x93,  0x95,  0xe4,  0xe4,  0xe6,  0xe7,
	  0xe7,  0xa3,  0x96,  0x97,  0xec,  0xec,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_850.upper */
    {
	  0x80,  0x9a,  0x90,  0xb6,  0x8e,  0xb7,  0x8f,  0x80,
	  0xd2,  0xd3,  0xd4,  0xd8,  0xd7,  0xde,  0x8e,  0x8f,
	  0x90,  0x92,  0x92,  0xe2,  0x99,  0xe3,  0xea,  0xeb,
	  0x98,  0x99,  0x9a,  0x9d,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xb5,  0xd6,  0xe0,  0xe9,  0xa5,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc7,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd1,  0xd1,  0xd2,  0xd3,  0xd4,  0x49,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe5,  0xe5,  0xe6,  0xe8,
	  0xe8,  0xe9,  0xea,  0xeb,  0xed,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_850.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_alpha | vl_lower | vl_print),
	/* 0x85 */	(vl_alpha | vl_lower | vl_print),
	/* 0x86 */	(vl_alpha | vl_lower | vl_print),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_lower | vl_print),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_lower | vl_print),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_lower | vl_print),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_lower | vl_print),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_print | vl_punct),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_print | vl_punct),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*   3:851 */
static const GNREIGHT_ENC encode_851 = {
    /* encode_851.chmap */
    {
	  0xc7,  0xfc,  0xe9,  0xe2,  0xe4,  0xe0, 0x386,  0xe7,
	  0xea,  0xeb,  0xe8,  0xef,  0xee, 0x388,  0xc4, 0x389,
	 0x38a,     0, 0x38c,  0xf4,  0xf6, 0x38e,  0xfb,  0xf9,
	 0x38f,  0xd6,  0xdc, 0x3ac,  0xa3, 0x3ad, 0x3ae, 0x3af,
	 0x3ca, 0x390, 0x3cc, 0x3cd, 0x391, 0x392, 0x393, 0x394,
	 0x395, 0x396, 0x397,  0xbd, 0x398, 0x399,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524, 0x39a, 0x39b, 0x39d,
	 0x39c,0x2563,0x2551,0x2557,0x255d, 0x39e, 0x39f,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c, 0x3a0, 0x3a1,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c, 0x3a3,
	 0x3a4, 0x3a5, 0x3a6, 0x3a7, 0x3a8, 0x3a9, 0x3b1, 0x3b2,
	 0x3b3,0x2518,0x250c,0x2588,0x2584, 0x3b4, 0x3b5,0x2580,
	 0x3b6, 0x3b7, 0x3b8, 0x3b9, 0x3ba, 0x3bb, 0x3bc, 0x3bd,
	 0x3be, 0x3bf, 0x3c0, 0x3c1, 0x3c3, 0x3c2, 0x3c4,  0xb4,
	  0xad,  0xb1, 0x3c5, 0x3c6, 0x3c7,  0xa7, 0x3c8, 0x2db,
	  0xb0,  0xa8, 0x3c9, 0x3cb, 0x3b0, 0x3ce,0x25a0,  0xa0
    },
    /* encode_851.lower */
    {
	  0x87,  0x81,  0x82,  0x83,  0x84,  0x85,  0x9b,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x9d,  0x84,  0x9e,
	  0x9f,     0,  0xa2,  0x93,  0x94,  0xa3,  0x96,  0x97,
	  0xfd,  0x94,  0x81,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xd6,  0xd7,  0xd8,  0xdd,
	  0xde,  0xe0,  0xe1,  0xab,  0xe2,  0xe3,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xe4,  0xe5,  0xe7,
	  0xe6,  0xb9,  0xba,  0xbb,  0xbc,  0xe8,  0xe9,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xea,  0xeb,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xec,
	  0xee,  0xf2,  0xf3,  0xf4,  0xf6,  0xfa,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_851.upper */
    {
	  0x80,  0x9a,  0x82,  0x83,  0x8e,  0x85,  0x86,  0x80,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,     0,  0x92,  0x93,  0x99,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x86,  0x9c,  0x8d,  0x8f,  0x90,
	  0xa0,  0xa1,  0x92,  0x95,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xa4,  0xa5,
	  0xa6,  0xd9,  0xda,  0xdb,  0xdc,  0xa7,  0xa8,  0xdf,
	  0xa9,  0xaa,  0xac,  0xad,  0xb5,  0xb6,  0xb8,  0xb7,
	  0xbd,  0xbe,  0xc6,  0xc7,  0xcf,  0xcf,  0xd0,  0xef,
	  0xf0,  0xf1,  0xd1,  0xd2,  0xd3,  0xf5,  0xd4,  0xf7,
	  0xf8,  0xf9,  0xd5,  0xfb,  0xfc,  0x98,  0xfe,  0xff
    },
    /* encode_851.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_alpha | vl_lower | vl_print),
	/* 0x85 */	(vl_alpha | vl_lower | vl_print),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	0,
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_lower | vl_print),
	/* 0x98 */	(vl_alpha | vl_print | vl_upper),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_alpha | vl_print | vl_upper),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*   4:852 */
static const GNREIGHT_ENC encode_852 = {
    /* encode_852.chmap */
    {
	  0xc7,  0xfc,  0xe9,  0xe2,  0xe4, 0x16f, 0x107,  0xe7,
	 0x142,  0xeb, 0x150, 0x151,  0xee, 0x179,  0xc4, 0x106,
	  0xc9, 0x139, 0x13a,  0xf4,  0xf6, 0x13d, 0x13e, 0x15a,
	 0x15b,  0xd6,  0xdc, 0x164, 0x165, 0x141,  0xd7, 0x10d,
	  0xe1,  0xed,  0xf3,  0xfa, 0x104, 0x105, 0x17d, 0x17e,
	 0x118, 0x119,  0xac, 0x17a, 0x10c, 0x15f,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524,  0xc1,  0xc2, 0x11a,
	 0x15e,0x2563,0x2551,0x2557,0x255d, 0x17b, 0x17c,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c, 0x102, 0x103,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,  0xa4,
	 0x111, 0x110, 0x10e,  0xcb, 0x10f, 0x147,  0xcd,  0xce,
	 0x11b,0x2518,0x250c,0x2588,0x2584, 0x162, 0x16e,0x2580,
	  0xd3,  0xdf,  0xd4, 0x143, 0x144, 0x148, 0x160, 0x161,
	 0x154,  0xda, 0x155, 0x170,  0xfd,  0xdd, 0x163,  0xb4,
	  0xad, 0x2dd, 0x2db, 0x2c7, 0x2d8,  0xa7,  0xf7,  0xb8,
	  0xb0,  0xa8, 0x2d9, 0x171, 0x158, 0x159,0x25a0,  0xa0
    },
    /* encode_852.lower */
    {
	  0x87,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8b,  0x8b,  0x8c,  0xab,  0x84,  0x86,
	  0x82,  0x92,  0x92,  0x93,  0x94,  0x96,  0x96,  0x98,
	  0x98,  0x94,  0x81,  0x9c,  0x9c,  0x88,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa5,  0xa5,  0xa7,  0xa7,
	  0xa9,  0xa9,  0xaa,  0xab,  0x9f,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xa0,  0x83,  0xd8,
	  0xad,  0xb9,  0xba,  0xbb,  0xbc,  0xbe,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc7,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd0,  0xd4,  0x89,  0xd4,  0xe5,  0xa1,  0x8c,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xee,  0x85,  0xdf,
	  0xa2,  0xe1,  0x93,  0xe4,  0xe4,  0xe5,  0xe7,  0xe7,
	  0xea,  0xa3,  0xea,  0xfb,  0xec,  0xec,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfd,  0xfd,  0xfe,  0xff
    },
    /* encode_852.upper */
    {
	  0x80,  0x9a,  0x90,  0xb6,  0x8e,  0xde,  0x8f,  0x80,
	  0x9d,  0xd3,  0x8a,  0x8a,  0xd7,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x91,  0xe2,  0x99,  0x95,  0x95,  0x97,
	  0x97,  0x99,  0x9a,  0x9b,  0x9b,  0x9d,  0x9e,  0xac,
	  0xb5,  0xd6,  0xe0,  0xe9,  0xa4,  0xa4,  0xa6,  0xa6,
	  0xa8,  0xa8,  0xaa,  0x8d,  0xac,  0xb8,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbd,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc6,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd1,  0xd1,  0xd2,  0xd3,  0xd2,  0xd5,  0xd6,  0xd7,
	  0xb7,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe3,  0xd5,  0xe6,  0xe6,
	  0xe8,  0xe9,  0xe8,  0xeb,  0xed,  0xed,  0xdd,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xeb,  0xfc,  0xfc,  0xfe,  0xff
    },
    /* encode_852.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_alpha | vl_lower | vl_print),
	/* 0x85 */	(vl_alpha | vl_lower | vl_print),
	/* 0x86 */	(vl_alpha | vl_lower | vl_print),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_lower | vl_print),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_print | vl_upper),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_print | vl_upper),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_alpha | vl_lower | vl_print),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_alpha | vl_lower | vl_print),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*   5:855 */
static const GNREIGHT_ENC encode_855 = {
    /* encode_855.chmap */
    {
	 0x452, 0x402, 0x453, 0x403, 0x451, 0x401, 0x454, 0x404,
	 0x455, 0x405, 0x456, 0x406, 0x457, 0x407, 0x458, 0x408,
	 0x459, 0x409, 0x45a, 0x40a, 0x45b, 0x40b, 0x45c, 0x40c,
	 0x45e, 0x40e, 0x45f, 0x40f, 0x44e, 0x42e, 0x44a, 0x42a,
	 0x430, 0x410, 0x431, 0x411, 0x446, 0x426, 0x434, 0x414,
	 0x435, 0x415, 0x444, 0x424, 0x433, 0x413,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524, 0x445, 0x425, 0x438,
	 0x418,0x2563,0x2551,0x2557,0x255d, 0x439, 0x419,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c, 0x43a, 0x41a,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,  0xa4,
	 0x43b, 0x41b, 0x43c, 0x41c, 0x43d, 0x41d, 0x43e, 0x41e,
	 0x43f,0x2518,0x250c,0x2588,0x2584, 0x41f, 0x44f,0x2580,
	 0x42f, 0x440, 0x420, 0x441, 0x421, 0x442, 0x422, 0x443,
	 0x423, 0x436, 0x416, 0x432, 0x412, 0x44c, 0x42c,0x2116,
	  0xad, 0x44b, 0x42b, 0x437, 0x417, 0x448, 0x428, 0x44d,
	 0x42d, 0x449, 0x429, 0x447, 0x427,  0xa7,0x25a0,  0xa0
    },
    /* encode_855.lower */
    {
	  0x80,  0x80,  0x82,  0x82,  0x84,  0x84,  0x86,  0x86,
	  0x88,  0x88,  0x8a,  0x8a,  0x8c,  0x8c,  0x8e,  0x8e,
	  0x90,  0x90,  0x92,  0x92,  0x94,  0x94,  0x96,  0x96,
	  0x98,  0x98,  0x9a,  0x9a,  0x9c,  0x9c,  0x9e,  0x9e,
	  0xa0,  0xa0,  0xa2,  0xa2,  0xa4,  0xa4,  0xa6,  0xa6,
	  0xa8,  0xa8,  0xaa,  0xaa,  0xac,  0xac,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb5,  0xb7,
	  0xb7,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbd,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc6,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd0,  0xd2,  0xd2,  0xd4,  0xd4,  0xd6,  0xd6,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xd8,  0xde,  0xdf,
	  0xde,  0xe1,  0xe1,  0xe3,  0xe3,  0xe5,  0xe5,  0xe7,
	  0xe7,  0xe9,  0xe9,  0xeb,  0xeb,  0xed,  0xed,  0xef,
	  0xf0,  0xf1,  0xf1,  0xf3,  0xf3,  0xf5,  0xf5,  0xf7,
	  0xf7,  0xf9,  0xf9,  0xfb,  0xfb,  0xfd,  0xfe,  0xff
    },
    /* encode_855.upper */
    {
	  0x81,  0x81,  0x83,  0x83,  0x85,  0x85,  0x87,  0x87,
	  0x89,  0x89,  0x8b,  0x8b,  0x8d,  0x8d,  0x8f,  0x8f,
	  0x91,  0x91,  0x93,  0x93,  0x95,  0x95,  0x97,  0x97,
	  0x99,  0x99,  0x9b,  0x9b,  0x9d,  0x9d,  0x9f,  0x9f,
	  0xa1,  0xa1,  0xa3,  0xa3,  0xa5,  0xa5,  0xa7,  0xa7,
	  0xa9,  0xa9,  0xab,  0xab,  0xad,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb6,  0xb6,  0xb8,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbe,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc7,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd1,  0xd1,  0xd3,  0xd3,  0xd5,  0xd5,  0xd7,  0xd7,
	  0xdd,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xe0,  0xdf,
	  0xe0,  0xe2,  0xe2,  0xe4,  0xe4,  0xe6,  0xe6,  0xe8,
	  0xe8,  0xea,  0xea,  0xec,  0xec,  0xee,  0xee,  0xef,
	  0xf0,  0xf2,  0xf2,  0xf4,  0xf4,  0xf6,  0xf6,  0xf8,
	  0xf8,  0xfa,  0xfa,  0xfc,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_855.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_lower | vl_print),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_alpha | vl_lower | vl_print),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_lower | vl_print),
	/* 0x87 */	(vl_alpha | vl_print | vl_upper),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_print | vl_upper),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_print | vl_upper),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_lower | vl_print),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_lower | vl_print),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_lower | vl_print),
	/* 0x93 */	(vl_alpha | vl_print | vl_upper),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_print | vl_upper),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_alpha | vl_print | vl_upper),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_lower | vl_print),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_lower | vl_print),
	/* 0xad */	(vl_alpha | vl_print | vl_upper),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_alpha | vl_lower | vl_print),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*   6:857 */
static const GNREIGHT_ENC encode_857 = {
    /* encode_857.chmap */
    {
	  0xc7,  0xfc,  0xe9,  0xe2,  0xe4,  0xe0,  0xe5,  0xe7,
	  0xea,  0xeb,  0xe8,  0xef,  0xee, 0x131,  0xc4,  0xc5,
	  0xc9,  0xe6,  0xc6,  0xf4,  0xf6,  0xf2,  0xfb,  0xf9,
	 0x130,  0xd6,  0xdc,  0xf8,  0xa3,  0xd8, 0x15e, 0x15f,
	  0xe1,  0xed,  0xf3,  0xfa,  0xf1,  0xd1, 0x11e, 0x11f,
	  0xbf,  0xae,  0xac,  0xbd,  0xbc,  0xa1,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524,  0xc1,  0xc2,  0xc0,
	  0xa9,0x2563,0x2551,0x2557,0x255d,  0xa2,  0xa5,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,  0xe3,  0xc3,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,  0xa4,
	  0xba,  0xaa,  0xca,  0xcb,  0xc8,     0,  0xcd,  0xce,
	  0xcf,0x2518,0x250c,0x2588,0x2584,  0xa6,  0xcc,0x2580,
	  0xd3,  0xdf,  0xd4,  0xd2,  0xf5,  0xd5,  0xb5,     0,
	  0xd7,  0xda,  0xdb,  0xd9,  0xec,  0xff,  0xaf,  0xb4,
	  0xad,  0xb1,     0,  0xbe,  0xb6,  0xa7,  0xf7,  0xb8,
	  0xb0,  0xa8,  0xb7,  0xb9,  0xb3,  0xb2,0x25a0,  0xa0
    },
    /* encode_857.lower */
    {
	  0x87,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x84,  0x86,
	  0x82,  0x91,  0x91,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x69,  0x94,  0x81,  0x9b,  0x9c,  0x9b,  0x9f,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa4,  0xa7,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xa0,  0x83,  0x85,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc6,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0x88,  0x89,  0x8a,     0,  0xa1,  0x8c,
	  0x8b,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xec,  0xdf,
	  0xa2,  0xe1,  0x93,  0x95,  0xe4,  0xe4,  0xe6,     0,
	  0xe8,  0xa3,  0x96,  0x97,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,     0,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_857.upper */
    {
	  0x80,  0x9a,  0x90,  0xb6,  0x8e,  0xb7,  0x8f,  0x80,
	  0xd2,  0xd3,  0xd4,  0xd8,  0xd7,  0x49,  0x8e,  0x8f,
	  0x90,  0x92,  0x92,  0xe2,  0x99,  0xe3,  0xea,  0xeb,
	  0x98,  0x99,  0x9a,  0x9d,  0x9c,  0x9d,  0x9e,  0x9e,
	  0xb5,  0xd6,  0xe0,  0xe9,  0xa5,  0xa5,  0xa6,  0xa6,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc7,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,     0,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe5,  0xe5,  0xe6,     0,
	  0xe8,  0xe9,  0xea,  0xeb,  0xde,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,     0,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_857.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_alpha | vl_lower | vl_print),
	/* 0x85 */	(vl_alpha | vl_lower | vl_print),
	/* 0x86 */	(vl_alpha | vl_lower | vl_print),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_lower | vl_print),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_lower | vl_print),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_lower | vl_print),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_lower | vl_print),
	/* 0x98 */	(vl_alpha | vl_print | vl_upper),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_alpha | vl_print | vl_upper),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	0,
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	0,
	/* 0xe8 */	(vl_print | vl_punct),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_print | vl_punct),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	0,
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_print | vl_punct),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*   7:860 */
static const GNREIGHT_ENC encode_860 = {
    /* encode_860.chmap */
    {
	  0xc7,  0xfc,  0xe9,  0xe2,  0xe3,  0xe0,  0xc1,  0xe7,
	  0xea,  0xca,  0xe8,  0xcd,  0xd4,  0xec,  0xc3,  0xc2,
	  0xc9,  0xc0,  0xc8,  0xf4,  0xf5,  0xf2,  0xda,  0xf9,
	  0xcc,  0xd5,  0xdc,  0xa2,  0xa3,  0xd9,0x20a7,  0xd3,
	  0xe1,  0xed,  0xf3,  0xfa,  0xf1,  0xd1,  0xaa,  0xba,
	  0xbf,  0xd2,  0xac,  0xbd,  0xbc,  0xa1,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
	0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
	0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
	0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	 0x3b1,  0xdf, 0x393, 0x3c0, 0x3a3, 0x3c3,  0xb5, 0x3c4,
	 0x3a6, 0x398, 0x3a9, 0x3b4,0x221e, 0x3c6, 0x3b5,0x2229,
	0x2261,  0xb1,0x2265,0x2264,0x2320,0x2321,  0xf7,0x2248,
	  0xb0,0x2219,  0xb7,0x221a,0x207f,  0xb2,0x25a0,  0xa0
    },
    /* encode_860.lower */
    {
	  0x87,  0x81,  0x82,  0x83,  0x84,  0x85,  0xa0,  0x87,
	  0x88,  0x88,  0x8a,  0xa1,  0x93,  0x8d,  0x84,  0x83,
	  0x82,  0x85,  0x8a,  0x93,  0x94,  0x95,  0xa3,  0x97,
	  0x8d,  0x94,  0x81,  0x9b,  0x9c,  0x97,  0x9e,  0xa2,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa4,  0xa6,  0xa7,
	  0xa8,  0x95,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe5,  0xe5,  0xe6,  0xe7,
	  0xed,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_860.upper */
    {
	  0x80,  0x9a,  0x90,  0x8f,  0x8e,  0x91,  0x86,  0x80,
	  0x89,  0x89,  0x92,  0x8b,  0x8c,  0x98,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x8c,  0x99,  0xa9,  0x96,  0x9d,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0x86,  0x8b,  0x9f,  0x96,  0xa5,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe4,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xe8,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_860.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_alpha | vl_lower | vl_print),
	/* 0x85 */	(vl_alpha | vl_lower | vl_print),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_print | vl_upper),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_print | vl_upper),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_lower | vl_print),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_lower | vl_print),
	/* 0x96 */	(vl_alpha | vl_print | vl_upper),
	/* 0x97 */	(vl_alpha | vl_lower | vl_print),
	/* 0x98 */	(vl_alpha | vl_print | vl_upper),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*   8:861 */
static const GNREIGHT_ENC encode_861 = {
    /* encode_861.chmap */
    {
	  0xc7,  0xfc,  0xe9,  0xe2,  0xe4,  0xe0,  0xe5,  0xe7,
	  0xea,  0xeb,  0xe8,  0xd0,  0xf0,  0xde,  0xc4,  0xc5,
	  0xc9,  0xe6,  0xc6,  0xf4,  0xf6,  0xfe,  0xfb,  0xdd,
	  0xfd,  0xd6,  0xdc,  0xf8,  0xa3,  0xd8,0x20a7, 0x192,
	  0xe1,  0xed,  0xf3,  0xfa,  0xc1,  0xcd,  0xd3,  0xda,
	  0xbf,0x2310,  0xac,  0xbd,  0xbc,  0xa1,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
	0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
	0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
	0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	 0x3b1,  0xdf, 0x393, 0x3c0, 0x3a3, 0x3c3,  0xb5, 0x3c4,
	 0x3a6, 0x398, 0x3a9, 0x3b4,0x221e, 0x3c6, 0x3b5,0x2229,
	0x2261,  0xb1,0x2265,0x2264,0x2320,0x2321,  0xf7,0x2248,
	  0xb0,0x2219,  0xb7,0x221a,0x207f,  0xb2,0x25a0,  0xa0
    },
    /* encode_861.lower */
    {
	  0x87,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8c,  0x8c,  0x95,  0x84,  0x86,
	  0x82,  0x91,  0x91,  0x93,  0x94,  0x95,  0x96,  0x98,
	  0x98,  0x94,  0x81,  0x9b,  0x9c,  0x9b,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa0,  0xa1,  0xa2,  0xa3,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe5,  0xe5,  0xe6,  0xe7,
	  0xed,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_861.upper */
    {
	  0x80,  0x9a,  0x90,  0x83,  0x8e,  0x85,  0x8f,  0x80,
	  0x88,  0x89,  0x8a,  0x8b,  0x8b,  0x8d,  0x8e,  0x8f,
	  0x90,  0x92,  0x92,  0x93,  0x99,  0x8d,  0x96,  0x97,
	  0x97,  0x99,  0x9a,  0x9d,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa4,  0xa5,  0xa6,  0xa7,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe4,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xe8,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_861.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_alpha | vl_lower | vl_print),
	/* 0x85 */	(vl_alpha | vl_lower | vl_print),
	/* 0x86 */	(vl_alpha | vl_lower | vl_print),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_print | vl_upper),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_lower | vl_print),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_lower | vl_print),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_print | vl_upper),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*   9:862 */
static const GNREIGHT_ENC encode_862 = {
    /* encode_862.chmap */
    {
	 0x5d0, 0x5d1, 0x5d2, 0x5d3, 0x5d4, 0x5d5, 0x5d6, 0x5d7,
	 0x5d8, 0x5d9, 0x5da, 0x5db, 0x5dc, 0x5dd, 0x5de, 0x5df,
	 0x5e0, 0x5e1, 0x5e2, 0x5e3, 0x5e4, 0x5e5, 0x5e6, 0x5e7,
	 0x5e8, 0x5e9, 0x5ea,  0xa2,  0xa3,  0xa5,0x20a7, 0x192,
	  0xe1,  0xed,  0xf3,  0xfa,  0xf1,  0xd1,  0xaa,  0xba,
	  0xbf,0x2310,  0xac,  0xbd,  0xbc,  0xa1,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
	0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
	0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
	0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	 0x3b1,  0xdf, 0x393, 0x3c0, 0x3a3, 0x3c3,  0xb5, 0x3c4,
	 0x3a6, 0x398, 0x3a9, 0x3b4,0x221e, 0x3c6, 0x3b5,0x2229,
	0x2261,  0xb1,0x2265,0x2264,0x2320,0x2321,  0xf7,0x2248,
	  0xb0,0x2219,  0xb7,0x221a,0x207f,  0xb2,0x25a0,  0xa0
    },
    /* encode_862.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa4,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe5,  0xe5,  0xe6,  0xe7,
	  0xed,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_862.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa5,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe4,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xe8,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_862.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print),
	/* 0x81 */	(vl_alpha | vl_print),
	/* 0x82 */	(vl_alpha | vl_print),
	/* 0x83 */	(vl_alpha | vl_print),
	/* 0x84 */	(vl_alpha | vl_print),
	/* 0x85 */	(vl_alpha | vl_print),
	/* 0x86 */	(vl_alpha | vl_print),
	/* 0x87 */	(vl_alpha | vl_print),
	/* 0x88 */	(vl_alpha | vl_print),
	/* 0x89 */	(vl_alpha | vl_print),
	/* 0x8a */	(vl_alpha | vl_print),
	/* 0x8b */	(vl_alpha | vl_print),
	/* 0x8c */	(vl_alpha | vl_print),
	/* 0x8d */	(vl_alpha | vl_print),
	/* 0x8e */	(vl_alpha | vl_print),
	/* 0x8f */	(vl_alpha | vl_print),
	/* 0x90 */	(vl_alpha | vl_print),
	/* 0x91 */	(vl_alpha | vl_print),
	/* 0x92 */	(vl_alpha | vl_print),
	/* 0x93 */	(vl_alpha | vl_print),
	/* 0x94 */	(vl_alpha | vl_print),
	/* 0x95 */	(vl_alpha | vl_print),
	/* 0x96 */	(vl_alpha | vl_print),
	/* 0x97 */	(vl_alpha | vl_print),
	/* 0x98 */	(vl_alpha | vl_print),
	/* 0x99 */	(vl_alpha | vl_print),
	/* 0x9a */	(vl_alpha | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_print | vl_punct),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  10:863 */
static const GNREIGHT_ENC encode_863 = {
    /* encode_863.chmap */
    {
	  0xc7,  0xfc,  0xe9,  0xe2,  0xc2,  0xe0,  0xb6,  0xe7,
	  0xea,  0xeb,  0xe8,  0xef,  0xee,0x2017,  0xc0,  0xa7,
	  0xc9,  0xc8,  0xca,  0xf4,  0xcb,  0xcf,  0xfb,  0xf9,
	  0xa4,  0xd4,  0xdc,  0xa2,  0xa3,  0xd9,  0xdb, 0x192,
	  0xa6,  0xb4,  0xf3,  0xfa,  0xa8,  0xb8,  0xb3,  0xaf,
	  0xce,0x2310,  0xac,  0xbd,  0xbc,  0xbe,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
	0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
	0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
	0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	 0x3b1,  0xdf, 0x393, 0x3c0, 0x3a3, 0x3c3,  0xb5, 0x3c4,
	 0x3a6, 0x398, 0x3a9, 0x3b4,0x221e, 0x3c6, 0x3b5,0x2229,
	0x2261,  0xb1,0x2265,0x2264,0x2320,0x2321,  0xf7,0x2248,
	  0xb0,0x2219,  0xb7,0x221a,0x207f,  0xb2,0x25a0,  0xa0
    },
    /* encode_863.lower */
    {
	  0x87,  0x81,  0x82,  0x83,  0x83,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x85,  0x8f,
	  0x82,  0x8a,  0x88,  0x93,  0x89,  0x8b,  0x96,  0x97,
	  0x98,  0x93,  0x81,  0x9b,  0x9c,  0x97,  0x96,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0x8c,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe5,  0xe5,  0xe6,  0xe7,
	  0xed,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_863.upper */
    {
	  0x80,  0x9a,  0x90,  0x84,  0x84,  0x8e,  0x86,  0x80,
	  0x92,  0x94,  0x91,  0x95,  0xa8,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x99,  0x94,  0x95,  0x9e,  0x9d,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe4,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xe8,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_863.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_alpha | vl_print | vl_upper),
	/* 0x85 */	(vl_alpha | vl_lower | vl_print),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_print | vl_punct),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_print | vl_punct),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_print | vl_upper),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_lower | vl_print),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_alpha | vl_print | vl_upper),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  11:865 */
static const GNREIGHT_ENC encode_865 = {
    /* encode_865.chmap */
    {
	  0xc7,  0xfc,  0xe9,  0xe2,  0xe4,  0xe0,  0xe5,  0xe7,
	  0xea,  0xeb,  0xe8,  0xef,  0xee,  0xec,  0xc4,  0xc5,
	  0xc9,  0xe6,  0xc6,  0xf4,  0xf6,  0xf2,  0xfb,  0xf9,
	  0xff,  0xd6,  0xdc,  0xf8,  0xa3,  0xd8,0x20a7, 0x192,
	  0xe1,  0xed,  0xf3,  0xfa,  0xf1,  0xd1,  0xaa,  0xba,
	  0xbf,0x2310,  0xac,  0xbd,  0xbc,  0xa1,  0xab,  0xa4,
	0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
	0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
	0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
	0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	 0x3b1,  0xdf, 0x393, 0x3c0, 0x3a3, 0x3c3,  0xb5, 0x3c4,
	 0x3a6, 0x398, 0x3a9, 0x3b4,0x221e, 0x3c6, 0x3b5,0x2229,
	0x2261,  0xb1,0x2265,0x2264,0x2320,0x2321,  0xf7,0x2248,
	  0xb0,0x2219,  0xb7,0x221a,0x207f,  0xb2,0x25a0,  0xa0
    },
    /* encode_865.lower */
    {
	  0x87,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x84,  0x86,
	  0x82,  0x91,  0x91,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x94,  0x81,  0x9b,  0x9c,  0x9b,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa4,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe5,  0xe5,  0xe6,  0xe7,
	  0xed,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_865.upper */
    {
	  0x80,  0x9a,  0x90,  0x83,  0x8e,  0x85,  0x8f,  0x80,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x92,  0x92,  0x93,  0x99,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9d,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa5,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe4,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xe8,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_865.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_alpha | vl_lower | vl_print),
	/* 0x85 */	(vl_alpha | vl_lower | vl_print),
	/* 0x86 */	(vl_alpha | vl_lower | vl_print),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_lower | vl_print),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_lower | vl_print),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_lower | vl_print),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_lower | vl_print),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  12:866 */
static const GNREIGHT_ENC encode_866 = {
    /* encode_866.chmap */
    {
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
	0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
	0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
	0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f,
	 0x401, 0x451, 0x404, 0x454, 0x407, 0x457, 0x40e, 0x45e,
	  0xb0,0x2219,  0xb7,0x221a,0x2116,  0xa4,0x25a0,  0xa0
    },
    /* encode_866.lower */
    {
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf1,  0xf1,  0xf3,  0xf3,  0xf5,  0xf5,  0xf7,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_866.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xf0,  0xf0,  0xf2,  0xf2,  0xf4,  0xf4,  0xf6,  0xf6,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_866.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_print | vl_upper),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_alpha | vl_print | vl_upper),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_print | vl_upper),
	/* 0x88 */	(vl_alpha | vl_print | vl_upper),
	/* 0x89 */	(vl_alpha | vl_print | vl_upper),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_alpha | vl_print | vl_upper),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_print | vl_upper),
	/* 0x94 */	(vl_alpha | vl_print | vl_upper),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_print | vl_upper),
	/* 0x97 */	(vl_alpha | vl_print | vl_upper),
	/* 0x98 */	(vl_alpha | vl_print | vl_upper),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_print | vl_upper),
	/* 0x9c */	(vl_alpha | vl_print | vl_upper),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_alpha | vl_print | vl_upper),
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xaa */	(vl_alpha | vl_lower | vl_print),
	/* 0xab */	(vl_alpha | vl_lower | vl_print),
	/* 0xac */	(vl_alpha | vl_lower | vl_print),
	/* 0xad */	(vl_alpha | vl_lower | vl_print),
	/* 0xae */	(vl_alpha | vl_lower | vl_print),
	/* 0xaf */	(vl_alpha | vl_lower | vl_print),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_print | vl_punct),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  13:866NAV */
static const GNREIGHT_ENC encode_866NAV = {
    /* encode_866NAV.chmap */
    {
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
	0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
	0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
	0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f,
	 0x401, 0x451, 0x490, 0x491, 0x404, 0x454, 0x406, 0x456,
	 0x407, 0x457, 0x40e, 0x45e,0x2116,  0xa4,0x25a0,  0xa0
    },
    /* encode_866NAV.lower */
    {
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf1,  0xf1,  0xf3,  0xf3,  0xf5,  0xf5,  0xf7,  0xf7,
	  0xf9,  0xf9,  0xfb,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_866NAV.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xf0,  0xf0,  0xf2,  0xf2,  0xf4,  0xf4,  0xf6,  0xf6,
	  0xf8,  0xf8,  0xfa,  0xfa,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_866NAV.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_print | vl_upper),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_alpha | vl_print | vl_upper),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_print | vl_upper),
	/* 0x88 */	(vl_alpha | vl_print | vl_upper),
	/* 0x89 */	(vl_alpha | vl_print | vl_upper),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_alpha | vl_print | vl_upper),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_print | vl_upper),
	/* 0x94 */	(vl_alpha | vl_print | vl_upper),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_print | vl_upper),
	/* 0x97 */	(vl_alpha | vl_print | vl_upper),
	/* 0x98 */	(vl_alpha | vl_print | vl_upper),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_print | vl_upper),
	/* 0x9c */	(vl_alpha | vl_print | vl_upper),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_alpha | vl_print | vl_upper),
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xaa */	(vl_alpha | vl_lower | vl_print),
	/* 0xab */	(vl_alpha | vl_lower | vl_print),
	/* 0xac */	(vl_alpha | vl_lower | vl_print),
	/* 0xad */	(vl_alpha | vl_lower | vl_print),
	/* 0xae */	(vl_alpha | vl_lower | vl_print),
	/* 0xaf */	(vl_alpha | vl_lower | vl_print),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_print | vl_punct),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  14:869 */
static const GNREIGHT_ENC encode_869 = {
    /* encode_869.chmap */
    {
	     0,     0,     0,     0,     0,     0, 0x386,     0,
	  0xb7,  0xac,  0xa6,0x2018,0x2019, 0x388,0x2015, 0x389,
	 0x38a, 0x3aa, 0x38c,     0,     0, 0x38e, 0x3ab,  0xa9,
	 0x38f,  0xb2,  0xb3, 0x3ac,  0xa3, 0x3ad, 0x3ae, 0x3af,
	 0x3ca, 0x390, 0x3cc, 0x3cd, 0x391, 0x392, 0x393, 0x394,
	 0x395, 0x396, 0x397,  0xbd, 0x398, 0x399,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524, 0x39a, 0x39b, 0x39c,
	 0x39d,0x2563,0x2551,0x2557,0x255d, 0x39e, 0x39f,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c, 0x3a0, 0x3a1,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c, 0x3a3,
	 0x3a4, 0x3a5, 0x3a6, 0x3a7, 0x3a8, 0x3a9, 0x3b1, 0x3b2,
	 0x3b3,0x2518,0x250c,0x2588,0x2584, 0x3b4, 0x3b5,0x2580,
	 0x3b6, 0x3b7, 0x3b8, 0x3b9, 0x3ba, 0x3bb, 0x3bc, 0x3bd,
	 0x3be, 0x3bf, 0x3c0, 0x3c1, 0x3c3, 0x3c2, 0x3c4, 0x384,
	  0xad,  0xb1, 0x3c5, 0x3c6, 0x3c7,  0xa7, 0x3c8, 0x385,
	  0xb0,  0xa8, 0x3c9, 0x3cb, 0x3b0, 0x3ce,0x25a0,  0xa0
    },
    /* encode_869.lower */
    {
	     0,     0,     0,     0,     0,     0,  0x9b,     0,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x9d,  0x8e,  0x9e,
	  0x9f,  0xa0,  0xa2,     0,     0,  0xa3,  0xfb,  0x97,
	  0xfd,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xd6,  0xd7,  0xd8,  0xdd,
	  0xde,  0xe0,  0xe1,  0xab,  0xe2,  0xe3,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xe4,  0xe5,  0xe6,
	  0xe7,  0xb9,  0xba,  0xbb,  0xbc,  0xe8,  0xe9,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xea,  0xeb,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xec,
	  0xee,  0xf2,  0xf3,  0xf4,  0xf6,  0xfa,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_869.upper */
    {
	     0,     0,     0,     0,     0,     0,  0x86,     0,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,     0,     0,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x86,  0x9c,  0x8d,  0x8f,  0x90,
	  0x91,  0xa1,  0x92,  0x95,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xa4,  0xa5,
	  0xa6,  0xd9,  0xda,  0xdb,  0xdc,  0xa7,  0xa8,  0xdf,
	  0xa9,  0xaa,  0xac,  0xad,  0xb5,  0xb6,  0xb7,  0xb8,
	  0xbd,  0xbe,  0xc6,  0xc7,  0xcf,  0xcf,  0xd0,  0xef,
	  0xf0,  0xf1,  0xd1,  0xd2,  0xd3,  0xf5,  0xd4,  0xf7,
	  0xf8,  0xf9,  0xd5,  0x96,  0xfc,  0x98,  0xfe,  0xff
    },
    /* encode_869.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	0,
	/* 0x82 */	0,
	/* 0x83 */	0,
	/* 0x84 */	0,
	/* 0x85 */	0,
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	0,
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_print | vl_punct),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_print | vl_punct),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_print | vl_punct),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	0,
	/* 0x94 */	0,
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_print | vl_upper),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_alpha | vl_print | vl_upper),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_print | vl_punct),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_alpha | vl_print | vl_upper),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  15:874 */
static const GNREIGHT_ENC encode_874 = {
    /* encode_874.chmap */
    {
	0x20ac,     0,     0,     0,     0,0x2026,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	     0,     0,     0,     0,     0,     0,     0,     0,
	  0xa0, 0xe01, 0xe02, 0xe03, 0xe04, 0xe05, 0xe06, 0xe07,
	 0xe08, 0xe09, 0xe0a, 0xe0b, 0xe0c, 0xe0d, 0xe0e, 0xe0f,
	 0xe10, 0xe11, 0xe12, 0xe13, 0xe14, 0xe15, 0xe16, 0xe17,
	 0xe18, 0xe19, 0xe1a, 0xe1b, 0xe1c, 0xe1d, 0xe1e, 0xe1f,
	 0xe20, 0xe21, 0xe22, 0xe23, 0xe24, 0xe25, 0xe26, 0xe27,
	 0xe28, 0xe29, 0xe2a, 0xe2b, 0xe2c, 0xe2d, 0xe2e, 0xe2f,
	 0xe30, 0xe31, 0xe32, 0xe33, 0xe34, 0xe35, 0xe36, 0xe37,
	 0xe38, 0xe39, 0xe3a,     0,     0,     0,     0, 0xe3f,
	 0xe40, 0xe41, 0xe42, 0xe43, 0xe44, 0xe45, 0xe46, 0xe47,
	 0xe48, 0xe49, 0xe4a, 0xe4b, 0xe4c, 0xe4d, 0xe4e, 0xe4f,
	 0xe50, 0xe51, 0xe52, 0xe53, 0xe54, 0xe55, 0xe56, 0xe57,
	 0xe58, 0xe59, 0xe5a, 0xe5b,     0,     0,     0,     0
    },
    /* encode_874.lower */
    {
	  0x80,     0,     0,     0,     0,  0x85,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,     0,     0,     0,     0,     0,     0,     0,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,     0,     0,     0,     0
    },
    /* encode_874.upper */
    {
	  0x80,     0,     0,     0,     0,  0x85,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,     0,     0,     0,     0,     0,     0,     0,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,     0,     0,     0,     0
    },
    /* encode_874.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	0,
	/* 0x82 */	0,
	/* 0x83 */	0,
	/* 0x84 */	0,
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	0,
	/* 0x87 */	0,
	/* 0x88 */	0,
	/* 0x89 */	0,
	/* 0x8a */	0,
	/* 0x8b */	0,
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	0,
	/* 0x99 */	0,
	/* 0x9a */	0,
	/* 0x9b */	0,
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print),
	/* 0xa2 */	(vl_alpha | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print),
	/* 0xa4 */	(vl_alpha | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_alpha | vl_print),
	/* 0xa9 */	(vl_alpha | vl_print),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_alpha | vl_print),
	/* 0xac */	(vl_alpha | vl_print),
	/* 0xad */	(vl_alpha | vl_print),
	/* 0xae */	(vl_alpha | vl_print),
	/* 0xaf */	(vl_alpha | vl_print),
	/* 0xb0 */	(vl_alpha | vl_print),
	/* 0xb1 */	(vl_alpha | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print),
	/* 0xb3 */	(vl_alpha | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print),
	/* 0xb5 */	(vl_alpha | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_alpha | vl_print),
	/* 0xbc */	(vl_alpha | vl_print),
	/* 0xbd */	(vl_alpha | vl_print),
	/* 0xbe */	(vl_alpha | vl_print),
	/* 0xbf */	(vl_alpha | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_print | vl_punct),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	(vl_alpha | vl_print),
	/* 0xee */	(vl_alpha | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_alpha | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*  16:8859_4 */
static const GNREIGHT_ENC encode_8859_4 = {
    /* encode_8859_4.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x104, 0x138, 0x156,  0xa4, 0x128, 0x13b,  0xa7,
	  0xa8, 0x160, 0x112, 0x122, 0x166,  0xad, 0x17d,  0xaf,
	  0xb0, 0x105, 0x2db, 0x157,  0xb4, 0x129, 0x13c, 0x2c7,
	  0xb8, 0x161, 0x113, 0x123, 0x167, 0x14a, 0x17e, 0x14b,
	 0x100,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6, 0x12e,
	 0x10c,  0xc9, 0x118,  0xcb, 0x116,  0xcd,  0xce, 0x12a,
	 0x110, 0x145, 0x14c, 0x136,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8, 0x172,  0xda,  0xdb,  0xdc, 0x168, 0x16a,  0xdf,
	 0x101,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6, 0x12f,
	 0x10d,  0xe9, 0x119,  0xeb, 0x117,  0xed,  0xee, 0x12b,
	 0x111, 0x146, 0x14d, 0x137,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8, 0x173,  0xfa,  0xfb,  0xfc, 0x169, 0x16b, 0x2d9
    },
    /* encode_8859_4.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xb1,  0xa2,  0xb3,  0xa4,  0xb5,  0xb6,  0xa7,
	  0xa8,  0xb9,  0xba,  0xbb,  0xbc,  0xad,  0xbe,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbf,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_8859_4.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xa1,  0xb2,  0xa3,  0xb4,  0xa5,  0xa6,  0xb7,
	  0xb8,  0xa9,  0xaa,  0xab,  0xac,  0xbd,  0xae,  0xbd,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_8859_4.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  17:ANSI_X3.110-1983 */
static const GNREIGHT_ENC encode_ANSI_X3_110_1983 = {
    /* encode_ANSI_X3_110_1983.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,  0x24,  0xa5,  0x23,  0xa7,
	  0xa4,0x2018,0x201c,  0xab,0x2190,0x2191,0x2192,0x2193,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xd7,  0xb5,  0xb6,  0xb7,
	  0xf7,0x2019,0x201d,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	0x2014,  0xb9,  0xae,  0xa9,0x2122,0x266a,0x2500,0x2502,
	0x2571,0x2572,0x25e2,0x25e3,0x215b,0x215c,0x215d,0x215e,
	0x2126,  0xc6,  0xd0,  0xaa, 0x126,0x253c, 0x132, 0x13f,
	 0x141,  0xd8, 0x152,  0xba,  0xde, 0x166, 0x14a, 0x149,
	 0x138,  0xe6, 0x111,  0xf0, 0x127, 0x131, 0x133, 0x140,
	 0x142,  0xf8, 0x153,  0xdf,  0xfe, 0x167, 0x14b,     0
    },
    /* encode_ANSI_X3_110_1983.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xf1,  0xf3,  0xe3,  0xf4,  0xe5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xeb,  0xfc,  0xfd,  0xfe,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_ANSI_X3_110_1983.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xe1,  0xf2,  0xe2,  0xe4,  0x49,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xfb,  0xec,  0xed,  0xee,     0
    },
    /* encode_ANSI_X3_110_1983.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	0,
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_print | vl_punct),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	0,
    },
};

/*  18:ANSI_X3.4-1968 */
static const GNREIGHT_ENC encode_ANSI_X3_4_1968 = {
    /* encode_ANSI_X3_4_1968.chmap */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_ANSI_X3_4_1968.lower */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_ANSI_X3_4_1968.upper */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_ANSI_X3_4_1968.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	0,
	/* 0x82 */	0,
	/* 0x83 */	0,
	/* 0x84 */	0,
	/* 0x85 */	0,
	/* 0x86 */	0,
	/* 0x87 */	0,
	/* 0x88 */	0,
	/* 0x89 */	0,
	/* 0x8a */	0,
	/* 0x8b */	0,
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	0,
	/* 0x92 */	0,
	/* 0x93 */	0,
	/* 0x94 */	0,
	/* 0x95 */	0,
	/* 0x96 */	0,
	/* 0x97 */	0,
	/* 0x98 */	0,
	/* 0x99 */	0,
	/* 0x9a */	0,
	/* 0x9b */	0,
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	0,
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	0,
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	0,
	/* 0xe1 */	0,
	/* 0xe2 */	0,
	/* 0xe3 */	0,
	/* 0xe4 */	0,
	/* 0xe5 */	0,
	/* 0xe6 */	0,
	/* 0xe7 */	0,
	/* 0xe8 */	0,
	/* 0xe9 */	0,
	/* 0xea */	0,
	/* 0xeb */	0,
	/* 0xec */	0,
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	0,
	/* 0xf1 */	0,
	/* 0xf2 */	0,
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*  19:ARMSCII-8 */
static const GNREIGHT_ENC encode_ARMSCII_8 = {
    /* encode_ARMSCII_8.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0, 0x587, 0x589,  0x29,  0x28,  0xbb,  0xab,
	0x2014,  0x2e, 0x55d,  0x2c,  0x2d, 0x58a,0x2026, 0x55c,
	 0x55b, 0x55e, 0x531, 0x561, 0x532, 0x562, 0x533, 0x563,
	 0x534, 0x564, 0x535, 0x565, 0x536, 0x566, 0x537, 0x567,
	 0x538, 0x568, 0x539, 0x569, 0x53a, 0x56a, 0x53b, 0x56b,
	 0x53c, 0x56c, 0x53d, 0x56d, 0x53e, 0x56e, 0x53f, 0x56f,
	 0x540, 0x570, 0x541, 0x571, 0x542, 0x572, 0x543, 0x573,
	 0x544, 0x574, 0x545, 0x575, 0x546, 0x576, 0x547, 0x577,
	 0x548, 0x578, 0x549, 0x579, 0x54a, 0x57a, 0x54b, 0x57b,
	 0x54c, 0x57c, 0x54d, 0x57d, 0x54e, 0x57e, 0x54f, 0x57f,
	 0x550, 0x580, 0x551, 0x581, 0x552, 0x582, 0x553, 0x583,
	 0x554, 0x584, 0x555, 0x585, 0x556, 0x586, 0x55a,     0
    },
    /* encode_ARMSCII_8.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,  0xa2,  0xa3,  0x29,  0x28,  0xa6,  0xa7,
	  0xa8,  0x2e,  0xaa,  0x2c,  0x2d,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb3,  0xb3,  0xb5,  0xb5,  0xb7,  0xb7,
	  0xb9,  0xb9,  0xbb,  0xbb,  0xbd,  0xbd,  0xbf,  0xbf,
	  0xc1,  0xc1,  0xc3,  0xc3,  0xc5,  0xc5,  0xc7,  0xc7,
	  0xc9,  0xc9,  0xcb,  0xcb,  0xcd,  0xcd,  0xcf,  0xcf,
	  0xd1,  0xd1,  0xd3,  0xd3,  0xd5,  0xd5,  0xd7,  0xd7,
	  0xd9,  0xd9,  0xdb,  0xdb,  0xdd,  0xdd,  0xdf,  0xdf,
	  0xe1,  0xe1,  0xe3,  0xe3,  0xe5,  0xe5,  0xe7,  0xe7,
	  0xe9,  0xe9,  0xeb,  0xeb,  0xed,  0xed,  0xef,  0xef,
	  0xf1,  0xf1,  0xf3,  0xf3,  0xf5,  0xf5,  0xf7,  0xf7,
	  0xf9,  0xf9,  0xfb,  0xfb,  0xfd,  0xfd,  0xfe,     0
    },
    /* encode_ARMSCII_8.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,  0xa2,  0xa3,  0x29,  0x28,  0xa6,  0xa7,
	  0xa8,  0x2e,  0xaa,  0x2c,  0x2d,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb2,  0xb4,  0xb4,  0xb6,  0xb6,
	  0xb8,  0xb8,  0xba,  0xba,  0xbc,  0xbc,  0xbe,  0xbe,
	  0xc0,  0xc0,  0xc2,  0xc2,  0xc4,  0xc4,  0xc6,  0xc6,
	  0xc8,  0xc8,  0xca,  0xca,  0xcc,  0xcc,  0xce,  0xce,
	  0xd0,  0xd0,  0xd2,  0xd2,  0xd4,  0xd4,  0xd6,  0xd6,
	  0xd8,  0xd8,  0xda,  0xda,  0xdc,  0xdc,  0xde,  0xde,
	  0xe0,  0xe0,  0xe2,  0xe2,  0xe4,  0xe4,  0xe6,  0xe6,
	  0xe8,  0xe8,  0xea,  0xea,  0xec,  0xec,  0xee,  0xee,
	  0xf0,  0xf0,  0xf2,  0xf2,  0xf4,  0xf4,  0xf6,  0xf6,
	  0xf8,  0xf8,  0xfa,  0xfa,  0xfc,  0xfc,  0xfe,     0
    },
    /* encode_ARMSCII_8.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	0,
	/* 0xa2 */	(vl_alpha | vl_print),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_lower | vl_print),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	0,
    },
};

/*  20:CP10007 */
static const GNREIGHT_ENC encode_CP10007 = {
    /* encode_CP10007.chmap */
    {
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	0x2020,  0xb0,  0xa2,  0xa3,  0xa7,0x2022,  0xb6, 0x406,
	  0xae,  0xa9,0x2122, 0x402, 0x452,0x2260, 0x403, 0x453,
	0x221e,  0xb1,0x2264,0x2265, 0x456,  0xb5, 0x491, 0x408,
	 0x404, 0x454, 0x407, 0x457, 0x409, 0x459, 0x40a, 0x45a,
	 0x458, 0x405,  0xac,0x221a, 0x192,0x2248,0x2206,  0xab,
	  0xbb,0x2026,  0xa0, 0x40b, 0x45b, 0x40c, 0x45c, 0x455,
	0x2013,0x2014,0x201c,0x201d,0x2018,0x2019,  0xf7,0x201e,
	 0x40e, 0x45e, 0x40f, 0x45f,0x2116, 0x401, 0x451, 0x44f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e,  0xa4
    },
    /* encode_CP10007.lower */
    {
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xb4,
	  0xa8,  0xa9,  0xaa,  0xac,  0xac,  0xad,  0xaf,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xc0,
	  0xb9,  0xb9,  0xbb,  0xbb,  0xbd,  0xbd,  0xbf,  0xbf,
	  0xc0,  0xcf,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcc,  0xcc,  0xce,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd9,  0xd9,  0xdb,  0xdb,  0xdc,  0xde,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP10007.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xab,  0xad,  0xae,  0xae,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xa7,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb8,  0xba,  0xba,  0xbc,  0xbc,  0xbe,  0xbe,
	  0xb7,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcb,  0xcd,  0xcd,  0xc1,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd8,  0xda,  0xda,  0xdc,  0xdd,  0xdd,  0x9f,
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0xff
    },
    /* encode_CP10007.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_print | vl_upper),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_alpha | vl_print | vl_upper),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_print | vl_upper),
	/* 0x88 */	(vl_alpha | vl_print | vl_upper),
	/* 0x89 */	(vl_alpha | vl_print | vl_upper),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_alpha | vl_print | vl_upper),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_print | vl_upper),
	/* 0x94 */	(vl_alpha | vl_print | vl_upper),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_print | vl_upper),
	/* 0x97 */	(vl_alpha | vl_print | vl_upper),
	/* 0x98 */	(vl_alpha | vl_print | vl_upper),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_print | vl_upper),
	/* 0x9c */	(vl_alpha | vl_print | vl_upper),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_alpha | vl_print | vl_upper),
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_lower | vl_print),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_alpha | vl_lower | vl_print),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_lower | vl_print),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  21:CP1004 */
static const GNREIGHT_ENC encode_CP1004 = {
    /* encode_CP1004.chmap */
    {
	     0,     0,0x201a,     0,0x201e,0x2026,0x2020,0x2021,
	 0x2c6,0x2030, 0x160,0x2039, 0x152,     0,     0,     0,
	     0,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	 0x2dc,0x2122, 0x161,0x203a, 0x153,     0,     0, 0x178,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1004.lower */
    {
	     0,     0,  0x82,     0,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x9a,  0x8b,  0x9c,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,     0,     0,  0xff,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1004.upper */
    {
	     0,     0,  0x82,     0,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x8a,  0x9b,  0x8c,     0,     0,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0x9f
    },
    /* encode_CP1004.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	0,
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	0,
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_alpha | vl_print),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  22:CP1008 */
static const GNREIGHT_ENC encode_CP1008 = {
    /* encode_CP1008.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x60c,  0xa2, 0x61b, 0x61f,0xfe7c,  0xa6,0xfe7d,
	 0x640,0xf8fc,0xfe80,0xfe81,  0xac,  0xad,0xfe82,0xfe83,
	 0x660, 0x661, 0x662, 0x663, 0x664, 0x665, 0x666, 0x667,
	 0x668, 0x669,0xfe84,0xfe85,0xfe8b,0xfe8d,0xfe8e,0xfe8f,
	0xfe91,0xfe93,0xfe95,0xfe97,0xfe99,0xfe9b,0xfe9d,0xfe9f,
	0xfea1,0xfea3,0xfea5,0xfea7,0xfea9,0xfeab,0xfead,0xfeaf,
	0xf8f6,0xfeb3,0xf8f5,0xfeb7,0xf8f4,0xfebb,0xf8f7,  0xd7,
	0xfebf,0xfec3,0xfec7,0xfec9,0xfeca,0xfecb,0xfecc,0xfecd,
	0xfece,0xfecf,0xfed0,0xfed1,0xfed3,0xfed5,0xfed7,0xfed9,
	0xfedb,0xfedd,0xfef5,0xfef6,0xfef7,0xfef8,0xfefb,0xfefc,
	0xfedf,0xfee1,0xfee3,0xfee5,0xfee7,0xfee9,0xfeeb,  0xf7,
	0xfeec,0xfeed,0xfeef,0xfef0,0xfef1,0xfef2,0xfef3,     0
    },
    /* encode_CP1008.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_CP1008.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_CP1008.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_print),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_alpha | vl_print),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_alpha | vl_print),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print),
	/* 0xaf */	(vl_alpha | vl_print),
	/* 0xb0 */	(vl_alpha | vl_print),
	/* 0xb1 */	(vl_alpha | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print),
	/* 0xb3 */	(vl_alpha | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print),
	/* 0xb5 */	(vl_alpha | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_alpha | vl_print),
	/* 0xbc */	(vl_alpha | vl_print),
	/* 0xbd */	(vl_alpha | vl_print),
	/* 0xbe */	(vl_alpha | vl_print),
	/* 0xbf */	(vl_alpha | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_alpha | vl_print),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	(vl_alpha | vl_print),
	/* 0xdc */	(vl_alpha | vl_print),
	/* 0xdd */	(vl_alpha | vl_print),
	/* 0xde */	(vl_alpha | vl_print),
	/* 0xdf */	(vl_alpha | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	(vl_alpha | vl_print),
	/* 0xee */	(vl_alpha | vl_print),
	/* 0xef */	(vl_alpha | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_alpha | vl_print),
	/* 0xfb */	(vl_alpha | vl_print),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_alpha | vl_print),
	/* 0xfe */	(vl_alpha | vl_print),
	/* 0xff */	0,
    },
};

/*  23:CP1124 */
static const GNREIGHT_ENC encode_CP1124 = {
    /* encode_CP1124.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x401, 0x402, 0x490, 0x404, 0x405, 0x406, 0x407,
	 0x408, 0x409, 0x40a, 0x40b, 0x40c,  0xad, 0x40e, 0x40f,
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f,
	0x2116, 0x451, 0x452, 0x491, 0x454, 0x455, 0x456, 0x457,
	 0x458, 0x459, 0x45a, 0x45b, 0x45c,  0xa7, 0x45e, 0x45f
    },
    /* encode_CP1124.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xad,  0xfe,  0xff,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1124.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xf0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xfd,  0xae,  0xaf
    },
    /* encode_CP1124.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_alpha | vl_print | vl_upper),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_print | vl_upper),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  24:CP1125 */
static const GNREIGHT_ENC encode_CP1125 = {
    /* encode_CP1125.chmap */
    {
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
	0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
	0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
	0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f,
	 0x401, 0x451, 0x490, 0x491, 0x404, 0x454, 0x406, 0x456,
	 0x407, 0x457,  0xb7,0x221a,0x2116,  0xa4,0x25a0,  0xa0
    },
    /* encode_CP1125.lower */
    {
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf1,  0xf1,  0xf3,  0xf3,  0xf5,  0xf5,  0xf7,  0xf7,
	  0xf9,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1125.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xf0,  0xf0,  0xf2,  0xf2,  0xf4,  0xf4,  0xf6,  0xf6,
	  0xf8,  0xf8,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1125.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_print | vl_upper),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_alpha | vl_print | vl_upper),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_print | vl_upper),
	/* 0x88 */	(vl_alpha | vl_print | vl_upper),
	/* 0x89 */	(vl_alpha | vl_print | vl_upper),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_alpha | vl_print | vl_upper),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_print | vl_upper),
	/* 0x94 */	(vl_alpha | vl_print | vl_upper),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_print | vl_upper),
	/* 0x97 */	(vl_alpha | vl_print | vl_upper),
	/* 0x98 */	(vl_alpha | vl_print | vl_upper),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_print | vl_upper),
	/* 0x9c */	(vl_alpha | vl_print | vl_upper),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_alpha | vl_print | vl_upper),
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xaa */	(vl_alpha | vl_lower | vl_print),
	/* 0xab */	(vl_alpha | vl_lower | vl_print),
	/* 0xac */	(vl_alpha | vl_lower | vl_print),
	/* 0xad */	(vl_alpha | vl_lower | vl_print),
	/* 0xae */	(vl_alpha | vl_lower | vl_print),
	/* 0xaf */	(vl_alpha | vl_lower | vl_print),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_print | vl_punct),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  25:CP1129 */
static const GNREIGHT_ENC encode_CP1129 = {
    /* encode_CP1129.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	 0x153,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3, 0x178,  0xb5,  0xb6,  0xb7,
	 0x152,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2, 0x102,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb, 0x300,  0xcd,  0xce,  0xcf,
	 0x110,  0xd1, 0x309,  0xd3,  0xd4, 0x1a0,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc, 0x1af, 0x303,  0xdf,
	  0xe0,  0xe1,  0xe2, 0x103,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb, 0x301,  0xed,  0xee,  0xef,
	 0x111,  0xf1, 0x323,  0xf3,  0xf4, 0x1a1,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc, 0x1b0,0x20ab,  0xff
    },
    /* encode_CP1129.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xff,  0xb5,  0xb6,  0xb7,
	  0xa8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xcc,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xd2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1129.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xb8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xec,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xf2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xfe,  0xb4
    },
    /* encode_CP1129.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  26:CP1133 */
static const GNREIGHT_ENC encode_CP1133 = {
    /* encode_CP1133.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0, 0xe81, 0xe82, 0xe84, 0xe87, 0xe88, 0xeaa, 0xe8a,
	 0xe8d, 0xe94, 0xe95, 0xe96, 0xe97, 0xe99, 0xe9a, 0xe9b,
	 0xe9c, 0xe9d, 0xe9e, 0xe9f, 0xea1, 0xea2, 0xea3, 0xea5,
	 0xea7, 0xeab, 0xead, 0xeae,     0,     0,     0, 0xeaf,
	 0xeb0, 0xeb2, 0xeb3, 0xeb4, 0xeb5, 0xeb6, 0xeb7, 0xeb8,
	 0xeb9, 0xebc, 0xeb1, 0xebb, 0xebd,     0,     0,     0,
	 0xec0, 0xec1, 0xec2, 0xec3, 0xec4, 0xec8, 0xec9, 0xeca,
	 0xecb, 0xecc, 0xecd, 0xec6,     0, 0xedc, 0xedd,  0x6b,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	 0xed0, 0xed1, 0xed2, 0xed3, 0xed4, 0xed5, 0xed6, 0xed7,
	 0xed8, 0xed9,     0,     0,  0xa2,  0xac,  0xa6,  0xa0
    },
    /* encode_CP1133.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,     0,     0,     0,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,     0,     0,     0,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,     0,  0xdd,  0xde,  0x6b,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,     0,     0,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1133.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,     0,     0,     0,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,     0,     0,     0,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,     0,  0xdd,  0xde,  0x4b,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,     0,     0,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1133.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	0,
	/* 0xa1 */	(vl_alpha | vl_print),
	/* 0xa2 */	(vl_alpha | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print),
	/* 0xa4 */	(vl_alpha | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_alpha | vl_print),
	/* 0xa9 */	(vl_alpha | vl_print),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_alpha | vl_print),
	/* 0xac */	(vl_alpha | vl_print),
	/* 0xad */	(vl_alpha | vl_print),
	/* 0xae */	(vl_alpha | vl_print),
	/* 0xaf */	(vl_alpha | vl_print),
	/* 0xb0 */	(vl_alpha | vl_print),
	/* 0xb1 */	(vl_alpha | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print),
	/* 0xb3 */	(vl_alpha | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print),
	/* 0xb5 */	(vl_alpha | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_alpha | vl_print),
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	(vl_alpha | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_alpha | vl_print),
	/* 0xdc */	0,
	/* 0xdd */	(vl_alpha | vl_print),
	/* 0xde */	(vl_alpha | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	0,
	/* 0xe1 */	0,
	/* 0xe2 */	0,
	/* 0xe3 */	0,
	/* 0xe4 */	0,
	/* 0xe5 */	0,
	/* 0xe6 */	0,
	/* 0xe7 */	0,
	/* 0xe8 */	0,
	/* 0xe9 */	0,
	/* 0xea */	0,
	/* 0xeb */	0,
	/* 0xec */	0,
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_alpha | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	(vl_print | vl_punct),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  27:CP1162 */
static const GNREIGHT_ENC encode_CP1162 = {
    /* encode_CP1162.chmap */
    {
	0x20ac,  0x81,  0x82,  0x83,  0x84,0x2026,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0xe01, 0xe02, 0xe03, 0xe04, 0xe05, 0xe06, 0xe07,
	 0xe08, 0xe09, 0xe0a, 0xe0b, 0xe0c, 0xe0d, 0xe0e, 0xe0f,
	 0xe10, 0xe11, 0xe12, 0xe13, 0xe14, 0xe15, 0xe16, 0xe17,
	 0xe18, 0xe19, 0xe1a, 0xe1b, 0xe1c, 0xe1d, 0xe1e, 0xe1f,
	 0xe20, 0xe21, 0xe22, 0xe23, 0xe24, 0xe25, 0xe26, 0xe27,
	 0xe28, 0xe29, 0xe2a, 0xe2b, 0xe2c, 0xe2d, 0xe2e, 0xe2f,
	 0xe30, 0xe31, 0xe32, 0xe33, 0xe34, 0xe35, 0xe36, 0xe37,
	 0xe38, 0xe39, 0xe3a,     0,     0,     0,     0, 0xe3f,
	 0xe40, 0xe41, 0xe42, 0xe43, 0xe44, 0xe45, 0xe46, 0xe47,
	 0xe48, 0xe49, 0xe4a, 0xe4b, 0xe4c, 0xe4d, 0xe4e, 0xe4f,
	 0xe50, 0xe51, 0xe52, 0xe53, 0xe54, 0xe55, 0xe56, 0xe57,
	 0xe58, 0xe59, 0xe5a, 0xe5b,     0,     0,     0,     0
    },
    /* encode_CP1162.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,     0,     0,     0,     0
    },
    /* encode_CP1162.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,     0,     0,     0,     0
    },
    /* encode_CP1162.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print),
	/* 0xa2 */	(vl_alpha | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print),
	/* 0xa4 */	(vl_alpha | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_alpha | vl_print),
	/* 0xa9 */	(vl_alpha | vl_print),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_alpha | vl_print),
	/* 0xac */	(vl_alpha | vl_print),
	/* 0xad */	(vl_alpha | vl_print),
	/* 0xae */	(vl_alpha | vl_print),
	/* 0xaf */	(vl_alpha | vl_print),
	/* 0xb0 */	(vl_alpha | vl_print),
	/* 0xb1 */	(vl_alpha | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print),
	/* 0xb3 */	(vl_alpha | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print),
	/* 0xb5 */	(vl_alpha | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_alpha | vl_print),
	/* 0xbc */	(vl_alpha | vl_print),
	/* 0xbd */	(vl_alpha | vl_print),
	/* 0xbe */	(vl_alpha | vl_print),
	/* 0xbf */	(vl_alpha | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_print | vl_punct),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	(vl_alpha | vl_print),
	/* 0xee */	(vl_alpha | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_alpha | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*  28:CP1163 */
static const GNREIGHT_ENC encode_CP1163 = {
    /* encode_CP1163.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,0x20ac,  0xa5,  0xa6,  0xa7,
	 0x153,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3, 0x178,  0xb5,  0xb6,  0xb7,
	 0x152,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2, 0x102,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb, 0x300,  0xcd,  0xce,  0xcf,
	 0x110,  0xd1, 0x309,  0xd3,  0xd4, 0x1a0,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc, 0x1af, 0x303,  0xdf,
	  0xe0,  0xe1,  0xe2, 0x103,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb, 0x301,  0xed,  0xee,  0xef,
	 0x111,  0xf1, 0x323,  0xf3,  0xf4, 0x1a1,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc, 0x1b0,0x20ab,  0xff
    },
    /* encode_CP1163.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xff,  0xb5,  0xb6,  0xb7,
	  0xa8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xcc,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xd2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1163.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xb8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xec,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xf2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xfe,  0xb4
    },
    /* encode_CP1163.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  29:CP1167 */
static const GNREIGHT_ENC encode_CP1167 = {
    /* encode_CP1167.chmap */
    {
	0x2500,0x2502,0x250c,0x2510,0x2514,0x2518,0x251c,0x2524,
	0x252c,0x2534,0x253c,0x2580,0x2584,0x2588,0x258c,0x2590,
	0x2591,0x2592,0x2593,0x201c,0x25a0,0x2219,0x201d,0x2014,
	0x2116,0x2122,  0xa0,  0xbb,  0xae,  0xab,  0xb7,  0xa4,
	0x2550,0x2551,0x2552, 0x451, 0x454,0x2554, 0x456, 0x457,
	0x2557,0x2558,0x2559,0x255a,0x255b, 0x491, 0x45e,0x255e,
	0x255f,0x2560,0x2561, 0x401, 0x404,0x2563, 0x406, 0x407,
	0x2566,0x2567,0x2568,0x2569,0x256a, 0x490, 0x40e,  0xa9,
	 0x44e, 0x430, 0x431, 0x446, 0x434, 0x435, 0x444, 0x433,
	 0x445, 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e,
	 0x43f, 0x44f, 0x440, 0x441, 0x442, 0x443, 0x436, 0x432,
	 0x44c, 0x44b, 0x437, 0x448, 0x44d, 0x449, 0x447, 0x44a,
	 0x42e, 0x410, 0x411, 0x426, 0x414, 0x415, 0x424, 0x413,
	 0x425, 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e,
	 0x41f, 0x42f, 0x420, 0x421, 0x422, 0x423, 0x416, 0x412,
	 0x42c, 0x42b, 0x417, 0x428, 0x42d, 0x429, 0x427, 0x42a
    },
    /* encode_CP1167.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xa3,  0xa4,  0xb5,  0xa6,  0xa7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xad,  0xae,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_CP1167.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xb3,  0xb4,  0xa5,  0xb6,  0xb7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xbd,  0xbe,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1167.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	(vl_print | vl_punct),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_print | vl_punct),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_print | vl_punct),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_print | vl_punct),
	/* 0x8d */	(vl_print | vl_punct),
	/* 0x8e */	(vl_print | vl_punct),
	/* 0x8f */	(vl_print | vl_punct),
	/* 0x90 */	(vl_print | vl_punct),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_print | vl_punct),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_print | vl_punct),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_print | vl_punct),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_alpha | vl_lower | vl_print),
	/* 0xae */	(vl_alpha | vl_lower | vl_print),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_lower | vl_print),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_print | vl_upper),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_print | vl_upper),
	/* 0xfe */	(vl_alpha | vl_print | vl_upper),
	/* 0xff */	(vl_alpha | vl_print | vl_upper),
    },
};

/*  30:CP1250 */
static const GNREIGHT_ENC encode_CP1250 = {
    /* encode_CP1250.chmap */
    {
	0x20ac,     0,0x201a,     0,0x201e,0x2026,0x2020,0x2021,
	     0,0x2030, 0x160,0x2039, 0x15a, 0x164, 0x17d, 0x179,
	     0,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	     0,0x2122, 0x161,0x203a, 0x15b, 0x165, 0x17e, 0x17a,
	  0xa0, 0x2c7, 0x2d8, 0x141,  0xa4, 0x104,  0xa6,  0xa7,
	  0xa8,  0xa9, 0x15e,  0xab,  0xac,  0xad,  0xae, 0x17b,
	  0xb0,  0xb1, 0x2db, 0x142,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8, 0x105, 0x15f,  0xbb, 0x13d, 0x2dd, 0x13e, 0x17c,
	 0x154,  0xc1,  0xc2, 0x102,  0xc4, 0x139, 0x106,  0xc7,
	 0x10c,  0xc9, 0x118,  0xcb, 0x11a,  0xcd,  0xce, 0x10e,
	 0x110, 0x143, 0x147,  0xd3,  0xd4, 0x150,  0xd6,  0xd7,
	 0x158, 0x16e,  0xda, 0x170,  0xdc,  0xdd, 0x162,  0xdf,
	 0x155,  0xe1,  0xe2, 0x103,  0xe4, 0x13a, 0x107,  0xe7,
	 0x10d,  0xe9, 0x119,  0xeb, 0x11b,  0xed,  0xee, 0x10f,
	 0x111, 0x144, 0x148,  0xf3,  0xf4, 0x151,  0xf6,  0xf7,
	 0x159, 0x16f,  0xfa, 0x171,  0xfc,  0xfd, 0x163, 0x2d9
    },
    /* encode_CP1250.lower */
    {
	  0x80,     0,  0x82,     0,  0x84,  0x85,  0x86,  0x87,
	     0,  0x89,  0x9a,  0x8b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xb3,  0xa4,  0xb9,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xba,  0xab,  0xac,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbe,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1250.upper */
    {
	  0x80,     0,  0x82,     0,  0x84,  0x85,  0x86,  0x87,
	     0,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,  0x8a,  0x9b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xa3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xa5,  0xaa,  0xbb,  0xbc,  0xbd,  0xbc,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_CP1250.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	0,
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	0,
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	0,
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	0,
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	0,
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  31:CP1251 */
static const GNREIGHT_ENC encode_CP1251 = {
    /* encode_CP1251.chmap */
    {
	 0x402, 0x403,0x201a, 0x453,0x201e,0x2026,0x2020,0x2021,
	0x20ac,0x2030, 0x409,0x2039, 0x40a, 0x40c, 0x40b, 0x40f,
	 0x452,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	     0,0x2122, 0x459,0x203a, 0x45a, 0x45c, 0x45b, 0x45f,
	  0xa0, 0x40e, 0x45e, 0x408,  0xa4, 0x490,  0xa6,  0xa7,
	 0x401,  0xa9, 0x404,  0xab,  0xac,  0xad,  0xae, 0x407,
	  0xb0,  0xb1, 0x406, 0x456, 0x491,  0xb5,  0xb6,  0xb7,
	 0x451,0x2116, 0x454,  0xbb, 0x458, 0x405, 0x455, 0x457,
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f
    },
    /* encode_CP1251.lower */
    {
	  0x90,  0x83,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x9a,  0x8b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa2,  0xa2,  0xbc,  0xa4,  0xb4,  0xa6,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xac,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb3,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbe,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1251.upper */
    {
	  0x80,  0x81,  0x82,  0x81,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x80,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,  0x8a,  0x9b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0xa0,  0xa1,  0xa1,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb2,  0xa5,  0xb5,  0xb6,  0xb7,
	  0xa8,  0xb9,  0xaa,  0xbb,  0xa3,  0xbd,  0xbd,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_CP1251.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_lower | vl_print),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	0,
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_print | vl_upper),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  32:CP1252 */
static const GNREIGHT_ENC encode_CP1252 = {
    /* encode_CP1252.chmap */
    {
	0x20ac,     0,0x201a, 0x192,0x201e,0x2026,0x2020,0x2021,
	 0x2c6,0x2030, 0x160,0x2039, 0x152,     0, 0x17d,     0,
	     0,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	 0x2dc,0x2122, 0x161,0x203a, 0x153,     0, 0x17e, 0x178,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1252.lower */
    {
	  0x80,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x9a,  0x8b,  0x9c,     0,  0x9e,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,     0,  0x9e,  0xff,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1252.upper */
    {
	  0x80,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,     0,  0x8e,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x8a,  0x9b,  0x8c,     0,  0x8e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0x9f
    },
    /* encode_CP1252.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	0,
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_alpha | vl_print),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	0,
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	0,
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  33:CP1253 */
static const GNREIGHT_ENC encode_CP1253 = {
    /* encode_CP1253.chmap */
    {
	0x20ac,     0,0x201a, 0x192,0x201e,0x2026,0x2020,0x2021,
	     0,0x2030,     0,0x2039,     0,     0,     0,     0,
	     0,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	     0,0x2122,     0,0x203a,     0,     0,     0,     0,
	  0xa0, 0x385, 0x386,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,     0,  0xab,  0xac,  0xad,  0xae,0x2015,
	  0xb0,  0xb1,  0xb2,  0xb3, 0x384,  0xb5,  0xb6,  0xb7,
	 0x388, 0x389, 0x38a,  0xbb, 0x38c,  0xbd, 0x38e, 0x38f,
	 0x390, 0x391, 0x392, 0x393, 0x394, 0x395, 0x396, 0x397,
	 0x398, 0x399, 0x39a, 0x39b, 0x39c, 0x39d, 0x39e, 0x39f,
	 0x3a0, 0x3a1,     0, 0x3a3, 0x3a4, 0x3a5, 0x3a6, 0x3a7,
	 0x3a8, 0x3a9, 0x3aa, 0x3ab, 0x3ac, 0x3ad, 0x3ae, 0x3af,
	 0x3b0, 0x3b1, 0x3b2, 0x3b3, 0x3b4, 0x3b5, 0x3b6, 0x3b7,
	 0x3b8, 0x3b9, 0x3ba, 0x3bb, 0x3bc, 0x3bd, 0x3be, 0x3bf,
	 0x3c0, 0x3c1, 0x3c2, 0x3c3, 0x3c4, 0x3c5, 0x3c6, 0x3c7,
	 0x3c8, 0x3c9, 0x3ca, 0x3cb, 0x3cc, 0x3cd, 0x3ce,     0
    },
    /* encode_CP1253.lower */
    {
	  0x80,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	     0,  0x89,     0,  0x8b,     0,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,     0,  0x9b,     0,     0,     0,     0,
	  0xa0,  0xa1,  0xdc,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,     0,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xdd,  0xde,  0xdf,  0xbb,  0xfc,  0xbd,  0xfd,  0xfe,
	  0xc0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,     0,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_CP1253.upper */
    {
	  0x80,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	     0,  0x89,     0,  0x8b,     0,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,     0,  0x9b,     0,     0,     0,     0,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,     0,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xcc,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,     0,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xa2,  0xb8,  0xb9,  0xba,
	  0xe0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd3,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xbc,  0xbe,  0xbf,     0
    },
    /* encode_CP1253.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	0,
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	0,
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	0,
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	0,
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	0,
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	0,
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_print | vl_upper),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	0,
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	0,
    },
};

/*  34:CP1254 */
static const GNREIGHT_ENC encode_CP1254 = {
    /* encode_CP1254.chmap */
    {
	0x20ac,     0,0x201a, 0x192,0x201e,0x2026,0x2020,0x2021,
	 0x2c6,0x2030, 0x160,0x2039, 0x152,     0,     0,     0,
	     0,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	 0x2dc,0x2122, 0x161,0x203a, 0x153,     0,     0, 0x178,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	 0x11e,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc, 0x130, 0x15e,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	 0x11f,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc, 0x131, 0x15f,  0xff
    },
    /* encode_CP1254.lower */
    {
	  0x80,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x9a,  0x8b,  0x9c,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,     0,     0,  0xff,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0x69,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1254.upper */
    {
	  0x80,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x8a,  0x9b,  0x8c,     0,     0,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0x49,  0xde,  0x9f
    },
    /* encode_CP1254.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	0,
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_alpha | vl_print),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  35:CP1255 */
static const GNREIGHT_ENC encode_CP1255 = {
    /* encode_CP1255.chmap */
    {
	0x20ac,     0,0x201a, 0x192,0x201e,0x2026,0x2020,0x2021,
	 0x2c6,0x2030,     0,0x2039,     0,     0,     0,     0,
	     0,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	 0x2dc,0x2122,     0,0x203a,     0,     0,     0,     0,
	  0xa0,  0xa1,  0xa2,  0xa3,0x20aa,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xd7,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xf7,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	 0x5b0, 0x5b1, 0x5b2, 0x5b3, 0x5b4, 0x5b5, 0x5b6, 0x5b7,
	 0x5b8, 0x5b9,     0, 0x5bb, 0x5bc, 0x5bd, 0x5be, 0x5bf,
	 0x5c0, 0x5c1, 0x5c2, 0x5c3, 0x5c3, 0x5f0, 0x5f1, 0x5f2,
	 0x5f4,     0,     0,     0,     0,     0,     0,     0,
	 0x5f4, 0x5d0, 0x5d1, 0x5d2, 0x5d3, 0x5d4, 0x5d5, 0x5d6,
	 0x5d7, 0x5d8, 0x5d9, 0x5da, 0x5db, 0x5dc, 0x5dd, 0x5de,
	 0x5df, 0x5e0, 0x5e1, 0x5e2, 0x5e3, 0x5e4, 0x5e5, 0x5e6,
	 0x5e7, 0x5e8, 0x5e9,     0,     0, 0x5ea,0x200f,     0
    },
    /* encode_CP1255.lower */
    {
	  0x80,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,     0,  0x8b,     0,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,     0,  0x9b,     0,     0,     0,     0,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,     0,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd3,  0xd5,  0xd6,  0xd7,
	  0xd8,     0,     0,     0,     0,     0,     0,     0,
	  0xd8,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,     0,     0,  0xfd,  0xfe,     0
    },
    /* encode_CP1255.upper */
    {
	  0x80,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,     0,  0x8b,     0,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,     0,  0x9b,     0,     0,     0,     0,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,     0,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd3,  0xd5,  0xd6,  0xd7,
	  0xd8,     0,     0,     0,     0,     0,     0,     0,
	  0xd8,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,     0,     0,  0xfd,  0xfe,     0
    },
    /* encode_CP1255.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	0,
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_alpha | vl_print),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	0,
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	0,
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	0,
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	(vl_print | vl_punct),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	(vl_alpha | vl_print),
	/* 0xee */	(vl_alpha | vl_print),
	/* 0xef */	(vl_alpha | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_alpha | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_alpha | vl_print),
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	(vl_alpha | vl_print),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	0,
    },
};

/*  36:CP1256 */
static const GNREIGHT_ENC encode_CP1256 = {
    /* encode_CP1256.chmap */
    {
	0x20ac, 0x67e,0x201a, 0x192,0x201e,0x2026,0x2020,0x2021,
	 0x2c6,0x2030, 0x679,0x2039, 0x152, 0x686, 0x698, 0x688,
	 0x6af,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	 0x6a9,0x2122, 0x691,0x203a, 0x153,0x200c,0x200d, 0x6ba,
	  0xa0, 0x60c,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9, 0x6be,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9, 0x61b,  0xbb,  0xbc,  0xbd,  0xbe, 0x61f,
	 0x6c1, 0x621, 0x622, 0x623, 0x624, 0x625, 0x626, 0x627,
	 0x628, 0x629, 0x62a, 0x62b, 0x62c, 0x62d, 0x62e, 0x62f,
	 0x630, 0x631, 0x632, 0x633, 0x634, 0x635, 0x636,  0xd7,
	 0x637, 0x638, 0x639, 0x63a, 0x640, 0x641, 0x642, 0x643,
	  0xe0, 0x644,  0xe2, 0x645, 0x646, 0x647, 0x648,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb, 0x649, 0x64a,  0xee,  0xef,
	 0x64b, 0x64c, 0x64d, 0x64e,  0xf4, 0x64f, 0x650,  0xf7,
	 0x651,  0xf9, 0x652,  0xfb,  0xfc,0x200e,0x200f, 0x6d2
    },
    /* encode_CP1256.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x9c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1256.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x8c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1256.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	(vl_alpha | vl_print),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_alpha | vl_print),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print),
	/* 0x8e */	(vl_alpha | vl_print),
	/* 0x8f */	(vl_alpha | vl_print),
	/* 0x90 */	(vl_alpha | vl_print),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_alpha | vl_print),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_print | vl_punct),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_alpha | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_alpha | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	(vl_alpha | vl_print),
	/* 0xdc */	(vl_alpha | vl_print),
	/* 0xdd */	(vl_alpha | vl_print),
	/* 0xde */	(vl_alpha | vl_print),
	/* 0xdf */	(vl_alpha | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	(vl_alpha | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_alpha | vl_print),
    },
};

/*  37:CP1257 */
static const GNREIGHT_ENC encode_CP1257 = {
    /* encode_CP1257.chmap */
    {
	0x20ac,     0,0x201a,     0,0x201e,0x2026,0x2020,0x2021,
	     0,0x2030,     0,0x2039,     0,  0xa8, 0x2c7,  0xb8,
	     0,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	     0,0x2122,     0,0x203a,     0,  0xaf, 0x2db,     0,
	  0xa0,     0,  0xa2,  0xa3,  0xa4,     0,  0xa6,  0xa7,
	  0xd8,  0xa9, 0x156,  0xab,  0xac,  0xad,  0xae,  0xc6,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xf8,  0xb9, 0x157,  0xbb,  0xbc,  0xbd,  0xbe,  0xe6,
	 0x104, 0x12e, 0x100, 0x106,  0xc4,  0xc5, 0x118, 0x112,
	 0x10c,  0xc9, 0x179, 0x116, 0x122, 0x136, 0x12a, 0x13b,
	 0x160, 0x143, 0x145,  0xd3, 0x14c,  0xd5,  0xd6,  0xd7,
	 0x172, 0x141, 0x15a, 0x16a,  0xdc, 0x17b, 0x17d,  0xdf,
	 0x105, 0x12f, 0x101, 0x107,  0xe4,  0xe5, 0x119, 0x113,
	 0x10d,  0xe9, 0x17a, 0x117, 0x123, 0x137, 0x12b, 0x13c,
	 0x161, 0x144, 0x146,  0xf3, 0x14d,  0xf5,  0xf6,  0xf7,
	 0x173, 0x142, 0x15b, 0x16b,  0xfc, 0x17c, 0x17e, 0x2d9
    },
    /* encode_CP1257.lower */
    {
	  0x80,     0,  0x82,     0,  0x84,  0x85,  0x86,  0x87,
	     0,  0x89,     0,  0x8b,     0,  0x8d,  0x8e,  0x8f,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,     0,  0x9b,     0,  0x9d,  0x9e,     0,
	  0xa0,     0,  0xa2,  0xa3,  0xa4,     0,  0xa6,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xac,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1257.upper */
    {
	  0x80,     0,  0x82,     0,  0x84,  0x85,  0x86,  0x87,
	     0,  0x89,     0,  0x8b,     0,  0x8d,  0x8e,  0x8f,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,     0,  0x9b,     0,  0x9d,  0x9e,     0,
	  0xa0,     0,  0xa2,  0xa3,  0xa4,     0,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xa8,  0xb9,  0xaa,  0xbb,  0xbc,  0xbd,  0xbe,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_CP1257.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	0,
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	0,
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	0,
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	0,
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	0,
	/* 0x8d */	(vl_print | vl_punct),
	/* 0x8e */	(vl_alpha | vl_print),
	/* 0x8f */	(vl_print | vl_punct),
	/* 0x90 */	0,
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	0,
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	0,
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	0,
	/* 0x9d */	(vl_print | vl_punct),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	0,
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	0,
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	0,
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  38:CP1282 */
static const GNREIGHT_ENC encode_CP1282 = {
    /* encode_CP1282.chmap */
    {
	  0xc4, 0x100, 0x101,  0xc9, 0x104,  0xd6,  0xdc,  0xe1,
	 0x105, 0x10c,  0xe4, 0x10d, 0x106, 0x107,  0xe9, 0x179,
	 0x17a, 0x10e,  0xed, 0x10f, 0x112, 0x113, 0x116,  0xf3,
	 0x117,  0xf4,  0xf6,  0xf5,  0xfa, 0x11a, 0x11b,  0xfc,
	0x2020,  0xb0, 0x118,  0xa3,  0xa7,0x2022,  0xb6,  0xdf,
	  0xae,  0xa9,0x2122, 0x119,  0xa8,0x2260, 0x123, 0x12e,
	 0x12f, 0x12a,0x2264,0x2265, 0x12b, 0x136,0x2202,0x2211,
	 0x142, 0x13b, 0x13c, 0x13d, 0x13e, 0x139, 0x13a, 0x145,
	 0x146, 0x143,  0xac,0x221a, 0x144, 0x147,0x2206,  0xab,
	  0xbb,0x2026,  0xa0, 0x148, 0x150,  0xd5, 0x151, 0x14c,
	0x2013,0x2014,0x201c,0x201d,0x2018,0x2019,  0xf7,0x25ca,
	 0x14d, 0x154, 0x155, 0x158,0x2039,0x203a, 0x159, 0x156,
	 0x157, 0x160,0x201a,0x201e, 0x161, 0x15a, 0x15b,  0xc1,
	 0x164, 0x165,  0xcd, 0x17d, 0x17e, 0x16a,  0xd3,  0xd4,
	 0x16b, 0x16e,  0xda, 0x16f, 0x170, 0x171, 0x172, 0x173,
	  0xdd,  0xfd, 0x137, 0x17b, 0x141, 0x17c, 0x122, 0x2c7
    },
    /* encode_CP1282.lower */
    {
	  0x8a,  0x82,  0x82,  0x8e,  0x88,  0x9a,  0x9f,  0x87,
	  0x88,  0x8b,  0x8a,  0x8b,  0x8d,  0x8d,  0x8e,  0x90,
	  0x90,  0x93,  0x92,  0x93,  0x95,  0x95,  0x98,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9e,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xab,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xb0,
	  0xb0,  0xb4,  0xb2,  0xb3,  0xb4,  0xfa,  0xb6,  0xb7,
	  0xb8,  0xba,  0xba,  0xbc,  0xbc,  0xbe,  0xbe,  0xc0,
	  0xc0,  0xc4,  0xc2,  0xc3,  0xc4,  0xcb,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xce,  0x9b,  0xce,  0xd8,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xda,  0xda,  0xde,  0xdc,  0xdd,  0xde,  0xe0,
	  0xe0,  0xe4,  0xe2,  0xe3,  0xe4,  0xe6,  0xe6,  0x87,
	  0xe9,  0xe9,  0x92,  0xec,  0xec,  0xf0,  0x97,  0x99,
	  0xf0,  0xf3,  0x9c,  0xf3,  0xf5,  0xf5,  0xf7,  0xf7,
	  0xf9,  0xf9,  0xfa,  0xfd,  0xb8,  0xfd,  0xae,  0xff
    },
    /* encode_CP1282.upper */
    {
	  0x80,  0x81,  0x81,  0x83,  0x84,  0x85,  0x86,  0xe7,
	  0x84,  0x89,  0x80,  0x89,  0x8c,  0x8c,  0x83,  0x8f,
	  0x8f,  0x91,  0xea,  0x91,  0x94,  0x94,  0x96,  0xee,
	  0x96,  0xef,  0x85,  0xcd,  0xf2,  0x9d,  0x9d,  0x86,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xa2,  0xac,  0xad,  0xfe,  0xaf,
	  0xaf,  0xb1,  0xb2,  0xb3,  0xb1,  0xb5,  0xb6,  0xb7,
	  0xfc,  0xb9,  0xb9,  0xbb,  0xbb,  0xbd,  0xbd,  0xbf,
	  0xbf,  0xc1,  0xc2,  0xc3,  0xc1,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xc5,  0xcc,  0xcd,  0xcc,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xcf,  0xd9,  0xd9,  0xdb,  0xdc,  0xdd,  0xdb,  0xdf,
	  0xdf,  0xe1,  0xe2,  0xe3,  0xe1,  0xe5,  0xe5,  0xe7,
	  0xe8,  0xe8,  0xea,  0xeb,  0xeb,  0xed,  0xee,  0xef,
	  0xed,  0xf1,  0xf2,  0xf1,  0xf4,  0xf4,  0xf6,  0xf6,
	  0xf8,  0xf8,  0xb5,  0xfb,  0xfc,  0xfb,  0xfe,  0xff
    },
    /* encode_CP1282.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_alpha | vl_print | vl_upper),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_print | vl_upper),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_lower | vl_print),
	/* 0x8e */	(vl_alpha | vl_lower | vl_print),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_lower | vl_print),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_lower | vl_print),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_print | vl_upper),
	/* 0x95 */	(vl_alpha | vl_lower | vl_print),
	/* 0x96 */	(vl_alpha | vl_print | vl_upper),
	/* 0x97 */	(vl_alpha | vl_lower | vl_print),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_lower | vl_print),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_alpha | vl_lower | vl_print),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_lower | vl_print),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_print | vl_upper),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_print | vl_upper),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_print | vl_upper),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_print | vl_punct),
	/* 0xe3 */	(vl_print | vl_punct),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_print | vl_upper),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_print | vl_upper),
	/* 0xff */	(vl_alpha | vl_print),
    },
};

/*  39:CP4909 */
static const GNREIGHT_ENC encode_CP4909 = {
    /* encode_CP4909.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,0x2018,0x2019,  0xa3,0x20ac,     0,  0xa6,  0xa7,
	  0xa8,  0xa9,     0,  0xab,  0xac,  0xad,     0,0x2015,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4, 0x385, 0x386, 0x387,
	 0x388, 0x389, 0x38a,  0xbb, 0x38c,  0xbd, 0x38e, 0x38f,
	 0x390, 0x391, 0x392, 0x393, 0x394, 0x395, 0x396, 0x397,
	 0x398, 0x399, 0x39a, 0x39b, 0x39c, 0x39d, 0x39e, 0x39f,
	 0x3a0, 0x3a1,     0, 0x3a3, 0x3a4, 0x3a5, 0x3a6, 0x3a7,
	 0x3a8, 0x3a9, 0x3aa, 0x3ab, 0x3ac, 0x3ad, 0x3ae, 0x3af,
	 0x3b0, 0x3b1, 0x3b2, 0x3b3, 0x3b4, 0x3b5, 0x3b6, 0x3b7,
	 0x3b8, 0x3b9, 0x3ba, 0x3bb, 0x3bc, 0x3bd, 0x3be, 0x3bf,
	 0x3c0, 0x3c1, 0x3c2, 0x3c3, 0x3c4, 0x3c5, 0x3c6, 0x3c7,
	 0x3c8, 0x3c9, 0x3ca, 0x3cb, 0x3cc, 0x3cd, 0x3ce,     0
    },
    /* encode_CP4909.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,     0,  0xa6,  0xa7,
	  0xa8,  0xa9,     0,  0xab,  0xac,  0xad,     0,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xdc,  0xb7,
	  0xdd,  0xde,  0xdf,  0xbb,  0xfc,  0xbd,  0xfd,  0xfe,
	  0xc0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,     0,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_CP4909.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,     0,  0xa6,  0xa7,
	  0xa8,  0xa9,     0,  0xab,  0xac,  0xad,     0,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,     0,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xb6,  0xb8,  0xb9,  0xba,
	  0xe0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd3,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xbc,  0xbe,  0xbf,     0
    },
    /* encode_CP4909.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	0,
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	0,
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	0,
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_print | vl_upper),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	0,
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	0,
    },
};

/*  40:CP5347 */
static const GNREIGHT_ENC encode_CP5347 = {
    /* encode_CP5347.chmap */
    {
	 0x402, 0x403,0x201a, 0x453,0x201e,0x2026,0x2020,0x2021,
	0x20ac,0x2030, 0x409,0x2039, 0x40a, 0x40c, 0x40b, 0x40f,
	 0x452,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	  0x98,0x2122, 0x459,0x203a, 0x45a, 0x45c, 0x45b, 0x45f,
	  0xa0, 0x40e, 0x45e, 0x408,  0xa4, 0x490,  0xa6,  0xa7,
	 0x401,  0xa9, 0x404,  0xab,  0xac,  0xad,  0xae, 0x407,
	  0xb0,  0xb1, 0x406, 0x456, 0x491,  0xb5,  0xb6,  0xb7,
	 0x451,0x2116, 0x454,  0xbb, 0x458, 0x405, 0x455, 0x457,
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f
    },
    /* encode_CP5347.lower */
    {
	  0x90,  0x83,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x9a,  0x8b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa2,  0xa2,  0xbc,  0xa4,  0xb4,  0xa6,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xac,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb3,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbe,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP5347.upper */
    {
	  0x80,  0x81,  0x82,  0x81,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x80,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x8a,  0x9b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0xa0,  0xa1,  0xa1,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb2,  0xa5,  0xb5,  0xb6,  0xb7,
	  0xa8,  0xb9,  0xaa,  0xbb,  0xa3,  0xbd,  0xbd,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_CP5347.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_lower | vl_print),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_print | vl_upper),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  41:CP737 */
static const GNREIGHT_ENC encode_CP737 = {
    /* encode_CP737.chmap */
    {
	 0x391, 0x392, 0x393, 0x394, 0x395, 0x396, 0x397, 0x398,
	 0x399, 0x39a, 0x39b, 0x39c, 0x39d, 0x39e, 0x39f, 0x3a0,
	 0x3a1, 0x3a3, 0x3a4, 0x3a5, 0x3a6, 0x3a7, 0x3a8, 0x3a9,
	 0x3b1, 0x3b2, 0x3b3, 0x3b4, 0x3b5, 0x3b6, 0x3b7, 0x3b8,
	 0x3b9, 0x3ba, 0x3bb, 0x3bc, 0x3bd, 0x3be, 0x3bf, 0x3c0,
	 0x3c1, 0x3c3, 0x3c2, 0x3c4, 0x3c5, 0x3c6, 0x3c7, 0x3c8,
	0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
	0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
	0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
	0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	 0x3c9, 0x3ac, 0x3ad, 0x3ae, 0x3ca, 0x3af, 0x3cc, 0x3cd,
	 0x3cb, 0x3ce, 0x386, 0x388, 0x389, 0x38a, 0x38c, 0x38e,
	 0x38f,  0xb1,0x2265,0x2264, 0x3aa, 0x3ab,  0xf7,0x2248,
	  0xb0,0x2219,  0xb7,0x221a,0x207f,  0xb2,0x25a0,  0xa0
    },
    /* encode_CP737.lower */
    {
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xab,  0xac,  0xad,  0xae,  0xaf,  0xe0,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xe1,  0xe2,  0xe3,  0xe5,  0xe6,  0xe7,
	  0xe9,  0xf1,  0xf2,  0xf3,  0xe4,  0xe8,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP737.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0x97,  0xea,  0xeb,  0xec,  0xf4,  0xed,  0xee,  0xef,
	  0xf5,  0xf0,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP737.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_print | vl_upper),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_alpha | vl_print | vl_upper),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_print | vl_upper),
	/* 0x88 */	(vl_alpha | vl_print | vl_upper),
	/* 0x89 */	(vl_alpha | vl_print | vl_upper),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_alpha | vl_print | vl_upper),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_print | vl_upper),
	/* 0x94 */	(vl_alpha | vl_print | vl_upper),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_print | vl_upper),
	/* 0x97 */	(vl_alpha | vl_print | vl_upper),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_lower | vl_print),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xaa */	(vl_alpha | vl_lower | vl_print),
	/* 0xab */	(vl_alpha | vl_lower | vl_print),
	/* 0xac */	(vl_alpha | vl_lower | vl_print),
	/* 0xad */	(vl_alpha | vl_lower | vl_print),
	/* 0xae */	(vl_alpha | vl_lower | vl_print),
	/* 0xaf */	(vl_alpha | vl_lower | vl_print),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  42:CP775 */
static const GNREIGHT_ENC encode_CP775 = {
    /* encode_CP775.chmap */
    {
	 0x106,  0xfc,  0xe9, 0x101,  0xe4, 0x123,  0xe5, 0x107,
	 0x142, 0x113, 0x156, 0x157, 0x12b, 0x179,  0xc4,  0xc5,
	  0xc9,  0xe6,  0xc6, 0x14d,  0xf6, 0x122,  0xa2, 0x15a,
	 0x15b,  0xd6,  0xdc,  0xf8,  0xa3,  0xd8,  0xd7,  0xa4,
	 0x100, 0x12a,  0xf3, 0x17b, 0x17c, 0x17a,0x201d,  0xa6,
	  0xa9,  0xae,  0xac,  0xbd,  0xbc, 0x141,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524, 0x104, 0x10c, 0x118,
	 0x116,0x2563,0x2551,0x2557,0x255d, 0x12e, 0x160,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c, 0x172, 0x16a,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c, 0x17d,
	 0x105, 0x10d, 0x119, 0x117, 0x12f, 0x161, 0x173, 0x16b,
	 0x17e,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	  0xd3,  0xdf, 0x14c, 0x143,  0xf5,  0xd5,  0xb5, 0x144,
	 0x136, 0x137, 0x13b, 0x13c, 0x146, 0x112, 0x145,0x2019,
	  0xad,  0xb1,0x201c,  0xbe,  0xb6,  0xa7,  0xf7,0x201e,
	  0xb0,0x2219,  0xb7,  0xb9,  0xb3,  0xb2,0x25a0,  0xa0
    },
    /* encode_CP775.lower */
    {
	  0x87,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8b,  0x8b,  0x8c,  0xa5,  0x84,  0x86,
	  0x82,  0x91,  0x91,  0x93,  0x94,  0x85,  0x96,  0x98,
	  0x98,  0x94,  0x81,  0x9b,  0x9c,  0x9b,  0x9e,  0x9f,
	  0x83,  0x8c,  0xa2,  0xa4,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0x88,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xd0,  0xd1,  0xd2,
	  0xd3,  0xb9,  0xba,  0xbb,  0xbc,  0xd4,  0xd5,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xd6,  0xd7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xd8,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xa2,  0xe1,  0x93,  0xe7,  0xe4,  0xe4,  0xe6,  0xe7,
	  0xe9,  0xe9,  0xeb,  0xeb,  0xec,  0x89,  0xec,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP775.upper */
    {
	  0x80,  0x9a,  0x90,  0xa0,  0x8e,  0x95,  0x8f,  0x80,
	  0xad,  0xed,  0x8a,  0x8a,  0xa1,  0x8d,  0x8e,  0x8f,
	  0x90,  0x92,  0x92,  0xe2,  0x99,  0x95,  0x96,  0x97,
	  0x97,  0x99,  0x9a,  0x9d,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xe0,  0xa3,  0xa3,  0x8d,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xb5,  0xb6,  0xb7,  0xb8,  0xbd,  0xbe,  0xc6,  0xc7,
	  0xcf,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe5,  0xe5,  0xe6,  0xe3,
	  0xe8,  0xe8,  0xea,  0xea,  0xee,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP775.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_alpha | vl_lower | vl_print),
	/* 0x85 */	(vl_alpha | vl_lower | vl_print),
	/* 0x86 */	(vl_alpha | vl_lower | vl_print),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_lower | vl_print),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_alpha | vl_print | vl_upper),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_print | vl_punct),
	/* 0xa0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_alpha | vl_print | vl_upper),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_print | vl_punct),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  43:CP901 */
static const GNREIGHT_ENC encode_CP901 = {
    /* encode_CP901.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,0x201d,  0xa2,  0xa3,0x20ac,0x201e,  0xa6,  0xa7,
	  0xd8,  0xa9, 0x156,  0xab,  0xac,  0xad,  0xae,  0xc6,
	  0xb0,  0xb1,  0xb2,  0xb3,0x201c,  0xb5,  0xb6,  0xb7,
	  0xf8,  0xb9, 0x157,  0xbb,  0xbc,  0xbd,  0xbe,  0xe6,
	 0x104, 0x12e, 0x100, 0x106,  0xc4,  0xc5, 0x118, 0x112,
	 0x10c,  0xc9, 0x179, 0x116, 0x122, 0x136, 0x12a, 0x13b,
	 0x160, 0x143, 0x145,  0xd3, 0x14c,  0xd5,  0xd6,  0xd7,
	 0x172, 0x141, 0x15a, 0x16a,  0xdc, 0x17b, 0x17d,  0xdf,
	 0x105, 0x12f, 0x101, 0x107,  0xe4,  0xe5, 0x119, 0x113,
	 0x10d,  0xe9, 0x17a, 0x117, 0x123, 0x137, 0x12b, 0x13c,
	 0x161, 0x144, 0x146,  0xf3, 0x14d,  0xf5,  0xf6,  0xf7,
	 0x173, 0x142, 0x15b, 0x16b,  0xfc, 0x17c, 0x17e,0x2019
    },
    /* encode_CP901.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xac,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP901.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xa8,  0xb9,  0xaa,  0xbb,  0xbc,  0xbd,  0xbe,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_CP901.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  44:CP902 */
static const GNREIGHT_ENC encode_CP902 = {
    /* encode_CP902.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,0x20ac,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	 0x160,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd, 0x17d,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	 0x161,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd, 0x17e,  0xff
    },
    /* encode_CP902.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP902.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_CP902.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  45:CP922 */
static const GNREIGHT_ENC encode_CP922 = {
    /* encode_CP922.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	 0x160,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd, 0x17d,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	 0x161,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd, 0x17e,  0xff
    },
    /* encode_CP922.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP922.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_CP922.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  46:CP-AR */
static const GNREIGHT_ENC encode_CP_AR = {
    /* encode_CP_AR.chmap */
    {
	 0x660, 0x661, 0x662, 0x663, 0x664, 0x665, 0x666, 0x667,
	 0x668, 0x669, 0x60c, 0x61b, 0x61f, 0x622, 0x627,0xfe8e,
	0xe016, 0x628,0xfe91, 0x67e,     0, 0x629, 0x62a,0xfe97,
	     0,     0, 0x62b,0xfe9b, 0x62c,0xfe9f,     0,     0,
	 0x62d,0xfea3, 0x62e,0xfea7, 0x62f,     0, 0x630, 0x631,
	     0, 0x632,     0, 0x633,0xfeb3, 0x634,  0xab,  0xbb,
	0xfeb7, 0x635,0x2591,0x2592,0x2593,0x2502,0x2524,0xfebb,
	 0x636,0xfebf, 0x637,0x2563,0x2551,0x2557,0x255d, 0x638,
	 0x639,0x2510,0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,
	0xfeca,0xfecb,0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,
	0x256c,0xfecc, 0x63a,0xfece,0xfecf,0xfed0, 0x641,0xfed3,
	 0x642,0xfed7,0xfeda,0x2518,0x250c,0x2588,0x2580,0xfedb,
	     0,0x2584,     0, 0x644,0xfede,0xfee0, 0x645,0xfee3,
	     0, 0x646,0xfee7,     0, 0x648,     0,     0,     0,
	     0, 0x621,  0xad,     0,     0,     0,     0,     0,
	     0,     0,     0, 0x651,0xfe7d,     0,0x25a0,  0xa0
    },
    /* encode_CP_AR.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,     0,  0x95,  0x96,  0x97,
	     0,     0,  0x9a,  0x9b,  0x9c,  0x9d,     0,     0,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,     0,  0xa6,  0xa7,
	     0,  0xa9,     0,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	     0,  0xe1,     0,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	     0,  0xe9,  0xea,     0,  0xec,     0,     0,     0,
	     0,  0xf1,  0xf2,     0,     0,     0,     0,     0,
	     0,     0,     0,  0xfb,  0xfc,     0,  0xfe,  0xff
    },
    /* encode_CP_AR.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,     0,  0x95,  0x96,  0x97,
	     0,     0,  0x9a,  0x9b,  0x9c,  0x9d,     0,     0,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,     0,  0xa6,  0xa7,
	     0,  0xa9,     0,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	     0,  0xe1,     0,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	     0,  0xe9,  0xea,     0,  0xec,     0,     0,     0,
	     0,  0xf1,  0xf2,     0,     0,     0,     0,     0,
	     0,     0,     0,  0xfb,  0xfc,     0,  0xfe,  0xff
    },
    /* encode_CP_AR.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print),
	/* 0x81 */	(vl_alpha | vl_print),
	/* 0x82 */	(vl_alpha | vl_print),
	/* 0x83 */	(vl_alpha | vl_print),
	/* 0x84 */	(vl_alpha | vl_print),
	/* 0x85 */	(vl_alpha | vl_print),
	/* 0x86 */	(vl_alpha | vl_print),
	/* 0x87 */	(vl_alpha | vl_print),
	/* 0x88 */	(vl_alpha | vl_print),
	/* 0x89 */	(vl_alpha | vl_print),
	/* 0x8a */	(vl_print | vl_punct),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_print | vl_punct),
	/* 0x8d */	(vl_alpha | vl_print),
	/* 0x8e */	(vl_alpha | vl_print),
	/* 0x8f */	(vl_alpha | vl_print),
	/* 0x90 */	(vl_print | vl_punct),
	/* 0x91 */	(vl_alpha | vl_print),
	/* 0x92 */	(vl_alpha | vl_print),
	/* 0x93 */	(vl_alpha | vl_print),
	/* 0x94 */	0,
	/* 0x95 */	(vl_alpha | vl_print),
	/* 0x96 */	(vl_alpha | vl_print),
	/* 0x97 */	(vl_alpha | vl_print),
	/* 0x98 */	0,
	/* 0x99 */	0,
	/* 0x9a */	(vl_alpha | vl_print),
	/* 0x9b */	(vl_alpha | vl_print),
	/* 0x9c */	(vl_alpha | vl_print),
	/* 0x9d */	(vl_alpha | vl_print),
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	(vl_alpha | vl_print),
	/* 0xa1 */	(vl_alpha | vl_print),
	/* 0xa2 */	(vl_alpha | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print),
	/* 0xa4 */	(vl_alpha | vl_print),
	/* 0xa5 */	0,
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	0,
	/* 0xa9 */	(vl_alpha | vl_print),
	/* 0xaa */	0,
	/* 0xab */	(vl_alpha | vl_print),
	/* 0xac */	(vl_alpha | vl_print),
	/* 0xad */	(vl_alpha | vl_print),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_alpha | vl_print),
	/* 0xb1 */	(vl_alpha | vl_print),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_alpha | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_alpha | vl_print),
	/* 0xe0 */	0,
	/* 0xe1 */	(vl_print | vl_punct),
	/* 0xe2 */	0,
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	0,
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	0,
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	0,
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	0,
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  47:CP-HU */
static const GNREIGHT_ENC encode_CP_HU = {
    /* encode_CP_HU.chmap */
    {
	  0xc7,  0xfc,  0xe9,  0xe2,  0xe4,  0xe0,  0xe5,  0xe7,
	  0xea,  0xeb,  0xe8,  0xef,  0xee,  0xcd,  0xc4,  0xc1,
	  0xc9,  0xe6,  0xc6, 0x151,  0xf6,  0xd3, 0x171,  0xda,
	 0x170,  0xd6,  0xdc,  0xa2,  0xa3,  0xa5,0x20a7,0xe01f,
	  0xe1,  0xed,  0xf3,  0xfa,  0xf1,  0xd1,  0xaa, 0x150,
	  0xbf,0x2310,  0xac,  0xbd,  0xbc,  0xa1,  0xab,  0xbb,
	0x2591,0x2592,0x2593,0x2502,0x2524,0x2561,0x2562,0x2556,
	0x2555,0x2563,0x2551,0x2557,0x255d,0x255c,0x255b,0x2510,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x255e,0x255f,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2567,
	0x2568,0x2564,0x2565,0x2559,0x2558,0x2552,0x2553,0x256b,
	0x256a,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	 0x3b1, 0x3b2, 0x393, 0x3c0, 0x3a3, 0x3c3, 0x3bc, 0x3c4,
	 0x3a6, 0x398, 0x3a9, 0x3b4,0x221e,0x2205, 0x3b5,0x2229,
	0x2261,  0xb1,0x2265,0x2264,0x2320,0x2321,  0xf7,0x2248,
	0x2218,  0xb7,0x2022,0x221a,0x207f,  0xb2,0x25a0,  0xa0
    },
    /* encode_CP_HU.lower */
    {
	  0x87,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0xa1,  0x84,  0xa0,
	  0x82,  0x91,  0x91,  0x93,  0x94,  0xa2,  0x96,  0xa3,
	  0x96,  0x94,  0x81,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa4,  0xa6,  0x93,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe5,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP_HU.upper */
    {
	  0x80,  0x9a,  0x90,  0x83,  0x8e,  0x85,  0x86,  0x80,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x92,  0x92,  0xa7,  0x99,  0x95,  0x98,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0x8f,  0x8d,  0x95,  0x97,  0xa5,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe4,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP_HU.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_alpha | vl_lower | vl_print),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_alpha | vl_lower | vl_print),
	/* 0x85 */	(vl_alpha | vl_lower | vl_print),
	/* 0x86 */	(vl_alpha | vl_lower | vl_print),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_lower | vl_print),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_print | vl_upper),
	/* 0x98 */	(vl_alpha | vl_print | vl_upper),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_print | vl_punct),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_print | vl_punct),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_print | vl_punct),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  48:CSDECMCS */
static const GNREIGHT_ENC encode_CSDECMCS = {
    /* encode_CSDECMCS.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,     0,  0xa5,     0,  0xa7,
	  0xa4,  0xa9,  0xaa,  0xab,     0,     0,     0,     0,
	  0xb0,  0xb1,  0xb2,  0xb3,     0,  0xb5,  0xb6,  0xb7,
	     0,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,     0,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	     0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6, 0x152,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc, 0x178,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	     0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6, 0x153,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xff,     0,     0
    },
    /* encode_CSDECMCS.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,     0,  0xa5,     0,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,     0,     0,     0,     0,
	  0xb0,  0xb1,  0xb2,  0xb3,     0,  0xb5,  0xb6,  0xb7,
	     0,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,     0,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	     0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	     0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,     0,     0
    },
    /* encode_CSDECMCS.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,     0,  0xa5,     0,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,     0,     0,     0,     0,
	  0xb0,  0xb1,  0xb2,  0xb3,     0,  0xb5,  0xb6,  0xb7,
	     0,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,     0,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	     0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,     0,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	     0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,     0,     0
    },
    /* encode_CSDECMCS.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	0,
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	0,
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	0,
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	0,
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	0,
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	0,
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	0,
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	0,
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	0,
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*  49:CSHPROMAN8 */
static const GNREIGHT_ENC encode_CSHPROMAN8 = {
    /* encode_CSHPROMAN8.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xc0,  0xc2,  0xc8,  0xca,  0xcb,  0xce,  0xcf,
	  0xb4, 0x2cb, 0x2c6,  0xa8, 0x2dc,  0xd9,  0xdb,0x20a4,
	  0xaf,  0xdd,  0xfd,  0xb0,  0xc7,  0xe7,  0xd1,  0xf1,
	  0xa1,  0xbf,  0xa4,  0xa3,  0xa5,  0xa7, 0x192,  0xa2,
	  0xe2,  0xea,  0xf4,  0xfb,  0xe1,  0xe9,  0xf3,  0xfa,
	  0xe0,  0xe8,  0xf2,  0xf9,  0xe4,  0xeb,  0xf6,  0xfc,
	  0xc5,  0xee,  0xd8,  0xc6,  0xe5,  0xed,  0xf8,  0xe6,
	  0xc4,  0xec,  0xd6,  0xdc,  0xc9,  0xef,  0xdf,  0xd4,
	  0xc1,  0xc3,  0xe3,  0xd0,  0xf0,  0xcd,  0xcc,  0xd3,
	  0xd2,  0xd5,  0xf5, 0x160, 0x161,  0xda, 0x178,  0xff,
	  0xde,  0xfe,  0xb7,  0xb5,  0xb6,  0xbe,0x2014,  0xbc,
	  0xbd,  0xaa,  0xba,  0xab,0x25a0,  0xbb,  0xb1,     0
    },
    /* encode_CSHPROMAN8.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xc8,  0xc0,  0xc9,  0xc1,  0xcd,  0xd1,  0xdd,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xcb,  0xc3,  0xaf,
	  0xb0,  0xb2,  0xb2,  0xb3,  0xb5,  0xb5,  0xb7,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd4,  0xd1,  0xd6,  0xd7,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xcc,  0xd9,  0xce,  0xcf,  0xc5,  0xdd,  0xde,  0xc2,
	  0xc4,  0xe2,  0xe2,  0xe4,  0xe4,  0xd5,  0xd9,  0xc6,
	  0xca,  0xea,  0xea,  0xec,  0xec,  0xc7,  0xef,  0xef,
	  0xf1,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_CSHPROMAN8.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb1,  0xb3,  0xb4,  0xb4,  0xb6,  0xb6,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xa2,  0xa4,  0xdf,  0xae,  0xe0,  0xdc,  0xe7,  0xed,
	  0xa1,  0xa3,  0xe8,  0xad,  0xd8,  0xa5,  0xda,  0xdb,
	  0xd0,  0xa6,  0xd2,  0xd3,  0xd0,  0xe5,  0xd2,  0xd3,
	  0xd8,  0xe6,  0xda,  0xdb,  0xdc,  0xa7,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe1,  0xe3,  0xe3,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xe9,  0xeb,  0xeb,  0xed,  0xee,  0xee,
	  0xf0,  0xf0,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_CSHPROMAN8.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_alpha | vl_print),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_alpha | vl_print | vl_upper),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_lower | vl_print),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_print | vl_upper),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_alpha | vl_print),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_print | vl_punct),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	0,
    },
};

/*  50:CSISO103T618BIT */
static const GNREIGHT_ENC encode_CSISO103T618BIT = {
    /* encode_CSISO103T618BIT.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,  0x24,  0xa5,  0x23,  0xa7,
	  0xa4,     0,     0,  0xab,     0,     0,     0,     0,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xd7,  0xb5,  0xb6,  0xb7,
	  0xf7,     0,     0,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	0x2126,  0xc6,  0xd0,  0xaa, 0x126,     0, 0x132, 0x13f,
	 0x141,  0xd8, 0x152,  0xba,  0xde, 0x166, 0x14a, 0x149,
	 0x138,  0xe6, 0x111,  0xf0, 0x127, 0x131, 0x133, 0x140,
	 0x142,  0xf8, 0x153,  0xdf,  0xfe, 0x167, 0x14b,     0
    },
    /* encode_CSISO103T618BIT.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,     0,     0,  0xab,     0,     0,     0,     0,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,     0,     0,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	  0xe0,  0xf1,  0xf3,  0xe3,  0xf4,     0,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xeb,  0xfc,  0xfd,  0xfe,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_CSISO103T618BIT.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,     0,     0,  0xab,     0,     0,     0,     0,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,     0,     0,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,     0,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xe1,  0xf2,  0xe2,  0xe4,  0x49,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xfb,  0xec,  0xed,  0xee,     0
    },
    /* encode_CSISO103T618BIT.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	0,
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	0,
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	0,
    },
};

/*  51:CSISO111ECMACYRILLIC */
static const GNREIGHT_ENC encode_CSISO111ECMACYRILLIC = {
    /* encode_CSISO111ECMACYRILLIC.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x452, 0x453, 0x451, 0x454, 0x455, 0x456, 0x457,
	 0x458, 0x459, 0x45a, 0x45b, 0x45c,  0xad, 0x45e, 0x45f,
	0x2116, 0x402, 0x403, 0x401, 0x404, 0x405, 0x406, 0x407,
	 0x408, 0x409, 0x40a, 0x40b, 0x40c,  0xa4, 0x40e, 0x40f,
	 0x44e, 0x430, 0x431, 0x446, 0x434, 0x435, 0x444, 0x433,
	 0x445, 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e,
	 0x43f, 0x44f, 0x440, 0x441, 0x442, 0x443, 0x436, 0x432,
	 0x44c, 0x44b, 0x437, 0x448, 0x44d, 0x449, 0x447, 0x44a,
	 0x42e, 0x410, 0x411, 0x426, 0x414, 0x415, 0x424, 0x413,
	 0x425, 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e,
	 0x41f, 0x42f, 0x420, 0x421, 0x422, 0x423, 0x416, 0x412,
	 0x42c, 0x42b, 0x417, 0x428, 0x42d, 0x429, 0x427, 0x42a
    },
    /* encode_CSISO111ECMACYRILLIC.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xbd,  0xae,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_CSISO111ECMACYRILLIC.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xad,  0xbe,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CSISO111ECMACYRILLIC.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xaa */	(vl_alpha | vl_lower | vl_print),
	/* 0xab */	(vl_alpha | vl_lower | vl_print),
	/* 0xac */	(vl_alpha | vl_lower | vl_print),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_lower | vl_print),
	/* 0xaf */	(vl_alpha | vl_lower | vl_print),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_alpha | vl_print | vl_upper),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_print | vl_upper),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_lower | vl_print),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_print | vl_upper),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_print | vl_upper),
	/* 0xfe */	(vl_alpha | vl_print | vl_upper),
	/* 0xff */	(vl_alpha | vl_print | vl_upper),
    },
};

/*  52:CSISO143IECP271 */
static const GNREIGHT_ENC encode_CSISO143IECP271 = {
    /* encode_CSISO143IECP271.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	 0x2c7,0x2261,0x2227,0x2228,0x2229,0x222a,0x2282,0x2283,
	0x21d0,0x21d2,0x2234,0x2235,0x2208,0x220b,0x2286,0x2287,
	0x222b,0x222e,0x221e,0x2207,0x2202,0x223c,0x2248,0x2243,
	0x2245,0x2264,0x2260,0x2265,0x2194,  0xac,0x2200,0x2203,
	 0x5d0,0x25a1,0x2225, 0x393, 0x394,0x22a5,0x2220,0x221f,
	 0x398,0x2329,0x232a, 0x39b,0x2032,0x2033, 0x39e,0x2213,
	 0x3a0,  0xb2, 0x3a3,  0xd7,  0xb3, 0x3a5, 0x3a6,  0xb7,
	 0x3a8, 0x3a9,0x2205,0x21c0,0x221a, 0x192,0x221d,  0xb1,
	  0xb0, 0x3b1, 0x3b2, 0x3b3, 0x3b4, 0x3b5, 0x3b6, 0x3b7,
	 0x3b8, 0x3b9, 0x3ba, 0x3bb, 0x3bc, 0x3bd, 0x3be,0x2030,
	 0x3c0, 0x3c1, 0x3c3,  0xf7, 0x3c4, 0x3c5, 0x3c6, 0x3c7,
	 0x3c8, 0x3c9,0x2020,0x2190,0x2191,0x2192,0x2193,0x203e
    },
    /* encode_CSISO143IECP271.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xe3,  0xe4,  0xc5,  0xc6,  0xc7,
	  0xe8,  0xc9,  0xca,  0xeb,  0xcc,  0xcd,  0xee,  0xcf,
	  0xf0,  0xd1,  0xf2,  0xd3,  0xd4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CSISO143IECP271.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xc3,  0xc4,  0xe5,  0xe6,  0xe7,
	  0xc8,  0xe9,  0xea,  0xcb,  0xec,  0xed,  0xce,  0xef,
	  0xd0,  0xf1,  0xd2,  0xf3,  0xf4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CSISO143IECP271.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_alpha | vl_print),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_print | vl_punct),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_print | vl_punct),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  53:CSISO153GOST1976874 */
static const GNREIGHT_ENC encode_CSISO153GOST1976874 = {
    /* encode_CSISO153GOST1976874.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x401,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,  0xad,     0,     0,
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f,
	     0, 0x451,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_CSISO153GOST1976874.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xf1,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,  0xad,     0,     0,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	     0,  0xf1,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_CSISO153GOST1976874.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,  0xad,     0,     0,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	     0,  0xa1,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_CSISO153GOST1976874.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_alpha | vl_print | vl_upper),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_print | vl_upper),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	0,
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	0,
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*  54:CSMACINTOSH */
static const GNREIGHT_ENC encode_CSMACINTOSH = {
    /* encode_CSMACINTOSH.chmap */
    {
	  0xc4,  0xc5,  0xc7,  0xc9,  0xd1,  0xd6,  0xdc,  0xe1,
	  0xe0,  0xe2,  0xe4,  0xe3,  0xe5,  0xe7,  0xe9,  0xe8,
	  0xea,  0xeb,  0xed,  0xec,  0xee,  0xef,  0xf1,  0xf3,
	  0xf2,  0xf4,  0xf6,  0xf5,  0xfa,  0xf9,  0xfb,  0xfc,
	0x2020,  0xb0,  0xa2,  0xa3,  0xa7,0x2022,  0xb6,  0xdf,
	  0xae,  0xa9,0x2122,  0xb4,  0xa8,0x2260,  0xc6,  0xd8,
	0x221e,  0xb1,0x2264,0x2265,  0xa5,  0xb5,0x2202,0x2211,
	0x220f, 0x3c0,0x222b,  0xaa,  0xba, 0x3a9,  0xe6,  0xf8,
	  0xbf,  0xa1,  0xac,0x221a, 0x192,0x2248, 0x394,  0xab,
	  0xbb,0x2026,  0xa0,  0xc0,  0xc3,  0xd5, 0x152, 0x153,
	0x2013,0x2014,0x201c,0x201d,0x2018,0x2019,  0xf7,0x25ca,
	  0xff, 0x178,0x2044,0x20ac,0x2039,0x203a,0xfb01,0xfb02,
	0x2021,  0xb7,0x201a,0x201e,0x2030,  0xc2,  0xca,  0xc1,
	  0xcb,  0xc8,  0xcd,  0xce,  0xcf,  0xcc,  0xd3,  0xd4,
	0xe01e,  0xd2,  0xda,  0xdb,  0xd9, 0x131, 0x2c6, 0x2dc,
	  0xaf, 0x2d8, 0x2d9, 0x2da,  0xb8, 0x2dd, 0x2db, 0x2c7
    },
    /* encode_CSMACINTOSH.lower */
    {
	  0x8a,  0x8c,  0x8d,  0x8e,  0x96,  0x9a,  0x9f,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xbe,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0x88,  0x8b,  0x9b,  0xcf,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd8,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0x89,  0x90,  0x87,
	  0x91,  0x8f,  0x92,  0x94,  0x95,  0x93,  0x97,  0x99,
	  0xf0,  0x98,  0x9c,  0x9e,  0x9d,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CSMACINTOSH.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0xe7,
	  0xcb,  0xe5,  0x80,  0xcc,  0x81,  0x82,  0x83,  0xe9,
	  0xe6,  0xe8,  0xea,  0xed,  0xeb,  0xec,  0x84,  0xee,
	  0xf1,  0xef,  0x85,  0xcd,  0xf2,  0xf4,  0xf3,  0x86,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xae,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xce,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd9,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0x49,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CSMACINTOSH.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_print | vl_upper),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_alpha | vl_print | vl_upper),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_lower | vl_print),
	/* 0x8e */	(vl_alpha | vl_lower | vl_print),
	/* 0x8f */	(vl_alpha | vl_lower | vl_print),
	/* 0x90 */	(vl_alpha | vl_lower | vl_print),
	/* 0x91 */	(vl_alpha | vl_lower | vl_print),
	/* 0x92 */	(vl_alpha | vl_lower | vl_print),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_lower | vl_print),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_lower | vl_print),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_lower | vl_print),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_alpha | vl_print),
	/* 0xbc */	(vl_alpha | vl_print),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_alpha | vl_print),
	/* 0xdf */	(vl_alpha | vl_print),
	/* 0xe0 */	(vl_print | vl_punct),
	/* 0xe1 */	(vl_print | vl_punct),
	/* 0xe2 */	(vl_print | vl_punct),
	/* 0xe3 */	(vl_print | vl_punct),
	/* 0xe4 */	(vl_print | vl_punct),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_print | vl_punct),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_alpha | vl_print),
    },
};

/*  55:GEORGIAN-ACADEMY */
static const GNREIGHT_ENC encode_GEORGIAN_ACADEMY = {
    /* encode_GEORGIAN_ACADEMY.chmap */
    {
	  0x80,  0x81,0x201a, 0x192,0x201e,0x2026,0x2020,0x2021,
	 0x2c6,0x2030, 0x160,0x2039, 0x152,  0x8d,  0x8e,  0x8f,
	  0x90,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	 0x2dc,0x2122, 0x161,0x203a, 0x153,  0x9d,  0x9e, 0x178,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	0x10d0,0x10d1,0x10d2,0x10d3,0x10d4,0x10d5,0x10d6,0x10d7,
	0x10d8,0x10d9,0x10da,0x10db,0x10dc,0x10dd,0x10de,0x10df,
	0x10e0,0x10e1,0x10e2,0x10e3,0x10e4,0x10e5,0x10e6,0x10e7,
	0x10e8,0x10e9,0x10ea,0x10eb,0x10ec,0x10ed,0x10ee,0x10ef,
	0x10f0,0x10f1,0x10f2,0x10f3,0x10f4,0x10f5,0x10f6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_GEORGIAN_ACADEMY.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x9a,  0x8b,  0x9c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0xff,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_GEORGIAN_ACADEMY.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x8a,  0x9b,  0x8c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0x9f
    },
    /* encode_GEORGIAN_ACADEMY.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_alpha | vl_print),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_alpha | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	(vl_alpha | vl_print),
	/* 0xdc */	(vl_alpha | vl_print),
	/* 0xdd */	(vl_alpha | vl_print),
	/* 0xde */	(vl_alpha | vl_print),
	/* 0xdf */	(vl_alpha | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  56:GEORGIAN-PS */
static const GNREIGHT_ENC encode_GEORGIAN_PS = {
    /* encode_GEORGIAN_PS.chmap */
    {
	  0x80,  0x81,0x201a, 0x192,0x201e,0x2026,0x2020,0x2021,
	 0x2c6,0x2030, 0x160,0x2039, 0x152,  0x8d,  0x8e,  0x8f,
	  0x90,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	 0x2dc,0x2122, 0x161,0x203a, 0x153,  0x9d,  0x9e, 0x178,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	0x10d0,0x10d1,0x10d2,0x10d3,0x10d4,0x10d5,0x10d6,0x10f1,
	0x10d7,0x10d8,0x10d9,0x10da,0x10db,0x10dc,0x10f2,0x10dd,
	0x10de,0x10df,0x10e0,0x10e1,0x10e2,0x10f3,0x10e3,0x10e4,
	0x10e5,0x10e6,0x10e7,0x10e8,0x10e9,0x10ea,0x10eb,0x10ec,
	0x10ed,0x10ee,0x10f4,0x10ef,0x10f0,0x10f5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_GEORGIAN_PS.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x9a,  0x8b,  0x9c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0xff,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_GEORGIAN_PS.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x8a,  0x9b,  0x8c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0x9f
    },
    /* encode_GEORGIAN_PS.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_alpha | vl_print),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_alpha | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	(vl_alpha | vl_print),
	/* 0xdc */	(vl_alpha | vl_print),
	/* 0xdd */	(vl_alpha | vl_print),
	/* 0xde */	(vl_alpha | vl_print),
	/* 0xdf */	(vl_alpha | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  57:HP-GREEK8 */
static const GNREIGHT_ENC encode_HP_GREEK8 = {
    /* encode_HP_GREEK8.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0, 0x3ca,     0, 0x3cb,     0,
	     0, 0x391, 0x392, 0x393, 0x394, 0x395, 0x396, 0x397,
	 0x398, 0x399,     0, 0x39a, 0x39b, 0x39c, 0x39d, 0x39e,
	 0x39f, 0x3a0, 0x3a1, 0x3a3, 0x3a4, 0x3a5, 0x3a6,     0,
	 0x3a7, 0x3a8, 0x3a9, 0x3ac, 0x3ae, 0x3cc,     0,     0,
	 0x3cd, 0x3b1, 0x3b2, 0x3b3, 0x3b4, 0x3b5, 0x3b6, 0x3b7,
	 0x3b8, 0x3b9,     0, 0x3ba, 0x3bb, 0x3bc, 0x3bd, 0x3be,
	 0x3bf, 0x3c0, 0x3c1, 0x3c3, 0x3c4, 0x3c5, 0x3c6, 0x3c2,
	 0x3c7, 0x3c8, 0x3c9, 0x3ad, 0x3af, 0x3ce, 0x3f3,     0
    },
    /* encode_HP_GREEK8.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,  0xbc,     0,  0xbe,     0,
	     0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,     0,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,     0,
	  0xf8,  0xf9,  0xfa,  0xdb,  0xdc,  0xdd,     0,     0,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,     0,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_HP_GREEK8.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,  0xbc,     0,  0xbe,     0,
	     0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,     0,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,     0,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,     0,     0,
	  0xe0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,     0,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd3,
	  0xd8,  0xd9,  0xda,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_HP_GREEK8.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	0,
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	0,
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	0,
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	0,
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	0,
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_print),
	/* 0xff */	0,
    },
};

/*  58:HP-ROMAN9 */
static const GNREIGHT_ENC encode_HP_ROMAN9 = {
    /* encode_HP_ROMAN9.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xc0,  0xc2,  0xc8,  0xca,  0xcb,  0xce,  0xcf,
	  0xb4, 0x2cb, 0x2c6,  0xa8, 0x2dc,  0xd9,  0xdb,0x20a4,
	  0xaf,  0xdd,  0xfd,  0xb0,  0xc7,  0xe7,  0xd1,  0xf1,
	  0xa1,  0xbf,0x20a0,  0xa3,  0xa5,  0xa7, 0x192,  0xa2,
	  0xe2,  0xea,  0xf4,  0xfb,  0xe1,  0xe9,  0xf3,  0xfa,
	  0xe0,  0xe8,  0xf2,  0xf9,  0xe4,  0xeb,  0xf6,  0xfc,
	  0xc5,  0xee,  0xd8,  0xc6,  0xe5,  0xed,  0xf8,  0xe6,
	  0xc4,  0xec,  0xd6,  0xdc,  0xc9,  0xef,  0xdf,  0xd4,
	  0xc1,  0xc3,  0xe3,  0xd0,  0xf0,  0xcd,  0xcc,  0xd3,
	  0xd2,  0xd5,  0xf5, 0x160, 0x161,  0xda, 0x178,  0xff,
	  0xde,  0xfe,  0xb7,  0xb5,  0xb6,  0xbe,0x2014,  0xbc,
	  0xbd,  0xaa,  0xba,  0xab,0x25a0,  0xbb,  0xb1,     0
    },
    /* encode_HP_ROMAN9.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xc8,  0xc0,  0xc9,  0xc1,  0xcd,  0xd1,  0xdd,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xcb,  0xc3,  0xaf,
	  0xb0,  0xb2,  0xb2,  0xb3,  0xb5,  0xb5,  0xb7,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd4,  0xd1,  0xd6,  0xd7,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xcc,  0xd9,  0xce,  0xcf,  0xc5,  0xdd,  0xde,  0xc2,
	  0xc4,  0xe2,  0xe2,  0xe4,  0xe4,  0xd5,  0xd9,  0xc6,
	  0xca,  0xea,  0xea,  0xec,  0xec,  0xc7,  0xef,  0xef,
	  0xf1,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_HP_ROMAN9.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb1,  0xb3,  0xb4,  0xb4,  0xb6,  0xb6,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xa2,  0xa4,  0xdf,  0xae,  0xe0,  0xdc,  0xe7,  0xed,
	  0xa1,  0xa3,  0xe8,  0xad,  0xd8,  0xa5,  0xda,  0xdb,
	  0xd0,  0xa6,  0xd2,  0xd3,  0xd0,  0xe5,  0xd2,  0xd3,
	  0xd8,  0xe6,  0xda,  0xdb,  0xdc,  0xa7,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe1,  0xe3,  0xe3,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xe9,  0xeb,  0xeb,  0xed,  0xee,  0xee,
	  0xf0,  0xf0,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_HP_ROMAN9.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_alpha | vl_print),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_alpha | vl_print | vl_upper),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_lower | vl_print),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_print | vl_upper),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_alpha | vl_print),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_print | vl_punct),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	0,
    },
};

/*  59:HP-THAI8 */
static const GNREIGHT_ENC encode_HP_THAI8 = {
    /* encode_HP_THAI8.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0xe01, 0xe02, 0xe03, 0xe04, 0xe05, 0xe06, 0xe07,
	 0xe08, 0xe09, 0xe0a, 0xe0b, 0xe0c, 0xe0d, 0xe0e, 0xe0f,
	 0xe10, 0xe11, 0xe12, 0xe13, 0xe14, 0xe15, 0xe16, 0xe17,
	 0xe18, 0xe19, 0xe1a, 0xe1b, 0xe1c, 0xe1d, 0xe1e, 0xe1f,
	 0xe20, 0xe21, 0xe22, 0xe23, 0xe24, 0xe25, 0xe26, 0xe27,
	 0xe28, 0xe29, 0xe2a, 0xe2b, 0xe2c, 0xe2d, 0xe2e, 0xe2f,
	 0xe30, 0xe31, 0xe32, 0xe33, 0xe34, 0xe35, 0xe36, 0xe37,
	 0xe38, 0xe39, 0xe3a,     0,     0,     0,     0, 0xe3f,
	 0xe40, 0xe41, 0xe42, 0xe43, 0xe44, 0xe45, 0xe46, 0xe47,
	 0xe48, 0xe49, 0xe4a, 0xe4b, 0xe4c, 0xe4d, 0xe4e, 0xe4f,
	 0xe50, 0xe51, 0xe52, 0xe53, 0xe54, 0xe55, 0xe56, 0xe57,
	 0xe58, 0xe59, 0xe5a, 0xe5b,     0,     0,     0,     0
    },
    /* encode_HP_THAI8.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,     0,     0,     0,     0
    },
    /* encode_HP_THAI8.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,     0,     0,     0,     0
    },
    /* encode_HP_THAI8.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print),
	/* 0xa2 */	(vl_alpha | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print),
	/* 0xa4 */	(vl_alpha | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_alpha | vl_print),
	/* 0xa9 */	(vl_alpha | vl_print),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_alpha | vl_print),
	/* 0xac */	(vl_alpha | vl_print),
	/* 0xad */	(vl_alpha | vl_print),
	/* 0xae */	(vl_alpha | vl_print),
	/* 0xaf */	(vl_alpha | vl_print),
	/* 0xb0 */	(vl_alpha | vl_print),
	/* 0xb1 */	(vl_alpha | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print),
	/* 0xb3 */	(vl_alpha | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print),
	/* 0xb5 */	(vl_alpha | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_alpha | vl_print),
	/* 0xbc */	(vl_alpha | vl_print),
	/* 0xbd */	(vl_alpha | vl_print),
	/* 0xbe */	(vl_alpha | vl_print),
	/* 0xbf */	(vl_alpha | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_print | vl_punct),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	(vl_alpha | vl_print),
	/* 0xee */	(vl_alpha | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_alpha | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*  60:HP-TURKISH8 */
static const GNREIGHT_ENC encode_HP_TURKISH8 = {
    /* encode_HP_TURKISH8.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xc7, 0x11e,  0xc8,  0xca,  0xcb,  0xce,  0xcf,
	  0xb4, 0x2cb, 0x2c6,  0xa8, 0x2dc,  0xd9,  0xdb,0x20a4,
	     0,  0xdd,  0xfd,  0xb0,     0,     0,  0xd1,  0xf1,
	  0xa1,  0xbf,  0xa4,  0xa3,  0xa5,  0xa7, 0x192,  0xa2,
	     0,  0xea,  0xf4,     0,  0xe1,  0xe9,  0xf3,  0xfa,
	  0xe0,  0xe8,  0xf2,  0xf9,  0xe4,  0xeb,     0,     0,
	  0xc5,  0xee,  0xd8,  0xc6,  0xe5,  0xed,  0xf8,  0xe6,
	  0xc4,  0xec,     0, 0x130,  0xd6, 0x15e,  0xdc,  0xe7,
	 0x11f,  0xc3,  0xe3,  0xd0,  0xf0,  0xcd,  0xcc,  0xd3,
	  0xd2,  0xd5,  0xf5, 0x160, 0x161,  0xda, 0x178,  0xff,
	  0xde,  0xfe,  0xb7,  0xb5,  0xb6,  0xbe,0x2014,  0xbc,
	  0xbd,  0xaa,  0xba, 0x131,  0xf6, 0x15f,  0xfc,     0
    },
    /* encode_HP_TURKISH8.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xdf,  0xe0,  0xc9,  0xc1,  0xcd,  0xd1,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xcb,  0xae,  0xaf,
	     0,  0xb2,  0xb2,  0xb3,     0,     0,  0xb7,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	     0,  0xc1,  0xc2,     0,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,     0,     0,
	  0xd4,  0xd1,  0xd6,  0xd7,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xcc,  0xd9,     0,  0x69,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe2,  0xe2,  0xe4,  0xe4,  0xd5,  0xd9,  0xc6,
	  0xca,  0xea,  0xea,  0xec,  0xec,  0xc7,  0xef,  0xef,
	  0xf1,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_HP_TURKISH8.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	     0,  0xb1,  0xb1,  0xb3,     0,     0,  0xb6,  0xb6,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	     0,  0xa4,  0xc2,     0,  0xc4,  0xc5,  0xe7,  0xed,
	  0xc8,  0xa3,  0xe8,  0xad,  0xd8,  0xa5,     0,     0,
	  0xd0,  0xa6,  0xd2,  0xd3,  0xd0,  0xe5,  0xd2,  0xd3,
	  0xd8,  0xe6,     0,  0xdb,  0xdc,  0xdd,  0xde,  0xa1,
	  0xa2,  0xe1,  0xe1,  0xe3,  0xe3,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xe9,  0xeb,  0xeb,  0xed,  0xee,  0xee,
	  0xf0,  0xf0,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0x49,  0xdc,  0xdd,  0xde,     0
    },
    /* encode_HP_TURKISH8.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_alpha | vl_print),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_alpha | vl_print | vl_upper),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	0,
	/* 0xb1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	0,
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc3 */	0,
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_lower | vl_print),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	0,
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_alpha | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	0,
    },
};

/*  61:ISIRI-3342 */
static const GNREIGHT_ENC encode_ISIRI_3342 = {
    /* encode_ISIRI_3342.chmap */
    {
	     0,   0x1,   0x2,   0x3,   0x4,   0x5,   0x6,   0x7,
	   0x8,   0x9,   0xa,   0xb,   0xc,   0xd,   0xe,   0xf,
	  0x10,  0x11,  0x12,  0x13,  0x14,  0x15,  0x16,  0x17,
	  0x18,  0x19,  0x1a,  0x1b,  0x1c,  0x1d,  0x1e,  0x1f,
	  0x20,0x200c,0x200d,  0x21,  0xa4, 0x66a,  0x2e, 0x66c,
	  0x29,  0x28,  0xd7,  0x2b, 0x60c,  0x2d, 0x66b,  0x2f,
	 0x6f0, 0x6f1, 0x6f2, 0x6f3, 0x6f4, 0x6f5, 0x6f6, 0x6f7,
	 0x6f8, 0x6f9,  0x3a, 0x61b,  0x3c,  0x3d,  0x3e, 0x61f,
	 0x622, 0x627, 0x621, 0x628, 0x67e, 0x62a, 0x62b, 0x62c,
	 0x686, 0x62d, 0x62e, 0x62f, 0x630, 0x631, 0x632, 0x698,
	 0x633, 0x634, 0x635, 0x636, 0x637, 0x638, 0x639, 0x63a,
	 0x641, 0x642, 0x6a9, 0x6af, 0x644, 0x645, 0x646, 0x648,
	 0x647, 0x6cc,  0x5d,  0x5b,  0x7d,  0x7b,  0xab,  0xbb,
	  0x2a, 0x640,  0x7c,  0x5c,     0,     0,     0,     0,
	 0x64e, 0x650, 0x64f, 0x64b, 0x64d, 0x64c, 0x651, 0x652,
	 0x623, 0x624, 0x625, 0x626, 0x629, 0x643, 0x64a,  0x7f
    },
    /* encode_ISIRI_3342.lower */
    {
	     0,   0x1,   0x2,   0x3,   0x4,   0x5,   0x6,   0x7,
	   0x8,   0x9,   0xa,   0xb,   0xc,   0xd,   0xe,   0xf,
	  0x10,  0x11,  0x12,  0x13,  0x14,  0x15,  0x16,  0x17,
	  0x18,  0x19,  0x1a,  0x1b,  0x1c,  0x1d,  0x1e,  0x1f,
	  0x20,  0xa1,  0xa2,  0x21,  0xa4,  0xa5,  0x2e,  0xa7,
	  0x29,  0x28,  0xaa,  0x2b,  0xac,  0x2d,  0xae,  0x2f,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0x3a,  0xbb,  0x3c,  0x3d,  0x3e,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0x5d,  0x5b,  0x7d,  0x7b,  0xe6,  0xe7,
	  0x2a,  0xe9,  0x7c,  0x5c,     0,     0,     0,     0,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0x7f
    },
    /* encode_ISIRI_3342.upper */
    {
	     0,   0x1,   0x2,   0x3,   0x4,   0x5,   0x6,   0x7,
	   0x8,   0x9,   0xa,   0xb,   0xc,   0xd,   0xe,   0xf,
	  0x10,  0x11,  0x12,  0x13,  0x14,  0x15,  0x16,  0x17,
	  0x18,  0x19,  0x1a,  0x1b,  0x1c,  0x1d,  0x1e,  0x1f,
	  0x20,  0xa1,  0xa2,  0x21,  0xa4,  0xa5,  0x2e,  0xa7,
	  0x29,  0x28,  0xaa,  0x2b,  0xac,  0x2d,  0xae,  0x2f,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0x3a,  0xbb,  0x3c,  0x3d,  0x3e,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0x5d,  0x5b,  0x7d,  0x7b,  0xe6,  0xe7,
	  0x2a,  0xe9,  0x7c,  0x5c,     0,     0,     0,     0,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0x7f
    },
    /* encode_ISIRI_3342.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl | vl_space),
	/* 0x8a */	(vl_cntrl | vl_space),
	/* 0x8b */	(vl_cntrl | vl_space),
	/* 0x8c */	(vl_cntrl | vl_space),
	/* 0x8d */	(vl_cntrl | vl_space),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_space),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_alpha | vl_print),
	/* 0xb1 */	(vl_alpha | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print),
	/* 0xb3 */	(vl_alpha | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print),
	/* 0xb5 */	(vl_alpha | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_alpha | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	(vl_alpha | vl_print),
	/* 0xdc */	(vl_alpha | vl_print),
	/* 0xdd */	(vl_alpha | vl_print),
	/* 0xde */	(vl_alpha | vl_print),
	/* 0xdf */	(vl_alpha | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_print | vl_punct),
	/* 0xe3 */	(vl_print | vl_punct),
	/* 0xe4 */	(vl_print | vl_punct),
	/* 0xe5 */	(vl_print | vl_punct),
	/* 0xe6 */	(vl_print | vl_punct),
	/* 0xe7 */	(vl_print | vl_punct),
	/* 0xe8 */	(vl_print | vl_punct),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_print | vl_punct),
	/* 0xeb */	(vl_print | vl_punct),
	/* 0xec */	0,
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_alpha | vl_print),
	/* 0xfb */	(vl_alpha | vl_print),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_alpha | vl_print),
	/* 0xfe */	(vl_alpha | vl_print),
	/* 0xff */	(vl_cntrl),
    },
};

/*  62:ISO-8859-1 */
static const GNREIGHT_ENC encode_ISO_8859_1 = {
    /* encode_ISO_8859_1.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_1.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_1.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_ISO_8859_1.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  63:ISO-8859-10 */
static const GNREIGHT_ENC encode_ISO_8859_10 = {
    /* encode_ISO_8859_10.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x104, 0x112, 0x122, 0x12a, 0x128, 0x136,  0xa7,
	 0x13b, 0x110, 0x160, 0x166, 0x17d,  0xad, 0x16a, 0x14a,
	  0xb0, 0x105, 0x113, 0x123, 0x12b, 0x129, 0x137,  0xb7,
	 0x13c, 0x111, 0x161, 0x167, 0x17e,0x2015, 0x16b, 0x14b,
	 0x100,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6, 0x12e,
	 0x10c,  0xc9, 0x118,  0xcb, 0x116,  0xcd,  0xce,  0xcf,
	  0xd0, 0x145, 0x14c,  0xd3,  0xd4,  0xd5,  0xd6, 0x168,
	  0xd8, 0x172,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	 0x101,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6, 0x12f,
	 0x10d,  0xe9, 0x119,  0xeb, 0x117,  0xed,  0xee,  0xef,
	  0xf0, 0x146, 0x14d,  0xf3,  0xf4,  0xf5,  0xf6, 0x169,
	  0xf8, 0x173,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe, 0x138
    },
    /* encode_ISO_8859_10.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xa7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xad,  0xbe,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_10.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xb7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xbd,  0xae,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_ISO_8859_10.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_print),
    },
};

/*  64:ISO-8859-13 */
static const GNREIGHT_ENC encode_ISO_8859_13 = {
    /* encode_ISO_8859_13.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,0x201d,  0xa2,  0xa3,  0xa4,0x201e,  0xa6,  0xa7,
	  0xd8,  0xa9, 0x156,  0xab,  0xac,  0xad,  0xae,  0xc6,
	  0xb0,  0xb1,  0xb2,  0xb3,0x201c,  0xb5,  0xb6,  0xb7,
	  0xf8,  0xb9, 0x157,  0xbb,  0xbc,  0xbd,  0xbe,  0xe6,
	 0x104, 0x12e, 0x100, 0x106,  0xc4,  0xc5, 0x118, 0x112,
	 0x10c,  0xc9, 0x179, 0x116, 0x122, 0x136, 0x12a, 0x13b,
	 0x160, 0x143, 0x145,  0xd3, 0x14c,  0xd5,  0xd6,  0xd7,
	 0x172, 0x141, 0x15a, 0x16a,  0xdc, 0x17b, 0x17d,  0xdf,
	 0x105, 0x12f, 0x101, 0x107,  0xe4,  0xe5, 0x119, 0x113,
	 0x10d,  0xe9, 0x17a, 0x117, 0x123, 0x137, 0x12b, 0x13c,
	 0x161, 0x144, 0x146,  0xf3, 0x14d,  0xf5,  0xf6,  0xf7,
	 0x173, 0x142, 0x15b, 0x16b,  0xfc, 0x17c, 0x17e,0x2019
    },
    /* encode_ISO_8859_13.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xac,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_13.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xa8,  0xb9,  0xaa,  0xbb,  0xbc,  0xbd,  0xbe,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_ISO_8859_13.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  65:ISO-8859-14 */
static const GNREIGHT_ENC encode_ISO_8859_14 = {
    /* encode_ISO_8859_14.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,0x1e02,0x1e03,  0xa3, 0x10a, 0x10b,0x1e0a,  0xa7,
	0x1e80,  0xa9,0x1e82,0x1e0b,0x1ef2,  0xad,  0xae, 0x178,
	0x1e1e,0x1e1f, 0x120, 0x121,0x1e40,0x1e41,  0xb6,0x1e56,
	0x1e81,0x1e57,0x1e83,0x1e60,0x1ef3,0x1e84,0x1e85,0x1e61,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	 0x174,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,0x1e6a,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd, 0x176,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	 0x175,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,0x1e6b,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd, 0x177,  0xff
    },
    /* encode_ISO_8859_14.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa2,  0xa2,  0xa3,  0xa5,  0xa5,  0xab,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xbc,  0xad,  0xae,  0xff,
	  0xb1,  0xb1,  0xb3,  0xb3,  0xb5,  0xb5,  0xb6,  0xb9,
	  0xb8,  0xb9,  0xba,  0xbf,  0xbc,  0xbe,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_14.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa1,  0xa3,  0xa4,  0xa4,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xa6,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb0,  0xb2,  0xb2,  0xb4,  0xb4,  0xb6,  0xb7,
	  0xa8,  0xb7,  0xaa,  0xbb,  0xac,  0xbd,  0xbd,  0xbb,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xaf
    },
    /* encode_ISO_8859_14.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_alpha | vl_lower | vl_print),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_print | vl_upper),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  66:ISO-8859-15 */
static const GNREIGHT_ENC encode_ISO_8859_15 = {
    /* encode_ISO_8859_15.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,0x20ac,  0xa5, 0x160,  0xa7,
	 0x161,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3, 0x17d,  0xb5,  0xb6,  0xb7,
	 0x17e,  0xb9,  0xba,  0xbb, 0x152, 0x153, 0x178,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_15.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa8,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb8,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbd,  0xbd,  0xff,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_15.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa6,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb4,  0xb9,  0xba,  0xbb,  0xbc,  0xbc,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xbe
    },
    /* encode_ISO_8859_15.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_lower | vl_print),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  67:ISO-8859-16 */
static const GNREIGHT_ENC encode_ISO_8859_16 = {
    /* encode_ISO_8859_16.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x104, 0x105, 0x141,0x20ac,0x201e, 0x160,  0xa7,
	 0x161,  0xa9, 0x218,  0xab, 0x179,  0xad, 0x17a, 0x17b,
	  0xb0,  0xb1, 0x10c, 0x142, 0x17d,0x201d,  0xb6,  0xb7,
	 0x17e, 0x10d, 0x219,  0xbb, 0x152, 0x153, 0x178, 0x17c,
	  0xc0,  0xc1,  0xc2, 0x102,  0xc4, 0x106,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	 0x110, 0x143,  0xd2,  0xd3,  0xd4, 0x150,  0xd6, 0x15a,
	 0x170,  0xd9,  0xda,  0xdb,  0xdc, 0x118, 0x21a,  0xdf,
	  0xe0,  0xe1,  0xe2, 0x103,  0xe4, 0x107,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	 0x111, 0x144,  0xf2,  0xf3,  0xf4, 0x151,  0xf6, 0x15b,
	 0x171,  0xf9,  0xfa,  0xfb,  0xfc, 0x119, 0x21b,  0xff
    },
    /* encode_ISO_8859_16.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa2,  0xa2,  0xb3,  0xa4,  0xa5,  0xa8,  0xa7,
	  0xa8,  0xa9,  0xba,  0xab,  0xae,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb9,  0xb3,  0xb8,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbd,  0xbd,  0xff,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_16.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa1,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa6,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xac,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xa3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb4,  0xb2,  0xaa,  0xbb,  0xbc,  0xbc,  0xbe,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xbe
    },
    /* encode_ISO_8859_16.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_lower | vl_print),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_lower | vl_print),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  68:ISO-8859-2 */
static const GNREIGHT_ENC encode_ISO_8859_2 = {
    /* encode_ISO_8859_2.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x104, 0x2d8, 0x141,  0xa4, 0x13d, 0x15a,  0xa7,
	  0xa8, 0x160, 0x15e, 0x164, 0x179,  0xad, 0x17d, 0x17b,
	  0xb0, 0x105, 0x2db, 0x142,  0xb4, 0x13e, 0x15b, 0x2c7,
	  0xb8, 0x161, 0x15f, 0x165, 0x17a, 0x2dd, 0x17e, 0x17c,
	 0x154,  0xc1,  0xc2, 0x102,  0xc4, 0x139, 0x106,  0xc7,
	 0x10c,  0xc9, 0x118,  0xcb, 0x11a,  0xcd,  0xce, 0x10e,
	 0x110, 0x143, 0x147,  0xd3,  0xd4, 0x150,  0xd6,  0xd7,
	 0x158, 0x16e,  0xda, 0x170,  0xdc,  0xdd, 0x162,  0xdf,
	 0x155,  0xe1,  0xe2, 0x103,  0xe4, 0x13a, 0x107,  0xe7,
	 0x10d,  0xe9, 0x119,  0xeb, 0x11b,  0xed,  0xee, 0x10f,
	 0x111, 0x144, 0x148,  0xf3,  0xf4, 0x151,  0xf6,  0xf7,
	 0x159, 0x16f,  0xfa, 0x171,  0xfc,  0xfd, 0x163, 0x2d9
    },
    /* encode_ISO_8859_2.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xb1,  0xa2,  0xb3,  0xa4,  0xb5,  0xb6,  0xa7,
	  0xa8,  0xb9,  0xba,  0xbb,  0xbc,  0xad,  0xbe,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_2.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xa1,  0xb2,  0xa3,  0xb4,  0xa5,  0xa6,  0xb7,
	  0xb8,  0xa9,  0xaa,  0xab,  0xac,  0xbd,  0xae,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_ISO_8859_2.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  69:ISO-8859-3 */
static const GNREIGHT_ENC encode_ISO_8859_3 = {
    /* encode_ISO_8859_3.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x126, 0x2d8,  0xa3,  0xa4,     0, 0x124,  0xa7,
	  0xa8, 0x130, 0x15e, 0x11e, 0x134,  0xad,     0, 0x17b,
	  0xb0, 0x127,  0xb2,  0xb3,  0xb4,  0xb5, 0x125,  0xb7,
	  0xb8, 0x131, 0x15f, 0x11f, 0x135,  0xbd,     0, 0x17c,
	  0xc0,  0xc1,  0xc2,     0,  0xc4, 0x10a, 0x108,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	     0,  0xd1,  0xd2,  0xd3,  0xd4, 0x120,  0xd6,  0xd7,
	 0x11c,  0xd9,  0xda,  0xdb,  0xdc, 0x16c, 0x15c,  0xdf,
	  0xe0,  0xe1,  0xe2,     0,  0xe4, 0x10b, 0x109,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	     0,  0xf1,  0xf2,  0xf3,  0xf4, 0x121,  0xf6,  0xf7,
	 0x11d,  0xf9,  0xfa,  0xfb,  0xfc, 0x16d, 0x15d, 0x2d9
    },
    /* encode_ISO_8859_3.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xb1,  0xa2,  0xa3,  0xa4,     0,  0xb6,  0xa7,
	  0xa8,  0x69,  0xba,  0xbb,  0xbc,  0xad,     0,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,     0,  0xbf,
	  0xe0,  0xe1,  0xe2,     0,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	     0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,     0,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	     0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_3.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,     0,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,     0,  0xaf,
	  0xb0,  0xa1,  0xb2,  0xb3,  0xb4,  0xb5,  0xa6,  0xb7,
	  0xb8,  0x49,  0xaa,  0xab,  0xac,  0xbd,     0,  0xaf,
	  0xc0,  0xc1,  0xc2,     0,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	     0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,     0,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	     0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_ISO_8859_3.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	0,
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	0,
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	0,
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	0,
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	0,
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	0,
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	0,
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  70:ISO-8859-5 */
static const GNREIGHT_ENC encode_ISO_8859_5 = {
    /* encode_ISO_8859_5.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x401, 0x402, 0x403, 0x404, 0x405, 0x406, 0x407,
	 0x408, 0x409, 0x40a, 0x40b, 0x40c,  0xad, 0x40e, 0x40f,
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f,
	0x2116, 0x451, 0x452, 0x453, 0x454, 0x455, 0x456, 0x457,
	 0x458, 0x459, 0x45a, 0x45b, 0x45c,  0xa7, 0x45e, 0x45f
    },
    /* encode_ISO_8859_5.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xad,  0xfe,  0xff,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_5.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xf0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xfd,  0xae,  0xaf
    },
    /* encode_ISO_8859_5.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_alpha | vl_print | vl_upper),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_print | vl_upper),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  71:ISO-8859-6 */
static const GNREIGHT_ENC encode_ISO_8859_6 = {
    /* encode_ISO_8859_6.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,     0,     0,  0xa4,     0,     0,     0,
	     0,     0,     0,     0, 0x60c,  0xad,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0, 0x61b,     0,     0,     0, 0x61f,
	     0, 0x621, 0x622, 0x623, 0x624, 0x625, 0x626, 0x627,
	 0x628, 0x629, 0x62a, 0x62b, 0x62c, 0x62d, 0x62e, 0x62f,
	 0x630, 0x631, 0x632, 0x633, 0x634, 0x635, 0x636, 0x637,
	 0x638, 0x639, 0x63a,     0,     0,     0,     0,     0,
	 0x640, 0x641, 0x642, 0x643, 0x644, 0x645, 0x646, 0x647,
	 0x648, 0x649, 0x64a, 0x64b, 0x64c, 0x64d, 0x64e, 0x64f,
	 0x650, 0x651, 0x652,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_ISO_8859_6.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,     0,     0,  0xa4,     0,     0,     0,
	     0,     0,     0,     0,  0xac,  0xad,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,  0xbb,     0,     0,     0,  0xbf,
	     0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,     0,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_ISO_8859_6.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,     0,     0,  0xa4,     0,     0,     0,
	     0,     0,     0,     0,  0xac,  0xad,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,  0xbb,     0,     0,     0,  0xbf,
	     0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,     0,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_ISO_8859_6.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	0,
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_alpha | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_print | vl_punct),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_print | vl_punct),
	/* 0xee */	(vl_print | vl_punct),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*  72:ISO-8859-7 */
static const GNREIGHT_ENC encode_ISO_8859_7 = {
    /* encode_ISO_8859_7.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,0x2018,0x2019,  0xa3,0x20ac,0x20af,  0xa6,  0xa7,
	  0xa8,  0xa9, 0x37a,  0xab,  0xac,  0xad,     0,0x2015,
	  0xb0,  0xb1,  0xb2,  0xb3, 0x384, 0x385, 0x386,  0xb7,
	 0x388, 0x389, 0x38a,  0xbb, 0x38c,  0xbd, 0x38e, 0x38f,
	 0x390, 0x391, 0x392, 0x393, 0x394, 0x395, 0x396, 0x397,
	 0x398, 0x399, 0x39a, 0x39b, 0x39c, 0x39d, 0x39e, 0x39f,
	 0x3a0, 0x3a1,     0, 0x3a3, 0x3a4, 0x3a5, 0x3a6, 0x3a7,
	 0x3a8, 0x3a9, 0x3aa, 0x3ab, 0x3ac, 0x3ad, 0x3ae, 0x3af,
	 0x3b0, 0x3b1, 0x3b2, 0x3b3, 0x3b4, 0x3b5, 0x3b6, 0x3b7,
	 0x3b8, 0x3b9, 0x3ba, 0x3bb, 0x3bc, 0x3bd, 0x3be, 0x3bf,
	 0x3c0, 0x3c1, 0x3c2, 0x3c3, 0x3c4, 0x3c5, 0x3c6, 0x3c7,
	 0x3c8, 0x3c9, 0x3ca, 0x3cb, 0x3cc, 0x3cd, 0x3ce,     0
    },
    /* encode_ISO_8859_7.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,     0,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xdc,  0xb7,
	  0xdd,  0xde,  0xdf,  0xbb,  0xfc,  0xbd,  0xfd,  0xfe,
	  0xc0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,     0,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_ISO_8859_7.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,     0,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,     0,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xb6,  0xb8,  0xb9,  0xba,
	  0xe0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd3,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xbc,  0xbe,  0xbf,     0
    },
    /* encode_ISO_8859_7.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	0,
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_print | vl_upper),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	0,
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	0,
    },
};

/*  73:ISO-8859-8 */
static const GNREIGHT_ENC encode_ISO_8859_8 = {
    /* encode_ISO_8859_8.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xd7,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xf7,  0xbb,  0xbc,  0xbd,  0xbe,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,0x2017,
	 0x5d0, 0x5d1, 0x5d2, 0x5d3, 0x5d4, 0x5d5, 0x5d6, 0x5d7,
	 0x5d8, 0x5d9, 0x5da, 0x5db, 0x5dc, 0x5dd, 0x5de, 0x5df,
	 0x5e0, 0x5e1, 0x5e2, 0x5e3, 0x5e4, 0x5e5, 0x5e6, 0x5e7,
	 0x5e8, 0x5e9, 0x5ea,     0,     0,0x200e,0x200f,     0
    },
    /* encode_ISO_8859_8.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,     0,     0,  0xfd,  0xfe,     0
    },
    /* encode_ISO_8859_8.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,     0,     0,  0xfd,  0xfe,     0
    },
    /* encode_ISO_8859_8.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	0,
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	(vl_alpha | vl_print),
	/* 0xee */	(vl_alpha | vl_print),
	/* 0xef */	(vl_alpha | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_alpha | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_alpha | vl_print),
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	0,
    },
};

/*  74:ISO-8859-9 */
static const GNREIGHT_ENC encode_ISO_8859_9 = {
    /* encode_ISO_8859_9.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	 0x11e,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc, 0x130, 0x15e,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	 0x11f,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc, 0x131, 0x15f,  0xff
    },
    /* encode_ISO_8859_9.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0x69,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_9.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0x49,  0xde,  0xff
    },
    /* encode_ISO_8859_9.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  75:ISO-8859-9E */
static const GNREIGHT_ENC encode_ISO_8859_9E = {
    /* encode_ISO_8859_9E.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x17d,  0xa2,  0xa3,0x20ac,  0xa5, 0x12c,  0xa7,
	 0x16c,  0xa9, 0x1e6,  0xab, 0x14a,  0xad,  0xae, 0x1d1,
	  0xb0, 0x17e,  0xb2,  0xb3,  0xb4,  0xb5, 0x12d,  0xb7,
	 0x16d,  0xb9, 0x1e7,  0xbb, 0x14b,  0xbd, 0x178, 0x1d2,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5, 0x18f,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	 0x11e,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xdd,
	 0x19f,  0xd9,  0xda,  0xdb,  0xdc, 0x130, 0x15e,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5, 0x259,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	 0x11f,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xfd,
	 0x275,  0xf9,  0xfa,  0xfb,  0xfc, 0x131, 0x15f,  0xff
    },
    /* encode_ISO_8859_9E.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xb1,  0xa2,  0xa3,  0xa4,  0xa5,  0xb6,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xbc,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xff,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0x69,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_9E.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xa1,  0xb2,  0xb3,  0xb4,  0xb5,  0xa6,  0xb7,
	  0xa8,  0xb9,  0xaa,  0xbb,  0xac,  0xbd,  0xbe,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0x49,  0xde,  0xbe
    },
    /* encode_ISO_8859_9E.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  76:ISO-IR-156 */
static const GNREIGHT_ENC encode_ISO_IR_156 = {
    /* encode_ISO_IR_156.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,     0,  0xa5,     0,  0xa7,
	  0xa4,0x2018,0x201c,  0xab,0x2190,0x2191,0x2192,0x2193,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xd7,  0xb5,  0xb6,  0xb7,
	  0xf7,0x2019,0x201d,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	0x2014,  0xb9,  0xae,  0xa9,0x2122,0x266a,  0xac,  0xa6,
	     0,     0,     0,     0,0x215b,0x215c,0x215d,0x215e,
	0x2126,  0xc6,  0xd0,  0xaa, 0x126,     0, 0x132, 0x13f,
	 0x141,  0xd8, 0x152,  0xba,  0xde, 0x166, 0x14a, 0x149,
	 0x138,  0xe6, 0x111,  0xf0, 0x127, 0x131, 0x133, 0x140,
	 0x142,  0xf8, 0x153,  0xdf,  0xfe, 0x167, 0x14b,  0xad
    },
    /* encode_ISO_IR_156.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,     0,  0xa5,     0,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	     0,     0,     0,     0,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xf1,  0xf3,  0xe3,  0xf4,     0,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xeb,  0xfc,  0xfd,  0xfe,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_IR_156.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,     0,  0xa5,     0,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	     0,     0,     0,     0,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,     0,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xe1,  0xf2,  0xe2,  0xe4,  0x49,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xfb,  0xec,  0xed,  0xee,  0xff
    },
    /* encode_ISO_IR_156.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	0,
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	0,
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	0,
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  77:ISO-IR-197 */
static const GNREIGHT_ENC encode_ISO_IR_197 = {
    /* encode_ISO_IR_197.chmap */
    {
	     0,     0,0x201a, 0x192,0x201e,0x2026,  0xac,0x2260,
	  0xa3,0x2030,  0xbf,0x2264, 0x152,     0,     0,     0,
	     0,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	  0xae,0x2122,  0xa1,0x2265, 0x153,     0,     0, 0x178,
	  0xa0, 0x10c, 0x10d, 0x110, 0x111, 0x1e4, 0x1e5,  0xa7,
	 0x1e6,  0xa9, 0x1e7,  0xab, 0x1e8,  0xad, 0x1e9, 0x14a,
	  0xb0, 0x14b, 0x160, 0x161,  0xb4, 0x166,  0xb6,  0xb7,
	 0x167, 0x17d, 0x17e,  0xbb, 0x1b7, 0x292, 0x1ee, 0x1ef,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_IR_197.lower */
    {
	     0,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x9c,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,     0,     0,  0xff,
	  0xa0,  0xa2,  0xa2,  0xa4,  0xa4,  0xa6,  0xa6,  0xa7,
	  0xaa,  0xa9,  0xaa,  0xab,  0xae,  0xad,  0xae,  0xb1,
	  0xb0,  0xb1,  0xb3,  0xb3,  0xb4,  0xb8,  0xb6,  0xb7,
	  0xb8,  0xba,  0xba,  0xbb,  0xbd,  0xbd,  0xbf,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_IR_197.upper */
    {
	     0,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x8c,     0,     0,  0x9f,
	  0xa0,  0xa1,  0xa1,  0xa3,  0xa3,  0xa5,  0xa5,  0xa7,
	  0xa8,  0xa9,  0xa8,  0xab,  0xac,  0xad,  0xac,  0xaf,
	  0xb0,  0xaf,  0xb2,  0xb2,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb5,  0xb9,  0xb9,  0xbb,  0xbc,  0xbc,  0xbe,  0xbe,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0x9f
    },
    /* encode_ISO_IR_197.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	0,
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_print | vl_punct),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_print | vl_punct),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_lower | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_lower | vl_print),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_lower | vl_print),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  78:ISO-IR-209 */
static const GNREIGHT_ENC encode_ISO_IR_209 = {
    /* encode_ISO_IR_209.chmap */
    {
	     0,     0,0x201a, 0x192,0x201e,0x2026,  0xac,0x2260,
	  0xa3,0x2030,  0xbf,0x2264, 0x152,     0,     0,     0,
	     0,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	  0xae,0x2122,  0xa1,0x2265, 0x153,     0,     0, 0x178,
	  0xa0, 0x10c, 0x10d, 0x110, 0x111, 0x1e4, 0x1e5,  0xa7,
	 0x1e6,  0xa9, 0x1e7, 0x21e, 0x1e8,  0xad, 0x1e9, 0x14a,
	  0xb0, 0x14b, 0x160, 0x161,  0xb4, 0x166,  0xb6,  0xb7,
	 0x167, 0x17d, 0x17e, 0x21f, 0x1b7, 0x292, 0x1ee, 0x1ef,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_IR_209.lower */
    {
	     0,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x9c,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,     0,     0,  0xff,
	  0xa0,  0xa2,  0xa2,  0xa4,  0xa4,  0xa6,  0xa6,  0xa7,
	  0xaa,  0xa9,  0xaa,  0xbb,  0xae,  0xad,  0xae,  0xb1,
	  0xb0,  0xb1,  0xb3,  0xb3,  0xb4,  0xb8,  0xb6,  0xb7,
	  0xb8,  0xba,  0xba,  0xbb,  0xbd,  0xbd,  0xbf,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_IR_209.upper */
    {
	     0,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x8c,     0,     0,  0x9f,
	  0xa0,  0xa1,  0xa1,  0xa3,  0xa3,  0xa5,  0xa5,  0xa7,
	  0xa8,  0xa9,  0xa8,  0xab,  0xac,  0xad,  0xac,  0xaf,
	  0xb0,  0xaf,  0xb2,  0xb2,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb5,  0xb9,  0xb9,  0xab,  0xbc,  0xbc,  0xbe,  0xbe,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0x9f
    },
    /* encode_ISO_IR_209.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	0,
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_print | vl_punct),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_print | vl_punct),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_lower | vl_print),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_lower | vl_print),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_lower | vl_print),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  79:KOI8-R */
static const GNREIGHT_ENC encode_KOI8_R = {
    /* encode_KOI8_R.chmap */
    {
	0x2500,0x2502,0x250c,0x2510,0x2514,0x2518,0x251c,0x2524,
	0x252c,0x2534,0x253c,0x2580,0x2584,0x2588,0x258c,0x2590,
	0x2591,0x2592,0x2593,0x2320,0x25a0,0x2219,0x221a,0x2248,
	0x2264,0x2265,  0xa0,0x2321,  0xb0,  0xb2,  0xb7,  0xf7,
	0x2550,0x2551,0x2552, 0x451,0x2553,0x2554,0x2555,0x2556,
	0x2557,0x2558,0x2559,0x255a,0x255b,0x255c,0x255d,0x255e,
	0x255f,0x2560,0x2561, 0x401,0x2562,0x2563,0x2564,0x2565,
	0x2566,0x2567,0x2568,0x2569,0x256a,0x256b,0x256c,  0xa9,
	 0x44e, 0x430, 0x431, 0x446, 0x434, 0x435, 0x444, 0x433,
	 0x445, 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e,
	 0x43f, 0x44f, 0x440, 0x441, 0x442, 0x443, 0x436, 0x432,
	 0x44c, 0x44b, 0x437, 0x448, 0x44d, 0x449, 0x447, 0x44a,
	 0x42e, 0x410, 0x411, 0x426, 0x414, 0x415, 0x424, 0x413,
	 0x425, 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e,
	 0x41f, 0x42f, 0x420, 0x421, 0x422, 0x423, 0x416, 0x412,
	 0x42c, 0x42b, 0x417, 0x428, 0x42d, 0x429, 0x427, 0x42a
    },
    /* encode_KOI8_R.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xa3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_KOI8_R.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xb3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_KOI8_R.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	(vl_print | vl_punct),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_print | vl_punct),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_print | vl_punct),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_print | vl_punct),
	/* 0x8d */	(vl_print | vl_punct),
	/* 0x8e */	(vl_print | vl_punct),
	/* 0x8f */	(vl_print | vl_punct),
	/* 0x90 */	(vl_print | vl_punct),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_print | vl_punct),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_print | vl_punct),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_print | vl_punct),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_lower | vl_print),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_print | vl_upper),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_print | vl_upper),
	/* 0xfe */	(vl_alpha | vl_print | vl_upper),
	/* 0xff */	(vl_alpha | vl_print | vl_upper),
    },
};

/*  80:KOI8-T */
static const GNREIGHT_ENC encode_KOI8_T = {
    /* encode_KOI8_T.chmap */
    {
	 0x49b, 0x493,0x201a, 0x492,0x201e,0x2026,0x2020,0x2021,
	     0,0x2030, 0x4b3,0x2039, 0x4b2, 0x4b7, 0x4b6,     0,
	 0x49a,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	     0,0x2122,     0,0x203a,     0,     0,     0,     0,
	     0, 0x4ef, 0x4ee, 0x451,  0xa4, 0x4e3,  0xa6,  0xa7,
	     0,     0,     0,  0xab,  0xac,  0xad,  0xae,     0,
	  0xb0,  0xb1,  0xb2, 0x401,     0, 0x4e2,  0xb6,  0xb7,
	     0,0x2116,     0,  0xbb,     0,     0,     0,  0xa9,
	 0x44e, 0x430, 0x431, 0x446, 0x434, 0x435, 0x444, 0x433,
	 0x445, 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e,
	 0x43f, 0x44f, 0x440, 0x441, 0x442, 0x443, 0x436, 0x432,
	 0x44c, 0x44b, 0x437, 0x448, 0x44d, 0x449, 0x447, 0x44a,
	 0x42e, 0x410, 0x411, 0x426, 0x414, 0x415, 0x424, 0x413,
	 0x425, 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e,
	 0x41f, 0x42f, 0x420, 0x421, 0x422, 0x423, 0x416, 0x412,
	 0x42c, 0x42b, 0x417, 0x428, 0x42d, 0x429, 0x427, 0x42a
    },
    /* encode_KOI8_T.lower */
    {
	  0x80,  0x81,  0x82,  0x81,  0x84,  0x85,  0x86,  0x87,
	     0,  0x89,  0x8a,  0x8b,  0x8a,  0x8d,  0x8d,     0,
	  0x80,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,     0,  0x9b,     0,     0,     0,     0,
	     0,  0xa1,  0xa1,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	     0,     0,     0,  0xab,  0xac,  0xad,  0xae,     0,
	  0xb0,  0xb1,  0xb2,  0xa3,     0,  0xa5,  0xb6,  0xb7,
	     0,  0xb9,     0,  0xbb,     0,     0,     0,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_KOI8_T.upper */
    {
	  0x90,  0x83,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	     0,  0x89,  0x8c,  0x8b,  0x8c,  0x8e,  0x8e,     0,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,     0,  0x9b,     0,     0,     0,     0,
	     0,  0xa2,  0xa2,  0xb3,  0xa4,  0xb5,  0xa6,  0xa7,
	     0,     0,     0,  0xab,  0xac,  0xad,  0xae,     0,
	  0xb0,  0xb1,  0xb2,  0xb3,     0,  0xb5,  0xb6,  0xb7,
	     0,  0xb9,     0,  0xbb,     0,     0,     0,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_KOI8_T.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_lower | vl_print),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	0,
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_lower | vl_print),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	0,
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	0,
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	0,
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	0,
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	0,
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb4 */	0,
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	0,
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	0,
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_lower | vl_print),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_print | vl_upper),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_print | vl_upper),
	/* 0xfe */	(vl_alpha | vl_print | vl_upper),
	/* 0xff */	(vl_alpha | vl_print | vl_upper),
    },
};

/*  81:KOI8-U */
static const GNREIGHT_ENC encode_KOI8_U = {
    /* encode_KOI8_U.chmap */
    {
	0x2500,0x2502,0x250c,0x2510,0x2514,0x2518,0x251c,0x2524,
	0x252c,0x2534,0x253c,0x2580,0x2584,0x2588,0x258c,0x2590,
	0x2591,0x2592,0x2593,0x2320,0x25a0,0x2219,0x221a,0x2248,
	0x2264,0x2265,  0xa0,0x2321,  0xb0,  0xb2,  0xb7,  0xf7,
	0x2550,0x2551,0x2552, 0x451, 0x454,0x2554, 0x456, 0x457,
	0x2557,0x2558,0x2559,0x255a,0x255b, 0x491,0x255d,0x255e,
	0x255f,0x2560,0x2561, 0x401, 0x404,0x2563, 0x406, 0x407,
	0x2566,0x2567,0x2568,0x2569,0x256a, 0x490,0x256c,  0xa9,
	 0x44e, 0x430, 0x431, 0x446, 0x434, 0x435, 0x444, 0x433,
	 0x445, 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e,
	 0x43f, 0x44f, 0x440, 0x441, 0x442, 0x443, 0x436, 0x432,
	 0x44c, 0x44b, 0x437, 0x448, 0x44d, 0x449, 0x447, 0x44a,
	 0x42e, 0x410, 0x411, 0x426, 0x414, 0x415, 0x424, 0x413,
	 0x425, 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e,
	 0x41f, 0x42f, 0x420, 0x421, 0x422, 0x423, 0x416, 0x412,
	 0x42c, 0x42b, 0x417, 0x428, 0x42d, 0x429, 0x427, 0x42a
    },
    /* encode_KOI8_U.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xa3,  0xa4,  0xb5,  0xa6,  0xa7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xad,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_KOI8_U.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xb3,  0xb4,  0xa5,  0xb6,  0xb7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xbd,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_KOI8_U.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	(vl_print | vl_punct),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_print | vl_punct),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_print | vl_punct),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_print | vl_punct),
	/* 0x8d */	(vl_print | vl_punct),
	/* 0x8e */	(vl_print | vl_punct),
	/* 0x8f */	(vl_print | vl_punct),
	/* 0x90 */	(vl_print | vl_punct),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_print | vl_punct),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_print | vl_punct),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_print | vl_punct),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_alpha | vl_lower | vl_print),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_lower | vl_print),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_print | vl_upper),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_print | vl_upper),
	/* 0xfe */	(vl_alpha | vl_print | vl_upper),
	/* 0xff */	(vl_alpha | vl_print | vl_upper),
    },
};

/*  82:MAC-CYRILLIC */
static const GNREIGHT_ENC encode_MAC_CYRILLIC = {
    /* encode_MAC_CYRILLIC.chmap */
    {
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	0x2020,  0xb0, 0x490,  0xa3,  0xa7,0x2022,  0xb6, 0x406,
	  0xae,  0xa9,0x2122, 0x402, 0x452,0x2260, 0x403, 0x453,
	0x221e,  0xb1,0x2264,0x2265, 0x456,  0xb5, 0x491, 0x408,
	 0x404, 0x454, 0x407, 0x457, 0x409, 0x459, 0x40a, 0x45a,
	 0x458, 0x405,  0xac,0x221a, 0x192,0x2248,0x2206,  0xab,
	  0xbb,0x2026,  0xa0, 0x40b, 0x45b, 0x40c, 0x45c, 0x455,
	0x2013,0x2014,0x201c,0x201d,0x2018,0x2019,  0xf7,0x201e,
	 0x40e, 0x45e, 0x40f, 0x45f,0x2116, 0x401, 0x451, 0x44f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e,  0xa4
    },
    /* encode_MAC_CYRILLIC.lower */
    {
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xa0,  0xa1,  0xb6,  0xa3,  0xa4,  0xa5,  0xa6,  0xb4,
	  0xa8,  0xa9,  0xaa,  0xac,  0xac,  0xad,  0xaf,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xc0,
	  0xb9,  0xb9,  0xbb,  0xbb,  0xbd,  0xbd,  0xbf,  0xbf,
	  0xc0,  0xcf,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcc,  0xcc,  0xce,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd9,  0xd9,  0xdb,  0xdb,  0xdc,  0xde,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_MAC_CYRILLIC.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xab,  0xad,  0xae,  0xae,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xa7,  0xb5,  0xa2,  0xb7,
	  0xb8,  0xb8,  0xba,  0xba,  0xbc,  0xbc,  0xbe,  0xbe,
	  0xb7,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcb,  0xcd,  0xcd,  0xc1,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd8,  0xda,  0xda,  0xdc,  0xdd,  0xdd,  0x9f,
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0xff
    },
    /* encode_MAC_CYRILLIC.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_print | vl_upper),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_alpha | vl_print | vl_upper),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_print | vl_upper),
	/* 0x88 */	(vl_alpha | vl_print | vl_upper),
	/* 0x89 */	(vl_alpha | vl_print | vl_upper),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_alpha | vl_print | vl_upper),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_print | vl_upper),
	/* 0x94 */	(vl_alpha | vl_print | vl_upper),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_print | vl_upper),
	/* 0x97 */	(vl_alpha | vl_print | vl_upper),
	/* 0x98 */	(vl_alpha | vl_print | vl_upper),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_print | vl_upper),
	/* 0x9c */	(vl_alpha | vl_print | vl_upper),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_alpha | vl_print | vl_upper),
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_lower | vl_print),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_alpha | vl_lower | vl_print),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_lower | vl_print),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  83:MAC-IS */
static const GNREIGHT_ENC encode_MAC_IS = {
    /* encode_MAC_IS.chmap */
    {
	  0xc4,  0xc5,  0xc7,  0xc9,  0xd1,  0xd6,  0xdc,  0xe1,
	  0xe0,  0xe2,  0xe4,  0xe3,  0xe5,  0xe7,  0xe9,  0xe8,
	  0xea,  0xeb,  0xed,  0xec,  0xee,  0xef,  0xf1,  0xf3,
	  0xf2,  0xf4,  0xf6,  0xf5,  0xfa,  0xf9,  0xfb,  0xfc,
	0x2020,  0xb0,  0xa2,  0xa3,  0xa7,0x2022,  0xb6,  0xdf,
	  0xae,  0xa9,0x2122,  0xb4,  0xa8,0x2260,  0xc6,  0xd8,
	0x221e,  0xb1,0x2264,0x2265,  0xa5,  0xb5,0x2202,0x2211,
	0x220f, 0x3c0,0x222b,  0xaa,  0xba, 0x3a9,  0xe6,  0xf8,
	  0xbf,  0xa1,  0xac,0x221a, 0x192,0x2248, 0x394,  0xab,
	  0xbb,0x2026,  0xa0,  0xc0,  0xc3,  0xd5, 0x152, 0x153,
	0x2014,0x2013,0x201c,0x201d,0x2018,0x2019,  0xf7,0x25c6,
	  0xff, 0x178,0x2044,  0xa4, 0x110, 0x111,  0xde,  0xfe,
	0x2021,  0xb7,0x201a,0x201e,0x2030,  0xc2,  0xca,  0xc1,
	  0xcb,  0xc8,  0xcd,  0xce,  0xcf,  0xcc,  0xd3,  0xd4,
	0xe01e,  0xd2,  0xda,  0xdb,  0xd9, 0x131,     0,     0,
	  0xaf, 0x2d8, 0x2d9, 0x2da,  0xb8, 0x2dd, 0x2db, 0x2c7
    },
    /* encode_MAC_IS.lower */
    {
	  0x8a,  0x8c,  0x8d,  0x8e,  0x96,  0x9a,  0x9f,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xbe,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0x88,  0x8b,  0x9b,  0xcf,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd8,  0xda,  0xdb,  0xdd,  0xdd,  0xdf,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0x89,  0x90,  0x87,
	  0x91,  0x8f,  0x92,  0x94,  0x95,  0x93,  0x97,  0x99,
	  0xf0,  0x98,  0x9c,  0x9e,  0x9d,  0xf5,     0,     0,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_MAC_IS.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0xe7,
	  0xcb,  0xe5,  0x80,  0xcc,  0x81,  0x82,  0x83,  0xe9,
	  0xe6,  0xe8,  0xea,  0xed,  0xeb,  0xec,  0x84,  0xee,
	  0xf1,  0xef,  0x85,  0xcd,  0xf2,  0xf4,  0xf3,  0x86,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xae,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xce,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd9,  0xd9,  0xda,  0xdb,  0xdc,  0xdc,  0xde,  0xde,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0x49,     0,     0,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_MAC_IS.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_print | vl_upper),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_alpha | vl_print | vl_upper),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_lower | vl_print),
	/* 0x8e */	(vl_alpha | vl_lower | vl_print),
	/* 0x8f */	(vl_alpha | vl_lower | vl_print),
	/* 0x90 */	(vl_alpha | vl_lower | vl_print),
	/* 0x91 */	(vl_alpha | vl_lower | vl_print),
	/* 0x92 */	(vl_alpha | vl_lower | vl_print),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_lower | vl_print),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_lower | vl_print),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_lower | vl_print),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_alpha | vl_print),
	/* 0xbc */	(vl_alpha | vl_print),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_print | vl_punct),
	/* 0xe1 */	(vl_print | vl_punct),
	/* 0xe2 */	(vl_print | vl_punct),
	/* 0xe3 */	(vl_print | vl_punct),
	/* 0xe4 */	(vl_print | vl_punct),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_print | vl_punct),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_alpha | vl_print),
    },
};

/*  84:MAC-SAMI */
static const GNREIGHT_ENC encode_MAC_SAMI = {
    /* encode_MAC_SAMI.chmap */
    {
	  0xc4,  0xc5,  0xc7,  0xc9,  0xd1,  0xd6,  0xdc,  0xe1,
	  0xe0,  0xe2,  0xe4,  0xe3,  0xe5,  0xe7,  0xe9,  0xe8,
	  0xea,  0xeb,  0xed,  0xec,  0xee,  0xef,  0xf1,  0xf3,
	  0xf2,  0xf4,  0xf6,  0xf5,  0xfa,  0xf9,  0xfb,  0xfc,
	  0xdd,  0xb0, 0x10c,  0xa3,  0xa7,0x2022,  0xb6,  0xdf,
	  0xae,  0xa9,0x2122,  0xb4,  0xa8,0x2260,  0xc6,  0xd8,
	 0x110, 0x14a, 0x21e, 0x21f, 0x160, 0x166,0x2202, 0x17d,
	 0x10d, 0x111, 0x14b, 0x161, 0x167, 0x17e,  0xe6,  0xf8,
	  0xbf,  0xa1,  0xac,0x221a, 0x192,0x2248,0x2206,  0xab,
	  0xbb,0x2026,  0xa0,  0xc0,  0xc3,  0xd5, 0x152, 0x153,
	0x2013,0x2014,0x201c,0x201d,0x2018,0x2019,  0xf7,0x25ca,
	  0xff, 0x178,0x2044,  0xa4,  0xd0,  0xf0,  0xde,  0xfe,
	  0xfd,  0xb7,0x201a,0x201e,0x2030,  0xc2,  0xca,  0xc1,
	  0xcb,  0xc8,  0xcd,  0xce,  0xcf,  0xcc,  0xd3,  0xd4,
	0xf8ff,  0xd2,  0xda,  0xdb,  0xd9, 0x131, 0x1b7, 0x292,
	 0x1ee, 0x1ef, 0x1e4, 0x1e5, 0x1e6, 0x1e7, 0x1e8, 0x1e9
    },
    /* encode_MAC_SAMI.lower */
    {
	  0x8a,  0x8c,  0x8d,  0x8e,  0x96,  0x9a,  0x9f,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xe0,  0xa1,  0xb8,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xbe,  0xbf,
	  0xb9,  0xba,  0xb3,  0xb3,  0xbb,  0xbc,  0xb6,  0xbd,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0x88,  0x8b,  0x9b,  0xcf,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd8,  0xda,  0xdb,  0xdd,  0xdd,  0xdf,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0x89,  0x90,  0x87,
	  0x91,  0x8f,  0x92,  0x94,  0x95,  0x93,  0x97,  0x99,
	  0xf0,  0x98,  0x9c,  0x9e,  0x9d,  0xf5,  0xf7,  0xf7,
	  0xf9,  0xf9,  0xfb,  0xfb,  0xfd,  0xfd,  0xff,  0xff
    },
    /* encode_MAC_SAMI.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0xe7,
	  0xcb,  0xe5,  0x80,  0xcc,  0x81,  0x82,  0x83,  0xe9,
	  0xe6,  0xe8,  0xea,  0xed,  0xeb,  0xec,  0x84,  0xee,
	  0xf1,  0xef,  0x85,  0xcd,  0xf2,  0xf4,  0xf3,  0x86,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb2,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xa2,  0xb0,  0xb1,  0xb4,  0xb5,  0xb7,  0xae,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xce,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd9,  0xd9,  0xda,  0xdb,  0xdc,  0xdc,  0xde,  0xde,
	  0xa0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0x49,  0xf6,  0xf6,
	  0xf8,  0xf8,  0xfa,  0xfa,  0xfc,  0xfc,  0xfe,  0xfe
    },
    /* encode_MAC_SAMI.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_print | vl_upper),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_alpha | vl_print | vl_upper),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_lower | vl_print),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_alpha | vl_lower | vl_print),
	/* 0x8c */	(vl_alpha | vl_lower | vl_print),
	/* 0x8d */	(vl_alpha | vl_lower | vl_print),
	/* 0x8e */	(vl_alpha | vl_lower | vl_print),
	/* 0x8f */	(vl_alpha | vl_lower | vl_print),
	/* 0x90 */	(vl_alpha | vl_lower | vl_print),
	/* 0x91 */	(vl_alpha | vl_lower | vl_print),
	/* 0x92 */	(vl_alpha | vl_lower | vl_print),
	/* 0x93 */	(vl_alpha | vl_lower | vl_print),
	/* 0x94 */	(vl_alpha | vl_lower | vl_print),
	/* 0x95 */	(vl_alpha | vl_lower | vl_print),
	/* 0x96 */	(vl_alpha | vl_lower | vl_print),
	/* 0x97 */	(vl_alpha | vl_lower | vl_print),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_lower | vl_print),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_alpha | vl_lower | vl_print),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_print | vl_punct),
	/* 0xe2 */	(vl_print | vl_punct),
	/* 0xe3 */	(vl_print | vl_punct),
	/* 0xe4 */	(vl_print | vl_punct),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_print | vl_upper),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  85:MIK */
static const GNREIGHT_ENC encode_MIK = {
    /* encode_MIK.chmap */
    {
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f,
	0x2514,0x2534,0x252c,0x251c,0x2500,0x253c,0x2563,0x2551,
	0x255a,0x2554,0x2569,0x2566,0x2560,0x2550,0x256c,0x2510,
	0x2591,0x2592,0x2593,0x2502,0x2524,0x2116,  0xa7,0x2557,
	0x255d,0x2518,0x250c,0x2588,0x2584,0x258c,0x2590,0x2580,
	 0x3b1,  0xdf, 0x393, 0x3c0, 0x3a3, 0x3c3,  0xb5, 0x3c4,
	 0x3a6, 0x398, 0x3a9, 0x3b4,0x221e, 0x3c6, 0x3b5,0x2229,
	0x2261,  0xb1,0x2265,0x2264,0x2320,0x2321,  0xf7,0x2248,
	  0xb0,0x2219,  0xb7,0x221a,0x207f,  0xb2,0x25a0,  0xa0
    },
    /* encode_MIK.lower */
    {
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe5,  0xe5,  0xe6,  0xe7,
	  0xed,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_MIK.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe4,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xe8,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_MIK.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_print | vl_upper),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_alpha | vl_print | vl_upper),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_print | vl_upper),
	/* 0x88 */	(vl_alpha | vl_print | vl_upper),
	/* 0x89 */	(vl_alpha | vl_print | vl_upper),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_alpha | vl_print | vl_upper),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_alpha | vl_print | vl_upper),
	/* 0x92 */	(vl_alpha | vl_print | vl_upper),
	/* 0x93 */	(vl_alpha | vl_print | vl_upper),
	/* 0x94 */	(vl_alpha | vl_print | vl_upper),
	/* 0x95 */	(vl_alpha | vl_print | vl_upper),
	/* 0x96 */	(vl_alpha | vl_print | vl_upper),
	/* 0x97 */	(vl_alpha | vl_print | vl_upper),
	/* 0x98 */	(vl_alpha | vl_print | vl_upper),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_print | vl_upper),
	/* 0x9b */	(vl_alpha | vl_print | vl_upper),
	/* 0x9c */	(vl_alpha | vl_print | vl_upper),
	/* 0x9d */	(vl_alpha | vl_print | vl_upper),
	/* 0x9e */	(vl_alpha | vl_print | vl_upper),
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xaa */	(vl_alpha | vl_lower | vl_print),
	/* 0xab */	(vl_alpha | vl_lower | vl_print),
	/* 0xac */	(vl_alpha | vl_lower | vl_print),
	/* 0xad */	(vl_alpha | vl_lower | vl_print),
	/* 0xae */	(vl_alpha | vl_lower | vl_print),
	/* 0xaf */	(vl_alpha | vl_lower | vl_print),
	/* 0xb0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_alpha | vl_lower | vl_print),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	(vl_print | vl_punct),
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_print | vl_punct),
	/* 0xd5 */	(vl_print | vl_punct),
	/* 0xd6 */	(vl_print | vl_punct),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	(vl_print | vl_punct),
	/* 0xda */	(vl_print | vl_punct),
	/* 0xdb */	(vl_print | vl_punct),
	/* 0xdc */	(vl_print | vl_punct),
	/* 0xdd */	(vl_print | vl_punct),
	/* 0xde */	(vl_print | vl_punct),
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	(vl_print | vl_punct),
	/* 0xf4 */	(vl_print | vl_punct),
	/* 0xf5 */	(vl_print | vl_punct),
	/* 0xf6 */	(vl_print | vl_punct),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_print | vl_punct),
	/* 0xf9 */	(vl_print | vl_punct),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  86:PT154 */
static const GNREIGHT_ENC encode_PT154 = {
    /* encode_PT154.chmap */
    {
	 0x496, 0x492, 0x4ee, 0x493,0x201e,0x2026, 0x4b6, 0x4ae,
	 0x4b2, 0x4af, 0x4a0, 0x4e2, 0x4a2, 0x49a, 0x4ba, 0x4b8,
	 0x497,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	 0x4b3, 0x4b7, 0x4a1, 0x4e3, 0x4a3, 0x49b, 0x4bb, 0x4b9,
	  0xa0, 0x40e, 0x45e, 0x408, 0x4e8, 0x498, 0x4b0,  0xa7,
	 0x401,  0xa9, 0x4d8,  0xab,  0xac, 0x4ef,  0xae, 0x49c,
	  0xb0, 0x4b1, 0x406, 0x456, 0x499, 0x4e9,  0xb6,  0xb7,
	 0x451,0x2116, 0x4d9,  0xbb, 0x458, 0x4aa, 0x4ab, 0x49d,
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f
    },
    /* encode_PT154.lower */
    {
	  0x90,  0x83,  0xad,  0x83,  0x84,  0x85,  0x99,  0x89,
	  0x98,  0x89,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa2,  0xa2,  0xbc,  0xb5,  0xb4,  0xb1,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xac,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb3,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbe,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_PT154.upper */
    {
	  0x80,  0x81,  0x82,  0x81,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x87,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x80,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x88,  0x86,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0xa0,  0xa1,  0xa1,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0x82,  0xae,  0xaf,
	  0xb0,  0xa6,  0xb2,  0xb2,  0xa5,  0xa4,  0xb6,  0xb7,
	  0xa8,  0xb9,  0xaa,  0xbb,  0xa3,  0xbd,  0xbd,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_PT154.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_alpha | vl_print | vl_upper),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_alpha | vl_print | vl_upper),
	/* 0x87 */	(vl_alpha | vl_print | vl_upper),
	/* 0x88 */	(vl_alpha | vl_print | vl_upper),
	/* 0x89 */	(vl_alpha | vl_lower | vl_print),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_alpha | vl_print | vl_upper),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_lower | vl_print),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_lower | vl_print),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_alpha | vl_lower | vl_print),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_alpha | vl_lower | vl_print),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_print | vl_upper),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  87:RK1048 */
static const GNREIGHT_ENC encode_RK1048 = {
    /* encode_RK1048.chmap */
    {
	 0x402, 0x403,0x201a, 0x453,0x201e,0x2026,0x2020,0x2021,
	0x20ac,0x2030, 0x409,0x2039, 0x40a, 0x49a, 0x4ba, 0x40f,
	 0x452,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	     0,0x2122, 0x459,0x203a, 0x45a, 0x49b, 0x4bb, 0x45f,
	  0xa0, 0x4b0, 0x4b1, 0x4d8,  0xa4, 0x4e8,  0xa6,  0xa7,
	 0x401,  0xa9, 0x492,  0xab,  0xac,  0xad,  0xae, 0x4ae,
	  0xb0,  0xb1, 0x406, 0x456, 0x4e9,  0xb5,  0xb6,  0xb7,
	 0x451,0x2116, 0x493,  0xbb, 0x4d9, 0x4a2, 0x4a3, 0x4af,
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f
    },
    /* encode_RK1048.lower */
    {
	  0x90,  0x83,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x9a,  0x8b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa2,  0xa2,  0xbc,  0xa4,  0xb4,  0xa6,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xac,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb3,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbe,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_RK1048.upper */
    {
	  0x80,  0x81,  0x82,  0x81,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x80,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,  0x8a,  0x9b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0xa0,  0xa1,  0xa1,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb2,  0xa5,  0xb5,  0xb6,  0xb7,
	  0xa8,  0xb9,  0xaa,  0xbb,  0xa3,  0xbd,  0xbd,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_RK1048.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_lower | vl_print),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	0,
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_print | vl_upper),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  88:TIS-620 */
static const GNREIGHT_ENC encode_TIS_620 = {
    /* encode_TIS_620.chmap */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0, 0xe01, 0xe02, 0xe03, 0xe04, 0xe05, 0xe06, 0xe07,
	 0xe08, 0xe09, 0xe0a, 0xe0b, 0xe0c, 0xe0d, 0xe0e, 0xe0f,
	 0xe10, 0xe11, 0xe12, 0xe13, 0xe14, 0xe15, 0xe16, 0xe17,
	 0xe18, 0xe19, 0xe1a, 0xe1b, 0xe1c, 0xe1d, 0xe1e, 0xe1f,
	 0xe20, 0xe21, 0xe22, 0xe23, 0xe24, 0xe25, 0xe26, 0xe27,
	 0xe28, 0xe29, 0xe2a, 0xe2b, 0xe2c, 0xe2d, 0xe2e, 0xe2f,
	 0xe30, 0xe31, 0xe32, 0xe33, 0xe34, 0xe35, 0xe36, 0xe37,
	 0xe38, 0xe39, 0xe3a,     0,     0,     0,     0, 0xe3f,
	 0xe40, 0xe41, 0xe42, 0xe43, 0xe44, 0xe45, 0xe46, 0xe47,
	 0xe48, 0xe49, 0xe4a, 0xe4b, 0xe4c, 0xe4d, 0xe4e, 0xe4f,
	 0xe50, 0xe51, 0xe52, 0xe53, 0xe54, 0xe55, 0xe56, 0xe57,
	 0xe58, 0xe59, 0xe5a, 0xe5b,     0,     0,     0,     0
    },
    /* encode_TIS_620.lower */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,     0,     0,     0,     0
    },
    /* encode_TIS_620.upper */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,     0,     0,     0,     0
    },
    /* encode_TIS_620.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	0,
	/* 0x82 */	0,
	/* 0x83 */	0,
	/* 0x84 */	0,
	/* 0x85 */	0,
	/* 0x86 */	0,
	/* 0x87 */	0,
	/* 0x88 */	0,
	/* 0x89 */	0,
	/* 0x8a */	0,
	/* 0x8b */	0,
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	0,
	/* 0x92 */	0,
	/* 0x93 */	0,
	/* 0x94 */	0,
	/* 0x95 */	0,
	/* 0x96 */	0,
	/* 0x97 */	0,
	/* 0x98 */	0,
	/* 0x99 */	0,
	/* 0x9a */	0,
	/* 0x9b */	0,
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	0,
	/* 0xa1 */	(vl_alpha | vl_print),
	/* 0xa2 */	(vl_alpha | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print),
	/* 0xa4 */	(vl_alpha | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_alpha | vl_print),
	/* 0xa9 */	(vl_alpha | vl_print),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_alpha | vl_print),
	/* 0xac */	(vl_alpha | vl_print),
	/* 0xad */	(vl_alpha | vl_print),
	/* 0xae */	(vl_alpha | vl_print),
	/* 0xaf */	(vl_alpha | vl_print),
	/* 0xb0 */	(vl_alpha | vl_print),
	/* 0xb1 */	(vl_alpha | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print),
	/* 0xb3 */	(vl_alpha | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print),
	/* 0xb5 */	(vl_alpha | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_alpha | vl_print),
	/* 0xbc */	(vl_alpha | vl_print),
	/* 0xbd */	(vl_alpha | vl_print),
	/* 0xbe */	(vl_alpha | vl_print),
	/* 0xbf */	(vl_alpha | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_print | vl_punct),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	(vl_alpha | vl_print),
	/* 0xee */	(vl_alpha | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_alpha | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*  89:TSCII */
static const GNREIGHT_ENC encode_TSCII = {
    /* encode_TSCII.chmap */
    {
	 0xbe6, 0xbe7, 0xbb8, 0xb9c, 0xbb7, 0xbb8, 0xbb9, 0xb95,
	 0xb9c, 0xbb7, 0xbb8, 0xbcd, 0xbcd, 0xbe8, 0xbe9, 0xbea,
	 0xbeb,0x2018,0x2019,0x201c,0x201d, 0xbec, 0xbed, 0xbee,
	 0xbef, 0xb99, 0xb9e, 0xb99, 0xb9e, 0xbf0, 0xbf1, 0xbf2,
	     0, 0xbbe, 0xbbf, 0xbc0, 0xbc1, 0xbc2, 0xbc2, 0xbc6,
	 0xbc7, 0xbc8, 0xbd7, 0xb85, 0xb86, 0xb87, 0xb88, 0xb89,
	 0xb8a, 0xb8e, 0xb8f, 0xb90, 0xb92, 0xb93, 0xb94, 0xb83,
	 0xb95, 0xb99, 0xb9a, 0xb9e, 0xb9f, 0xba3, 0xba4, 0xba8,
	 0xbaa, 0xbae, 0xbaf, 0xbb0, 0xbb2, 0xbb5, 0xbb4, 0xbb3,
	 0xbb1, 0xba9, 0xb9f, 0xb9f, 0xb95, 0xb9a, 0xb9f, 0xba3,
	 0xba4, 0xba8, 0xbaa, 0xbae, 0xbaf, 0xbb0, 0xbb2, 0xbb5,
	 0xbb4, 0xbb3, 0xbb1, 0xba9, 0xb95, 0xb9a, 0xb9f, 0xba3,
	 0xba4, 0xba8, 0xbaa, 0xbae, 0xbaf, 0xbb0, 0xbb2, 0xbb5,
	 0xbb4, 0xbb3, 0xbb1, 0xba9, 0xb95, 0xb99, 0xb9a, 0xb9e,
	 0xb9f, 0xba3, 0xba4, 0xba8, 0xbaa, 0xbae, 0xbaf, 0xbb0,
	 0xbb2, 0xbb5, 0xbb4, 0xbb3, 0xbb1, 0xba9, 0xb87,     0
    },
    /* encode_TSCII.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x82,  0x86,  0x87,
	  0x83,  0x84,  0x82,  0x8b,  0x8b,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x99,  0x9a,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa5,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0x87,  0x99,  0xba,  0x9a,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xbc,  0xbc,  0x87,  0xba,  0xbc,  0xbd,
	  0xbe,  0xbf,  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,
	  0xc6,  0xc7,  0xc8,  0xc9,  0x87,  0xba,  0xbc,  0xbd,
	  0xbe,  0xbf,  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,
	  0xc6,  0xc7,  0xc8,  0xc9,  0x87,  0x99,  0xba,  0x9a,
	  0xbc,  0xbd,  0xbe,  0xbf,  0xc0,  0xc1,  0xc2,  0xc3,
	  0xc4,  0xc5,  0xc6,  0xc7,  0xc8,  0xc9,  0xad,     0
    },
    /* encode_TSCII.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x82,  0x86,  0x87,
	  0x83,  0x84,  0x82,  0x8b,  0x8b,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x99,  0x9a,  0x9d,  0x9e,  0x9f,
	     0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa5,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0x87,  0x99,  0xba,  0x9a,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xbc,  0xbc,  0x87,  0xba,  0xbc,  0xbd,
	  0xbe,  0xbf,  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,
	  0xc6,  0xc7,  0xc8,  0xc9,  0x87,  0xba,  0xbc,  0xbd,
	  0xbe,  0xbf,  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,
	  0xc6,  0xc7,  0xc8,  0xc9,  0x87,  0x99,  0xba,  0x9a,
	  0xbc,  0xbd,  0xbe,  0xbf,  0xc0,  0xc1,  0xc2,  0xc3,
	  0xc4,  0xc5,  0xc6,  0xc7,  0xc8,  0xc9,  0xad,     0
    },
    /* encode_TSCII.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print),
	/* 0x81 */	(vl_alpha | vl_print),
	/* 0x82 */	(vl_alpha | vl_print),
	/* 0x83 */	(vl_alpha | vl_print),
	/* 0x84 */	(vl_alpha | vl_print),
	/* 0x85 */	(vl_alpha | vl_print),
	/* 0x86 */	(vl_alpha | vl_print),
	/* 0x87 */	(vl_alpha | vl_print),
	/* 0x88 */	(vl_alpha | vl_print),
	/* 0x89 */	(vl_alpha | vl_print),
	/* 0x8a */	(vl_alpha | vl_print),
	/* 0x8b */	(vl_alpha | vl_print),
	/* 0x8c */	(vl_alpha | vl_print),
	/* 0x8d */	(vl_alpha | vl_print),
	/* 0x8e */	(vl_alpha | vl_print),
	/* 0x8f */	(vl_alpha | vl_print),
	/* 0x90 */	(vl_alpha | vl_print),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_alpha | vl_print),
	/* 0x96 */	(vl_alpha | vl_print),
	/* 0x97 */	(vl_alpha | vl_print),
	/* 0x98 */	(vl_alpha | vl_print),
	/* 0x99 */	(vl_alpha | vl_print),
	/* 0x9a */	(vl_alpha | vl_print),
	/* 0x9b */	(vl_alpha | vl_print),
	/* 0x9c */	(vl_alpha | vl_print),
	/* 0x9d */	(vl_alpha | vl_print),
	/* 0x9e */	(vl_alpha | vl_print),
	/* 0x9f */	(vl_alpha | vl_print),
	/* 0xa0 */	0,
	/* 0xa1 */	(vl_alpha | vl_print),
	/* 0xa2 */	(vl_alpha | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print),
	/* 0xa4 */	(vl_alpha | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_alpha | vl_print),
	/* 0xa9 */	(vl_alpha | vl_print),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_alpha | vl_print),
	/* 0xac */	(vl_alpha | vl_print),
	/* 0xad */	(vl_alpha | vl_print),
	/* 0xae */	(vl_alpha | vl_print),
	/* 0xaf */	(vl_alpha | vl_print),
	/* 0xb0 */	(vl_alpha | vl_print),
	/* 0xb1 */	(vl_alpha | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print),
	/* 0xb3 */	(vl_alpha | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print),
	/* 0xb5 */	(vl_alpha | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_alpha | vl_print),
	/* 0xbc */	(vl_alpha | vl_print),
	/* 0xbd */	(vl_alpha | vl_print),
	/* 0xbe */	(vl_alpha | vl_print),
	/* 0xbf */	(vl_alpha | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_alpha | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	(vl_alpha | vl_print),
	/* 0xdc */	(vl_alpha | vl_print),
	/* 0xdd */	(vl_alpha | vl_print),
	/* 0xde */	(vl_alpha | vl_print),
	/* 0xdf */	(vl_alpha | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	(vl_alpha | vl_print),
	/* 0xee */	(vl_alpha | vl_print),
	/* 0xef */	(vl_alpha | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_alpha | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_alpha | vl_print),
	/* 0xfb */	(vl_alpha | vl_print),
	/* 0xfc */	(vl_alpha | vl_print),
	/* 0xfd */	(vl_alpha | vl_print),
	/* 0xfe */	(vl_alpha | vl_print),
	/* 0xff */	0,
    },
};

/*  90:WIN-SAMI-2 */
static const GNREIGHT_ENC encode_WIN_SAMI_2 = {
    /* encode_WIN_SAMI_2.chmap */
    {
	0x20ac,     0, 0x10c, 0x192, 0x10d, 0x1b7, 0x292, 0x1ee,
	 0x1ef, 0x110, 0x160,0x2039, 0x152,     0,     0,     0,
	     0,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	 0x111, 0x1e6, 0x161,0x203a, 0x153,     0,     0, 0x178,
	  0xa0, 0x1e7, 0x1e4,  0xa3,  0xa4, 0x1e5,  0xa6,  0xa7,
	  0xa8,  0xa9, 0x21e,  0xab,  0xac,  0xad,  0xae, 0x21f,
	  0xb0,  0xb1, 0x1e8, 0x1e9,  0xb4,  0xb5,  0xb6,  0xb7,
	 0x14a, 0x14b, 0x166,  0xbb, 0x167,  0xbd, 0x17d, 0x17e,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_WIN_SAMI_2.lower */
    {
	  0x80,     0,  0x84,  0x83,  0x84,  0x86,  0x86,  0x88,
	  0x88,  0x98,  0x9a,  0x8b,  0x9c,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0xa1,  0x9a,  0x9b,  0x9c,     0,     0,  0xff,
	  0xa0,  0xa1,  0xa5,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaf,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb3,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb9,  0xb9,  0xbc,  0xbb,  0xbc,  0xbd,  0xbf,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_WIN_SAMI_2.upper */
    {
	  0x80,     0,  0x82,  0x83,  0x82,  0x85,  0x85,  0x87,
	  0x87,  0x89,  0x8a,  0x8b,  0x8c,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x89,  0x99,  0x8a,  0x9b,  0x8c,     0,     0,  0x9f,
	  0xa0,  0x99,  0xa2,  0xa3,  0xa4,  0xa2,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaa,
	  0xb0,  0xb1,  0xb2,  0xb2,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb8,  0xba,  0xbb,  0xba,  0xbd,  0xbe,  0xbe,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0x9f
    },
    /* encode_WIN_SAMI_2.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	0,
	/* 0x82 */	(vl_alpha | vl_print | vl_upper),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_alpha | vl_lower | vl_print),
	/* 0x85 */	(vl_alpha | vl_print | vl_upper),
	/* 0x86 */	(vl_alpha | vl_lower | vl_print),
	/* 0x87 */	(vl_alpha | vl_print | vl_upper),
	/* 0x88 */	(vl_alpha | vl_lower | vl_print),
	/* 0x89 */	(vl_alpha | vl_print | vl_upper),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_alpha | vl_lower | vl_print),
	/* 0x99 */	(vl_alpha | vl_print | vl_upper),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_lower | vl_print),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/* Sorted encodings */
static const GNREIGHT_INX all_encodings[] = {
    { "1046",                        &encode_1046 },
    { "437",                         &encode_437 },
    { "850",                         &encode_850 },
    { "851",                         &encode_851 },
    { "852",                         &encode_852 },
    { "855",                         &encode_855 },
    { "857",                         &encode_857 },
    { "860",                         &encode_860 },
    { "861",                         &encode_861 },
    { "862",                         &encode_862 },
    { "863",                         &encode_863 },
    { "865",                         &encode_865 },
    { "866",                         &encode_866 },
    { "866NAV",                      &encode_866NAV },
    { "869",                         &encode_869 },
    { "874",                         &encode_874 },
    { "8859_1",                      &encode_ISO_8859_1 },
    { "8859_2",                      &encode_ISO_8859_2 },
    { "8859_3",                      &encode_ISO_8859_3 },
    { "8859_4",                      &encode_8859_4 },
    { "8859_5",                      &encode_ISO_8859_5 },
    { "8859_6",                      &encode_ISO_8859_6 },
    { "8859_7",                      &encode_ISO_8859_7 },
    { "8859_8",                      &encode_ISO_8859_8 },
    { "8859_9",                      &encode_ISO_8859_9 },
    { "ANSI_X3.110",                 &encode_ANSI_X3_110_1983 },
    { "ANSI_X3.110-1983",            &encode_ANSI_X3_110_1983 },
    { "ANSI_X3.4",                   &encode_ANSI_X3_4_1968 },
    { "ANSI_X3.4-1968",              &encode_ANSI_X3_4_1968 },
    { "ANSI_X3.4-1986",              &encode_ANSI_X3_4_1968 },
    { "ARABIC",                      &encode_ISO_8859_6 },
    { "ARMSCII-8",                   &encode_ARMSCII_8 },
    { "ASMO-708",                    &encode_ISO_8859_6 },
    { "BALTIC",                      &encode_ISO_8859_13 },
    { "CP-AR",                       &encode_CP_AR },
    { "CP-GR",                       &encode_869 },
    { "CP-HU",                       &encode_CP_HU },
    { "CP10007",                     &encode_CP10007 },
    { "CP1004",                      &encode_CP1004 },
    { "CP1008",                      &encode_CP1008 },
    { "CP1046",                      &encode_1046 },
    { "CP1089",                      &encode_ISO_8859_6 },
    { "CP1124",                      &encode_CP1124 },
    { "CP1125",                      &encode_CP1125 },
    { "CP1129",                      &encode_CP1129 },
    { "CP1133",                      &encode_CP1133 },
    { "CP1162",                      &encode_CP1162 },
    { "CP1163",                      &encode_CP1163 },
    { "CP1167",                      &encode_CP1167 },
    { "CP1250",                      &encode_CP1250 },
    { "CP1251",                      &encode_CP1251 },
    { "CP1252",                      &encode_CP1252 },
    { "CP1253",                      &encode_CP1253 },
    { "CP1254",                      &encode_CP1254 },
    { "CP1255",                      &encode_CP1255 },
    { "CP1256",                      &encode_CP1256 },
    { "CP1257",                      &encode_CP1257 },
    { "CP1282",                      &encode_CP1282 },
    { "CP437",                       &encode_437 },
    { "CP4909",                      &encode_CP4909 },
    { "CP5347",                      &encode_CP5347 },
    { "CP737",                       &encode_CP737 },
    { "CP775",                       &encode_CP775 },
    { "CP813",                       &encode_ISO_8859_7 },
    { "CP819",                       &encode_ISO_8859_1 },
    { "CP850",                       &encode_850 },
    { "CP851",                       &encode_851 },
    { "CP852",                       &encode_852 },
    { "CP855",                       &encode_855 },
    { "CP857",                       &encode_857 },
    { "CP860",                       &encode_860 },
    { "CP861",                       &encode_861 },
    { "CP862",                       &encode_862 },
    { "CP863",                       &encode_863 },
    { "CP865",                       &encode_865 },
    { "CP866",                       &encode_866 },
    { "CP866NAV",                    &encode_866NAV },
    { "CP868",                       &encode_CP_AR },
    { "CP869",                       &encode_869 },
    { "CP874",                       &encode_874 },
    { "CP901",                       &encode_CP901 },
    { "CP902",                       &encode_CP902 },
    { "CP912",                       &encode_ISO_8859_2 },
    { "CP915",                       &encode_ISO_8859_5 },
    { "CP916",                       &encode_ISO_8859_8 },
    { "CP920",                       &encode_ISO_8859_9 },
    { "CP921",                       &encode_ISO_8859_13 },
    { "CP922",                       &encode_CP922 },
    { "CP9448",                      &encode_CP1256 },
    { "CPIBM861",                    &encode_861 },
    { "CSA_T500",                    &encode_ANSI_X3_110_1983 },
    { "CSA_T500-1983",               &encode_ANSI_X3_110_1983 },
    { "CSDECMCS",                    &encode_CSDECMCS },
    { "CSHPROMAN8",                  &encode_CSHPROMAN8 },
    { "CSIBM1008",                   &encode_CP1008 },
    { "CSIBM1124",                   &encode_CP1124 },
    { "CSIBM1129",                   &encode_CP1129 },
    { "CSIBM1133",                   &encode_CP1133 },
    { "CSIBM11621162",               &encode_CP1162 },
    { "CSIBM1163",                   &encode_CP1163 },
    { "CSIBM1167",                   &encode_CP1167 },
    { "CSIBM4909",                   &encode_CP4909 },
    { "CSIBM5347",                   &encode_CP5347 },
    { "CSIBM851",                    &encode_851 },
    { "CSIBM855",                    &encode_855 },
    { "CSIBM857",                    &encode_857 },
    { "CSIBM860",                    &encode_860 },
    { "CSIBM863",                    &encode_863 },
    { "CSIBM865",                    &encode_865 },
    { "CSIBM866",                    &encode_866 },
    { "CSIBM868",                    &encode_CP_AR },
    { "CSIBM869",                    &encode_869 },
    { "CSIBM901",                    &encode_CP901 },
    { "CSIBM902",                    &encode_CP902 },
    { "CSIBM921",                    &encode_ISO_8859_13 },
    { "CSIBM922",                    &encode_CP922 },
    { "CSIBM9448",                   &encode_CP1256 },
    { "CSISO103T618BIT",             &encode_CSISO103T618BIT },
    { "CSISO111ECMACYRILLIC",        &encode_CSISO111ECMACYRILLIC },
    { "CSISO143IECP271",             &encode_CSISO143IECP271 },
    { "CSISO153GOST1976874",         &encode_CSISO153GOST1976874 },
    { "CSISO99NAPLPS",               &encode_ANSI_X3_110_1983 },
    { "CSISOLATIN1",                 &encode_ISO_8859_1 },
    { "CSISOLATIN2",                 &encode_ISO_8859_2 },
    { "CSISOLATIN3",                 &encode_ISO_8859_3 },
    { "CSISOLATIN4",                 &encode_8859_4 },
    { "CSISOLATIN5",                 &encode_ISO_8859_9 },
    { "CSISOLATIN6",                 &encode_ISO_8859_10 },
    { "CSISOLATINARABIC",            &encode_ISO_8859_6 },
    { "CSISOLATINCYRILLIC",          &encode_ISO_8859_5 },
    { "CSISOLATINGREEK",             &encode_ISO_8859_7 },
    { "CSISOLATINHEBREW",            &encode_ISO_8859_8 },
    { "CSKOI8R",                     &encode_KOI8_R },
    { "CSMACINTOSH",                 &encode_CSMACINTOSH },
    { "CSPC775BALTIC",               &encode_CP775 },
    { "CSPC850MULTILINGUAL",         &encode_850 },
    { "CSPC862LATINHEBREW",          &encode_862 },
    { "CSPC8CODEPAGE437",            &encode_437 },
    { "CSPCP852",                    &encode_852 },
    { "CWI",                         &encode_CP_HU },
    { "CWI-2",                       &encode_CP_HU },
    { "CYRILLIC",                    &encode_ISO_8859_5 },
    { "DEC",                         &encode_CSDECMCS },
    { "DEC-MCS",                     &encode_CSDECMCS },
    { "DECMCS",                      &encode_CSDECMCS },
    { "ECMA-114",                    &encode_ISO_8859_6 },
    { "ECMA-118",                    &encode_ISO_8859_7 },
    { "ECMA-128",                    &encode_ISO_8859_9 },
    { "ECMA-CYRILLIC",               &encode_CSISO111ECMACYRILLIC },
    { "ECMACYRILLIC",                &encode_CSISO111ECMACYRILLIC },
    { "ELOT_928",                    &encode_ISO_8859_7 },
    { "GEORGIAN-ACADEMY",            &encode_GEORGIAN_ACADEMY },
    { "GEORGIAN-PS",                 &encode_GEORGIAN_PS },
    { "GOST_19768",                  &encode_CSISO153GOST1976874 },
    { "GOST_19768-74",               &encode_CSISO153GOST1976874 },
    { "GOST_1976874",                &encode_CSISO153GOST1976874 },
    { "GREEK",                       &encode_ISO_8859_7 },
    { "GREEK8",                      &encode_ISO_8859_7 },
    { "HEBREW",                      &encode_ISO_8859_8 },
    { "HP-GREEK8",                   &encode_HP_GREEK8 },
    { "HP-ROMAN8",                   &encode_CSHPROMAN8 },
    { "HP-ROMAN9",                   &encode_HP_ROMAN9 },
    { "HP-THAI8",                    &encode_HP_THAI8 },
    { "HP-TURKISH8",                 &encode_HP_TURKISH8 },
    { "HPGREEK8",                    &encode_HP_GREEK8 },
    { "HPROMAN8",                    &encode_CSHPROMAN8 },
    { "HPROMAN9",                    &encode_HP_ROMAN9 },
    { "HPTHAI8",                     &encode_HP_THAI8 },
    { "HPTURKISH8",                  &encode_HP_TURKISH8 },
    { "IBM-1008",                    &encode_CP1008 },
    { "IBM-1046",                    &encode_1046 },
    { "IBM-1124",                    &encode_CP1124 },
    { "IBM-1129",                    &encode_CP1129 },
    { "IBM-1133",                    &encode_CP1133 },
    { "IBM-1162",                    &encode_CP1162 },
    { "IBM-1163",                    &encode_CP1163 },
    { "IBM-1167",                    &encode_CP1167 },
    { "IBM-4909",                    &encode_CP4909 },
    { "IBM-5347",                    &encode_CP5347 },
    { "IBM-901",                     &encode_CP901 },
    { "IBM-902",                     &encode_CP902 },
    { "IBM-921",                     &encode_ISO_8859_13 },
    { "IBM-922",                     &encode_CP922 },
    { "IBM-9448",                    &encode_CP1256 },
    { "IBM1004",                     &encode_CP1004 },
    { "IBM1008",                     &encode_CP1008 },
    { "IBM1046",                     &encode_1046 },
    { "IBM1089",                     &encode_ISO_8859_6 },
    { "IBM1124",                     &encode_CP1124 },
    { "IBM1129",                     &encode_CP1129 },
    { "IBM1133",                     &encode_CP1133 },
    { "IBM1162",                     &encode_CP1162 },
    { "IBM1163",                     &encode_CP1163 },
    { "IBM1167",                     &encode_CP1167 },
    { "IBM437",                      &encode_437 },
    { "IBM4909",                     &encode_CP4909 },
    { "IBM5347",                     &encode_CP5347 },
    { "IBM775",                      &encode_CP775 },
    { "IBM813",                      &encode_ISO_8859_7 },
    { "IBM819",                      &encode_ISO_8859_1 },
    { "IBM848",                      &encode_CP1125 },
    { "IBM850",                      &encode_850 },
    { "IBM851",                      &encode_851 },
    { "IBM852",                      &encode_852 },
    { "IBM855",                      &encode_855 },
    { "IBM857",                      &encode_857 },
    { "IBM860",                      &encode_860 },
    { "IBM861",                      &encode_861 },
    { "IBM862",                      &encode_862 },
    { "IBM863",                      &encode_863 },
    { "IBM865",                      &encode_865 },
    { "IBM866",                      &encode_866 },
    { "IBM866NAV",                   &encode_866NAV },
    { "IBM868",                      &encode_CP_AR },
    { "IBM869",                      &encode_869 },
    { "IBM874",                      &encode_874 },
    { "IBM901",                      &encode_CP901 },
    { "IBM902",                      &encode_CP902 },
    { "IBM912",                      &encode_ISO_8859_2 },
    { "IBM915",                      &encode_ISO_8859_5 },
    { "IBM916",                      &encode_ISO_8859_8 },
    { "IBM920",                      &encode_ISO_8859_9 },
    { "IBM921",                      &encode_ISO_8859_13 },
    { "IBM922",                      &encode_CP922 },
    { "IBM9448",                     &encode_CP1256 },
    { "IEC_P27-1",                   &encode_CSISO143IECP271 },
    { "IEC_P271",                    &encode_CSISO143IECP271 },
    { "ISIRI-3342",                  &encode_ISIRI_3342 },
    { "ISIRI3342",                   &encode_ISIRI_3342 },
    { "ISO-8859-1",                  &encode_ISO_8859_1 },
    { "ISO-8859-10",                 &encode_ISO_8859_10 },
    { "ISO-8859-11",                 &encode_HP_THAI8 },
    { "ISO-8859-13",                 &encode_ISO_8859_13 },
    { "ISO-8859-14",                 &encode_ISO_8859_14 },
    { "ISO-8859-15",                 &encode_ISO_8859_15 },
    { "ISO-8859-16",                 &encode_ISO_8859_16 },
    { "ISO-8859-2",                  &encode_ISO_8859_2 },
    { "ISO-8859-3",                  &encode_ISO_8859_3 },
    { "ISO-8859-4",                  &encode_8859_4 },
    { "ISO-8859-5",                  &encode_ISO_8859_5 },
    { "ISO-8859-6",                  &encode_ISO_8859_6 },
    { "ISO-8859-7",                  &encode_ISO_8859_7 },
    { "ISO-8859-8",                  &encode_ISO_8859_8 },
    { "ISO-8859-9",                  &encode_ISO_8859_9 },
    { "ISO-8859-9E",                 &encode_ISO_8859_9E },
    { "ISO-CELTIC",                  &encode_ISO_8859_14 },
    { "ISO-IR-100",                  &encode_ISO_8859_1 },
    { "ISO-IR-101",                  &encode_ISO_8859_2 },
    { "ISO-IR-103",                  &encode_CSISO103T618BIT },
    { "ISO-IR-109",                  &encode_ISO_8859_3 },
    { "ISO-IR-110",                  &encode_8859_4 },
    { "ISO-IR-111",                  &encode_CSISO111ECMACYRILLIC },
    { "ISO-IR-126",                  &encode_ISO_8859_7 },
    { "ISO-IR-127",                  &encode_ISO_8859_6 },
    { "ISO-IR-138",                  &encode_ISO_8859_8 },
    { "ISO-IR-143",                  &encode_CSISO143IECP271 },
    { "ISO-IR-144",                  &encode_ISO_8859_5 },
    { "ISO-IR-148",                  &encode_ISO_8859_9 },
    { "ISO-IR-153",                  &encode_CSISO153GOST1976874 },
    { "ISO-IR-156",                  &encode_ISO_IR_156 },
    { "ISO-IR-157",                  &encode_ISO_8859_10 },
    { "ISO-IR-166",                  &encode_TIS_620 },
    { "ISO-IR-179",                  &encode_ISO_8859_13 },
    { "ISO-IR-197",                  &encode_ISO_IR_197 },
    { "ISO-IR-199",                  &encode_ISO_8859_14 },
    { "ISO-IR-203",                  &encode_ISO_8859_15 },
    { "ISO-IR-209",                  &encode_ISO_IR_209 },
    { "ISO-IR-226",                  &encode_ISO_8859_16 },
    { "ISO-IR-99",                   &encode_ANSI_X3_110_1983 },
    { "ISO6937",                     &encode_ISO_IR_156 },
    { "ISO8859-1",                   &encode_ISO_8859_1 },
    { "ISO8859-10",                  &encode_ISO_8859_10 },
    { "ISO8859-11",                  &encode_HP_THAI8 },
    { "ISO8859-13",                  &encode_ISO_8859_13 },
    { "ISO8859-14",                  &encode_ISO_8859_14 },
    { "ISO8859-15",                  &encode_ISO_8859_15 },
    { "ISO8859-16",                  &encode_ISO_8859_16 },
    { "ISO8859-2",                   &encode_ISO_8859_2 },
    { "ISO8859-3",                   &encode_ISO_8859_3 },
    { "ISO8859-4",                   &encode_8859_4 },
    { "ISO8859-5",                   &encode_ISO_8859_5 },
    { "ISO8859-6",                   &encode_ISO_8859_6 },
    { "ISO8859-7",                   &encode_ISO_8859_7 },
    { "ISO8859-8",                   &encode_ISO_8859_8 },
    { "ISO8859-9",                   &encode_ISO_8859_9 },
    { "ISO8859-9E",                  &encode_ISO_8859_9E },
    { "ISO88591",                    &encode_ISO_8859_1 },
    { "ISO885910",                   &encode_ISO_8859_10 },
    { "ISO885911",                   &encode_HP_THAI8 },
    { "ISO885913",                   &encode_ISO_8859_13 },
    { "ISO885914",                   &encode_ISO_8859_14 },
    { "ISO885915",                   &encode_ISO_8859_15 },
    { "ISO885916",                   &encode_ISO_8859_16 },
    { "ISO88592",                    &encode_ISO_8859_2 },
    { "ISO88593",                    &encode_ISO_8859_3 },
    { "ISO88594",                    &encode_8859_4 },
    { "ISO88595",                    &encode_ISO_8859_5 },
    { "ISO88596",                    &encode_ISO_8859_6 },
    { "ISO88597",                    &encode_ISO_8859_7 },
    { "ISO88598",                    &encode_ISO_8859_8 },
    { "ISO88599",                    &encode_ISO_8859_9 },
    { "ISO88599E",                   &encode_ISO_8859_9E },
    { "ISO_6937",                    &encode_ISO_IR_156 },
    { "ISO_6937:1992",               &encode_ISO_IR_156 },
    { "ISO_8859-1",                  &encode_ISO_8859_1 },
    { "ISO_8859-10",                 &encode_ISO_8859_10 },
    { "ISO_8859-10:1992",            &encode_ISO_8859_10 },
    { "ISO_8859-14",                 &encode_ISO_8859_14 },
    { "ISO_8859-14:1998",            &encode_ISO_8859_14 },
    { "ISO_8859-15",                 &encode_ISO_8859_15 },
    { "ISO_8859-15:1998",            &encode_ISO_8859_15 },
    { "ISO_8859-16",                 &encode_ISO_8859_16 },
    { "ISO_8859-16:2001",            &encode_ISO_8859_16 },
    { "ISO_8859-1:1987",             &encode_ISO_8859_1 },
    { "ISO_8859-2",                  &encode_ISO_8859_2 },
    { "ISO_8859-2:1987",             &encode_ISO_8859_2 },
    { "ISO_8859-3",                  &encode_ISO_8859_3 },
    { "ISO_8859-3:1988",             &encode_ISO_8859_3 },
    { "ISO_8859-4",                  &encode_8859_4 },
    { "ISO_8859-4:1988",             &encode_8859_4 },
    { "ISO_8859-5",                  &encode_ISO_8859_5 },
    { "ISO_8859-5:1988",             &encode_ISO_8859_5 },
    { "ISO_8859-6",                  &encode_ISO_8859_6 },
    { "ISO_8859-6:1987",             &encode_ISO_8859_6 },
    { "ISO_8859-7",                  &encode_ISO_8859_7 },
    { "ISO_8859-7:1987",             &encode_ISO_8859_7 },
    { "ISO_8859-7:2003",             &encode_ISO_8859_7 },
    { "ISO_8859-8",                  &encode_ISO_8859_8 },
    { "ISO_8859-8:1988",             &encode_ISO_8859_8 },
    { "ISO_8859-9",                  &encode_ISO_8859_9 },
    { "ISO_8859-9:1989",             &encode_ISO_8859_9 },
    { "ISO_8859-9E",                 &encode_ISO_8859_9E },
    { "KOI8-R",                      &encode_KOI8_R },
    { "KOI8-RU",                     &encode_CP1167 },
    { "KOI8-T",                      &encode_KOI8_T },
    { "KOI8-U",                      &encode_KOI8_U },
    { "KOI8R",                       &encode_KOI8_R },
    { "KOI8U",                       &encode_KOI8_U },
    { "L1",                          &encode_ISO_8859_1 },
    { "L10",                         &encode_ISO_8859_16 },
    { "L2",                          &encode_ISO_8859_2 },
    { "L3",                          &encode_ISO_8859_3 },
    { "L4",                          &encode_8859_4 },
    { "L5",                          &encode_ISO_8859_9 },
    { "L6",                          &encode_ISO_8859_10 },
    { "L7",                          &encode_ISO_8859_13 },
    { "L8",                          &encode_ISO_8859_14 },
    { "LATIN-9",                     &encode_ISO_8859_15 },
    { "LATIN1",                      &encode_ISO_8859_1 },
    { "LATIN10",                     &encode_ISO_8859_16 },
    { "LATIN2",                      &encode_ISO_8859_2 },
    { "LATIN3",                      &encode_ISO_8859_3 },
    { "LATIN4",                      &encode_8859_4 },
    { "LATIN5",                      &encode_ISO_8859_9 },
    { "LATIN6",                      &encode_ISO_8859_10 },
    { "LATIN7",                      &encode_ISO_8859_13 },
    { "LATIN8",                      &encode_ISO_8859_14 },
    { "LATIN9",                      &encode_ISO_8859_15 },
    { "MAC",                         &encode_CSMACINTOSH },
    { "MAC-CENTRALEUROPE",           &encode_CP1282 },
    { "MAC-CYRILLIC",                &encode_MAC_CYRILLIC },
    { "MAC-IS",                      &encode_MAC_IS },
    { "MAC-SAMI",                    &encode_MAC_SAMI },
    { "MAC-UK",                      &encode_MAC_CYRILLIC },
    { "MACCYRILLIC",                 &encode_MAC_CYRILLIC },
    { "MACINTOSH",                   &encode_CSMACINTOSH },
    { "MACIS",                       &encode_MAC_IS },
    { "MACUK",                       &encode_MAC_CYRILLIC },
    { "MACUKRAINIAN",                &encode_MAC_CYRILLIC },
    { "MIK",                         &encode_MIK },
    { "MS-ANSI",                     &encode_CP1252 },
    { "MS-ARAB",                     &encode_CP1256 },
    { "MS-CYRL",                     &encode_CP1251 },
    { "MS-EE",                       &encode_CP1250 },
    { "MS-GREEK",                    &encode_CP1253 },
    { "MS-HEBR",                     &encode_CP1255 },
    { "MS-MAC-CYRILLIC",             &encode_CP10007 },
    { "MS-TURK",                     &encode_CP1254 },
    { "MSMACCYRILLIC",               &encode_CP10007 },
    { "NAPLPS",                      &encode_ANSI_X3_110_1983 },
    { "OS2LATIN1",                   &encode_CP1004 },
    { "OSF00010001",                 &encode_ISO_8859_1 },
    { "OSF00010002",                 &encode_ISO_8859_2 },
    { "OSF00010003",                 &encode_ISO_8859_3 },
    { "OSF00010004",                 &encode_8859_4 },
    { "OSF00010005",                 &encode_ISO_8859_5 },
    { "OSF00010006",                 &encode_ISO_8859_6 },
    { "OSF00010007",                 &encode_ISO_8859_7 },
    { "OSF00010008",                 &encode_ISO_8859_8 },
    { "OSF00010009",                 &encode_ISO_8859_9 },
    { "OSF0001000A",                 &encode_ISO_8859_10 },
    { "OSF10010001",                 &encode_CSHPROMAN8 },
    { "OSF10010004",                 &encode_HP_GREEK8 },
    { "OSF10010006",                 &encode_HP_TURKISH8 },
    { "OSF100201B5",                 &encode_437 },
    { "OSF10020352",                 &encode_850 },
    { "OSF10020354",                 &encode_852 },
    { "OSF10020357",                 &encode_855 },
    { "OSF10020359",                 &encode_857 },
    { "OSF1002035D",                 &encode_861 },
    { "OSF1002035E",                 &encode_862 },
    { "OSF1002035F",                 &encode_863 },
    { "OSF10020364",                 &encode_CP_AR },
    { "OSF10020365",                 &encode_869 },
    { "PT154",                       &encode_PT154 },
    { "R8",                          &encode_CSHPROMAN8 },
    { "R9",                          &encode_HP_ROMAN9 },
    { "RK1048",                      &encode_RK1048 },
    { "ROMAN8",                      &encode_CSHPROMAN8 },
    { "ROMAN9",                      &encode_HP_ROMAN9 },
    { "RUSCII",                      &encode_CP1125 },
    { "STRK1048-2002",               &encode_RK1048 },
    { "ST_SEV_358-88",               &encode_CSISO153GOST1976874 },
    { "T.61",                        &encode_CSISO103T618BIT },
    { "T.61-8BIT",                   &encode_CSISO103T618BIT },
    { "T.618BIT",                    &encode_CSISO103T618BIT },
    { "THAI8",                       &encode_HP_THAI8 },
    { "TIS-620",                     &encode_TIS_620 },
    { "TIS620",                      &encode_TIS_620 },
    { "TIS620-0",                    &encode_TIS_620 },
    { "TIS620.2529-1",               &encode_TIS_620 },
    { "TIS620.2533-0",               &encode_TIS_620 },
    { "TS-5881",                     &encode_ISO_8859_9 },
    { "TSCII",                       &encode_TSCII },
    { "TURKISH8",                    &encode_HP_TURKISH8 },
    { "WIN-SAMI-2",                  &encode_WIN_SAMI_2 },
    { "WINBALTRIM",                  &encode_CP1257 },
    { "WINDOWS-1250",                &encode_CP1250 },
    { "WINDOWS-1251",                &encode_CP1251 },
    { "WINDOWS-1252",                &encode_CP1252 },
    { "WINDOWS-1253",                &encode_CP1253 },
    { "WINDOWS-1254",                &encode_CP1254 },
    { "WINDOWS-1255",                &encode_CP1255 },
    { "WINDOWS-1256",                &encode_CP1256 },
    { "WINDOWS-1257",                &encode_CP1257 },
    { "WINDOWS-874",                 &encode_874 },
    { "WINSAMI2",                    &encode_WIN_SAMI_2 },
    { "WS2",                         &encode_WIN_SAMI_2 },
    { 0, 0 }
};

/* Sorted aliases */
static const GNREIGHT_INX all_locales[] = {
    { "C",                           &encode_ANSI_X3_4_1968 },
    { "POSIX",                       &encode_ANSI_X3_4_1968 },
    { "aa_DJ",                       &encode_ISO_8859_1 },
    { "aa_DJ.iso88591",              &encode_ISO_8859_1 },
    { "af_ZA",                       &encode_ISO_8859_1 },
    { "af_ZA.iso88591",              &encode_ISO_8859_1 },
    { "an_ES",                       &encode_ISO_8859_15 },
    { "an_ES.iso885915",             &encode_ISO_8859_15 },
    { "ar_AE",                       &encode_ISO_8859_6 },
    { "ar_AE.iso88596",              &encode_ISO_8859_6 },
    { "ar_BH",                       &encode_ISO_8859_6 },
    { "ar_BH.iso88596",              &encode_ISO_8859_6 },
    { "ar_DZ",                       &encode_ISO_8859_6 },
    { "ar_DZ.iso88596",              &encode_ISO_8859_6 },
    { "ar_EG",                       &encode_ISO_8859_6 },
    { "ar_EG.iso88596",              &encode_ISO_8859_6 },
    { "ar_IQ",                       &encode_ISO_8859_6 },
    { "ar_IQ.iso88596",              &encode_ISO_8859_6 },
    { "ar_JO",                       &encode_ISO_8859_6 },
    { "ar_JO.iso88596",              &encode_ISO_8859_6 },
    { "ar_KW",                       &encode_ISO_8859_6 },
    { "ar_KW.iso88596",              &encode_ISO_8859_6 },
    { "ar_LB",                       &encode_ISO_8859_6 },
    { "ar_LB.iso88596",              &encode_ISO_8859_6 },
    { "ar_LY",                       &encode_ISO_8859_6 },
    { "ar_LY.iso88596",              &encode_ISO_8859_6 },
    { "ar_MA",                       &encode_ISO_8859_6 },
    { "ar_MA.iso88596",              &encode_ISO_8859_6 },
    { "ar_OM",                       &encode_ISO_8859_6 },
    { "ar_OM.iso88596",              &encode_ISO_8859_6 },
    { "ar_QA",                       &encode_ISO_8859_6 },
    { "ar_QA.iso88596",              &encode_ISO_8859_6 },
    { "ar_SA",                       &encode_ISO_8859_6 },
    { "ar_SA.iso88596",              &encode_ISO_8859_6 },
    { "ar_SD",                       &encode_ISO_8859_6 },
    { "ar_SD.iso88596",              &encode_ISO_8859_6 },
    { "ar_SY",                       &encode_ISO_8859_6 },
    { "ar_SY.iso88596",              &encode_ISO_8859_6 },
    { "ar_TN",                       &encode_ISO_8859_6 },
    { "ar_TN.iso88596",              &encode_ISO_8859_6 },
    { "ar_YE",                       &encode_ISO_8859_6 },
    { "ar_YE.iso88596",              &encode_ISO_8859_6 },
    { "ast_ES",                      &encode_ISO_8859_15 },
    { "ast_ES.iso885915",            &encode_ISO_8859_15 },
    { "be_BY",                       &encode_CP1251 },
    { "be_BY.cp1251",                &encode_CP1251 },
    { "bg_BG",                       &encode_CP1251 },
    { "bg_BG.cp1251",                &encode_CP1251 },
    { "bokmal",                      &encode_ISO_8859_1 },
    { "bokm\303\245l",               &encode_ISO_8859_1 },
    { "br_FR",                       &encode_ISO_8859_1 },
    { "br_FR.iso88591",              &encode_ISO_8859_1 },
    { "br_FR.iso885915@euro",        &encode_ISO_8859_15 },
    { "br_FR@euro",                  &encode_ISO_8859_15 },
    { "bs_BA",                       &encode_ISO_8859_2 },
    { "bs_BA.iso88592",              &encode_ISO_8859_2 },
    { "ca_AD",                       &encode_ISO_8859_15 },
    { "ca_AD.iso885915",             &encode_ISO_8859_15 },
    { "ca_ES",                       &encode_ISO_8859_1 },
    { "ca_ES.iso88591",              &encode_ISO_8859_1 },
    { "ca_ES.iso885915@euro",        &encode_ISO_8859_15 },
    { "ca_ES.iso885915@valencia",    &encode_ISO_8859_15 },
    { "ca_ES@euro",                  &encode_ISO_8859_15 },
    { "ca_ES@valencia",              &encode_ISO_8859_15 },
    { "ca_FR",                       &encode_ISO_8859_15 },
    { "ca_FR.iso885915",             &encode_ISO_8859_15 },
    { "ca_IT",                       &encode_ISO_8859_15 },
    { "ca_IT.iso885915",             &encode_ISO_8859_15 },
    { "catalan",                     &encode_ISO_8859_1 },
    { "croatian",                    &encode_ISO_8859_2 },
    { "cs_CZ",                       &encode_ISO_8859_2 },
    { "cs_CZ.iso88592",              &encode_ISO_8859_2 },
    { "cy_GB",                       &encode_ISO_8859_14 },
    { "cy_GB.iso885914",             &encode_ISO_8859_14 },
    { "czech",                       &encode_ISO_8859_2 },
    { "da_DK",                       &encode_ISO_8859_1 },
    { "da_DK.iso88591",              &encode_ISO_8859_1 },
    { "danish",                      &encode_ISO_8859_1 },
    { "dansk",                       &encode_ISO_8859_1 },
    { "de_AT",                       &encode_ISO_8859_1 },
    { "de_AT.iso88591",              &encode_ISO_8859_1 },
    { "de_AT.iso885915@euro",        &encode_ISO_8859_15 },
    { "de_AT@euro",                  &encode_ISO_8859_15 },
    { "de_BE",                       &encode_ISO_8859_1 },
    { "de_BE.iso88591",              &encode_ISO_8859_1 },
    { "de_BE.iso885915@euro",        &encode_ISO_8859_15 },
    { "de_BE@euro",                  &encode_ISO_8859_15 },
    { "de_CH",                       &encode_ISO_8859_1 },
    { "de_CH.iso88591",              &encode_ISO_8859_1 },
    { "de_DE",                       &encode_ISO_8859_1 },
    { "de_DE.iso88591",              &encode_ISO_8859_1 },
    { "de_DE.iso885915@euro",        &encode_ISO_8859_15 },
    { "de_DE@euro",                  &encode_ISO_8859_15 },
    { "de_LU",                       &encode_ISO_8859_1 },
    { "de_LU.iso88591",              &encode_ISO_8859_1 },
    { "de_LU.iso885915@euro",        &encode_ISO_8859_15 },
    { "de_LU@euro",                  &encode_ISO_8859_15 },
    { "deutsch",                     &encode_ISO_8859_1 },
    { "dutch",                       &encode_ISO_8859_1 },
    { "eesti",                       &encode_ISO_8859_15 },
    { "el_CY",                       &encode_ISO_8859_7 },
    { "el_CY.iso88597",              &encode_ISO_8859_7 },
    { "el_GR",                       &encode_ISO_8859_7 },
    { "el_GR.iso88597",              &encode_ISO_8859_7 },
    { "en_AU",                       &encode_ISO_8859_1 },
    { "en_AU.iso88591",              &encode_ISO_8859_1 },
    { "en_BW",                       &encode_ISO_8859_1 },
    { "en_BW.iso88591",              &encode_ISO_8859_1 },
    { "en_CA",                       &encode_ISO_8859_1 },
    { "en_CA.iso88591",              &encode_ISO_8859_1 },
    { "en_DK",                       &encode_ISO_8859_1 },
    { "en_DK.iso88591",              &encode_ISO_8859_1 },
    { "en_DK.iso885915",             &encode_ISO_8859_15 },
    { "en_GB",                       &encode_ISO_8859_1 },
    { "en_GB.iso88591",              &encode_ISO_8859_1 },
    { "en_GB.iso885915",             &encode_ISO_8859_15 },
    { "en_HK",                       &encode_ISO_8859_1 },
    { "en_HK.iso88591",              &encode_ISO_8859_1 },
    { "en_IE",                       &encode_ISO_8859_1 },
    { "en_IE.iso88591",              &encode_ISO_8859_1 },
    { "en_IE.iso885915@euro",        &encode_ISO_8859_15 },
    { "en_IE@euro",                  &encode_ISO_8859_15 },
    { "en_NZ",                       &encode_ISO_8859_1 },
    { "en_NZ.iso88591",              &encode_ISO_8859_1 },
    { "en_PH",                       &encode_ISO_8859_1 },
    { "en_PH.iso88591",              &encode_ISO_8859_1 },
    { "en_SG",                       &encode_ISO_8859_1 },
    { "en_SG.iso88591",              &encode_ISO_8859_1 },
    { "en_US",                       &encode_ISO_8859_1 },
    { "en_US.iso88591",              &encode_ISO_8859_1 },
    { "en_US.iso885915",             &encode_ISO_8859_15 },
    { "en_ZA",                       &encode_ISO_8859_1 },
    { "en_ZA.iso88591",              &encode_ISO_8859_1 },
    { "en_ZW",                       &encode_ISO_8859_1 },
    { "en_ZW.iso88591",              &encode_ISO_8859_1 },
    { "eo",                          &encode_ISO_8859_3 },
    { "eo.iso88593",                 &encode_ISO_8859_3 },
    { "es_AR",                       &encode_ISO_8859_1 },
    { "es_AR.iso88591",              &encode_ISO_8859_1 },
    { "es_BO",                       &encode_ISO_8859_1 },
    { "es_BO.iso88591",              &encode_ISO_8859_1 },
    { "es_CL",                       &encode_ISO_8859_1 },
    { "es_CL.iso88591",              &encode_ISO_8859_1 },
    { "es_CO",                       &encode_ISO_8859_1 },
    { "es_CO.iso88591",              &encode_ISO_8859_1 },
    { "es_CR",                       &encode_ISO_8859_1 },
    { "es_CR.iso88591",              &encode_ISO_8859_1 },
    { "es_DO",                       &encode_ISO_8859_1 },
    { "es_DO.iso88591",              &encode_ISO_8859_1 },
    { "es_EC",                       &encode_ISO_8859_1 },
    { "es_EC.iso88591",              &encode_ISO_8859_1 },
    { "es_ES",                       &encode_ISO_8859_1 },
    { "es_ES.iso88591",              &encode_ISO_8859_1 },
    { "es_ES.iso885915@euro",        &encode_ISO_8859_15 },
    { "es_ES@euro",                  &encode_ISO_8859_15 },
    { "es_GT",                       &encode_ISO_8859_1 },
    { "es_GT.iso88591",              &encode_ISO_8859_1 },
    { "es_HN",                       &encode_ISO_8859_1 },
    { "es_HN.iso88591",              &encode_ISO_8859_1 },
    { "es_MX",                       &encode_ISO_8859_1 },
    { "es_MX.iso88591",              &encode_ISO_8859_1 },
    { "es_NI",                       &encode_ISO_8859_1 },
    { "es_NI.iso88591",              &encode_ISO_8859_1 },
    { "es_PA",                       &encode_ISO_8859_1 },
    { "es_PA.iso88591",              &encode_ISO_8859_1 },
    { "es_PE",                       &encode_ISO_8859_1 },
    { "es_PE.iso88591",              &encode_ISO_8859_1 },
    { "es_PR",                       &encode_ISO_8859_1 },
    { "es_PR.iso88591",              &encode_ISO_8859_1 },
    { "es_PY",                       &encode_ISO_8859_1 },
    { "es_PY.iso88591",              &encode_ISO_8859_1 },
    { "es_SV",                       &encode_ISO_8859_1 },
    { "es_SV.iso88591",              &encode_ISO_8859_1 },
    { "es_US",                       &encode_ISO_8859_1 },
    { "es_US.iso88591",              &encode_ISO_8859_1 },
    { "es_UY",                       &encode_ISO_8859_1 },
    { "es_UY.iso88591",              &encode_ISO_8859_1 },
    { "es_VE",                       &encode_ISO_8859_1 },
    { "es_VE.iso88591",              &encode_ISO_8859_1 },
    { "estonian",                    &encode_ISO_8859_15 },
    { "et_EE",                       &encode_ISO_8859_1 },
    { "et_EE.iso88591",              &encode_ISO_8859_1 },
    { "et_EE.iso885915",             &encode_ISO_8859_15 },
    { "eu_ES",                       &encode_ISO_8859_1 },
    { "eu_ES.iso88591",              &encode_ISO_8859_1 },
    { "eu_ES.iso885915@euro",        &encode_ISO_8859_15 },
    { "eu_ES@euro",                  &encode_ISO_8859_15 },
    { "eu_FR",                       &encode_ISO_8859_1 },
    { "eu_FR.iso88591",              &encode_ISO_8859_1 },
    { "eu_FR.iso885915@euro",        &encode_ISO_8859_15 },
    { "eu_FR@euro",                  &encode_ISO_8859_15 },
    { "fi_FI",                       &encode_ISO_8859_1 },
    { "fi_FI.iso88591",              &encode_ISO_8859_1 },
    { "fi_FI.iso885915@euro",        &encode_ISO_8859_15 },
    { "fi_FI@euro",                  &encode_ISO_8859_15 },
    { "finnish",                     &encode_ISO_8859_1 },
    { "fo_FO",                       &encode_ISO_8859_1 },
    { "fo_FO.iso88591",              &encode_ISO_8859_1 },
    { "fr_BE",                       &encode_ISO_8859_1 },
    { "fr_BE.iso88591",              &encode_ISO_8859_1 },
    { "fr_BE.iso885915@euro",        &encode_ISO_8859_15 },
    { "fr_BE@euro",                  &encode_ISO_8859_15 },
    { "fr_CA",                       &encode_ISO_8859_1 },
    { "fr_CA.iso88591",              &encode_ISO_8859_1 },
    { "fr_CH",                       &encode_ISO_8859_1 },
    { "fr_CH.iso88591",              &encode_ISO_8859_1 },
    { "fr_FR",                       &encode_ISO_8859_1 },
    { "fr_FR.iso88591",              &encode_ISO_8859_1 },
    { "fr_FR.iso885915@euro",        &encode_ISO_8859_15 },
    { "fr_FR@euro",                  &encode_ISO_8859_15 },
    { "fr_LU",                       &encode_ISO_8859_1 },
    { "fr_LU.iso88591",              &encode_ISO_8859_1 },
    { "fr_LU.iso885915@euro",        &encode_ISO_8859_15 },
    { "fr_LU@euro",                  &encode_ISO_8859_15 },
    { "fran\303\247ais",             &encode_ISO_8859_1 },
    { "french",                      &encode_ISO_8859_1 },
    { "ga_IE",                       &encode_ISO_8859_1 },
    { "ga_IE.iso88591",              &encode_ISO_8859_1 },
    { "ga_IE.iso885915@euro",        &encode_ISO_8859_15 },
    { "ga_IE@euro",                  &encode_ISO_8859_15 },
    { "galego",                      &encode_ISO_8859_1 },
    { "galician",                    &encode_ISO_8859_1 },
    { "gd_GB",                       &encode_ISO_8859_15 },
    { "gd_GB.iso885915",             &encode_ISO_8859_15 },
    { "german",                      &encode_ISO_8859_1 },
    { "gl_ES",                       &encode_ISO_8859_1 },
    { "gl_ES.iso88591",              &encode_ISO_8859_1 },
    { "gl_ES.iso885915@euro",        &encode_ISO_8859_15 },
    { "gl_ES@euro",                  &encode_ISO_8859_15 },
    { "greek",                       &encode_ISO_8859_7 },
    { "gv_GB",                       &encode_ISO_8859_1 },
    { "gv_GB.iso88591",              &encode_ISO_8859_1 },
    { "he_IL",                       &encode_ISO_8859_8 },
    { "he_IL.iso88598",              &encode_ISO_8859_8 },
    { "hebrew",                      &encode_ISO_8859_8 },
    { "hr_HR",                       &encode_ISO_8859_2 },
    { "hr_HR.iso88592",              &encode_ISO_8859_2 },
    { "hrvatski",                    &encode_ISO_8859_2 },
    { "hsb_DE",                      &encode_ISO_8859_2 },
    { "hsb_DE.iso88592",             &encode_ISO_8859_2 },
    { "hu_HU",                       &encode_ISO_8859_2 },
    { "hu_HU.iso88592",              &encode_ISO_8859_2 },
    { "hungarian",                   &encode_ISO_8859_2 },
    { "hy_AM.armscii8",              &encode_ARMSCII_8 },
    { "icelandic",                   &encode_ISO_8859_1 },
    { "id_ID",                       &encode_ISO_8859_1 },
    { "id_ID.iso88591",              &encode_ISO_8859_1 },
    { "is_IS",                       &encode_ISO_8859_1 },
    { "is_IS.iso88591",              &encode_ISO_8859_1 },
    { "it_CH",                       &encode_ISO_8859_1 },
    { "it_CH.iso88591",              &encode_ISO_8859_1 },
    { "it_IT",                       &encode_ISO_8859_1 },
    { "it_IT.iso88591",              &encode_ISO_8859_1 },
    { "it_IT.iso885915@euro",        &encode_ISO_8859_15 },
    { "it_IT@euro",                  &encode_ISO_8859_15 },
    { "italian",                     &encode_ISO_8859_1 },
    { "iw_IL",                       &encode_ISO_8859_8 },
    { "iw_IL.iso88598",              &encode_ISO_8859_8 },
    { "ka_GE",                       &encode_GEORGIAN_PS },
    { "ka_GE.georgianps",            &encode_GEORGIAN_PS },
    { "kk_KZ",                       &encode_RK1048 },
    { "kk_KZ.pt154",                 &encode_RK1048 },
    { "kk_KZ.rk1048",                &encode_RK1048 },
    { "kl_GL",                       &encode_ISO_8859_1 },
    { "kl_GL.iso88591",              &encode_ISO_8859_1 },
    { "ku_TR",                       &encode_ISO_8859_9 },
    { "ku_TR.iso88599",              &encode_ISO_8859_9 },
    { "kw_GB",                       &encode_ISO_8859_1 },
    { "kw_GB.iso88591",              &encode_ISO_8859_1 },
    { "lg_UG",                       &encode_ISO_8859_10 },
    { "lg_UG.iso885910",             &encode_ISO_8859_10 },
    { "lithuanian",                  &encode_ISO_8859_13 },
    { "lt_LT",                       &encode_ISO_8859_13 },
    { "lt_LT.iso885913",             &encode_ISO_8859_13 },
    { "lv_LV",                       &encode_ISO_8859_13 },
    { "lv_LV.iso885913",             &encode_ISO_8859_13 },
    { "mg_MG",                       &encode_ISO_8859_15 },
    { "mg_MG.iso885915",             &encode_ISO_8859_15 },
    { "mi_NZ",                       &encode_ISO_8859_13 },
    { "mi_NZ.iso885913",             &encode_ISO_8859_13 },
    { "mk_MK",                       &encode_ISO_8859_5 },
    { "mk_MK.iso88595",              &encode_ISO_8859_5 },
    { "ms_MY",                       &encode_ISO_8859_1 },
    { "ms_MY.iso88591",              &encode_ISO_8859_1 },
    { "mt_MT",                       &encode_ISO_8859_3 },
    { "mt_MT.iso88593",              &encode_ISO_8859_3 },
    { "nb_NO",                       &encode_ISO_8859_1 },
    { "nb_NO.iso88591",              &encode_ISO_8859_1 },
    { "nl_BE",                       &encode_ISO_8859_1 },
    { "nl_BE.iso88591",              &encode_ISO_8859_1 },
    { "nl_BE.iso885915@euro",        &encode_ISO_8859_15 },
    { "nl_BE@euro",                  &encode_ISO_8859_15 },
    { "nl_NL",                       &encode_ISO_8859_1 },
    { "nl_NL.iso88591",              &encode_ISO_8859_1 },
    { "nl_NL.iso885915@euro",        &encode_ISO_8859_15 },
    { "nl_NL@euro",                  &encode_ISO_8859_15 },
    { "nn_NO",                       &encode_ISO_8859_1 },
    { "nn_NO.iso88591",              &encode_ISO_8859_1 },
    { "no_NO",                       &encode_ISO_8859_1 },
    { "norwegian",                   &encode_ISO_8859_1 },
    { "nynorsk",                     &encode_ISO_8859_1 },
    { "oc_FR",                       &encode_ISO_8859_1 },
    { "oc_FR.iso88591",              &encode_ISO_8859_1 },
    { "om_KE",                       &encode_ISO_8859_1 },
    { "om_KE.iso88591",              &encode_ISO_8859_1 },
    { "pl_PL",                       &encode_ISO_8859_2 },
    { "pl_PL.iso88592",              &encode_ISO_8859_2 },
    { "polish",                      &encode_ISO_8859_2 },
    { "portuguese",                  &encode_ISO_8859_1 },
    { "pt_BR",                       &encode_ISO_8859_1 },
    { "pt_BR.iso88591",              &encode_ISO_8859_1 },
    { "pt_PT",                       &encode_ISO_8859_1 },
    { "pt_PT.iso88591",              &encode_ISO_8859_1 },
    { "pt_PT.iso885915@euro",        &encode_ISO_8859_15 },
    { "pt_PT@euro",                  &encode_ISO_8859_15 },
    { "ro_RO",                       &encode_ISO_8859_2 },
    { "ro_RO.iso88592",              &encode_ISO_8859_2 },
    { "romanian",                    &encode_ISO_8859_2 },
    { "ru_RU",                       &encode_ISO_8859_5 },
    { "ru_RU.cp1251",                &encode_CP1251 },
    { "ru_RU.iso88595",              &encode_ISO_8859_5 },
    { "ru_RU.koi8r",                 &encode_KOI8_R },
    { "ru_UA",                       &encode_KOI8_U },
    { "ru_UA.koi8u",                 &encode_KOI8_U },
    { "russian",                     &encode_KOI8_R },
    { "sk_SK",                       &encode_ISO_8859_2 },
    { "sk_SK.iso88592",              &encode_ISO_8859_2 },
    { "sl_SI",                       &encode_ISO_8859_2 },
    { "sl_SI.iso88592",              &encode_ISO_8859_2 },
    { "slovak",                      &encode_ISO_8859_2 },
    { "slovene",                     &encode_ISO_8859_2 },
    { "slovenian",                   &encode_ISO_8859_2 },
    { "so_DJ",                       &encode_ISO_8859_1 },
    { "so_DJ.iso88591",              &encode_ISO_8859_1 },
    { "so_KE",                       &encode_ISO_8859_1 },
    { "so_KE.iso88591",              &encode_ISO_8859_1 },
    { "so_SO",                       &encode_ISO_8859_1 },
    { "so_SO.iso88591",              &encode_ISO_8859_1 },
    { "spanish",                     &encode_ISO_8859_1 },
    { "sq_AL",                       &encode_ISO_8859_1 },
    { "sq_AL.iso88591",              &encode_ISO_8859_1 },
    { "st_ZA",                       &encode_ISO_8859_1 },
    { "st_ZA.iso88591",              &encode_ISO_8859_1 },
    { "sv_FI",                       &encode_ISO_8859_1 },
    { "sv_FI.iso88591",              &encode_ISO_8859_1 },
    { "sv_FI.iso885915@euro",        &encode_ISO_8859_15 },
    { "sv_FI@euro",                  &encode_ISO_8859_15 },
    { "sv_SE",                       &encode_ISO_8859_1 },
    { "sv_SE.iso88591",              &encode_ISO_8859_1 },
    { "sv_SE.iso885915",             &encode_ISO_8859_15 },
    { "swedish",                     &encode_ISO_8859_1 },
    { "tg_TJ",                       &encode_KOI8_T },
    { "tg_TJ.koi8t",                 &encode_KOI8_T },
    { "th_TH",                       &encode_TIS_620 },
    { "th_TH.tis620",                &encode_TIS_620 },
    { "thai",                        &encode_TIS_620 },
    { "tl_PH",                       &encode_ISO_8859_1 },
    { "tl_PH.iso88591",              &encode_ISO_8859_1 },
    { "tr_CY",                       &encode_ISO_8859_9 },
    { "tr_CY.iso88599",              &encode_ISO_8859_9 },
    { "tr_TR",                       &encode_ISO_8859_9 },
    { "tr_TR.iso88599",              &encode_ISO_8859_9 },
    { "turkish",                     &encode_ISO_8859_9 },
    { "uk_UA",                       &encode_KOI8_U },
    { "uk_UA.koi8u",                 &encode_KOI8_U },
    { "uz_UZ",                       &encode_ISO_8859_1 },
    { "uz_UZ.iso88591",              &encode_ISO_8859_1 },
    { "wa_BE",                       &encode_ISO_8859_1 },
    { "wa_BE.iso88591",              &encode_ISO_8859_1 },
    { "wa_BE.iso885915@euro",        &encode_ISO_8859_15 },
    { "wa_BE@euro",                  &encode_ISO_8859_15 },
    { "xh_ZA",                       &encode_ISO_8859_1 },
    { "xh_ZA.iso88591",              &encode_ISO_8859_1 },
    { "yi_US",                       &encode_CP1255 },
    { "yi_US.cp1255",                &encode_CP1255 },
    { "zu_ZA",                       &encode_ISO_8859_1 },
    { "zu_ZA.iso88591",              &encode_ISO_8859_1 },
    { 0, 0 }
};
/* *INDENT-ON* */

#endif /* GNREIGHT_H */
