/*
	This file is part of Warzone 2100.
	Copyright (C) 2005-2015  Warzone 2100 Project

	Warzone 2100 is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Warzone 2100 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Warzone 2100; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

#line 2 "script_lexer.cpp"

#line 4 "script_lexer.cpp"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer scr__create_buffer
#define yy_delete_buffer scr__delete_buffer
#define yy_flex_debug scr__flex_debug
#define yy_init_buffer scr__init_buffer
#define yy_flush_buffer scr__flush_buffer
#define yy_load_buffer_state scr__load_buffer_state
#define yy_switch_to_buffer scr__switch_to_buffer
#define yyin scr_in
#define yyleng scr_leng
#define yylex scr_lex
#define yylineno scr_lineno
#define yyout scr_out
#define yyrestart scr_restart
#define yytext scr_text
#define yywrap scr_wrap
#define yyalloc scr_alloc
#define yyrealloc scr_realloc
#define yyfree scr_free

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */
#include "lib/framework/frame.h"
/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types.
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE scr_restart(scr_in  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int scr_leng;

extern FILE *scr_in, *scr_out;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE scr_lex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-scr_lineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < scr_leng; ++yyl )\
                    if ( scr_text[yyl] == '\n' )\
                        --scr_lineno;\
            }while(0)

/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up scr_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up scr_text again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via scr_restart()), so that the user can continue scanning by
	 * just pointing scr_in at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when scr_text is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int scr_leng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow scr_wrap()'s to do buffer switches
 * instead of setting up a fresh scr_in.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void scr_restart (FILE *input_file  );
void scr__switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE scr__create_buffer (FILE *file,int size  );
void scr__delete_buffer (YY_BUFFER_STATE b  );
void scr__flush_buffer (YY_BUFFER_STATE b  );
void scr_push_buffer_state (YY_BUFFER_STATE new_buffer  );
void scr_pop_buffer_state (void );

static void scr_ensure_buffer_stack (void );
static void scr__load_buffer_state (void );
static void scr__init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER scr__flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE scr__scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE scr__scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE scr__scan_bytes (yyconst char *bytes,int len  );

void *scr_alloc (yy_size_t  );
void *scr_realloc (void *,yy_size_t  );
void scr_free (void *  );

#define yy_new_buffer scr__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        scr_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            scr__create_buffer(scr_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        scr_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            scr__create_buffer(scr_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *scr_in = (FILE *) 0, *scr_out = (FILE *) 0;

typedef int yy_state_type;

extern int scr_lineno;

int scr_lineno = 1;

extern char *scr_text;
#define yytext_ptr scr_text

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up scr_text.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	scr_leng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 65
#define YY_END_OF_BUFFER 66
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[251] =
    {   0,
        0,    0,    0,    0,   63,   63,   54,   54,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   42,   42,
       66,   64,   55,   55,   38,   52,   49,   64,   64,   64,
       64,   64,   64,   47,   35,   64,   34,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   64,   59,   60,   59,   63,   62,   54,   65,   53,
       51,   50,   44,   45,   40,   41,   42,   31,    0,    0,
       36,    0,    0,    0,    0,   28,   29,    0,   47,   46,
       56,   61,   33,   30,   32,   48,   48,   48,   48,   48,

       48,   48,   37,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   17,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   37,   57,
       63,   54,   44,   40,   41,   42,    0,    0,    0,    0,
        0,    0,   36,   48,   48,   48,   24,   38,   48,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,   48,   48,   48,    8,   48,   48,   48,   48,
       48,   48,   48,   58,    0,    0,    0,    0,    0,    0,
       23,   48,   48,   48,   26,   21,   18,   48,   48,   19,
       48,   48,   48,   48,    6,    7,   48,   48,   48,   48,

       48,   48,   48,    1,   48,    0,    0,    0,   11,    0,
       27,   25,   48,    4,    2,   48,   48,   15,   20,   48,
       48,   48,   48,   48,   16,    0,    0,    0,    0,   22,
       48,   48,   48,   13,    9,   48,    0,    0,   12,   48,
       48,   14,    3,   39,    0,   10,    5,    0,   43,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    1,    1,    8,    1,    9,
       10,   11,   12,    1,   13,   14,   15,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,    1,    1,   17,
       18,   19,    1,    1,   20,   21,   22,   23,   24,   25,
       26,   22,   27,   22,   22,   28,   22,   29,   30,   22,
       22,   31,   32,   33,   34,   35,   22,   22,   22,   22,
        1,    1,    1,    1,   22,    1,   36,   37,   38,   39,

       40,   41,   42,   43,   44,   22,   45,   46,   22,   47,
       48,   49,   22,   50,   51,   52,   53,   54,   55,   56,
       57,   22,    1,   58,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[59] =
    {   0,
        1,    2,    3,    4,    1,    5,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    6,    1,    1,    1,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    1
    } ;

static yyconst flex_int16_t yy_base[265] =
    {   0,
        0,    0,   56,   57,  375,  374,   58,   59,  373,  372,
       67,   69,  368,  367,   75,  133,  370,  369,   92,   94,
      370,  379,  379,  379,  351,  379,   60,  360,   75,  355,
       92,  350,   92,   95,  347,  346,  345,  333,  331,    0,
       46,  331,  329,  327,  324,  325,  325,  307,  305,   64,
       76,   74,   69,  304,  301,   78,  310,  297,  298,  299,
       87,  288,  379,  379,  330,    0,  379,    0,  379,  379,
      379,  379,    0,  379,    0,  342,    0,  379,  303,  295,
      379,  313,  311,  293,  291,  379,  379,  321,  110,  320,
      379,  379,  379,  379,  379,    0,  312,  304,  305,  302,

      298,  297,    0,  298,  294,  300,  287,  277,  273,  283,
      278,  275,  272,  272,    0,  117,  271,  279,  264,  262,
      270,  276,  113,  262,  111,  267,  266,  265,  379,  305,
        0,    0,    0,    0,  305,    0,  265,  267,  274,  270,
      254,  249,    0,  272,  267,  278,    0,    0,  270,  272,
      272,  248,  253,  109,  240,  240,  254,  251,  250,  235,
      241,  249,  233,  229,  236,    0,  228,  236,  237,  238,
      238,  224,  229,  379,  230,  227,  252,  261,  234,  259,
        0,  244,  234,  237,    0,    0,    0,  213,  207,    0,
      221,  208,  204,  202,    0,    0,  207,  210,  212,  198,

      140,  142,  146,    0,  147,  139,  132,  151,  379,  131,
        0,    0,  156,    0,    0,  137,  136,    0,    0,  127,
      140,  130,  134,  135,    0,  134,  134,  162,  161,    0,
      122,  114,  127,    0,    0,  116,  161,  120,  379,  110,
       92,    0,    0,  125,  123,    0,    0,  156,  379,  379,
      191,  197,  203,  209,  215,  221,  227,  233,   95,  239,
      245,  251,   57,  257
    } ;

static yyconst flex_int16_t yy_def[265] =
    {   0,
      250,    1,  251,  251,  252,  252,  253,  253,  254,  254,
      255,  255,  256,  256,  257,  257,  256,  256,  258,  258,
      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
      250,  250,  250,  250,  250,  250,  250,  259,  259,  259,
      259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
      259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
      259,  250,  250,  250,  250,  260,  250,  261,  250,  250,
      250,  250,  262,  250,  263,  250,  264,  250,  250,  250,
      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
      250,  250,  250,  250,  250,  259,  259,  259,  259,  259,

      259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
      259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
      259,  259,  259,  259,  259,  259,  259,  259,  250,  250,
      260,  261,  262,  263,  250,  264,  250,  250,  250,  250,
      250,  250,  259,  259,  259,  259,  259,  259,  259,  259,
      259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
      259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
      259,  259,  259,  250,  250,  250,  250,  250,  250,  250,
      259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
      259,  259,  259,  259,  259,  259,  259,  259,  259,  259,

      259,  259,  259,  259,  259,  250,  250,  250,  250,  250,
      259,  259,  259,  259,  259,  259,  259,  259,  259,  259,
      259,  259,  259,  259,  259,  250,  250,  250,  250,  259,
      259,  259,  259,  259,  259,  259,  250,  250,  250,  259,
      259,  259,  259,  250,  250,  259,  259,  250,  250,    0,
      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
      250,  250,  250,  250
    } ;

static yyconst flex_int16_t yy_nxt[438] =
    {   0,
       22,   23,   24,   23,   25,   26,   27,   28,   29,   22,
       22,   30,   31,   32,   33,   34,   35,   36,   37,   38,
       39,   40,   40,   40,   41,   40,   42,   40,   43,   44,
       40,   45,   46,   40,   47,   48,   49,   40,   40,   50,
       51,   40,   40,   52,   40,   53,   54,   55,   56,   57,
       58,   59,   40,   60,   61,   40,   40,   62,   64,   64,
       69,   69,  134,   70,   70,   99,   65,   65,   69,   69,
       69,   69,   69,  100,   69,   69,   69,   69,   69,   69,
       69,   69,   69,   69,   69,   69,   69,   69,   69,   69,
       69,   69,   69,   69,   69,   69,   69,   69,   79,   82,

       96,   83,   91,   80,   87,   88,   92,   89,   88,  109,
       89,  112,  117,  120,  115,   84,  118,  110,   85,  111,
      116,  113,  127,   88,  248,   89,  244,  121,  114,  128,
      122,  247,   69,   69,   69,   69,   69,   69,   69,   69,
       69,   69,   69,   69,   69,   69,   69,   69,   69,   69,
       69,   69,  159,  166,  169,  188,  246,  248,  189,  245,
      160,  249,  244,  170,  167,  243,  242,  241,  147,  240,
      239,  239,  238,  237,  236,  230,  235,  234,  233,  232,
      231,  230,  229,  228,  227,  226,  225,  224,  223,  222,
       69,   63,   63,   63,   63,   63,   63,   66,   66,   66,

       66,   66,   66,   68,   68,   68,   68,   68,   68,   71,
       71,   71,   71,   71,   71,   73,   73,   73,   73,   73,
       73,   69,   69,   69,   69,   69,   69,   75,   75,   75,
       75,   75,   75,   77,   77,   77,   77,   77,   77,  131,
      131,  221,  131,  131,  131,  132,  132,  220,  132,  219,
      132,  133,  218,  217,  133,  216,  133,  136,  136,  212,
      211,  136,  136,  215,  214,  213,  212,  211,  209,  210,
      209,  208,  207,  206,  205,  204,  186,  185,  203,  202,
      201,  200,  199,  198,  197,  196,  195,  194,  193,  192,
      191,  190,  187,  181,  186,  185,  184,  183,  182,  181,

      180,  179,  178,  177,  176,  175,  135,  174,  173,  172,
      171,  168,  165,  164,  163,  148,  162,  161,  158,  157,
      156,  155,  154,  153,  152,  143,  151,  150,  149,  148,
      147,  146,  145,  144,  143,   90,   90,  142,  141,  140,
      139,  138,  137,  135,  130,  129,  126,  125,  124,  123,
      103,  119,  108,  107,  106,  105,  104,  103,  102,  101,
       98,   97,   95,   94,   93,   90,   86,   81,   78,  250,
       76,   76,   74,   74,   72,   72,   67,   67,   21,  250,
      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,

      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
      250,  250,  250,  250,  250,  250,  250
    } ;

static yyconst flex_int16_t yy_chk[438] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    3,    4,
        7,    8,  263,    7,    8,   41,    3,    4,   11,   11,
       12,   12,   11,   41,   12,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   19,   19,   20,   20,   27,   29,

      259,   29,   33,   27,   31,   31,   33,   31,   34,   50,
       34,   51,   53,   56,   52,   29,   53,   50,   29,   50,
       52,   51,   61,   89,  245,   89,  244,   56,   51,   61,
       56,  241,   15,   16,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
       16,   16,  116,  123,  125,  154,  240,  248,  154,  238,
      116,  248,  237,  125,  123,  236,  233,  232,  116,  231,
      229,  228,  227,  226,  224,  223,  222,  221,  220,  217,
      216,  213,  210,  208,  207,  206,  205,  203,  202,  201,
       16,  251,  251,  251,  251,  251,  251,  252,  252,  252,

      252,  252,  252,  253,  253,  253,  253,  253,  253,  254,
      254,  254,  254,  254,  254,  255,  255,  255,  255,  255,
      255,  256,  256,  256,  256,  256,  256,  257,  257,  257,
      257,  257,  257,  258,  258,  258,  258,  258,  258,  260,
      260,  200,  260,  260,  260,  261,  261,  199,  261,  198,
      261,  262,  197,  194,  262,  193,  262,  264,  264,  192,
      191,  264,  264,  189,  188,  184,  183,  182,  180,  179,
      178,  177,  176,  175,  173,  172,  171,  170,  169,  168,
      167,  165,  164,  163,  162,  161,  160,  159,  158,  157,
      156,  155,  153,  152,  151,  150,  149,  146,  145,  144,

      142,  141,  140,  139,  138,  137,  135,  130,  128,  127,
      126,  124,  122,  121,  120,  119,  118,  117,  114,  113,
      112,  111,  110,  109,  108,  107,  106,  105,  104,  102,
      101,  100,   99,   98,   97,   90,   88,   85,   84,   83,
       82,   80,   79,   76,   65,   62,   60,   59,   58,   57,
       55,   54,   49,   48,   47,   46,   45,   44,   43,   42,
       39,   38,   37,   36,   35,   32,   30,   28,   25,   21,
       18,   17,   14,   13,   10,    9,    6,    5,  250,  250,
      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,

      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
      250,  250,  250,  250,  250,  250,  250,  250,  250,  250,
      250,  250,  250,  250,  250,  250,  250
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[66] =
    {   0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0,
    1, 0, 1, 0, 0, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int scr__flex_debug;
int scr__flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *scr_text;
#line 1 "script_lexer.lpp"
/*
	This file is part of Warzone 2100.
	Copyright (C) 1999-2004  Eidos Interactive
	Copyright (C) 2005-2015  Warzone 2100 Project

	Warzone 2100 is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Warzone 2100 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Warzone 2100; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/
#line 21 "script_lexer.lpp"
/*
 * script.l
 *
 * Script file lexer.
 */
#include <physfs.h>
#include "lib/framework/frame.h"
#include "lib/framework/string_ext.h"
#include "lib/script/interpreter.h"
#include "lib/script/parse.h"
#include "lib/script/script.h"

/* Get the Yacc definitions */
#include "script_parser.h"

// fwrite declared with warn_unused_result, resulting in mysterious errors in "%%" on some distros.
static inline bool no_warn_unused_result(int ignore) { if (ignore) {} return true; }
#define fwrite(a, b, c, d) no_warn_unused_result(fwrite(a, b, c, d))

/* Maximum length for any TEXT value */
#ifndef YYLMAX
#define YYLMAX	255
#endif

#if defined(YY_FLEX_SUBMINOR_VERSION) && YY_FLEX_SUBMINOR_VERSION == 33
extern int scr_get_lineno(void);
extern FILE *scr_get_in(void);
extern FILE *scr_get_out(void);
extern int scr_get_leng(void);
extern char *scr_get_text(void);
extern void scr_set_lineno(int line_number);
extern void scr_set_in(FILE* in_str);
extern void scr_set_out(FILE* out_str);
extern int scr_get_debug(void);
extern void scr_set_debug(int bdebug);
extern int scr_lex_destroy(void);
#endif

/* Store for any string values */
static char aText[TEXT_BUFFERS][YYLMAX];
static UDWORD currText=0;

// Note if we are in a comment
static bool inComment = false;

/* FLEX include buffer stack */
static YY_BUFFER_STATE include_stack[MAX_SCR_INCLUDE_DEPTH];

/* FLEX define buffer stack */
static YY_BUFFER_STATE macro_stack[MAX_SCR_MACRO_DEPTH];
static SCR_MACRO scr_macro[MAX_SCR_MACROS];

/* Script include files stack */
static unsigned int scr_include_stack_ptr = 0;
static PHYSFS_file* pScrInputFiles[MAX_SCR_INCLUDE_DEPTH];

/* Line count stack used with script includes */
static unsigned int scrInclLine[MAX_SCR_INCLUDE_DEPTH];

/* Script defines stack */
static unsigned int scr_num_macros;       /* Number of macros defined so far */
static int scr_macro_stack_ptr;  /* Pointer to the current flex macro input buffer */
static char *pScrMacroBuffer[MAX_SCR_MACRO_DEPTH];

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	{ \
		if (PHYSFS_eof(pScrInputFiles[scr_include_stack_ptr])) \
		{ \
			buf[0] = EOF; \
			result = YY_NULL; \
		} \
		else \
		{ \
			result = PHYSFS_read(pScrInputFiles[scr_include_stack_ptr], buf, 1, max_size); \
			if (result == -1) \
			{ \
				buf[0] = EOF; \
				result = YY_NULL; \
			} \
		} \
	}

static YYSTYPE dummy;

/* Get the token type for a variable symbol */
static SDWORD scriptGetVarToken(VAR_SYMBOL *psVar)
{
	bool	object;

	// See if this is an object pointer
	if (!asScrTypeTab || psVar->type < VAL_USERTYPESTART)
	{
		object = false;
	}
	else
	{
		object = asScrTypeTab[psVar->type - VAL_USERTYPESTART].accessType == AT_OBJECT;
	}

	if (psVar->storage == ST_OBJECT)
	{
		/* This is an object member variable */
		if (object)
		{

			RULE("current variable is OBJ_OBJVAR");

			return OBJ_OBJVAR;
		}
		else
		{
			switch (psVar->type)
			{
			case VAL_BOOL:
				return BOOL_OBJVAR;
				break;
			case VAL_INT:
//			case VAL_FLOAT:

				RULE( "current variable is NUM_OBJVAR");

				return NUM_OBJVAR;
				break;
			default:

				RULE( "current variable is USER_OBJVAR");

				return USER_OBJVAR;
				break;
			}
		}
	}
	else if (psVar->dimensions > 0)
	{
		/* This is an array variable */
		if (object)
		{
			return OBJ_ARRAY;
		}
		else
		{
			switch (psVar->type)
			{
			case VAL_BOOL:
				return BOOL_ARRAY;
				break;
			case VAL_FLOAT:
				return FLOAT_ARRAY;
				break;
			case VAL_INT:
				return NUM_ARRAY;
				break;
			default:
				return VAR_ARRAY;
				break;
			}
		}
	}
	else
	{
		/* This is a standard variable */
		if (object)
		{

			RULE( "current variable is OBJ_VAR");

			return OBJ_VAR;
		}
		else
		{

			RULE( "ordinary var");

			switch (psVar->type)
			{
			case VAL_BOOL:
				return BOOL_VAR;
				break;
			case VAL_FLOAT:

				RULE( "VAL_FLOAT");

				return FLOAT_VAR;
				break;
			case VAL_INT:
				return NUM_VAR;
				break;
			case VAL_STRING:
				return STRING_VAR;
				break;
			default:
				return VAR;
				break;
			}
		}
	}
}

/* Get the token type for a constant symbol */
static SDWORD scriptGetConstToken(CONST_SYMBOL *psConst)
{
	bool	object;

	// See if this is an object constant
	if (!asScrTypeTab || psConst->type < VAL_USERTYPESTART)
	{
		object = false;
	}
	else
	{
		object = asScrTypeTab[psConst->type - VAL_USERTYPESTART].accessType == AT_OBJECT;
	}

	switch (psConst->type)
	{
	case VAL_BOOL:
		return BOOL_CONSTANT;
		break;
//	case VAL_FLOAT:
	case VAL_INT:
		return NUM_CONSTANT;
		break;
	case VAL_STRING:
		return STRING_CONSTANT;
		break;
	default:
		if (object)
		{
			//debug(LOG_SCRIPT, "scriptGetConstToken: OBJ_CONSTANT");
			return OBJ_CONSTANT;
		}
		else
		{
			return USER_CONSTANT;
		}
		break;
	}
}

/* Get the token type for a function symbol */
static SDWORD scriptGetFuncToken(FUNC_SYMBOL *psFunc)
{
	bool	object;

	// See if this is an object pointer
	if(psFunc->type >= VAL_USERTYPESTART)
	{
		object = asScrTypeTab[psFunc->type - VAL_USERTYPESTART].accessType == AT_OBJECT;

		if (object)
		{
			return OBJ_FUNC;
		}
	}
	switch (psFunc->type)
	{
	case VAL_BOOL:
		return BOOL_FUNC;
		break;
	case VAL_FLOAT:
		return FLOAT_FUNC;
		break;
	case VAL_INT:
		return NUM_FUNC;
		break;
	case VAL_STRING:
		return STRING_FUNC;
		break;
	case VAL_VOID:
		return FUNC;
		break;
	default:
		return USER_FUNC;
		break;
	}
}

/* Get the token type for a custom function symbol */
static SDWORD scriptGetCustomFuncToken(EVENT_SYMBOL *psFunc)
{
	bool	object;

	// See if this is an object pointer
	if (!asScrTypeTab || psFunc->retType < VAL_USERTYPESTART)
	{
		object = false;
	}
	else
	{
		object = asScrTypeTab[psFunc->retType - VAL_USERTYPESTART].accessType == AT_OBJECT;
	}

	if (object)
	{
		return OBJ_FUNC_CUST;
	}
	else
	{
		switch (psFunc->retType)
		{
		case VAL_BOOL:
			return BOOL_FUNC_CUST;
			break;
		case VAL_FLOAT:

			RULE( "current function is FLOAT_FUNC_CUST");

			return FLOAT_FUNC_CUST;
			break;
		case VAL_INT:

			RULE( "current function is NUM_FUNC_CUST");

			return NUM_FUNC_CUST;
			break;
		case VAL_STRING:
			return STRING_FUNC_CUST;
			break;
		case VAL_VOID:
			return VOID_FUNC_CUST;
			break;
		default:
			return USER_FUNC_CUST;
			break;
		}
	}
}

/* Look up defined macro and return new define buffer */
static bool scriptLoopUpMacro(const char *pMacro, char **ppMacroBody)
{
	unsigned int i;

	for (i = 0; i < scr_num_macros; ++i)
	{
		if(strcmp(pMacro, &(scr_macro[i].scr_define_macro[0]) ) == 0)
		{
			*ppMacroBody = (char *)malloc(MAXSTRLEN);
			strcpy( *ppMacroBody, &(scr_macro[i].scr_define_body[0]) );		//copy macro body into buffer so we can process it
			//*pMacroBody = &(scr_macro[i].scr_define_body[0]);	//return macro body
			return true;
		}
	}

	return false;
}

/* Return to the previous macto buffer */
static void popMacroStack(void)
{
	ASSERT(scr_macro_stack_ptr <= MAX_SCR_MACRO_DEPTH,
		"FLEX: macro stack pointer out of bounds: %d", scr_macro_stack_ptr);

	/* Free current macro buffer */
	free(pScrMacroBuffer[scr_macro_stack_ptr]);
	pScrMacroBuffer[scr_macro_stack_ptr] = NULL;

	/* Delete flex buffer */
	scr__delete_buffer(YY_CURRENT_BUFFER );

	/* Switch one level lower in the macro stack */
	scr__switch_to_buffer(macro_stack[scr_macro_stack_ptr - 1] );

	scr_macro_stack_ptr--;
}

/* Store macro name */
static void storeMacroName(const char *pMacroName)
{
	ASSERT(scr_num_macros < MAX_SCR_MACROS,
		"FLEX: macro count out of bounds: %u", scr_num_macros);

	/* Make sure this name isn't already reserved */
	if((scriptLookUpType(pMacroName, &dummy.tval)) ||
	(scriptLookUpVariable(pMacroName, &dummy.vSymbol)) ||
	(scriptLookUpConstant(pMacroName, &dummy.cSymbol)) ||
	(scriptLookUpFunction(pMacroName, &dummy.fSymbol)) ||
	(scriptLookUpCustomFunction(pMacroName, &dummy.eSymbol)) ||
	(scriptLookUpTrigger(pMacroName, &dummy.tSymbol)) ||
	(scriptLookUpEvent(pMacroName, &dummy.eSymbol)) ||
	(scriptLookUpCallback(pMacroName, &dummy.cbSymbol)))
	{
		scr_error("FLEX: macro name '%s' is already reserved", pMacroName);
	}

	/* Store define macro */
	sstrcpy(scr_macro[scr_num_macros].scr_define_macro, pMacroName);
}

/* Store macro body */
static void storeMacroBody(const char *pMacroBody)
{
	ASSERT(scr_num_macros < MAX_SCR_MACROS,
		"FLEX: macro count out of bounds: %u", scr_num_macros);

	/* Store macro body */
	sstrcpy(scr_macro[scr_num_macros].scr_define_body, pMacroBody);

	scr_num_macros++;
}

/* include directive encountered - push current buffer, set up new one */
static void pushInclude(const char *pIncludePath)
{
	PHYSFS_file* newInput;

	if ( scr_include_stack_ptr >= MAX_SCR_INCLUDE_DEPTH ){
		scr_error("FLEX: Includes nested too deeply" );
	}

	if(!PHYSFS_exists(pIncludePath)){
		scr_error("FLEX: '%s' include doesn't exist", pIncludePath );
	}

	/* Open include */
	newInput = PHYSFS_openRead(pIncludePath);

	if(!newInput){
		scr_error("FLEX: Couldn't open include: '%s'\n%s",
			pIncludePath, PHYSFS_getLastError() );
	}

	/* Push current flex buffer */
	include_stack[scr_include_stack_ptr] = YY_CURRENT_BUFFER;
	scr_include_stack_ptr++;

	ASSERT(scr_include_stack_ptr < MAX_SCR_INCLUDE_DEPTH,
		"FLEX: scr_include_stack_ptr out of bounds: %u", scr_include_stack_ptr);

	pScrInputFiles[scr_include_stack_ptr] = newInput;
}












#line 1147 "script_lexer.cpp"

#define INITIAL 0
#define COMMENT 1
#define SLCOMMENT 2
#define QUOTE 3
#define _MACRO 4
#define _INCL 5
#define _INCL_END_QUOTE 6
#define _DEF_MACRO 7
#define _DEF_BODY_START 8
#define _DEF_BODY 9

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int scr_lex_destroy (void );

int scr_get_debug (void );

void scr_set_debug (int debug_flag  );

YY_EXTRA_TYPE scr_get_extra (void );

void scr_set_extra (YY_EXTRA_TYPE user_defined  );

FILE *scr_get_in (void );

void scr_set_in  (FILE * in_str  );

FILE *scr_get_out (void );

void scr_set_out  (FILE * out_str  );

int scr_get_leng (void );

char *scr_get_text (void );

int scr_get_lineno (void );

void scr_set_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int scr_wrap (void );
#else
extern int scr_wrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( scr_text, scr_leng, 1, scr_out )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( scr_in )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( scr_in ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, scr_in))==0 && ferror(scr_in)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(scr_in); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int scr_lex (void);

#define YY_DECL int scr_lex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after scr_text and scr_leng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 478 "script_lexer.lpp"


	/* Match keywords */
#line 1345 "script_lexer.cpp"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! scr_in )
			scr_in = stdin;

		if ( ! scr_out )
			scr_out = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			scr_ensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				scr__create_buffer(scr_in,YY_BUF_SIZE );
		}

		scr__load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of scr_text. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 251 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 250 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < scr_leng; ++yyl )
				if ( scr_text[yyl] == '\n' )

    scr_lineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 481 "script_lexer.lpp"
return WAIT;
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 482 "script_lexer.lpp"
return EVERY;
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 483 "script_lexer.lpp"
return TRIGGER;
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 484 "script_lexer.lpp"
return EVENT;
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 485 "script_lexer.lpp"
return INACTIVE;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 486 "script_lexer.lpp"
return INITIALISE;
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 487 "script_lexer.lpp"
return LINK;
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 488 "script_lexer.lpp"
return REF;
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 489 "script_lexer.lpp"
return	RET;
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 490 "script_lexer.lpp"
return	lexFUNCTION;
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 491 "script_lexer.lpp"
{ RULE(scr_text); return TO_INT_CAST; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 492 "script_lexer.lpp"
{ RULE(scr_text); return TO_FLOAT_CAST; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 493 "script_lexer.lpp"
{ scr_lval.stype = ST_PUBLIC; return STORAGE; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 494 "script_lexer.lpp"
{ scr_lval.stype = ST_PRIVATE; return STORAGE; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 495 "script_lexer.lpp"
{ scr_lval.stype = ST_LOCAL; return STORAGE; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 496 "script_lexer.lpp"
return WHILE;
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 497 "script_lexer.lpp"
return IF;
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 498 "script_lexer.lpp"
return ELSE;
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 499 "script_lexer.lpp"
return EXIT;
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 500 "script_lexer.lpp"
return PAUSE;
	YY_BREAK
/* Match type keywords */
case 21:
YY_RULE_SETUP
#line 503 "script_lexer.lpp"
{ scr_lval.tval = VAL_VOID; return _VOID; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 504 "script_lexer.lpp"
{ scr_lval.tval = VAL_STRING; return TYPE; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 505 "script_lexer.lpp"
{ scr_lval.tval = VAL_BOOL; return TYPE; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 506 "script_lexer.lpp"
{ scr_lval.tval = VAL_INT; return TYPE; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 507 "script_lexer.lpp"
{ scr_lval.tval = VAL_FLOAT; return TYPE; }
	YY_BREAK
/* Match boolean values */
case 26:
YY_RULE_SETUP
#line 510 "script_lexer.lpp"
{ scr_lval.bval = true; return BOOLEAN_T; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 511 "script_lexer.lpp"
{ scr_lval.bval = false; return BOOLEAN_T; }
	YY_BREAK
/* Match increment/decrement operators */
case 28:
YY_RULE_SETUP
#line 514 "script_lexer.lpp"
{RULE("++"); return _INC; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 515 "script_lexer.lpp"
{RULE("++"); return _DEC; }
	YY_BREAK
/* Match boolean operators */
case 30:
YY_RULE_SETUP
#line 518 "script_lexer.lpp"
return BOOLEQUAL;
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 519 "script_lexer.lpp"
return NOTEQUAL;
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 520 "script_lexer.lpp"
return GREATEQUAL;
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 521 "script_lexer.lpp"
return LESSEQUAL;
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 522 "script_lexer.lpp"
return GREATER;
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 523 "script_lexer.lpp"
return LESS;
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 524 "script_lexer.lpp"
return _AND;
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 525 "script_lexer.lpp"
return _OR;
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 526 "script_lexer.lpp"
return _NOT;
	YY_BREAK
/* Start of a #define */
case 39:
YY_RULE_SETUP
#line 529 "script_lexer.lpp"
{ BEGIN (_DEF_MACRO); }
	YY_BREAK
/* Start of the #define macro name */
case 40:
YY_RULE_SETUP
#line 532 "script_lexer.lpp"
{
								RULE("FLEX: matched define macro: '#define %s'", scr_text);

								/* Store macro name */
								storeMacroName(scr_text);

								BEGIN (_DEF_BODY_START);
							}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 541 "script_lexer.lpp"
{ BEGIN (_DEF_BODY); }	/* Eat space between macro and body */
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 543 "script_lexer.lpp"
{	/* Anything until the end of the line is macro body */

								RULE("FLEX: matched define body: '#define %s %s' (%d)",
									scr_macro[scr_num_macros].scr_define_macro, scr_text, scr_num_macros + 1);

								/* Store macro body */
								storeMacroBody(scr_text);

								BEGIN (INITIAL);
							}
	YY_BREAK
/* Handle Includes */
case 43:
YY_RULE_SETUP
#line 555 "script_lexer.lpp"
{ BEGIN (_INCL); }	/* Match '#include' and skip whitespace until quotation */
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 557 "script_lexer.lpp"
{ 	/* got the include file name */
								RULE("FLEX: Opening include '%s' (scr_include_stack_ptr: %u)", scr_text, scr_include_stack_ptr);

								/* Set up new input buffer, push current one to stack */
								pushInclude(scr_text);

								/* Match the ending quote */
						        BEGIN(_INCL_END_QUOTE);
							}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 567 "script_lexer.lpp"
{
								int	line;
								char	*text;
								YY_BUFFER_STATE includeBuffer;

								ASSERT(scr_include_stack_ptr < MAX_SCR_INCLUDE_DEPTH,
									"FLEX:  scr_include_stack_ptr out of bounds: %u", scr_include_stack_ptr);

								ASSERT(pScrInputFiles[scr_include_stack_ptr] != NULL, "FLEX: failed to load include");

								RULE("FLEX: storing line number for include %u: ",
									scr_include_stack_ptr - 1, scr_lineno);

								/* Store the current line number in the current input buffer */
								scriptGetErrorData(&line, &text);
								scrInclLine[scr_include_stack_ptr - 1] = line;
								scr_lineno = 1;		//we are at the beginning of the first line in a new input now

								/* Create a new YY_BUFFER_STATE for this file */
								includeBuffer = scr__create_buffer(NULL,YY_BUF_SIZE);

								/* Switch to the new buffer */
								scr__switch_to_buffer(includeBuffer);

								BEGIN (INITIAL);
							}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(SLCOMMENT):
case YY_STATE_EOF(QUOTE):
case YY_STATE_EOF(_MACRO):
case YY_STATE_EOF(_INCL):
case YY_STATE_EOF(_INCL_END_QUOTE):
case YY_STATE_EOF(_DEF_MACRO):
case YY_STATE_EOF(_DEF_BODY_START):
case YY_STATE_EOF(_DEF_BODY):
#line 594 "script_lexer.lpp"
{
								RULE("FLEX: EOF: scr_include_stack_ptr: %u; scr_macro_stack_ptr: %d",
									scr_include_stack_ptr, scr_macro_stack_ptr);

								ASSERT(pScrInputFiles[scr_include_stack_ptr] != NULL, "FLEX: can't unload, buffer is NULL");

								if ( scr_include_stack_ptr == 0 )
								{
									/* We finished scanning top level script or macro */
									if(scr_macro_stack_ptr > 0)
									{
										RULE("FLEX: Finished parsing macro %d", scr_macro_stack_ptr);

										popMacroStack();
									}
									else	//both stacks are empty
									{
										RULE("FLEX: Finished parsing all input");
										yyterminate();
									}
								}
								else
								{
									/* First finish scanning all macros */
									if(scr_macro_stack_ptr > 0)
									{
										RULE("FLEX: Finished parsing macro %d in include %d",
											scr_macro_stack_ptr, scr_include_stack_ptr);

										popMacroStack();
									}
									else	//no macros, return to previous include
									{
										RULE("FLEX: returning from parsing include %u", scr_include_stack_ptr);

										/* Free include buffer */
										PHYSFS_close(pScrInputFiles[scr_include_stack_ptr]);
										pScrInputFiles[scr_include_stack_ptr] = NULL;

										/* Delete flex buffer */
										scr__delete_buffer(YY_CURRENT_BUFFER );

										/* Pop previous script file */
										scr__switch_to_buffer(include_stack[scr_include_stack_ptr - 1] );

										ASSERT(scr_include_stack_ptr != 0,
											"Can't restore line number of theprevious flex input");

										/* Restore line count of the previous buffer from the line count stack */
										scr_lineno = scrInclLine[scr_include_stack_ptr - 1];
										RULE("FLEX: restoring line number for include %u: ",
											scr_include_stack_ptr, scr_lineno);

										/* Go to the previous flex input buffer */
										scr_include_stack_ptr--;
									}
								}
					        }
	YY_BREAK
/* Match floating point numbers */
case 46:
YY_RULE_SETUP
#line 655 "script_lexer.lpp"
{
								RULE( "float matched '%s'", scr_text);

								scr_lval.fval = (float)atof(scr_text);

								return FLOAT_T;
							}
	YY_BREAK
/* Match integer numbers */
case 47:
YY_RULE_SETUP
#line 664 "script_lexer.lpp"
{ scr_lval.ival = atol(scr_text); return INTEGER; }
	YY_BREAK
/* Match identifiers */
case 48:
YY_RULE_SETUP
#line 667 "script_lexer.lpp"
{
								char* tmpMacroBuffer;
								RULE( "looking up '%s'", scr_text);

								/* See if this identifier has been defined as a type */
								if (scriptLookUpType(scr_text, &scr_lval.tval))	//STRUCTURESTAT etc
								{

									RULE( "'%s' is a user type", scr_text);

									return TYPE;
								}
								/* See if this identifier has been defined as a variable */
								else if (scriptLookUpVariable(scr_text, &scr_lval.vSymbol))
								{

									RULE( "'%s' is a var", scr_text);

									return scriptGetVarToken(scr_lval.vSymbol);
								}
								/* See if this identifier has been defined as a constant */
								else if (scriptLookUpConstant(scr_text, &scr_lval.cSymbol))
								{

									RULE( "'%s' is a constant", scr_text);

									return scriptGetConstToken(scr_lval.cSymbol);
								}
								/* See if this identifier has been defined as a function */
								else if (scriptLookUpFunction(scr_text, &scr_lval.fSymbol))
								{

									RULE( "'%s' is a function", scr_text);

									return scriptGetFuncToken(scr_lval.fSymbol);
								}

								/* See if this identifier has been defined as a custom function */
								else if (scriptLookUpCustomFunction(scr_text, &scr_lval.eSymbol))
								{

									RULE( "'%s' is a cust func", scr_text);

									return scriptGetCustomFuncToken(scr_lval.eSymbol);
								}

								else if (scriptLookUpTrigger(scr_text, &scr_lval.tSymbol))
								{

									RULE( "'%s' is a trigger", scr_text);

									return TRIG_SYM;
								}
								else if (scriptLookUpEvent(scr_text, &scr_lval.eSymbol))
								{

									RULE( "'%s' is an event", scr_text);

									return EVENT_SYM;
								}
								else if (scriptLookUpCallback(scr_text, &scr_lval.cbSymbol))
								{

									RULE( "'%s' is a callback", scr_text);

									return CALLBACK_SYM;
								}
								else if(scriptLoopUpMacro(scr_text, &tmpMacroBuffer))
								{
									RULE( "'%s' is a macro", scr_text);

									ASSERT(tmpMacroBuffer != NULL,
										"FLEX: failed to allocate memory for macro buffer %d", scr_macro_stack_ptr);

									ASSERT(scr_macro_stack_ptr >= 0 && scr_macro_stack_ptr < MAX_SCR_MACRO_DEPTH,
										"FLEX: flex macro buffer pointer out of bounds: %d", scr_macro_stack_ptr );

									/* Push current buffer we are processing;
									 * can be either macro buffer, include buffer or top level script
									 */
									macro_stack[scr_macro_stack_ptr] = YY_CURRENT_BUFFER;
									scr_macro_stack_ptr++;

									pScrMacroBuffer[scr_macro_stack_ptr] = tmpMacroBuffer; // Assign to the new input buffer

									/* Feed flex with the new macro buffer */
									scr__switch_to_buffer(scr__scan_string(pScrMacroBuffer[scr_macro_stack_ptr] ) );
								}
								else
								{
									RULE( "'%s' is an ident", scr_text);

									sstrcpy(aText[currText], scr_text);
									scr_lval.sval = aText[currText];
									currText = (currText + 1) % TEXT_BUFFERS;
									return IDENT;
								}
							}
	YY_BREAK
/* Strip macros */
case 49:
YY_RULE_SETUP
#line 766 "script_lexer.lpp"
{ BEGIN (_MACRO); }
	YY_BREAK
case 50:
/* rule 50 can match eol */
YY_RULE_SETUP
#line 767 "script_lexer.lpp"
{ BEGIN (INITIAL); }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 768 "script_lexer.lpp"
;
	YY_BREAK
/* Match quoted text */
case 52:
YY_RULE_SETUP
#line 771 "script_lexer.lpp"
{ BEGIN (QUOTE); }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 772 "script_lexer.lpp"
{ BEGIN (INITIAL); }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 773 "script_lexer.lpp"
{
								sstrcpy(aText[currText], scr_text);
								scr_lval.sval = aText[currText];
								currText = (currText + 1) % TEXT_BUFFERS;
								//debug(LOG_SCRIPT, "%s is QTEXT", scr_text);
								return QTEXT;
							}
	YY_BREAK
/* Skip white space */
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
#line 782 "script_lexer.lpp"
;
	YY_BREAK
/* Strip comments */
case 56:
YY_RULE_SETUP
#line 785 "script_lexer.lpp"
{ inComment=true; BEGIN (COMMENT); }
	YY_BREAK
case 57:
#line 787 "script_lexer.lpp"
case 58:
/* rule 58 can match eol */
YY_RULE_SETUP
#line 787 "script_lexer.lpp"
{ inComment=false; BEGIN (INITIAL); }
	YY_BREAK
case 59:
#line 789 "script_lexer.lpp"
case 60:
/* rule 60 can match eol */
YY_RULE_SETUP
#line 789 "script_lexer.lpp"
;
	YY_BREAK
/* Strip single line comments */
case 61:
YY_RULE_SETUP
#line 792 "script_lexer.lpp"
{ BEGIN (SLCOMMENT); }
	YY_BREAK
case 62:
/* rule 62 can match eol */
YY_RULE_SETUP
#line 793 "script_lexer.lpp"
{ BEGIN (INITIAL); }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 794 "script_lexer.lpp"
;
	YY_BREAK
/* Match anything that's been missed and pass it as a char */
case 64:
YY_RULE_SETUP
#line 797 "script_lexer.lpp"
return scr_text[0];
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 799 "script_lexer.lpp"
ECHO;
	YY_BREAK
#line 2002 "script_lexer.cpp"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed scr_in at a new source and called
			 * scr_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = scr_in;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( scr_wrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * scr_text, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of scr_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					scr_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			scr_restart(scr_in  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) scr_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 251 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 251 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 250);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;

	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					scr_restart(scr_in );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( scr_wrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve scr_text */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )

    scr_lineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 *
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void scr_restart  (FILE * input_file )
{

	if ( ! YY_CURRENT_BUFFER ){
        scr_ensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            scr__create_buffer(scr_in,YY_BUF_SIZE );
	}

	scr__init_buffer(YY_CURRENT_BUFFER,input_file );
	scr__load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 *
 */
    void scr__switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		scr_pop_buffer_state();
	 *		scr_push_buffer_state(new_buffer);
     */
	scr_ensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	scr__load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (scr_wrap()) processing, but the only time this flag
	 * is looked at is after scr_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void scr__load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	scr_in = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 *
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE scr__create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) scr_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in scr__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) scr_alloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in scr__create_buffer()" );

	b->yy_is_our_buffer = 1;

	scr__init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with scr__create_buffer()
 *
 */
    void scr__delete_buffer (YY_BUFFER_STATE  b )
{

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		scr_free((void *) b->yy_ch_buf  );

	scr_free((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a scr_restart() or at EOF.
 */
    static void scr__init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;

	scr__flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then scr__init_buffer was _probably_
     * called from scr_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;

	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 *
 */
    void scr__flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		scr__load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *
 */
void scr_push_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	scr_ensure_buffer_stack();

	/* This block is copied from scr__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from scr__switch_to_buffer. */
	scr__load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *
 */
void scr_pop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	scr__delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		scr__load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void scr_ensure_buffer_stack (void)
{
	int num_to_alloc;

	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)scr_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in scr_ensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)scr_realloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in scr_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 *
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE scr__scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) scr_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in scr__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	scr__switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to scr_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 *
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       scr__scan_bytes() instead.
 */
YY_BUFFER_STATE scr__scan_string (yyconst char * yystr )
{

	return scr__scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to scr_lex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 *
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE scr__scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) scr_alloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in scr__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = scr__scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in scr__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up scr_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		scr_text[scr_leng] = (yy_hold_char); \
		(yy_c_buf_p) = scr_text + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		scr_leng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 *
 */
int scr_get_lineno  (void)
{

    return scr_lineno;
}

/** Get the input stream.
 *
 */
FILE *scr_get_in  (void)
{
        return scr_in;
}

/** Get the output stream.
 *
 */
FILE *scr_get_out  (void)
{
        return scr_out;
}

/** Get the length of the current token.
 *
 */
int scr_get_leng  (void)
{
        return scr_leng;
}

/** Get the current token.
 *
 */

char *scr_get_text  (void)
{
        return scr_text;
}

/** Set the current line number.
 * @param line_number
 *
 */
void scr_set_lineno (int  line_number )
{

    scr_lineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 *
 * @see scr__switch_to_buffer
 */
void scr_set_in (FILE *  in_str )
{
        scr_in = in_str ;
}

void scr_set_out (FILE *  out_str )
{
        scr_out = out_str ;
}

int scr_get_debug  (void)
{
        return scr__flex_debug;
}

void scr_set_debug (int  bdebug )
{
        scr__flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from scr_lex_destroy(), so don't allocate here.
     */

    /* We do not touch scr_lineno unless the option is enabled. */
    scr_lineno =  1;

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    scr_in = stdin;
    scr_out = stdout;
#else
    scr_in = (FILE *) 0;
    scr_out = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * scr_lex_init()
     */
    return 0;
}

/* scr_lex_destroy is for both reentrant and non-reentrant scanners. */
int scr_lex_destroy  (void)
{

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		scr__delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		scr_pop_buffer_state();
	}

	/* Destroy the stack itself. */
	scr_free((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * scr_lex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *scr_alloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *scr_realloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void scr_free (void * ptr )
{
	free( (char *) ptr );	/* see scr_realloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 799 "script_lexer.lpp"



/* Set the current input file for the lexer */
void scriptSetInputFile(PHYSFS_file* fileHandle)
{
	YY_BUFFER_STATE inputScript;
	unsigned int i;

	/* Reset the lexer in case it's been used before */
	scr__flush_buffer( YY_CURRENT_BUFFER );

	/* Reset include stack */
	scr_include_stack_ptr = 0;

	/* Initialize include input files */
	for(i = 0; i < MAX_SCR_INCLUDE_DEPTH; ++i)
	{
		pScrInputFiles[i] = NULL;
		scrInclLine[i] = 0;
	}

	/* Set the initial input buffer */
	pScrInputFiles[0] = fileHandle;

	inputScript = scr__create_buffer(NULL,YY_BUF_SIZE);

	scr__switch_to_buffer(inputScript);

	/* Reset number of macros */
	scr_num_macros = 0;

	/* Reset macro stack */
	scr_macro_stack_ptr = 0;

	/* Initialize macro input buffers */
	for(i = 0; i < MAX_SCR_MACRO_DEPTH; ++i)
	{
		pScrMacroBuffer[i] = NULL;
	}
}

void scriptGetErrorData(int *pLine, char **ppText)
{
	*pLine = scr_lineno;
	*ppText = scr_text;
}

int scr_wrap(void)
{
	if (inComment)
	{
		debug( LOG_ERROR, "Warning: reached end of file in a comment" );
		abort();
	}
	return 1;
}


/* Older GNU Flex versions don't define scr_lex_destroy()
 * (and neither define a subminor version)
 */
#if !defined(YY_FLEX_SUBMINOR_VERSION) || (YY_FLEX_SUBMINOR_VERSION < 9)
int scr_lex_destroy(void)
{
	/* For non-reentrant C scanner only. */
	scr__delete_buffer(YY_CURRENT_BUFFER);
	yy_init = 1;
	return 0;
}
#endif

