package WebGUI::i18n::English::Friends;
use strict;

our $I18N = {

    'invitation accepted by user' => {
        message     => q{Your invitation has been accepted by %s.},
        lastUpdated => 0,
    },

    'friends invitation accepted' => {
        message     => q{Friends Invitation Accepted},
        lastUpdated => 0,
    },

    'friends invitation not accepted by user' => {
        message     => q{Your invitation has not been accepted by %s.},
        lastUpdated => 0,
    },

    'friends invitation not accepted' => {
        message     => q{Friends Invitation Not Accepted},
        lastUpdated => 0,
    },

    'invitation approval email' => {
        message     => q{%s has requested that you join their friend network on this site %s.

%s

Please visit the following url to accept or deny the request:

%s},
        lastUpdated => 0,
    },

    'friends network invitation' => {
        message     => q{Friends Network Invitation},
        lastUpdated => 0,
    },

    'send friend email instructions' => {
        message     => q{Check the friends you'd like to send a message to and then fill in the message below.},
        lastUpdated => 0,
    },

    'confirm remove friends' => {
        message     => q{Are you certain you wish to remove the selected friends from your list?},
        lastUpdated => 0,
    },

    'already a friend' => {
        message     => q{You can't add a friend twice.},
        lastUpdated => 1186028432,
    },

    'add to friends list' => {
        message     => q{Add this person to my friends list.},
        lastUpdated => 1186028432,
    },

    'add to friends' => {
        message     => q{Add to Friends},
        lastUpdated => 1186030775,
    },

    'add to friends description' => {
        message     => q{Do you really want to add %s as a friend?},
        lastUpdated => 1186030776,
    },

    'add to friends confirmation' => {
        message     => q{An email has been sent to %s for your request to be added to your friends network.},
        lastUpdated => 1186030776,
    },

    'add to friends profile' => {
        message     => q{Return to %s's Profile},
        lastUpdated => 1186030776,
    },

    'does not want to be a friend' => {
        message     => q{This user prefers not to be added as a friend.},
        lastUpdated => 1186264488,
   },

    'manage friends template' => {
        message     => q{Manage Friends Template},
        lastUpdated => 1186264488,
        context     => "setting",
    },

    'manage friends template help' => {
        message     => q{Which template would you like to use for the "See my friends." screen in the user account?},
        lastUpdated => 1186264488,
        context     => "setting",
    },

    'deny unanswered friends' => {
        message     => q{Deny Unanswered Friends},
        lastUpdated => 1186264488,
        context     => "workflow activity",
    },

    'timeout' => {
        message     => q{Timeout},
        lastUpdated => 1186264488,
        context     => "workflow activity",
    },

    'timeout help' => {
        message     => q{How long should invitations to a friends network go unanswered before we automatically deny the request?},
        lastUpdated => 1186264488,
        context     => "workflow activity",
    },

    'add' => {
        message     => q{Add},
        lastUpdated => 1186264488,
    },

    'default friend comments' => {
        message     => q{%s,
I'd like you to be a part of my friends network.

Thanks,
%s},
        lastUpdated => 1186277362,
    },

    'friend request' => {
        message     => q{Friend Request},
        lastUpdated => 1186277362,
    },

    'friend request description' => {
        message     => q{%s has requested you be added to their friends list with the following comments:},
        lastUpdated => 1186277362,
    },

	'invalid invite code' => {
		message => q|Invalid invitation code|,
		lastUpdated => 1186718713,
	},

	'invalid invite code message' => {
		message => q|The invitation code in your URL is invalid.|,
		lastUpdated => 1186718715,
	},

	'not the right user' => {
		message => q|The invitation code you are trying to use is not for you.|,
		lastUpdated => 1186718715,
	},

	'you have not been added' => {
		message => q|You have denied %s's request.|,
		lastUpdated => 1186718715,
	},

	'you have been added' => {
		message => q|You have been added to %s's Friends List.|,
		lastUpdated => 1186718715,
	},

	'manage friends' => {
		message => q|Manage Friends or send them private messages.|,
		lastUpdated => 1186975937,
	},

	'no friends' => {
		message => q|You haven't signed up any friends.|,
		lastUpdated => 1186976178,
	},

	'my friends' => {
		message => q|My Friends|,
		lastUpdated => 1186976178,
	},

	'name' => {
		message => q|Name|,
		lastUpdated => 1186976178,
	},

	'status' => {
		message => q|Status|,
		lastUpdated => 1186976178,
	},

	'online' => {
		message => q|Online|,
		lastUpdated => 1186976178,
	},

	'offline' => {
		message => q|Offline|,
		lastUpdated => 1186976178,
	},

	'send message' => {
		message => q|Send Message|,
		lastUpdated => 1186976178,
	},

	'remove' => {
		message => q|Remove|,
		lastUpdated => 1186976178,
	},

	'see my friends' => {
		message => q|See my friends.|,
		lastUpdated => 1187066104,
	},

    'manage friends template title' => {
        message     => q{Manage Friends Template Variables},
        lastUpdated => 1193193904,
    },

    'manage friends template title' => {
        message     => q{Manage Friends Template Variables},
        lastUpdated => 1193193904,
    },

    'formHeader' => {
        message     => q{HTML required to begin the form},
        lastUpdated => 1193193904,
    },

    'removeFriendButton' => {
        message     => q{HTML code for a button that will remove all selected Friends.},
        lastUpdated => 1193193904,
    },

    'subjectForm' => {
        message     => q{HTML code for a text form for the subject of emails to send to your Friends.},
        lastUpdated => 1193193904,
    },

    'messageForm' => {
        message     => q{HTML code for a text form for the body of emails to send to your Friends.},
        lastUpdated => 1193193904,
    },

    'subject' => {
        message     => q{Subject},
        lastUpdated => 1215395668,
        context     => q|Label for the manage friends template|,
    },

    'message' => {
        message     => q{Message},
        lastUpdated => 1215395674,
        context     => q|Label for the manage friends template|,
    },

    'sendMessageButton' => {
        message     => q{HTML code for a button to send an email to selected Friends.},
        lastUpdated => 1193193904,
    },

    'formFooter' => {
        message     => q{HTML code for ending this form.},
        lastUpdated => 1193193904,
    },

    'friends' => {
        message     => q{A loop containing information about friends and form controls for deleting them, or sending a message to them.},
        lastUpdated => 1193193904,
    },

    'name' => {
        message     => q{The name of this Friend},
        lastUpdated => 1193193904,
    },

    'profileUrl' => {
        message     => q{The URL to this friend's user profile},
        lastUpdated => 1193193904,
    },

    'status' => {
        message     => q{The user's status, either online (logged in) or offline (logged out)},
        lastUpdated => 1193193904,
    },

    'checkboxForm' => {
        message     => q{HTML code for a checkbox.  This checkbox is used to select the Friend to be deleted, or to send them an email.},
        lastUpdated => 1193194455,
    },

	'topicName' => {
		message => q|Friends Network.|,
		lastUpdated => 1181493546,
	},

    'error user is already friend' => {
        message     => q|This user is already a member of your friends network <br /><p> <a href="%s">%s</a></p>|,
        lastUpdated => 1181493546,    
    },

    'error user is already invited' => {
        message     => q|You have already sent an invitation for this user to join your friends network <br /> <p><a href="%s">%s</a></p>|,
        lastUpdated => 1181493546,
    }

};

1;
