/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.StringTokenizer;

public class Clicktile
extends Applet
implements Runnable,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final int serialVersionUID = 1;
    int[][] Clicktile;
    int MAX;
    int dx;
    int dy;
    Thread thread = null;
    Image canvas;
    Graphics2D drawing;
    int xmin = -10;
    int xmax = 10;
    int ymin = -10;
    int ymax = 10;
    int xsize;
    int ysize;
    int x_rect;
    int y_rect;
    int Rx;
    int Ry;
    int[][] palette = new int[][]{{255, 255, 255}, {255, 0, 0}, {0, 255, 0}, {0, 0, 255}, {238, 154, 0}, {255, 255, 0}, {160, 32, 240}, {144, 238, 144}, {173, 216, 230}, {0, 255, 255}, {165, 24, 24}, {250, 128, 114}, {255, 192, 203}, {0, 0, 0}};
    final int max = this.palette.length;
    int[] color = new int[this.max];
    int objects = 0;
    int[][] xcoords;
    int[][] ycoords;
    int[] length;
    public String[] COLORS = new String[this.max];
    int linewidth = 1;
    int TYPE = 0;
    int[] xpoints;
    int[] ypoints;
    int point_color = 0;
    String language = "en";
    boolean status = true;
    int[] used_colors;
    int this_color = 0;
    Image bg;
    URL url;
    int copy_x = 0;
    int copy_y = 0;

    @Override
    public void init() {
        String k;
        int p;
        StringTokenizer q;
        int i;
        this.xsize = this.getSize().width;
        this.ysize = this.getSize().height;
        String c = this.getParameter("status");
        if (c != null && c.length() > 0) {
            if (c.equalsIgnoreCase("waiting")) {
                this.status = true;
            } else if (c.equalsIgnoreCase("done")) {
                this.status = false;
            }
        }
        if ((c = this.getParameter("language")) != null && c.length() > 0) {
            this.Determine_Color_Names(c);
        }
        if ((c = this.getParameter("background_color")) != null && c.length() > 0) {
            this.color[0] = this.GetInternalColorCode(c, 0);
        }
        int obj = 1;
        c = this.getParameter("square" + obj + "_color");
        while (c != null && c.length() > 0) {
            c = this.getParameter("square" + obj + "_color");
            if (c != null && c.length() > 0) {
                ++this.objects;
                this.color[obj] = this.GetInternalColorCode(c, 13);
            }
            ++obj;
        }
        c = this.getParameter("xrange");
        if (c != null && c.length() > 0) {
            this.Determine_Range(c, "x");
        }
        if ((c = this.getParameter("yrange")) != null && c.length() > 0) {
            this.Determine_Range(c, "y");
        }
        this.Rx = Math.abs(this.xmax - this.xmin);
        this.Ry = Math.abs(this.ymax - this.ymin);
        this.MAX = this.Rx * this.Ry;
        this.x_rect = this.xsize / this.Rx;
        this.y_rect = this.ysize / this.Ry;
        this.Clicktile = new int[this.MAX][this.MAX];
        this.canvas = this.createImage(this.xsize, this.ysize);
        this.drawing = (Graphics2D)this.canvas.getGraphics();
        this.xcoords = new int[this.MAX][this.MAX];
        this.ycoords = new int[this.MAX][this.MAX];
        this.length = new int[this.MAX];
        for (i = 0; i < this.MAX; ++i) {
            this.length[i] = 0;
        }
        for (i = 0; i < this.MAX; ++i) {
            for (int ii = 0; ii < this.MAX; ++ii) {
                this.xcoords[ii][i] = 0;
                this.ycoords[ii][i] = 0;
            }
        }
        for (int x = 0; x < this.MAX; ++x) {
            for (int y = 0; y < this.MAX; ++y) {
                this.Clicktile[y][x] = this.color[0];
            }
        }
        c = this.getParameter("colors");
        int maxcolors = 0;
        if (c != null && c.length() > 0) {
            StringTokenizer q2 = new StringTokenizer(c, ",");
            maxcolors = q2.countTokens();
        }
        int[] tmpcolors = new int[this.objects + 1 + maxcolors];
        if (c != null && c.length() > 0) {
            q = new StringTokenizer(c, ",");
            maxcolors = q.countTokens();
            for (p = 0; p < maxcolors; ++p) {
                k = q.nextToken();
                tmpcolors[p] = this.GetInternalColorCode(k, 0);
            }
        }
        if (maxcolors > 0) {
            this.this_color = maxcolors;
        }
        tmpcolors[maxcolors] = this.color[0];
        for (obj = 1; obj <= this.objects; ++obj) {
            c = this.getParameter("square" + obj);
            int L = 0;
            int coords = 0;
            if (c == null || c.length() <= 0) continue;
            c = c.replace(';', ':');
            c = c.replace('@', ':');
            c = c.replace(' ', ':');
            StringTokenizer q1 = new StringTokenizer(c, ",");
            int array_x = 0;
            int array_y = 0;
            coords = q1.countTokens();
            L = 0;
            try {
                for (int p2 = 0; p2 < coords; ++p2) {
                    String k1 = q1.nextToken();
                    StringTokenizer q2 = new StringTokenizer(k1, ":");
                    boolean out_of_range = false;
                    for (int s = 0; s < 2; ++s) {
                        String k2 = q2.nextToken();
                        int tmp = Integer.parseInt(k2, 10);
                        if (s == 0 && (tmp < this.xmin || tmp > this.xmax)) {
                            out_of_range = true;
                            System.out.println("x-value : " + tmp + " will be ignored !!! it is out of xrange\n");
                        }
                        if (s == 1 && (tmp < this.ymin || tmp > this.ymax)) {
                            out_of_range = true;
                            System.out.println("y-value : " + tmp + " will be ignored !!! it is out of yrange\n");
                        }
                        if (out_of_range) continue;
                        if (s == 0) {
                            this.xcoords[p2][obj] = array_x = (tmp - this.xmin) * (this.xmax - this.xmin) / this.Rx;
                            continue;
                        }
                        this.ycoords[p2][obj] = array_y = this.Ry + (tmp - this.ymin) * (this.ymax - this.ymin) / (-1 * this.Ry);
                    }
                    if (out_of_range) continue;
                    tmpcolors[obj + maxcolors] = this.color[obj];
                    this.Clicktile[array_y][array_x] = this.color[obj];
                    ++L;
                }
                this.length[obj] = L;
                continue;
            }
            catch (Exception e) {
                System.out.println("there is no square" + obj + "\n" + e);
            }
        }
        this.used_colors = this.ListUniq(tmpcolors);
        c = this.getParameter("image");
        if (c != null && c.length() > 0) {
            try {
                this.url = new URL(c);
            }
            catch (MalformedURLException e) {
                this.url = null;
            }
            this.bg = this.url != null ? this.getImage(this.url) : null;
        } else {
            this.bg = null;
        }
        c = this.getParameter("copy");
        if (c != null && c.length() > 0) {
            q = new StringTokenizer(c, ",");
            for (p = 0; p < 2; ++p) {
                k = q.nextToken();
                if (p == 0) {
                    this.copy_x = Integer.parseInt(k, 10);
                }
                if (p != 1) continue;
                this.copy_y = Integer.parseInt(k, 10);
            }
        }
        if ((c = this.getParameter("point_color")) != null && c.length() > 0) {
            this.point_color = this.GetInternalColorCode(c, 0);
        }
        if ((c = this.getParameter("linewidth")) != null && c.length() > 0) {
            this.linewidth = Integer.parseInt(c, 10);
        }
        if ((c = this.getParameter("point")) != null && c.length() > 0) {
            this.Retreive_values_from_coordinates(c, 1);
        } else {
            c = this.getParameter("segment");
            if (c != null && c.length() > 0) {
                this.Retreive_values_from_coordinates(c, 2);
            } else {
                c = this.getParameter("line");
                if (c != null && c.length() > 0) {
                    this.Retreive_values_from_coordinates(c, 3);
                } else {
                    c = this.getParameter("polygon");
                    if (c != null && c.length() > 0) {
                        this.Retreive_values_from_coordinates(c, 4);
                    }
                }
            }
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    @Override
    public synchronized void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.requestFocus();
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.requestFocus();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (this.status) {
            this.dx = evt.getX() / this.x_rect;
            this.dy = evt.getY() / this.y_rect;
            if (evt.getButton() == 3 || evt.getButton() == 2) {
                ++this.this_color;
                System.out.println("Change color : " + this.this_color);
                if (this.this_color > this.used_colors.length - 1) {
                    this.this_color = 0;
                }
                this.Clicktile[this.dy][this.dx] = this.used_colors[this.this_color];
                this.process_mouse(this.dx, this.dy);
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        if (this.status) {
            this.dx = evt.getX() / this.x_rect;
            this.dy = evt.getY() / this.y_rect;
            ++this.this_color;
            if (this.this_color > this.used_colors.length - 1) {
                this.this_color = 0;
            }
            this.Clicktile[this.dy][this.dx] = this.used_colors[this.this_color];
            this.process_mouse(this.dx, this.dy);
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (this.status) {
            this.dx = evt.getX() / this.x_rect;
            this.dy = evt.getY() / this.y_rect;
            this.process_mouse(this.dx, this.dy);
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.status) {
            this.dx = evt.getX() / this.x_rect;
            this.dy = evt.getY() / this.y_rect;
            this.process_mouse(this.dx, this.dy);
        }
    }

    public void process_mouse(int dx, int dy) {
        if (dx > -1 && dy > -1) {
            boolean n = false;
            boolean do_paint = true;
            if (dx >= 0 && dx <= this.Rx && dy >= 0 && dy <= this.Ry) {
                for (int obj = 0; obj <= this.objects && do_paint; ++obj) {
                    for (int p = 0; p < this.length[obj] && do_paint; ++p) {
                        if (this.xcoords[p][obj] != dx || this.ycoords[p][obj] != dy) continue;
                        do_paint = false;
                    }
                }
            }
            if (do_paint) {
                this.Clicktile[dy][dx] = this.used_colors[this.this_color];
                this.repaint();
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        int p;
        this.drawing.setColor(Color.white);
        this.drawing.fillRect(0, 0, this.xsize, this.ysize);
        for (int xr = 0; xr < this.Rx; ++xr) {
            for (int yr = 0; yr < this.Ry; ++yr) {
                int k = this.Clicktile[yr][xr];
                this.drawing.setColor(new Color(this.palette[k][0], this.palette[k][1], this.palette[k][2]));
                this.drawing.fill3DRect(this.x_rect * xr, this.y_rect * yr, this.x_rect, this.y_rect, true);
            }
        }
        if (this.TYPE != 0) {
            this.drawing.setColor(new Color(this.palette[this.point_color][0], this.palette[this.point_color][1], this.palette[this.point_color][2]));
        }
        if (this.TYPE == 1) {
            this.drawing.setStroke(new BasicStroke(this.linewidth, 1, 2));
            for (p = 0; p < this.xpoints.length; ++p) {
                this.drawing.fillOval((int)((double)this.xpoints[p] - 0.5 * (double)this.linewidth), (int)((double)this.ypoints[p] - 0.5 * (double)this.linewidth), this.linewidth, this.linewidth);
            }
        } else if (this.TYPE == 2) {
            this.drawing.setStroke(new BasicStroke(this.linewidth, 1, 2));
            for (p = 0; p < this.xpoints.length - 1; p += 2) {
                this.drawing.drawLine(this.xpoints[p], this.ypoints[p], this.xpoints[p + 1], this.ypoints[p + 1]);
            }
        } else if (this.TYPE == 3) {
            this.drawing.setStroke(new BasicStroke(this.linewidth, 1, 2));
            for (p = 0; p < this.xpoints.length - 1; p += 2) {
                this.drawing.drawLine(this.xpoints[p], this.ypoints[p], this.xpoints[p + 1], this.ypoints[p + 1]);
            }
        } else if (this.TYPE == 4) {
            int lim = this.xpoints.length - 1;
            this.drawing.setStroke(new BasicStroke(this.linewidth, 1, 2));
            for (int p2 = 0; p2 < lim; ++p2) {
                this.drawing.drawLine(this.xpoints[p2], this.ypoints[p2], this.xpoints[p2 + 1], this.ypoints[p2 + 1]);
            }
            this.drawing.drawLine(this.xpoints[lim], this.ypoints[lim], this.xpoints[0], this.ypoints[0]);
        }
        g.drawImage(this.canvas, 0, 0, this);
        if (this.bg != null) {
            g.drawImage(this.bg, this.copy_x, this.copy_y, this);
        }
    }

    @Override
    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @Override
    public void stop() {
        this.thread = null;
    }

    @Override
    public void run() {
        while (this.thread != null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public String ReadApplet() {
        String c = this.getParameter("return_all_objects");
        boolean return_all = false;
        boolean do_print = true;
        if (c.equalsIgnoreCase("yes") || c.equals("1")) {
            return_all = true;
        }
        String reply = "";
        boolean fnd = false;
        int repx = 0;
        int repy = 0;
        String K = "";
        for (int x = 0; x < this.Rx; ++x) {
            for (int y = 0; y < this.Ry; ++y) {
                int k = this.Clicktile[y][x];
                repx = this.xmin + x * this.Rx / (this.xmax - this.xmin);
                repy = this.Ry + (y - this.ymin) * (this.ymax - this.ymin) / (-1 * this.Ry);
                if (return_all) {
                    if (k == this.color[0]) continue;
                    K = this.COLORS[k];
                    if (fnd) {
                        reply = reply + "," + K + "@" + repx + ":" + repy;
                        continue;
                    }
                    fnd = true;
                    reply = K + "@" + repx + ":" + repy;
                    continue;
                }
                do_print = true;
                for (int obj = 0; obj <= this.objects; ++obj) {
                    for (int p = 0; p < this.length[obj]; ++p) {
                        if (this.xcoords[p][obj] != x || this.ycoords[p][obj] != y) continue;
                        do_print = false;
                    }
                }
                if (!do_print || k == this.color[0]) continue;
                K = this.COLORS[k];
                if (fnd) {
                    reply = reply + "," + K + "@" + repx + ":" + repy;
                    continue;
                }
                fnd = true;
                reply = K + "@" + repx + ":" + repy;
            }
        }
        if (reply.length() == 0) {
            reply = "ERROR: YOU DID NOT CLICK ANYTHING";
        }
        return reply;
    }

    public String ReadXY() {
        String c = this.getParameter("return_all_objects");
        boolean return_all = false;
        boolean do_print = true;
        if (c.equalsIgnoreCase("yes") || c.equals("1")) {
            return_all = true;
        }
        String reply_x = "";
        String reply_y = "";
        boolean fnd = false;
        int repx = 0;
        int repy = 0;
        for (int x = 0; x < this.Rx; ++x) {
            for (int y = 0; y < this.Ry; ++y) {
                int k = this.Clicktile[y][x];
                repx = this.xmin + x * this.Rx / (this.xmax - this.xmin);
                repy = this.Ry + (y - this.ymin) * (this.ymax - this.ymin) / (-1 * this.Ry);
                if (return_all) {
                    if (k == this.color[0]) continue;
                    if (fnd) {
                        reply_x = reply_x + "," + repx;
                        reply_y = reply_y + "," + repy;
                        continue;
                    }
                    fnd = true;
                    reply_x = "" + repx;
                    reply_y = "" + repy;
                    continue;
                }
                do_print = true;
                for (int obj = 0; obj <= this.objects; ++obj) {
                    for (int p = 0; p < this.length[obj]; ++p) {
                        if (this.xcoords[p][obj] != x || this.ycoords[p][obj] != y) continue;
                        do_print = false;
                    }
                }
                if (!do_print || k == this.color[0]) continue;
                if (fnd) {
                    reply_x = reply_x + "," + repx;
                    reply_y = reply_y + "," + repy;
                    continue;
                }
                fnd = true;
                reply_x = "" + repx;
                reply_y = "" + repy;
            }
        }
        if (reply_x.length() == 0) {
            reply_x = "ERROR: YOU DID NOT CLICK ANYTHING";
        }
        return reply_x + "\n" + reply_y;
    }

    public int GetInternalColorCode(String c, int defaultcode) {
        int colorcode = defaultcode;
        if (c.equalsIgnoreCase("white")) {
            colorcode = 0;
        } else if (c.equalsIgnoreCase("red")) {
            colorcode = 1;
        } else if (c.equalsIgnoreCase("green")) {
            colorcode = 2;
        } else if (c.equalsIgnoreCase("blue")) {
            colorcode = 3;
        } else if (c.equalsIgnoreCase("orange")) {
            colorcode = 4;
        } else if (c.equalsIgnoreCase("yellow")) {
            colorcode = 5;
        } else if (c.equalsIgnoreCase("purple")) {
            colorcode = 6;
        } else if (c.equalsIgnoreCase("lightgreen")) {
            colorcode = 7;
        } else if (c.equalsIgnoreCase("lightblue")) {
            colorcode = 8;
        } else if (c.equalsIgnoreCase("cyan")) {
            colorcode = 9;
        } else if (c.equalsIgnoreCase("brown")) {
            colorcode = 10;
        } else if (c.equalsIgnoreCase("salmon")) {
            colorcode = 11;
        } else if (c.equalsIgnoreCase("pink")) {
            colorcode = 12;
        } else if (c.equalsIgnoreCase("black")) {
            colorcode = 13;
        }
        return colorcode;
    }

    public int X_ConvertToInternalCoordinates(int x) {
        int X = this.x_rect * (x - this.xmin) * (this.xmax - this.xmin) / this.Rx;
        return X;
    }

    public int Y_ConvertToInternalCoordinates(int y) {
        int Y = this.y_rect * (this.Ry + (y - this.ymin) * (this.ymax - this.ymin) / (-1 * this.Ry));
        return Y;
    }

    public void Retreive_values_from_coordinates(String c, int type) {
        this.TYPE = type;
        c = c.replace(';', ':');
        c = c.replace('@', ':');
        c = c.replace(' ', ':');
        StringTokenizer q1 = new StringTokenizer(c, ",");
        int m0 = q1.countTokens();
        this.xpoints = new int[m0];
        this.ypoints = new int[m0];
        boolean flipflop = true;
        for (int p = 0; p < m0; ++p) {
            String k1 = q1.nextToken();
            StringTokenizer q2 = new StringTokenizer(k1, ":");
            int m1 = q2.countTokens();
            for (int s = 0; s < m1; ++s) {
                int tmp;
                String k2 = q2.nextToken();
                if (flipflop) {
                    try {
                        tmp = Integer.parseInt(k2, 10);
                        this.xpoints[p] = this.X_ConvertToInternalCoordinates(tmp);
                    }
                    catch (Exception e) {
                        System.out.println("ERROR\n" + e);
                    }
                    flipflop = false;
                    continue;
                }
                try {
                    tmp = Integer.parseInt(k2, 10);
                    this.ypoints[p] = this.Y_ConvertToInternalCoordinates(tmp);
                }
                catch (Exception e) {
                    System.out.println("ERROR\n" + e);
                }
                flipflop = true;
            }
        }
    }

    public void Determine_Range(String c, String type) {
        c = c.replace(':', ',');
        c = c.replace(';', ',');
        StringTokenizer q = new StringTokenizer(c, ",");
        for (int p = 0; p < 2; ++p) {
            String k = q.nextToken();
            if (p == 0) {
                if (type.equals("x")) {
                    this.xmin = Integer.parseInt(k, 10);
                    continue;
                }
                this.ymin = Integer.parseInt(k, 10);
                continue;
            }
            if (type.equals("x")) {
                this.xmax = Integer.parseInt(k, 10);
                continue;
            }
            this.ymax = Integer.parseInt(k, 10);
        }
    }

    public void Determine_Color_Names(String lang) {
        if (lang.equalsIgnoreCase("nl")) {
            this.COLORS[0] = "wit";
            this.COLORS[1] = "rood";
            this.COLORS[2] = "groen";
            this.COLORS[3] = "blauw";
            this.COLORS[4] = "oranje";
            this.COLORS[5] = "geel";
            this.COLORS[6] = "paars";
            this.COLORS[7] = "licht groen";
            this.COLORS[8] = "licht blauw";
            this.COLORS[9] = "cyaan";
            this.COLORS[10] = "bruiwn";
            this.COLORS[11] = "zalmroze";
            this.COLORS[12] = "roze";
            this.COLORS[13] = "zwart";
        } else if (lang.equalsIgnoreCase("fr")) {
            this.COLORS[0] = "blanc";
            this.COLORS[1] = "rouge";
            this.COLORS[2] = "vert";
            this.COLORS[3] = "bleu";
            this.COLORS[4] = "orange";
            this.COLORS[5] = "jaune";
            this.COLORS[6] = "violet";
            this.COLORS[7] = "vert p\u00e2le";
            this.COLORS[8] = "bleu clair";
            this.COLORS[9] = "cyan";
            this.COLORS[10] = "marron";
            this.COLORS[11] = "saumon";
            this.COLORS[12] = "rose";
            this.COLORS[13] = "noir";
        } else if (lang.equalsIgnoreCase("de")) {
            this.COLORS[0] = "wei\u00df";
            this.COLORS[1] = "rot";
            this.COLORS[2] = "grun";
            this.COLORS[3] = "blau";
            this.COLORS[4] = "orange";
            this.COLORS[5] = "gelb";
            this.COLORS[6] = "violett";
            this.COLORS[7] = "hellgr\u00fcn";
            this.COLORS[8] = "hellblau";
            this.COLORS[9] = "cyan";
            this.COLORS[10] = "braun";
            this.COLORS[11] = "Lachsfarbig";
            this.COLORS[12] = "rosa";
            this.COLORS[13] = "schwartz";
        } else {
            this.COLORS[0] = "white";
            this.COLORS[1] = "red";
            this.COLORS[2] = "green";
            this.COLORS[3] = "blue";
            this.COLORS[4] = "orange";
            this.COLORS[5] = "yellow";
            this.COLORS[6] = "purple";
            this.COLORS[7] = "lightgreen";
            this.COLORS[8] = "lightblue";
            this.COLORS[9] = "cyan";
            this.COLORS[10] = "brown";
            this.COLORS[11] = "salmon";
            this.COLORS[12] = "pink";
            this.COLORS[13] = "black";
        }
    }

    public int[] ListUniq(int[] array) {
        Arrays.sort(array);
        int k = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i > 0 && array[i] == array[i - 1]) continue;
            array[k++] = array[i];
        }
        int[] unique = new int[k];
        System.arraycopy(array, 0, unique, 0, k);
        return unique;
    }
}

