/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.ArrangeMolecule;
import WIMSchem.DrawMolecule;
import WIMSchem.MainApplet;
import WIMSchem.MainPanel;
import WIMSchem.MolSelectListener;
import WIMSchem.Molecule;
import WIMSchem.MoleculeStream;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.TransferHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorPane
extends JComponent
implements MouseListener,
MouseMotionListener,
FocusListener,
KeyListener,
MouseWheelListener,
ComponentListener {
    private Molecule mol;
    private boolean editable = true;
    private boolean hasBorder = false;
    private boolean autoScale = false;
    private static final double IDEALBOND = 1.5;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double scale = 20.0;
    public boolean[] selected = null;
    public boolean[] dragged = null;
    private double[] px = null;
    private double[] py = null;
    private double[] rw = null;
    private double[] rh = null;
    private int highlightAtom = 0;
    private int highlightBond = 0;
    boolean showHydr = false;
    public static boolean[] bondselection = null;
    public static boolean[] atomselection = null;
    private int showMode = 0;
    private boolean showSter = false;
    private static final int TOOL_CURSOR = 1;
    private static final int TOOL_ROTATOR = 2;
    private static final int TOOL_ERASOR = 3;
    private static final int TOOL_ATOM = 4;
    private static final int TOOL_BOND = 5;
    private static final int TOOL_CHARGE = 6;
    private static final int TOOL_TEMPLATE = 7;
    private static final int TOOL_SELECT = 8;
    private static final int DRAG_SELECT = 1;
    private static final int DRAG_MOVE = 2;
    private static final int DRAG_COPY = 3;
    private static final int DRAG_SCALE = 4;
    private static final int DRAG_ROTATE = 5;
    private int trackX = -1;
    private int trackY = -1;
    private boolean isSelectionPane = false;
    private int selBoxW = 0;
    private int selBoxH = 0;
    private MolSelectListener selectListen = null;
    private int tool = 0;
    private int toolDragReason = 0;
    private double toolDragX1;
    private double toolDragY1;
    private double toolDragX2;
    private double toolDragY2;
    private String toolAtomType = null;
    private boolean toolAtomDrag;
    private boolean toolAtomSnap;
    private int toolAtomEditSel = 0;
    private int toolAtomEditX;
    private int toolAtomEditY;
    private JTextField toolAtomEditBox = null;
    private int toolBondOrder = 0;
    private int toolBondType = 0;
    private int toolBondFrom = 0;
    private int toolBondHit = 0;
    private double toolBondFromX = 0.0;
    private double toolBondFromY = 0.0;
    private double toolBondToX = 0.0;
    private double toolBondToY = 0.0;
    private boolean toolSnap;
    private boolean toolBondDrag = false;
    private int toolCharge = 0;
    private static final int UNDO_LEVELS = 10;
    private EditState[] undo = null;
    private EditState[] redo = null;
    private Molecule template = null;
    private Molecule templDraw = null;
    private int templateIdx = 0;
    private Molecule lastCleanMol = null;
    private boolean lastDirty = false;

    public EditorPane() {
        this.init();
    }

    public EditorPane(int width, int height) {
        this.isSelectionPane = true;
        this.selBoxW = width;
        this.selBoxH = height;
        this.init();
    }

    private void init() {
        this.mol = new Molecule();
        if (MainApplet.USER_SELECTION) {
            atomselection = new boolean[this.mol.numAtoms() + 32];
            bondselection = new boolean[this.mol.numBonds() + 32];
            for (int p = 0; p < this.mol.numAtoms() + 32; ++p) {
                EditorPane.atomselection[p] = false;
                EditorPane.bondselection[p] = false;
            }
        }
        this.determineSize();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
    }

    public void enableDnD() {
        this.setTransferHandler(new TransferMoleculeDest(this));
    }

    public Molecule molData() {
        return this.mol;
    }

    public boolean isEmpty() {
        return this.mol.numAtoms() == 0;
    }

    public void clear() {
        this.cacheUndo();
        if (MainApplet.USER_SELECTION) {
            atomselection = new boolean[256];
            bondselection = new boolean[256];
        }
        this.mol = new Molecule();
        this.clearTemporary();
        this.determineSize();
        this.repaint();
        this.checkDirtiness();
    }

    public void replace(Molecule Mol) {
        this.replace(Mol, false, true);
    }

    public void replace(Molecule Mol, boolean ClearSelection) {
        this.replace(Mol, ClearSelection, true);
    }

    public void replace(Molecule Mol, boolean ClearSelection, boolean Repaint) {
        if (this.mol.numAtoms() != Mol.numAtoms()) {
            ClearSelection = true;
        }
        this.mol = Mol;
        this.clearTemporary(ClearSelection);
        if (Repaint) {
            this.repaint();
        }
    }

    public void setMolSelectListener(MolSelectListener listen) {
        this.selectListen = listen;
    }

    public void setEditable(boolean Editable) {
        this.editable = Editable;
    }

    public void setBorder(boolean HasBorder) {
        this.hasBorder = HasBorder;
    }

    public void setAutoScale(boolean AutoScale) {
        this.autoScale = AutoScale;
    }

    public void notifySaved() {
        this.lastCleanMol = this.mol.clone();
        this.lastDirty = false;
        if (this.selectListen != null) {
            this.selectListen.dirtyChanged(false);
        }
    }

    public boolean isDirty() {
        return this.lastDirty;
    }

    private void checkDirtiness() {
        boolean nowDirty;
        boolean bl = nowDirty = this.mol.compareTo(this.lastCleanMol) != 0;
        if (nowDirty != this.lastDirty) {
            if (this.selectListen != null) {
                this.selectListen.dirtyChanged(nowDirty);
            }
            this.lastDirty = nowDirty;
        }
    }

    public void setShowMode(int ShowMode) {
        if (this.showMode == ShowMode) {
            return;
        }
        this.showMode = ShowMode;
        this.repaint();
    }

    public void setShowHydrogens(boolean ShowHydr) {
        if (this.showHydr == ShowHydr) {
            return;
        }
        this.showHydr = ShowHydr;
        this.repaint();
    }

    public void setShowStereolabels(boolean ShowSter) {
        if (this.showSter == ShowSter) {
            return;
        }
        this.showSter = ShowSter;
        this.repaint();
    }

    public void setToolCursor() {
        this.tool = 1;
        this.repaint();
    }

    public void setToolRotator() {
        this.tool = 2;
        this.repaint();
    }

    public void setToolErasor() {
        this.tool = 3;
        this.repaint();
    }

    public void setToolAtom(String Atom2) {
        this.tool = 4;
        this.toolAtomType = Atom2;
        this.toolAtomDrag = false;
        this.toolAtomSnap = false;
        this.toolBondFrom = 0;
        this.toolBondToX = 0.0;
        this.toolBondToY = 0.0;
        this.repaint();
    }

    public void setToolBond(int Order) {
        this.tool = 5;
        this.toolBondFrom = 0;
        if (Order >= 0) {
            this.toolBondOrder = Order;
            this.toolBondType = 0;
        } else {
            this.toolBondOrder = 1;
            if (Order == -1) {
                this.toolBondType = 1;
            } else if (Order == -2) {
                this.toolBondType = 2;
            } else if (Order == -3) {
                this.toolBondType = 3;
            }
        }
        this.repaint();
    }

    public void setToolCharge(int DChg) {
        this.tool = 6;
        this.toolCharge = DChg;
    }

    public void setToolTemplate(Molecule Templ, int Idx) {
        this.tool = 7;
        this.template = Templ;
        this.templateIdx = Idx;
        this.repaint();
    }

    public boolean canUndo() {
        return this.undo != null && this.undo[0] != null;
    }

    public boolean canRedo() {
        return this.redo != null && this.redo[0] != null;
    }

    public void undo() {
        int n;
        if (!this.canUndo()) {
            return;
        }
        if (this.redo == null) {
            this.redo = new EditState[10];
        }
        for (n = 9; n > 0; --n) {
            this.redo[n] = this.redo[n - 1];
        }
        this.redo[0] = new EditState();
        this.redo[0].Molecule = this.mol;
        this.redo[0].Selected = this.selected;
        this.mol = this.undo[0].Molecule;
        this.selected = this.undo[0].Selected;
        for (n = 0; n < 9; ++n) {
            this.undo[n] = this.undo[n + 1];
        }
        this.clearTemporary(false);
        this.determineSize();
        this.repaint();
        this.checkDirtiness();
    }

    public void redo() {
        int n;
        if (!this.canRedo()) {
            return;
        }
        if (this.undo == null) {
            this.undo = new EditState[10];
        }
        for (n = 9; n > 0; --n) {
            this.undo[n] = this.undo[n - 1];
        }
        this.undo[0] = new EditState();
        this.undo[0].Molecule = this.mol;
        this.undo[0].Selected = this.selected;
        this.mol = this.redo[0].Molecule;
        this.selected = this.redo[0].Selected;
        for (n = 0; n < 9; ++n) {
            this.redo[n] = this.redo[n + 1];
        }
        this.clearTemporary(false);
        this.determineSize();
        this.repaint();
        this.checkDirtiness();
    }

    public void scaleToFit() {
        this.scaleToFit(20.0);
    }

    public void scaleToFit(double MaxScale) {
        this.clearTemporary();
        double mw = 2.0 + this.mol.rangeX();
        double mh = 2.0 + this.mol.rangeY();
        Rectangle vis = this.getVisibleRect();
        if (vis.getWidth() == 0.0 || vis.getHeight() == 0.0) {
            vis = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        double sw = (double)this.selBoxW > vis.getWidth() ? (double)this.selBoxW : vis.getWidth();
        double sh = (double)this.selBoxH > vis.getHeight() ? (double)this.selBoxH : vis.getHeight();
        this.scale = Math.min(Math.min(sw / mw, sh / mh), MaxScale);
        this.offsetX = 0.5 * (sw / this.scale - this.mol.rangeX()) - this.mol.minX();
        this.offsetY = 0.5 * (sh / this.scale - this.mol.rangeY()) + this.mol.maxY();
    }

    public void zoomFull() {
        this.scaleToFit();
        this.determineSize();
        this.repaint();
    }

    public void zoomIn(double Mag) {
        this.scale *= Mag;
        this.determineSize();
        this.repaint();
    }

    public void zoomOut(double Mag) {
        this.scale /= Mag;
        this.determineSize();
        this.repaint();
    }

    public void deSelectAll() {
        if (MainPanel.appletMode) {
            int p;
            int i = atomselection.length;
            for (p = 0; p < i; ++p) {
                EditorPane.atomselection[p] = false;
            }
            i = bondselection.length;
            for (p = 0; p < i; ++p) {
                EditorPane.bondselection[p] = false;
            }
            System.out.println("EditorPane deSelectAll()");
            this.repaint();
        }
    }

    public void Select() {
        System.out.println("EditorPane Select()");
        this.tool = 8;
    }

    public void selectAll() {
        this.selected = new boolean[this.mol.numAtoms()];
        for (int n = 0; n < this.mol.numAtoms(); ++n) {
            this.selected[n] = true;
        }
        this.repaint();
    }

    public void addArbitraryFragment(Molecule Frag) {
        int n;
        if (Frag.numAtoms() == 0) {
            return;
        }
        this.cacheUndo();
        if (this.mol.numAtoms() == 0) {
            this.mol = Frag;
            this.clearTemporary();
            this.scaleToFit();
            this.determineSize();
            this.repaint();
            this.checkDirtiness();
            return;
        }
        double[] dirX = new double[]{1.0, 0.0, -1.0, 1.0, -1.0, 1.0, 0.0, -1.0};
        double[] dirY = new double[]{1.0, 1.0, 1.0, 0.0, 0.0, -1.0, -1.0, -1.0};
        double[] dx = new double[8];
        double[] dy = new double[8];
        double[] score = new double[8];
        for (int n2 = 0; n2 < 8; ++n2) {
            double iscore;
            int iter;
            double vx = dirX[n2];
            double vy = dirY[n2];
            dx[n2] = n2 == 0 || n2 == 3 || n2 == 5 ? this.mol.minX() - Frag.maxX() : (n2 == 2 || n2 == 4 || n2 == 7 ? this.mol.maxX() - Frag.minX() : 0.5 * (this.mol.minX() + this.mol.maxX() - Frag.minX() - Frag.maxX()));
            dy[n2] = n2 == 5 || n2 == 6 || n2 == 7 ? this.mol.minY() - Frag.maxY() : (n2 == 0 || n2 == 1 || n2 == 2 ? this.mol.maxY() - Frag.minY() : 0.5 * (this.mol.minY() + this.mol.maxY() - Frag.minY() - Frag.maxY()));
            int n3 = n2;
            dx[n3] = dx[n3] - vx;
            int n4 = n2;
            dy[n4] = dy[n4] - vy;
            score[n2] = this.fragPosScore(Frag, dx[n2], dy[n2]);
            vx *= 0.25;
            vy *= 0.25;
            for (iter = 100; iter > 0 && !((iscore = this.fragPosScore(Frag, dx[n2] + vx, dy[n2] + vy)) <= score[n2]); --iter) {
                score[n2] = iscore;
                int n5 = n2;
                dx[n5] = dx[n5] + vx;
                int n6 = n2;
                dy[n6] = dy[n6] + vy;
            }
            for (iter = 100; iter > 0; --iter) {
                double iscore2;
                for (int d = 0; d < 8 && !((iscore2 = this.fragPosScore(Frag, dx[n2] + (vx = dirX[d] * 0.1), dy[n2] + (vy = dirY[d] * 0.1))) <= score[n2]); ++d) {
                    score[n2] = iscore2;
                    int n7 = n2;
                    dx[n7] = dx[n7] + vx;
                    int n8 = n2;
                    dy[n8] = dy[n8] + vy;
                }
            }
        }
        int best = 0;
        for (n = 1; n < 8; ++n) {
            if (!(score[n] > score[best])) continue;
            best = n;
        }
        for (n = 1; n <= Frag.numAtoms(); ++n) {
            Frag.setAtomPos(n, Frag.atomX(n) + dx[best], Frag.atomY(n) + dy[best]);
        }
        int base = this.mol.numAtoms();
        this.mol.append(Frag);
        this.clearTemporary();
        this.scaleToFit();
        this.determineSize();
        this.selected = new boolean[this.mol.numAtoms()];
        for (int n9 = 0; n9 < this.mol.numAtoms(); ++n9) {
            this.selected[n9] = n9 >= base;
        }
        this.repaint();
        this.checkDirtiness();
    }

    private void addFragmentPosition(Molecule Frag, int X, int Y) {
        int n;
        double loY;
        double loX;
        if (Frag.numAtoms() == 0) {
            return;
        }
        double cx = this.xToAng(X);
        double cy = this.yToAng(Y);
        double hiX = loX = Frag.atomX(1);
        double hiY = loY = Frag.atomY(1);
        for (n = 2; n <= Frag.numAtoms(); ++n) {
            loX = Math.min(loX, Frag.atomX(n));
            hiX = Math.max(hiX, Frag.atomX(n));
            loY = Math.min(loY, Frag.atomY(n));
            hiY = Math.max(hiY, Frag.atomY(n));
        }
        cx -= 0.5 * (loX + hiX);
        cy -= 0.5 * (loY + hiY);
        for (n = 1; n <= Frag.numAtoms(); ++n) {
            Frag.setAtomPos(n, Frag.atomX(n) + cx, Frag.atomY(n) + cy);
        }
        this.cacheUndo();
        int base = this.mol.numAtoms();
        this.mol.append(Frag);
        this.clearTemporary();
        this.scaleToFit();
        this.determineSize();
        this.selected = new boolean[this.mol.numAtoms()];
        for (int n2 = 0; n2 < this.mol.numAtoms(); ++n2) {
            this.selected[n2] = n2 >= base;
        }
        this.repaint();
        this.checkDirtiness();
    }

    private double fragPosScore(Molecule Frag, double DX, double DY) {
        double score = 0.0;
        for (int i = 1; i <= this.mol.numAtoms(); ++i) {
            for (int j = 1; j <= Frag.numAtoms(); ++j) {
                double dy;
                double dx = Frag.atomX(j) + DX - this.mol.atomX(i);
                double dist2 = dx * dx + (dy = Frag.atomY(j) + DY - this.mol.atomY(i)) * dy;
                if (dist2 < 1.0) {
                    return 0.0;
                }
                score += 1.0 / dist2;
            }
        }
        double minX = Math.min(Frag.minX() + DX, this.mol.minX());
        double maxX = Math.max(Frag.maxX() + DX, this.mol.maxX());
        double minY = Math.min(Frag.minY() + DY, this.mol.minY());
        double maxY = Math.max(Frag.maxY() + DY, this.mol.maxY());
        double rangeX = Math.max(1.0, maxX - minX);
        double rangeY = Math.max(1.0, maxY - minY);
        double ratio = Math.max(rangeX / rangeY, rangeY / rangeX);
        return score / ratio;
    }

    public int countSelected() {
        if (this.selected == null) {
            return 0;
        }
        int num = 0;
        for (int n = 0; n < this.mol.numAtoms(); ++n) {
            if (!this.selected[n]) continue;
            ++num;
        }
        return num;
    }

    public ArrayList<Integer> selectedIndices() {
        int n;
        ArrayList<Integer> selidx = new ArrayList<Integer>();
        if (this.selected != null) {
            for (n = 0; n < this.mol.numAtoms(); ++n) {
                if (!this.selected[n]) continue;
                selidx.add(n + 1);
            }
        }
        if (selidx.size() == 0) {
            for (n = 1; n <= this.mol.numAtoms(); ++n) {
                selidx.add(n);
            }
        }
        return selidx;
    }

    public Molecule selectedSubgraph() {
        if (this.selected == null) {
            return this.mol.clone();
        }
        int sum = 0;
        for (int n = 0; n < this.mol.numAtoms(); ++n) {
            if (!this.selected[n]) continue;
            ++sum;
        }
        if (sum == 0) {
            return this.mol.clone();
        }
        return this.mol.subgraph(this.selected);
    }

    public void deleteSelected() {
        int n;
        this.cacheUndo();
        boolean anySelected = false;
        if (this.selected != null) {
            for (n = 0; n < this.mol.numAtoms(); ++n) {
                if (!this.selected[n]) continue;
                anySelected = true;
                break;
            }
        }
        if (!anySelected) {
            return;
        }
        for (n = this.mol.numAtoms() - 1; n >= 0; --n) {
            if (!this.selected[n]) continue;
            this.mol.deleteAtomAndBonds(n + 1);
        }
        this.clearTemporary();
        this.determineSize();
        this.repaint();
        this.checkDirtiness();
    }

    public void hydrogenSetExplicit(boolean IsExpl) {
        this.hydrogenSetExplicit(IsExpl, -1);
    }

    public void hydrogenSetExplicit(boolean IsExpl, int NumExpl) {
        this.cacheUndo();
        ArrayList<Integer> sel = this.selectedIndices();
        for (int n = 0; n < sel.size(); ++n) {
            int i = sel.get(n);
            if (IsExpl) {
                this.mol.setAtomHExplicit(i, this.mol.atomHydrogens(i));
                continue;
            }
            this.mol.setAtomHExplicit(i, NumExpl);
        }
        this.repaint();
        this.checkDirtiness();
    }

    public void hydrogenCreateActual() {
        this.cacheUndo();
        ArrayList<Integer> sel = this.selectedIndices();
        int[] score = new int[360];
        for (int n = 0; n < sel.size(); ++n) {
            int i2;
            int i1;
            int i0;
            int i = sel.get(n);
            int hy = this.mol.atomHydrogens(i);
            if (hy == 0) continue;
            for (int j = 0; j < 360; ++j) {
                score[j] = 0;
            }
            int[] adj = this.mol.atomAdjList(i);
            for (int j = 0; j < adj.length; ++j) {
                int iang = (int)(Math.atan2(this.mol.atomY(adj[j]) - this.mol.atomY(i), this.mol.atomX(adj[j]) - this.mol.atomX(i)) * 180.0 / Math.PI);
                if (iang < 0) {
                    iang += 360;
                }
                score[iang] = -1;
                score[(iang + 1) % 360] = -1;
                score[(iang + 359) % 360] = -1;
                i0 = (iang + 180) % 360;
                i1 = (iang + 120) % 360;
                i2 = (iang + 240) % 360;
                if (score[i0] >= 0) {
                    int n2 = i0;
                    score[n2] = score[n2] + 2;
                }
                if (score[i1] >= 0) {
                    int n3 = i1;
                    score[n3] = score[n3] + 4;
                }
                if (score[i2] < 0) continue;
                int n4 = i2;
                score[n4] = score[n4] + 4;
            }
            while (hy > 0) {
                int iang = 0;
                for (int j = 1; j < 360; ++j) {
                    if (score[j] <= score[iang]) continue;
                    iang = j;
                }
                int num = this.mol.addAtom("H", this.mol.atomX(i) + Math.cos((double)iang * Math.PI / 180.0), this.mol.atomY(i) + Math.sin((double)iang * Math.PI / 180.0));
                this.mol.addBond(i, num, 1);
                score[iang] = -1;
                score[(iang + 1) % 360] = -1;
                score[(iang + 359) % 360] = -1;
                i0 = (iang + 180) % 360;
                i1 = (iang + 120) % 360;
                i2 = (iang + 240) % 360;
                if (score[i0] >= 0) {
                    int n5 = i0;
                    score[n5] = score[n5] + 1;
                }
                if (score[i1] >= 0) {
                    int n6 = i1;
                    score[n6] = score[n6] + 2;
                }
                if (score[i2] >= 0) {
                    int n7 = i2;
                    score[n7] = score[n7] + 2;
                }
                --hy;
            }
            this.mol.setAtomHExplicit(i, -1);
        }
        this.clearTemporary();
        this.determineSize();
        this.repaint();
        this.checkDirtiness();
    }

    public void hydrogenDeleteActual() {
        int n;
        ArrayList<Integer> sel = this.selectedIndices();
        ArrayList<Integer> chop = new ArrayList<Integer>();
        for (n = 0; n < sel.size(); ++n) {
            int i = sel.get(n);
            if (this.mol.atomElement(i).compareTo("H") == 0) {
                chop.add(new Integer(i));
            }
            int[] adj = this.mol.atomAdjList(i);
            for (int j = 0; j < adj.length; ++j) {
                if (this.mol.atomElement(adj[j]).compareTo("H") != 0) continue;
                chop.add(adj[j]);
            }
        }
        if (chop.size() == 0) {
            return;
        }
        this.cacheUndo();
        Collections.sort(chop);
        for (n = 0; n < chop.size(); ++n) {
            int[] adj = this.mol.atomAdjList((Integer)chop.get(n));
            for (int i = 0; i < adj.length; ++i) {
                this.mol.setAtomHExplicit(adj[i], -1);
            }
        }
        int decr = 0;
        int lastVal = -1;
        for (int n2 = 0; n2 < chop.size(); ++n2) {
            int i = (Integer)chop.get(n2);
            if (i == lastVal) continue;
            this.mol.deleteAtomAndBonds(i - decr);
            ++decr;
            lastVal = i;
        }
        this.clearTemporary();
        this.determineSize();
        this.repaint();
        this.checkDirtiness();
    }

    public void normaliseBondLengths() {
        double numer = 0.0;
        double denom = 0.0;
        for (int n = 1; n <= this.mol.numBonds(); ++n) {
            double dx = this.mol.atomX(this.mol.bondFrom(n)) - this.mol.atomX(this.mol.bondTo(n));
            double dy = this.mol.atomY(this.mol.bondFrom(n)) - this.mol.atomY(this.mol.bondTo(n));
            double weight = this.mol.bondInRing(n) ? 1.0 : 2.0;
            numer += Math.sqrt(dx * dx + dy * dy) * weight;
            denom += weight;
        }
        if (denom == 0.0) {
            return;
        }
        this.cacheUndo();
        double stretch = 1.5 * denom / numer;
        for (int n = 1; n <= this.mol.numAtoms(); ++n) {
            this.mol.setAtomPos(n, this.mol.atomX(n) * stretch, this.mol.atomY(n) * stretch);
        }
        this.clearTemporary();
        this.determineSize();
        this.repaint();
    }

    public void cycleSelection(boolean Forward, boolean Group) {
        int pos;
        int max;
        if (this.mol.numAtoms() <= 1) {
            return;
        }
        int high = 0;
        if (this.selected != null) {
            for (int n = 1; n <= this.mol.numAtoms(); ++n) {
                if (!this.selected[n - 1]) continue;
                if (Group) {
                    if (this.mol.atomConnComp(n) <= high) continue;
                    high = this.mol.atomConnComp(n);
                    continue;
                }
                high = n;
            }
        }
        int n = max = Group ? 0 : this.mol.numAtoms();
        if (Group) {
            for (int n2 = 1; n2 <= this.mol.numAtoms(); ++n2) {
                if (this.mol.atomConnComp(n2) <= max) continue;
                max = this.mol.atomConnComp(n2);
            }
        }
        int n3 = pos = Forward ? high + 1 : high - 1;
        if (pos < 1) {
            pos = max;
        }
        if (pos > max) {
            pos = 1;
        }
        this.selected = new boolean[this.mol.numAtoms()];
        for (int n4 = 1; n4 <= this.mol.numAtoms(); ++n4) {
            this.selected[n4 - 1] = Group ? this.mol.atomConnComp(n4) == pos : n4 == pos;
        }
        this.clearTemporary(false);
        this.repaint();
    }

    public void nudgeSelectedAtoms(double DX, double DY) {
        if (this.selected == null) {
            return;
        }
        this.cacheUndo();
        for (int n = 1; n <= this.mol.numAtoms(); ++n) {
            if (!this.selected[n - 1]) continue;
            this.mol.setAtomPos(n, this.mol.atomX(n) + DX, this.mol.atomY(n) + DY);
        }
        this.clearTemporary(false);
        this.determineSize();
        this.repaint();
    }

    public void flipSelectedAtoms(boolean Vertical) {
        int n;
        if (this.selected == null) {
            return;
        }
        int count = 0;
        double cx = 0.0;
        double cy = 0.0;
        for (n = 1; n <= this.mol.numAtoms(); ++n) {
            if (!this.selected[n - 1]) continue;
            cx += this.mol.atomX(n);
            cy += this.mol.atomY(n);
            ++count;
        }
        if (count == 0) {
            return;
        }
        this.cacheUndo();
        cx /= (double)count;
        cy /= (double)count;
        for (n = 1; n <= this.mol.numAtoms(); ++n) {
            if (!this.selected[n - 1]) continue;
            if (Vertical) {
                this.mol.setAtomPos(n, this.mol.atomX(n), 2.0 * cy - this.mol.atomY(n));
                continue;
            }
            this.mol.setAtomPos(n, 2.0 * cx - this.mol.atomX(n), this.mol.atomY(n));
        }
        this.clearTemporary(false);
        this.determineSize();
        this.repaint();
    }

    public void rotateSelectedAtoms(double Degrees) {
        if (this.selected == null) {
            return;
        }
        int count = 0;
        double cx = 0.0;
        double cy = 0.0;
        for (int n = 1; n <= this.mol.numAtoms(); ++n) {
            if (!this.selected[n - 1]) continue;
            cx += this.mol.atomX(n);
            cy += this.mol.atomY(n);
            ++count;
        }
        if (count == 0) {
            return;
        }
        this.cacheUndo();
        cx /= (double)count;
        cy /= (double)count;
        double radians = Degrees * Math.PI / 180.0;
        for (int n = 1; n <= this.mol.numAtoms(); ++n) {
            if (!this.selected[n - 1]) continue;
            double dx = this.mol.atomX(n) - cx;
            double dy = this.mol.atomY(n) - cy;
            double dist = Math.sqrt(dx * dx + dy * dy);
            double theta = Math.atan2(dy, dx);
            this.mol.setAtomPos(n, cx + dist * Math.cos(theta + radians), cy + dist * Math.sin(theta + radians));
        }
        this.clearTemporary(false);
        this.determineSize();
        this.repaint();
    }

    public void setStereo(int Operation) {
        int n;
        ArrayList<Integer> selidx = this.selectedIndices();
        int[][] graph = new int[this.mol.numAtoms()][];
        for (n = 0; n < this.mol.numAtoms(); ++n) {
            graph[n] = this.mol.atomAdjList(n + 1);
        }
        this.cacheUndo();
        for (n = 0; n < selidx.size(); ++n) {
            int a = selidx.get(n);
            int ster = this.mol.atomChirality(a);
            if (Operation != 3 ? ster == Operation : ster != 1 && ster != 2) continue;
            if (ster == 1 || ster == 2) {
                for (int i = 1; i <= this.mol.numBonds(); ++i) {
                    if (this.mol.bondFrom(i) != a) continue;
                    if (this.mol.bondType(i) == 1) {
                        this.mol.setBondType(i, 2);
                        continue;
                    }
                    if (this.mol.bondType(i) != 2) continue;
                    this.mol.setBondType(i, 1);
                }
                continue;
            }
            ArrayList<int[]> perm = this.wedgeFormations(a, Operation);
            if (perm == null || perm.size() <= 0) continue;
            int[] adj = this.mol.atomAdjList(a);
            for (int i = 0; i < adj.length; ++i) {
                int j = this.mol.findBond(a, adj[i]);
                if (j == 0) continue;
                this.mol.setBondType(j, perm.get(0)[i] < 0 ? 2 : (perm.get(0)[i] > 0 ? 1 : 0));
                if (this.mol.bondFrom(j) == a) continue;
                this.mol.setBondFromTo(j, this.mol.bondTo(j), this.mol.bondFrom(j));
            }
        }
        for (n = 1; n <= this.mol.numBonds(); ++n) {
            int i;
            boolean changed;
            int ster;
            int bf = this.mol.bondFrom(n);
            int bt = this.mol.bondTo(n);
            if (this.mol.bondOrder(n) == 2 && selidx.indexOf(bf) < 0 && selidx.indexOf(bt) < 0 || (ster = this.mol.bondStereo(n)) != 1 && ster != 2 || ster == Operation || this.mol.atomRingBlock(bf) != 0 && this.mol.atomRingBlock(bf) != this.mol.atomRingBlock(bt)) continue;
            int sc1 = 1;
            int sc2 = 1;
            int[] side = new int[this.mol.numAtoms()];
            for (int i2 = 0; i2 < this.mol.numAtoms(); ++i2) {
                side[i2] = 0;
            }
            side[bf - 1] = 1;
            side[bt - 1] = 2;
            do {
                changed = false;
                for (int i3 = 0; i3 < this.mol.numAtoms(); ++i3) {
                    if (side[i3] != 0) continue;
                    for (int j = 0; j < graph[i3].length; ++j) {
                        if (side[graph[i3][j] - 1] == 0) continue;
                        side[i3] = side[graph[i3][j] - 1];
                        if (side[i3] == 1) {
                            ++sc1;
                        } else {
                            ++sc2;
                        }
                        changed = true;
                    }
                }
            } while (changed);
            int which = sc1 <= sc2 ? 1 : 2;
            double cx = this.mol.atomX(which == 1 ? bf : bt);
            double cy = this.mol.atomY(which == 1 ? bf : bt);
            double axis = Math.atan2(cy - this.mol.atomY(which == 1 ? bt : bf), cx - this.mol.atomX(which == 1 ? bt : bf));
            for (i = 0; i < this.mol.numAtoms(); ++i) {
                if (side[i] != which) continue;
                double dx = this.mol.atomX(i + 1) - cx;
                double dy = this.mol.atomY(i + 1) - cy;
                double r = Math.sqrt(dx * dx + dy * dy);
                double th = Math.atan2(dy, dx);
                th = 2.0 * axis - th;
                this.mol.setAtomPos(i + 1, cx + r * Math.cos(th), cy + r * Math.sin(th));
            }
            for (i = 1; i <= this.mol.numBonds(); ++i) {
                if (this.mol.bondType(i) != 1 && this.mol.bondType(i) != 2 || side[this.mol.bondFrom(i) - 1] != which || side[this.mol.bondTo(i) - 1] != which) continue;
                this.mol.setBondType(i, this.mol.bondType(i) == 1 ? 2 : 1);
            }
        }
        this.clearTemporary(false);
        this.determineSize();
        this.repaint();
    }

    public void removeChiralWedges() {
        this.cacheUndo();
        ArrayList<Integer> selidx = this.selectedIndices();
        for (int n = 0; n < selidx.size(); ++n) {
            if (this.mol.atomChirality(selidx.get(n)) == 0) continue;
            for (int i = 1; i <= this.mol.numBonds(); ++i) {
                if (this.mol.bondFrom(i) != selidx.get(n).intValue() && this.mol.bondTo(i) != selidx.get(n).intValue() || this.mol.bondType(i) != 1 && this.mol.bondType(i) != 2) continue;
                this.mol.setBondType(i, 0);
            }
        }
        this.repaint();
    }

    public void cycleChiralWedges() {
        this.cacheUndo();
        ArrayList<Integer> selidx = this.selectedIndices();
        for (int n = 0; n < selidx.size(); ++n) {
            int i;
            ArrayList<int[]> perm;
            int a = selidx.get(n);
            int chi = this.mol.atomChirality(a);
            if (chi != 1 && chi != 2 || (perm = this.wedgeFormations(a, chi)).size() <= 1) continue;
            int[] adj = this.mol.atomAdjList(a);
            int[] curperm = new int[adj.length];
            for (int i2 = 0; i2 < adj.length; ++i2) {
                int j = this.mol.findBond(a, adj[i2]);
                curperm[i2] = this.mol.bondType(j) == 1 ? 1 : (this.mol.bondType(j) == 2 ? -1 : 0);
            }
            int match = -1;
            for (i = 0; i < perm.size(); ++i) {
                int[] thisperm = perm.get(i);
                boolean same = true;
                for (int j = 0; j < curperm.length; ++j) {
                    if (thisperm[j] == curperm[j]) continue;
                    same = false;
                    break;
                }
                if (!same) continue;
                match = i;
                break;
            }
            match = (match + 1) % perm.size();
            curperm = perm.get(match);
            for (i = 0; i < adj.length; ++i) {
                int j = this.mol.findBond(a, adj[i]);
                if (this.mol.bondFrom(j) != a) {
                    this.mol.setBondFromTo(j, a, adj[i]);
                }
                this.mol.setBondType(j, curperm[i] < 0 ? 2 : (curperm[i] > 0 ? 1 : 0));
            }
        }
        this.repaint();
    }

    double angToX(double AX) {
        return (this.offsetX + AX) * this.scale;
    }

    double angToY(double AY) {
        return (this.offsetY - AY) * this.scale;
    }

    double xToAng(double PX) {
        return PX / this.scale - this.offsetX;
    }

    double yToAng(double PY) {
        return -PY / this.scale + this.offsetY;
    }

    void determineSize() {
        int h;
        int w;
        if (!this.isSelectionPane) {
            w = Math.max((int)this.angToX(this.mol.maxX() + 1.0), 500);
            h = Math.max((int)this.angToY(this.mol.minY() - 1.0), 500);
        } else {
            w = this.selBoxW;
            h = this.selBoxH;
        }
        this.setPreferredSize(new Dimension(w, h));
        this.setSize(w, h);
    }

    void clearTemporary() {
        this.clearTemporary(true);
    }

    void clearTemporary(boolean AndSelected) {
        this.rh = null;
        this.rw = null;
        this.py = null;
        this.px = null;
        this.highlightBond = 0;
        this.highlightAtom = 0;
        if (AndSelected) {
            this.selected = null;
        } else if (this.selected != null && this.selected.length != this.mol.numAtoms()) {
            boolean[] newSelected = new boolean[this.mol.numAtoms()];
            for (int n = 0; n < this.selected.length; ++n) {
                newSelected[n] = this.selected[n];
            }
            this.selected = newSelected;
        }
    }

    void resetSelected(boolean Clear) {
        if (this.selected == null) {
            this.selected = new boolean[this.mol.numAtoms()];
        }
        if (Clear) {
            for (int n = 0; n < this.mol.numAtoms(); ++n) {
                this.selected[n] = false;
            }
        }
    }

    private int pickAtom(int X, int Y) {
        if (this.px == null || this.py == null) {
            return 0;
        }
        for (int n = 1; n <= this.mol.numAtoms(); ++n) {
            double dx = (double)X - this.px[n - 1];
            double dy = (double)Y - this.py[n - 1];
            if (!(Math.abs(dx) <= this.rw[n - 1]) || !(Math.abs(dy) <= this.rh[n - 1]) || !(dx * dx / (this.rw[n - 1] * this.rw[n - 1]) + dy * dy / (this.rh[n - 1] * this.rh[n - 1]) <= 1.0)) continue;
            return n;
        }
        return 0;
    }

    private int pickBond(int X, int Y) {
        if (this.px == null || this.py == null) {
            return 0;
        }
        for (int n = 1; n <= this.mol.numBonds(); ++n) {
            double x1 = this.px[this.mol.bondFrom(n) - 1];
            double y1 = this.py[this.mol.bondFrom(n) - 1];
            double x2 = this.px[this.mol.bondTo(n) - 1];
            double y2 = this.py[this.mol.bondTo(n) - 1];
            double nx1 = x1;
            double ny1 = y1;
            double nx2 = x2;
            double ny2 = y2;
            int delta = Math.max(2, (int)(this.scale / 20.0));
            if (nx1 > nx2) {
                nx1 = x2;
                nx2 = x1;
            }
            if (ny1 > ny2) {
                ny1 = y2;
                ny2 = y1;
            }
            if ((double)X < nx1 - (double)(2 * delta) || (double)X > nx2 + (double)(2 * delta) || (double)Y < ny1 - (double)(2 * delta) || (double)Y > ny2 + (double)(2 * delta)) continue;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double d = Math.abs(dx) > Math.abs(dy) ? (double)Y - y1 - ((double)X - x1) * dy / dx : (double)X - x1 - ((double)Y - y1) * dx / dy;
            if (Math.abs(d) > (double)((2 + this.mol.bondOrder(n)) * delta)) continue;
            return n;
        }
        return 0;
    }

    private void snapToolBond() {
        double cx = this.toolBondFrom > 0 ? this.mol.atomX(this.toolBondFrom) : this.toolBondFromX;
        double cy = this.toolBondFrom > 0 ? this.mol.atomY(this.toolBondFrom) : this.toolBondFromY;
        double dx = this.toolBondToX - cx;
        double dy = this.toolBondToY - cy;
        double th = Math.atan2(dy, dx) * 180.0 / Math.PI;
        double ext = Math.sqrt(dx * dx + dy * dy);
        th = (double)(Math.round(th / 30.0) * 30L) * Math.PI / 180.0;
        ext = (double)Math.round(ext / 1.5) * 1.5;
        this.toolBondToX = cx + ext * Math.cos(th);
        this.toolBondToY = cy + ext * Math.sin(th);
    }

    public void cacheUndo() {
        if (this.undo == null) {
            this.undo = new EditState[10];
        }
        this.redo = null;
        for (int n = 9; n > 0; --n) {
            this.undo[n] = this.undo[n - 1];
        }
        this.undo[0] = new EditState();
        this.undo[0].Molecule = this.mol == null ? null : this.mol.clone();
        this.undo[0].Selected = this.selected == null ? null : (boolean[])this.selected.clone();
    }

    private void completeAtomEdit() {
        if (this.toolAtomEditBox == null) {
            return;
        }
        String el = this.toolAtomEditBox.getText();
        if (el.length() > 0) {
            this.cacheUndo();
            if (el.charAt(0) >= 'a' && el.charAt(0) <= 'z') {
                el = el.substring(0, 1).toUpperCase() + el.substring(1);
            }
            if (this.toolAtomEditSel == 0) {
                this.mol.addAtom(el, this.xToAng(this.toolAtomEditX), this.yToAng(this.toolAtomEditY));
                this.clearTemporary();
                this.determineSize();
            } else {
                this.mol.setAtomElement(this.toolAtomEditSel, el);
            }
        }
        this.toolAtomEditBox.setVisible(false);
        this.remove(this.toolAtomEditBox);
        this.toolAtomEditBox = null;
        this.repaint();
        this.checkDirtiness();
    }

    private void adjustTemplateByAtom(int Atom2) {
        int n;
        this.templDraw = this.template.clone();
        ArrayList<Integer> bonded = new ArrayList<Integer>();
        for (int n2 = 1; n2 <= this.mol.numBonds(); ++n2) {
            if (this.mol.bondFrom(n2) == Atom2) {
                bonded.add(new Integer(this.mol.bondTo(n2)));
            }
            if (this.mol.bondTo(n2) != Atom2) continue;
            bonded.add(new Integer(this.mol.bondFrom(n2)));
        }
        boolean INCR = true;
        double[] rotScores = new double[360];
        for (int n3 = 1; n3 <= this.templDraw.numAtoms(); ++n3) {
            if (n3 == this.templateIdx) continue;
            double x = this.template.atomX(n3) - this.template.atomX(this.templateIdx);
            double y = this.template.atomY(n3) - this.template.atomY(this.templateIdx);
            double th = Math.atan2(y, x);
            double ext = Math.sqrt(x * x + y * y);
            for (int i = 0; i < 360; ++i) {
                double rx = this.mol.atomX(Atom2) + ext * Math.cos(th + (double)(i * 1) * Math.PI / 180.0);
                double ry = this.mol.atomY(Atom2) + ext * Math.sin(th + (double)(i * 1) * Math.PI / 180.0);
                for (int j = 0; j < bonded.size(); ++j) {
                    double dy;
                    int k = (Integer)bonded.get(j);
                    double dx = this.mol.atomX(k) - rx;
                    double ext2 = dx * dx + (dy = this.mol.atomY(k) - ry) * dy;
                    if (ext2 < 0.01) {
                        ext2 = 0.01;
                    }
                    int n4 = i;
                    rotScores[n4] = rotScores[n4] + 1.0 / ext2;
                }
            }
        }
        int bestRot = 0;
        for (n = 1; n < 360; ++n) {
            if (!(rotScores[n] < rotScores[bestRot])) continue;
            bestRot = n;
        }
        for (n = 1; n <= this.templDraw.numAtoms(); ++n) {
            double x = this.template.atomX(n) - this.template.atomX(this.templateIdx);
            double y = this.template.atomY(n) - this.template.atomY(this.templateIdx);
            double th = Math.atan2(y, x);
            double ext = Math.sqrt(x * x + y * y);
            this.templDraw.setAtomPos(n, this.mol.atomX(Atom2) + ext * Math.cos(th + (double)(bestRot * 1) * Math.PI / 180.0), this.mol.atomY(Atom2) + ext * Math.sin(th + (double)(bestRot * 1) * Math.PI / 180.0));
        }
    }

    private boolean adjustTemplateByBond(int Bond2) {
        Molecule[] rotMol = new Molecule[2];
        double[] rotScores = new double[2];
        for (int r = 0; r < 2; ++r) {
            rotMol[r] = this.template.clone();
            int imol1 = r == 0 ? this.mol.bondFrom(Bond2) : this.mol.bondTo(Bond2);
            int imol2 = r == 0 ? this.mol.bondTo(Bond2) : this.mol.bondFrom(Bond2);
            int irot1 = this.template.bondFrom(-this.templateIdx);
            int irot2 = this.template.bondTo(-this.templateIdx);
            double dtheta = Math.atan2(this.mol.atomY(imol2) - this.mol.atomY(imol1), this.mol.atomX(imol2) - this.mol.atomX(imol1)) - Math.atan2(this.template.atomY(irot2) - this.template.atomY(irot1), this.template.atomX(irot2) - this.template.atomX(irot1));
            for (int n = 1; n <= this.template.numAtoms(); ++n) {
                double rx = this.template.atomX(n) - this.template.atomX(irot1);
                double ry = this.template.atomY(n) - this.template.atomY(irot1);
                double th = Math.atan2(ry, rx);
                double ext = Math.sqrt(rx * rx + ry * ry);
                rx = this.mol.atomX(imol1) + ext * Math.cos(th + dtheta);
                ry = this.mol.atomY(imol1) + ext * Math.sin(th + dtheta);
                rotMol[r].setAtomPos(n, rx, ry);
                for (int i = 1; i <= this.mol.numAtoms(); ++i) {
                    double dy;
                    double dx = this.mol.atomX(i) - rx;
                    double ext2 = dx * dx + (dy = this.mol.atomY(i) - ry) * dy;
                    if (ext2 < 0.01) {
                        ext2 = 0.01;
                    }
                    int n2 = r;
                    rotScores[n2] = rotScores[n2] + 1.0 / ext2;
                }
            }
        }
        boolean swap = rotScores[0] < rotScores[1];
        this.templDraw = rotMol[swap ? 0 : 1];
        return swap;
    }

    private void adjustTemplateByCoord(double X, double Y) {
        this.templDraw = this.template.clone();
        double dx = 0.0;
        double dy = 0.0;
        if (this.templateIdx > 0) {
            dx = this.template.atomX(this.templateIdx);
            dy = this.template.atomY(this.templateIdx);
        } else if (this.templateIdx < 0) {
            int from = this.template.bondFrom(-this.templateIdx);
            int to = this.template.bondTo(-this.templateIdx);
            dx = 0.5 * (this.template.atomX(from) + this.template.atomX(to));
            dy = 0.5 * (this.template.atomY(from) + this.template.atomY(to));
        }
        for (int n = 1; n <= this.template.numAtoms(); ++n) {
            this.templDraw.setAtomPos(n, this.template.atomX(n) - dx + X, this.template.atomY(n) - dy + Y);
        }
    }

    private void templateSetByAtom(int JoinAtom) {
        int n;
        int[] map = new int[this.templDraw.numAtoms()];
        int oldNum = this.mol.numAtoms();
        for (n = 1; n <= this.templDraw.numAtoms(); ++n) {
            if (JoinAtom != 0 && n == this.templateIdx) continue;
            this.mol.addAtom(this.templDraw.atomElement(n), this.templDraw.atomX(n), this.templDraw.atomY(n), this.templDraw.atomCharge(n), this.templDraw.atomUnpaired(n));
        }
        for (n = 1; n <= this.templDraw.numBonds(); ++n) {
            int from = this.templDraw.bondFrom(n);
            int to = this.templDraw.bondTo(n);
            if (JoinAtom > 0) {
                if (from == this.templateIdx) {
                    from = JoinAtom;
                } else {
                    if (from > this.templateIdx) {
                        --from;
                    }
                    from += oldNum;
                }
                if (to == this.templateIdx) {
                    to = JoinAtom;
                } else {
                    if (to > this.templateIdx) {
                        --to;
                    }
                    to += oldNum;
                }
            } else {
                from += oldNum;
                to += oldNum;
            }
            this.mol.addBond(from, to, this.templDraw.bondOrder(n), this.templDraw.bondType(n));
        }
        this.mergeNewAtoms(oldNum);
        this.clearTemporary();
        this.determineSize();
        this.repaint();
    }

    private void templateSetByBond(int JoinBond, boolean Swap) {
        int n;
        int[] map = new int[this.templDraw.numAtoms()];
        int oldNum = this.mol.numAtoms();
        int joinFrom = JoinBond > 0 ? this.mol.bondFrom(JoinBond) : 0;
        int joinTo = JoinBond > 0 ? this.mol.bondTo(JoinBond) : 0;
        int newFrom = Swap ? this.templDraw.bondFrom(-this.templateIdx) : this.templDraw.bondTo(-this.templateIdx);
        int newTo = Swap ? this.templDraw.bondTo(-this.templateIdx) : this.templDraw.bondFrom(-this.templateIdx);
        for (n = 1; n <= this.templDraw.numAtoms(); ++n) {
            map[n - 1] = n == newFrom && JoinBond > 0 ? joinFrom : (n == newTo && JoinBond > 0 ? joinTo : this.mol.addAtom(this.templDraw.atomElement(n), this.templDraw.atomX(n), this.templDraw.atomY(n), this.templDraw.atomCharge(n), this.templDraw.atomUnpaired(n)));
        }
        for (n = 1; n <= this.template.numBonds(); ++n) {
            if (n == -this.templateIdx && JoinBond != 0) continue;
            this.mol.addBond(map[this.templDraw.bondFrom(n) - 1], map[this.templDraw.bondTo(n) - 1], this.templDraw.bondOrder(n), this.templDraw.bondType(n));
        }
        this.mergeNewAtoms(oldNum);
        this.clearTemporary();
        this.determineSize();
        this.repaint();
    }

    private void mergeNewAtoms(int Watermark) {
        int pos = Watermark + 1;
        while (pos <= this.mol.numAtoms()) {
            int close = 0;
            for (int n = 1; n <= Watermark; ++n) {
                double dy;
                double dx = this.mol.atomX(n) - this.mol.atomX(pos);
                if (!(dx * dx + (dy = this.mol.atomY(n) - this.mol.atomY(pos)) * dy < 0.04000000000000001)) continue;
                close = n;
                break;
            }
            if (close > 0) {
                int[] adj = this.mol.atomAdjList(pos);
                for (int i = 0; i < adj.length; ++i) {
                    if (this.mol.findBond(close, adj[i]) != 0) continue;
                    int j = this.mol.findBond(pos, adj[i]);
                    this.mol.addBond(close, adj[i], this.mol.bondOrder(j));
                }
                this.mol.deleteAtomAndBonds(pos);
                continue;
            }
            ++pos;
        }
    }

    private boolean anySelected() {
        if (this.selected == null) {
            return false;
        }
        for (int n = 0; n < this.mol.numAtoms(); ++n) {
            if (!this.selected[n]) continue;
            return true;
        }
        return false;
    }

    private double dragExtendBy(double px, double py) {
        double diff = 0.2 * Math.sqrt(px * px + py * py) / this.scale;
        if (px < 0.0 && py < 0.0) {
            diff = -diff;
        }
        if (diff >= 0.0) {
            return 1.0 + diff;
        }
        return Math.exp(diff);
    }

    private ArrayList<int[]> wedgeFormations(int N, int Chi) {
        int n;
        int[] wedges;
        int iz;
        int i;
        if (this.mol.atomAdjCount(N) != 3 && this.mol.atomAdjCount(N) != 4) {
            return null;
        }
        int[] adj = this.mol.atomAdjList(N);
        for (int i2 = 0; i2 < adj.length - 1; ++i2) {
            for (int j = i2 + 1; j < adj.length; ++j) {
                if (this.mol.atomPriority(adj[i2]) != this.mol.atomPriority(adj[j])) continue;
                return null;
            }
        }
        int[] badj = new int[adj.length];
        for (int n2 = 0; n2 < adj.length; ++n2) {
            badj[n2] = this.mol.findBond(N, adj[n2]);
        }
        ArrayList<int[]> perm = new ArrayList<int[]>();
        if (adj.length == 3) {
            for (i = 0; i < 3; ++i) {
                for (iz = -1; iz <= 1; iz += 2) {
                    wedges = new int[3];
                    for (n = 0; n < 3; ++n) {
                        wedges[n] = 0;
                    }
                    wedges[i] = iz;
                    perm.add(wedges);
                }
            }
        } else {
            for (i = 0; i < 4; ++i) {
                for (iz = -1; iz <= 1; iz += 2) {
                    wedges = new int[4];
                    for (n = 0; n < 4; ++n) {
                        wedges[n] = 0;
                    }
                    wedges[i] = iz;
                    perm.add(wedges);
                    for (int j = i + 1; j < 4; ++j) {
                        for (int jz = -1; jz <= 1; jz += 2) {
                            if (jz == iz) continue;
                            wedges = new int[4];
                            for (int n3 = 0; n3 < 4; ++n3) {
                                wedges[n3] = 0;
                            }
                            wedges[i] = iz;
                            wedges[j] = jz;
                            perm.add(wedges);
                        }
                    }
                }
            }
        }
        int pos = 0;
        while (pos < perm.size()) {
            int[] wedges2 = (int[])perm.get(pos);
            Molecule mchi = this.mol.clone();
            for (n = 0; n < adj.length; ++n) {
                mchi.setBondType(badj[n], wedges2[n] < 0 ? 2 : (wedges2[n] > 0 ? 1 : 0));
                if (mchi.bondFrom(badj[n]) == N) continue;
                this.mol.setBondFromTo(badj[n], this.mol.bondTo(badj[n]), this.mol.bondFrom(badj[n]));
            }
            if (mchi.atomChirality(N) != Chi) {
                perm.remove(pos);
                continue;
            }
            ++pos;
        }
        double[] score = new double[perm.size()];
        for (int n4 = 0; n4 < perm.size(); ++n4) {
            score[n4] = 0.0;
            int[] wedges3 = (int[])perm.get(n4);
            int wcount = 0;
            for (int i3 = 0; i3 < adj.length; ++i3) {
                if (wedges3[i3] == 0) continue;
                ++wcount;
                int n5 = n4;
                score[n5] = score[n5] - 0.5 * (double)this.mol.atomPriority(adj[i3]) / (double)this.mol.numAtoms();
                if (this.mol.atomAdjCount(adj[i3]) == 1) {
                    int n6 = n4;
                    score[n6] = score[n6] + 1.0;
                }
                if (this.mol.atomRingBlock(adj[i3]) <= 0) continue;
                int n7 = n4;
                score[n7] = score[n7] - 1.0;
                if (this.mol.atomRingBlock(N) != this.mol.atomRingBlock(adj[i3])) continue;
                int n8 = n4;
                score[n8] = score[n8] - 1.0;
            }
            if (adj.length != 4 || wcount != 2) continue;
            int n9 = n4;
            score[n9] = score[n9] + 1.0;
        }
        pos = 0;
        while (pos < perm.size() - 1) {
            if (score[pos] < score[pos + 1]) {
                int[] w1 = perm.get(pos);
                int[] w2 = perm.get(pos + 1);
                perm.set(pos + 1, w1);
                perm.set(pos, w2);
                double s = score[pos];
                score[pos] = score[pos + 1];
                score[pos + 1] = s;
                if (pos <= 0) continue;
                --pos;
                continue;
            }
            ++pos;
        }
        return perm;
    }

    @Override
    protected void paintComponent(Graphics gr) {
        if (this.autoScale) {
            this.scaleToFit();
        }
        gr.setColor(Color.WHITE);
        gr.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.hasBorder) {
            gr.setColor(Color.BLACK);
            gr.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawMolecule draw = new DrawMolecule(this.mol, g, this.scale);
        draw.setBackground(this.getBackground());
        draw.setShowHydr(this.showHydr);
        draw.setShowMode(this.showMode);
        draw.setShowStereo(this.showSter);
        draw.setOffset(this.offsetX, this.offsetY);
        draw.setHighlight(this.highlightAtom, this.highlightBond);
        this.resetSelected(false);
        draw.setSelected(this.selected, this.dragged);
        if (this.tool == 4 && this.toolAtomDrag || this.tool == 5 && this.toolBondFrom > 0) {
            draw.bondInProgress(this.toolBondFrom, this.toolBondToX, this.toolBondToY, this.toolBondOrder, this.toolBondType);
        }
        if (this.tool == 4 && this.toolAtomDrag && this.toolAtomType != null && this.toolAtomType.compareTo("C") != 0) {
            draw.atomInProgress(this.toolAtomType, this.toolBondToX, this.toolBondToY);
        }
        if (this.tool == 5 && this.toolBondFrom == 0 && this.toolBondDrag) {
            int i = this.pickAtom((int)this.angToX(this.toolBondToX), (int)this.angToY(this.toolBondToY));
            if (i == 0 && this.toolSnap) {
                this.snapToolBond();
            }
            double x1 = this.toolBondFromX;
            double y1 = this.toolBondFromY;
            double x2 = this.toolBondToX;
            double y2 = this.toolBondToY;
            if (i > 0) {
                x2 = this.mol.atomX(i);
                y2 = this.mol.atomY(i);
            }
            draw.newBondLine(x1, y1, x2, y2);
        }
        if (this.toolDragReason == 1) {
            draw.dragSelect((int)this.toolDragX1, (int)this.toolDragY1, (int)this.toolDragX2, (int)this.toolDragY2);
        }
        if (!(this.toolDragReason != 2 && this.toolDragReason != 3 && this.toolDragReason != 4 || this.toolDragX1 == this.toolDragX2 && this.toolDragY1 == this.toolDragY2)) {
            if (this.toolDragReason == 4) {
                double extmul = this.dragExtendBy(this.toolDragX2 - this.toolDragX1, this.toolDragY2 - this.toolDragY1);
                double cx = 0.0;
                double cy = 0.0;
                int count = 0;
                for (int n = 1; n <= this.mol.numAtoms(); ++n) {
                    if (!this.selected[n - 1]) continue;
                    cx += this.mol.atomX(n);
                    cy += this.mol.atomY(n);
                    ++count;
                }
                draw.dragScale(cx /= (double)count, cy /= (double)count, extmul);
            } else {
                int dx = (int)(this.toolDragX2 - this.toolDragX1);
                int dy = (int)(this.toolDragY2 - this.toolDragY1);
                draw.dragMove(dx, dy, this.toolDragReason == 3);
            }
        }
        if (this.toolDragReason == 5 && (Math.abs(this.toolDragX2 - this.toolDragX1) > 5.0 || Math.abs(this.toolDragY2 - this.toolDragY1) > 5.0)) {
            double dx = this.toolDragX2 - this.toolDragX1;
            double dy = this.toolDragY2 - this.toolDragY1;
            double th = -Math.atan2(dy, dx) * 180.0 / Math.PI;
            if (this.toolSnap) {
                th = Math.round(th / 15.0) * 15L;
            }
            draw.dragRotate(th, (int)this.toolDragX1, (int)this.toolDragY1);
        }
        if (this.tool == 7 && this.trackX >= 0 && this.trackY >= 0) {
            if (this.highlightAtom != 0 && this.templateIdx > 0) {
                this.adjustTemplateByAtom(this.highlightAtom);
            } else if (this.highlightBond != 0 && this.templateIdx < 0) {
                this.adjustTemplateByBond(this.highlightBond);
            } else {
                this.adjustTemplateByCoord(this.xToAng(this.trackX), this.yToAng(this.trackY));
            }
            draw.outlineTemplate(this.templDraw);
        }
        draw.draw();
        ArrangeMolecule arrmol = draw.arrangement();
        this.px = new double[this.mol.numAtoms()];
        this.py = new double[this.mol.numAtoms()];
        this.rw = new double[this.mol.numAtoms()];
        this.rh = new double[this.mol.numAtoms()];
        for (int n = 0; n < this.mol.numAtoms(); ++n) {
            this.px[n] = arrmol.pointCX(n);
            this.py[n] = arrmol.pointCY(n);
            this.rw[n] = Math.max(arrmol.pointRW(n), 5.0);
            this.rh[n] = Math.max(arrmol.pointRH(n), 5.0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && MainApplet.USER_SELECTION && this.tool == 8) {
            if (this.highlightAtom > 0) {
                if (this.highlightAtom > atomselection.length - 1) {
                    atomselection = EditorPane.GrowArray(atomselection, this.highlightAtom + 2);
                }
                EditorPane.atomselection[this.highlightAtom] = !atomselection[this.highlightAtom];
            }
            if (this.highlightBond > 0) {
                if (this.highlightBond > bondselection.length - 1) {
                    bondselection = EditorPane.GrowArray(bondselection, this.highlightBond + 2);
                }
                EditorPane.bondselection[this.highlightBond] = !bondselection[this.highlightBond];
            }
            this.repaint();
        } else if (this.tool == 1 && this.selectListen != null) {
            int i = this.pickAtom(e.getX(), e.getY());
            if ((e.getModifiers() & 2) > 0 && i > 0 && this.editable) {
                if ((e.getModifiers() & 1) == 0 && this.selected != null) {
                    for (int n = 0; n < this.mol.numAtoms(); ++n) {
                        this.selected[n] = false;
                    }
                }
                if (this.selected == null) {
                    this.selected = new boolean[this.mol.numAtoms()];
                }
                int cc = this.mol.atomConnComp(i);
                for (int n = 1; n <= this.mol.numAtoms(); ++n) {
                    if (this.mol.atomConnComp(n) != cc) continue;
                    this.selected[n - 1] = true;
                }
                this.repaint();
            } else if (i > 0) {
                this.selectListen.molSelected(this, i, e.getClickCount() > 1);
            } else {
                i = this.pickBond(e.getX(), e.getY());
                this.selectListen.molSelected(this, -i, e.getClickCount() > 1);
            }
        } else if (this.tool == 2) {
            this.selected = null;
            this.clearTemporary();
            this.repaint();
        } else if (this.tool == 3) {
            int i;
            if (MainApplet.USER_SELECTION) {
                this.deSelectAll();
            }
            if ((i = this.pickAtom(e.getX(), e.getY())) > 0) {
                this.cacheUndo();
                this.mol.deleteAtomAndBonds(i);
            } else {
                this.cacheUndo();
                i = this.pickBond(e.getX(), e.getY());
                if (i > 0) {
                    this.mol.deleteBond(i);
                }
            }
            if (i > 0) {
                this.clearTemporary();
                this.determineSize();
                this.repaint();
            }
        } else if (this.tool == 4 && e.getButton() == 1 && !this.toolAtomDrag) {
            if (this.toolAtomEditBox != null) {
                this.completeAtomEdit();
                return;
            }
            if (this.toolAtomType != null) {
                int i = this.pickAtom(e.getX(), e.getY());
                this.cacheUndo();
                if (i == 0) {
                    i = this.mol.addAtom(this.toolAtomType, this.xToAng(e.getX()), this.yToAng(e.getY()));
                    this.offsetX = (double)e.getX() / this.scale - this.mol.atomX(i);
                    this.offsetY = (double)e.getY() / this.scale + this.mol.atomY(i);
                } else {
                    this.mol.setAtomElement(i, this.toolAtomType);
                }
                this.clearTemporary();
                this.determineSize();
                this.repaint();
            } else {
                this.toolAtomEditX = e.getX();
                this.toolAtomEditY = e.getY();
                this.toolAtomEditSel = this.pickAtom(this.toolAtomEditX, this.toolAtomEditY);
                if (this.toolAtomEditSel == 0 && this.pickBond(e.getX(), e.getY()) > 0) {
                    return;
                }
                this.toolAtomEditBox = new JTextField(this.toolAtomEditSel > 0 ? this.mol.atomElement(this.toolAtomEditSel) : "");
                this.add(this.toolAtomEditBox);
                this.toolAtomEditBox.addFocusListener(this);
                this.toolAtomEditBox.addKeyListener(this);
                this.toolAtomEditBox.setLocation(this.toolAtomEditX - 10, this.toolAtomEditY - 10);
                this.toolAtomEditBox.setSize(20, 20);
                this.toolAtomEditBox.setVisible(true);
                this.toolAtomEditBox.setSelectionStart(0);
                this.toolAtomEditBox.setSelectionEnd(this.toolAtomEditBox.getText().length());
                this.toolAtomEditBox.grabFocus();
            }
        } else if (this.tool == 7 && e.getButton() == 2) {
            boolean vertical = e.isShiftDown();
            for (int n = 1; n <= this.template.numAtoms(); ++n) {
                this.template.setAtomPos(n, this.template.atomX(n) * (double)(vertical ? 1 : -1), this.template.atomY(n) * (double)(vertical ? -1 : 1));
            }
            this.templDraw = this.template.clone();
            this.repaint();
        }
        this.checkDirtiness();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        boolean redraw = false;
        if (this.tool == 7 && (this.trackX != e.getX() || this.trackY != e.getY())) {
            redraw = true;
        }
        this.trackX = e.getX();
        this.trackY = e.getY();
        if (redraw) {
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        boolean redraw = false;
        if (this.tool == 7 && (this.trackX != e.getX() || this.trackY != e.getY())) {
            redraw = true;
        }
        this.trackX = -1;
        this.trackY = -1;
        if (redraw) {
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.grabFocus();
        if ((this.tool == 1 || this.tool == 2 && !this.anySelected()) && e.getButton() == 1 && this.editable) {
            boolean anySelected;
            this.highlightBond = 0;
            this.highlightAtom = 0;
            boolean shift = (e.getModifiers() & 1) > 0;
            boolean ctrl = (e.getModifiers() & 2) > 0;
            boolean alt = (e.getModifiers() & 8) > 0;
            boolean bl = anySelected = this.countSelected() > 0;
            if (this.tool == 2) {
                shift = false;
                ctrl = false;
                alt = false;
            }
            if (!ctrl && !alt) {
                this.resetSelected(!shift);
                int atom = this.pickAtom(e.getX(), e.getY());
                if (atom > 0) {
                    this.selected[atom - 1] = true;
                } else {
                    this.toolDragReason = 1;
                }
            } else if (!shift && ctrl && !alt && anySelected) {
                this.toolDragReason = 3;
            } else if (!shift && !ctrl && alt && anySelected) {
                this.toolDragReason = 2;
            } else if (shift && !ctrl && alt && anySelected) {
                this.toolDragReason = 4;
            }
            this.toolDragX1 = this.toolDragX2 = (double)e.getX();
            this.toolDragY1 = this.toolDragY2 = (double)e.getY();
            this.repaint();
        } else if (this.tool == 3 && e.getButton() == 1) {
            if (MainApplet.USER_SELECTION) {
                this.deSelectAll();
            }
            this.highlightBond = 0;
            this.highlightAtom = 0;
            this.resetSelected(true);
            this.toolDragReason = 1;
            this.toolDragX1 = this.toolDragX2 = (double)e.getX();
            this.toolDragY1 = this.toolDragY2 = (double)e.getY();
            this.repaint();
        } else if (this.tool == 4) {
            this.toolBondFrom = this.pickAtom(e.getX(), e.getY());
            this.toolAtomSnap = e.getButton() == 1;
        } else if (this.tool == 5 && (e.getButton() == 1 || e.getButton() == 3)) {
            this.highlightBond = 0;
            this.highlightAtom = 0;
            this.toolBondDrag = false;
            this.toolBondFrom = this.pickAtom(e.getX(), e.getY());
            boolean bl = this.toolSnap = e.getButton() == 1;
            if (this.toolBondFrom > 0) {
                this.toolBondToX = this.mol.atomX(this.toolBondFrom);
                this.toolBondToY = this.mol.atomY(this.toolBondFrom);
                this.repaint();
            }
            this.toolBondFromX = this.xToAng(e.getX());
            this.toolBondFromY = this.yToAng(e.getY());
            this.toolBondHit = this.pickBond(e.getX(), e.getY());
        } else if (this.tool == 7 && e.getButton() == 1) {
            boolean swap = false;
            if (this.highlightAtom != 0 && this.templateIdx > 0) {
                this.adjustTemplateByAtom(this.highlightAtom);
            } else if (this.highlightBond != 0 && this.templateIdx < 0) {
                swap = this.adjustTemplateByBond(this.highlightBond);
            } else {
                this.adjustTemplateByCoord(this.xToAng(this.trackX), this.yToAng(this.trackY));
            }
            this.cacheUndo();
            if (this.templateIdx >= 0) {
                this.templateSetByAtom(this.highlightAtom);
            } else {
                this.templateSetByBond(this.highlightBond, swap);
            }
        } else if (this.tool == 2 && (e.getButton() == 1 || e.getButton() == 3) && this.anySelected()) {
            this.toolDragReason = 5;
            boolean bl = this.toolSnap = e.getButton() == 1;
            if (this.highlightAtom > 0) {
                this.toolDragX1 = this.angToX(this.mol.atomX(this.highlightAtom));
                this.toolDragY1 = this.angToY(this.mol.atomY(this.highlightAtom));
            } else if (this.highlightBond > 0) {
                this.toolDragX1 = this.angToX(0.5 * (this.mol.atomX(this.mol.bondFrom(this.highlightBond)) + this.mol.atomX(this.mol.bondTo(this.highlightBond))));
                this.toolDragY1 = this.angToY(0.5 * (this.mol.atomY(this.mol.bondFrom(this.highlightBond)) + this.mol.atomY(this.mol.bondTo(this.highlightBond))));
            } else {
                this.toolDragX1 = e.getX();
                this.toolDragY1 = e.getY();
            }
            this.highlightBond = 0;
            this.highlightAtom = 0;
            this.toolDragX2 = this.toolDragX1;
            this.toolDragY2 = this.toolDragY1;
            this.repaint();
        } else if (this.tool == 6 && this.highlightAtom > 0) {
            int chg = this.mol.atomCharge(this.highlightAtom);
            chg = e.getButton() == 1 ? (chg += this.toolCharge) : (e.getButton() == 3 ? (chg -= this.toolCharge) : 0);
            this.cacheUndo();
            this.mol.setAtomCharge(this.highlightAtom, chg);
            this.repaint();
        }
        this.checkDirtiness();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int n;
        if (this.tool == 1 && this.toolDragReason != 0 || this.tool == 2 && this.toolDragReason == 1 && this.editable) {
            double dy;
            this.toolDragX2 = e.getX();
            this.toolDragY2 = e.getY();
            double mx = this.toolDragX2 - this.toolDragX1;
            double my = this.toolDragY2 - this.toolDragY1;
            if (this.toolDragReason == 1 && this.dragged != null) {
                for (int n2 = 0; n2 < this.mol.numAtoms(); ++n2) {
                    this.selected[n2] = this.selected[n2] || this.dragged[n2];
                }
            }
            if (this.toolDragReason == 2 && this.selected != null && mx * mx + my * my > 25.0) {
                double dx = mx / this.scale;
                dy = -my / this.scale;
                this.cacheUndo();
                for (int n3 = 1; n3 <= this.mol.numAtoms(); ++n3) {
                    if (!this.selected[n3 - 1]) continue;
                    this.mol.setAtomPos(n3, this.mol.atomX(n3) + dx, this.mol.atomY(n3) + dy);
                }
                this.clearTemporary(false);
                this.determineSize();
            }
            if (this.toolDragReason == 3 && this.selected != null && mx * mx + my * my > 25.0) {
                double dx = (this.toolDragX2 - this.toolDragX1) / this.scale;
                dy = -(this.toolDragY2 - this.toolDragY1) / this.scale;
                int oldnumAtoms = this.mol.numAtoms();
                int oldnumBonds = this.mol.numBonds();
                int[] newPos = new int[this.mol.numAtoms()];
                this.cacheUndo();
                for (n = 1; n <= oldnumAtoms; ++n) {
                    if (!this.selected[n - 1]) continue;
                    newPos[n - 1] = this.mol.addAtom(this.mol.atomElement(n), this.mol.atomX(n) + dx, this.mol.atomY(n) + dy, this.mol.atomCharge(n), this.mol.atomUnpaired(n));
                }
                for (n = 1; n <= oldnumBonds; ++n) {
                    if (!this.selected[this.mol.bondFrom(n) - 1] || !this.selected[this.mol.bondTo(n) - 1]) continue;
                    this.mol.addBond(newPos[this.mol.bondFrom(n) - 1], newPos[this.mol.bondTo(n) - 1], this.mol.bondOrder(n), this.mol.bondType(n));
                }
                this.clearTemporary();
                this.selected = new boolean[this.mol.numAtoms()];
                for (n = 1; n <= this.mol.numAtoms(); ++n) {
                    this.selected[n - 1] = n > oldnumAtoms;
                }
                this.determineSize();
            }
            if (this.toolDragReason == 4 && this.selected != null && mx * mx + my * my > 25.0) {
                double extmul = this.dragExtendBy(mx, my);
                double cx = 0.0;
                double cy = 0.0;
                int count = 0;
                for (n = 1; n <= this.mol.numAtoms(); ++n) {
                    if (!this.selected[n - 1]) continue;
                    cx += this.mol.atomX(n);
                    cy += this.mol.atomY(n);
                    ++count;
                }
                cx /= (double)count;
                cy /= (double)count;
                this.cacheUndo();
                for (n = 1; n <= this.mol.numAtoms(); ++n) {
                    if (!this.selected[n - 1]) continue;
                    this.mol.setAtomPos(n, (this.mol.atomX(n) - cx) * extmul + cx, (this.mol.atomY(n) - cy) * extmul + cy);
                }
                this.clearTemporary(false);
                this.determineSize();
            }
            this.toolDragReason = 0;
            this.dragged = null;
            this.repaint();
        }
        if (this.tool == 3 && this.toolDragReason != 0) {
            this.toolDragX2 = e.getX();
            this.toolDragY2 = e.getY();
            if (this.toolDragReason == 1 && this.dragged != null) {
                for (int n4 = 0; n4 < this.mol.numAtoms(); ++n4) {
                    this.selected[n4] = this.selected[n4] || this.dragged[n4];
                }
                this.deleteSelected();
                this.clearTemporary();
            }
            this.toolDragReason = 0;
            this.dragged = null;
            this.repaint();
        } else if (this.tool == 2 && this.toolDragReason == 5) {
            double dx = this.toolDragX2 - this.toolDragX1;
            double dy = this.toolDragY2 - this.toolDragY1;
            double th = -Math.atan2(dy, dx) * 180.0 / Math.PI;
            if (this.toolSnap) {
                th = Math.round(th / 15.0) * 15L;
            }
            if (Math.abs(th) > 1.0) {
                this.cacheUndo();
                th = th * Math.PI / 180.0;
                double ax = this.xToAng(this.toolDragX1);
                double ay = this.yToAng(this.toolDragY1);
                for (int n5 = 1; n5 <= this.mol.numAtoms(); ++n5) {
                    if (!this.selected[n5 - 1]) continue;
                    double rx = this.mol.atomX(n5) - ax;
                    double ry = this.mol.atomY(n5) - ay;
                    double rth = Math.atan2(ry, rx);
                    double ext = Math.sqrt(rx * rx + ry * ry);
                    this.mol.setAtomPos(n5, ax + ext * Math.cos(rth + th), ay + ext * Math.sin(rth + th));
                }
                this.clearTemporary(false);
                this.determineSize();
            }
            this.toolDragReason = 0;
            this.dragged = null;
            this.repaint();
        } else if (this.tool == 4 && this.toolAtomDrag && this.toolBondFrom > 0) {
            this.cacheUndo();
            this.mol.addAtom(this.toolAtomType, this.toolBondToX, this.toolBondToY);
            this.mol.addBond(this.toolBondFrom, this.mol.numAtoms(), 1);
            this.clearTemporary();
            this.determineSize();
            this.toolAtomDrag = false;
            this.toolBondFrom = 0;
            this.repaint();
        } else if (this.tool == 5) {
            this.toolBondToX = this.xToAng(e.getX());
            this.toolBondToY = this.yToAng(e.getY());
            int joinTo = this.pickAtom(e.getX(), e.getY());
            if (this.toolBondFrom > 0 && joinTo == 0 && this.toolSnap) {
                this.snapToolBond();
                joinTo = this.pickAtom((int)this.angToX(this.toolBondToX), (int)this.angToY(this.toolBondToY));
            }
            if (e.getButton() == 1 && this.toolBondFrom == 0 && this.toolBondHit > 0) {
                int i = this.pickBond(e.getX(), e.getY());
                if (i == this.toolBondHit) {
                    this.cacheUndo();
                    if (this.toolBondOrder == this.mol.bondOrder(i) && this.toolBondType == this.mol.bondType(i)) {
                        this.mol.setBondFromTo(i, this.mol.bondTo(i), this.mol.bondFrom(i));
                    }
                    this.mol.setBondOrder(i, this.toolBondOrder);
                    this.mol.setBondType(i, this.toolBondType);
                    this.clearTemporary();
                }
            } else if (this.toolBondFrom == 0) {
                int a1 = 0;
                int a2 = 0;
                double x1 = 0.0;
                double x2 = 0.0;
                double y1 = 0.0;
                double y2 = 0.0;
                if (this.toolBondDrag) {
                    if (this.toolSnap) {
                        this.snapToolBond();
                    }
                    x1 = this.toolBondFromX;
                    y1 = this.toolBondFromY;
                    a2 = this.pickAtom(e.getX(), e.getY());
                    if (a2 > 0) {
                        x2 = this.mol.atomX(a2);
                        y2 = this.mol.atomY(a2);
                    } else {
                        x2 = this.toolBondToX;
                        y2 = this.toolBondToY;
                    }
                } else {
                    x1 = x2 = this.xToAng(e.getX());
                    if ((e.getModifiers() & 1) > 0) {
                        x1 -= 0.75;
                        x2 += 0.75;
                    }
                    y1 = y2 = this.yToAng(e.getY());
                    if ((e.getModifiers() & 1) == 0) {
                        y1 -= 0.75;
                        y2 += 0.75;
                    }
                }
                double dx = x2 - x1;
                double dy = y2 - y1;
                if (dx * dx + dy * dy > 0.25) {
                    this.cacheUndo();
                    a1 = this.mol.addAtom("C", x1, y1, 0, 0);
                    if (a2 == 0) {
                        a2 = this.mol.addAtom("C", x2, y2, 0, 0);
                    }
                    this.mol.addBond(a1, a2, this.toolBondOrder);
                    this.clearTemporary();
                }
                this.repaint();
            } else if (joinTo > 0 && joinTo != this.toolBondFrom) {
                this.cacheUndo();
                this.mol.addBond(this.toolBondFrom, joinTo, this.toolBondOrder);
                this.mol.setBondType(this.mol.numBonds(), this.toolBondType);
                this.clearTemporary();
            } else if (this.toolBondFrom > 0) {
                double dx = this.toolBondToX - this.mol.atomX(this.toolBondFrom);
                double dy = this.toolBondToY - this.mol.atomY(this.toolBondFrom);
                if (this.toolBondFrom == joinTo) {
                    int[] adj = this.mol.atomAdjList(this.toolBondFrom);
                    ArrayList<Double> poss = new ArrayList<Double>();
                    double ax = this.mol.atomX(this.toolBondFrom);
                    double ay = this.mol.atomY(this.toolBondFrom);
                    if (adj.length == 0) {
                        poss.add(0.0);
                    } else if (adj.length == 1) {
                        double ang = Math.atan2(this.mol.atomY(adj[0]) - ay, this.mol.atomX(adj[0]) - ax) * 180.0 / Math.PI;
                        if (this.toolBondOrder != 3) {
                            poss.add(ang + 120.0);
                            poss.add(ang - 120.0);
                        } else {
                            poss.add(ang + 180.0);
                        }
                    } else if (adj.length == 2) {
                        double ang1 = Math.atan2(this.mol.atomY(adj[0]) - ay, this.mol.atomX(adj[0]) - ax) * 180.0 / Math.PI;
                        double ang2 = Math.atan2(this.mol.atomY(adj[1]) - ay, this.mol.atomX(adj[1]) - ax) * 180.0 / Math.PI;
                        if (ang2 < ang1) {
                            ang2 += 360.0;
                        }
                        if (ang2 - ang1 < 180.0) {
                            poss.add(0.5 * (ang1 + ang2) + 180.0);
                        } else {
                            poss.add(0.5 * (ang1 + ang2));
                        }
                    } else {
                        for (n = 0; n < adj.length; ++n) {
                            double ang = Math.atan2(this.mol.atomY(adj[n]) - ay, this.mol.atomX(adj[n]) - ax) * 180.0 / Math.PI;
                            poss.add(ang + 180.0);
                        }
                    }
                    double ang = (Double)poss.get(0);
                    if (poss.size() > 1) {
                        int best = -1;
                        double bestScore = 0.0;
                        for (int n6 = 0; n6 < poss.size(); ++n6) {
                            double nx = ax + 1.5 * Math.cos((Double)poss.get(n6) * Math.PI / 180.0);
                            double ny = ay + 1.5 * Math.sin((Double)poss.get(n6) * Math.PI / 180.0);
                            double score = 0.0;
                            for (int i = 1; i <= this.mol.numAtoms(); ++i) {
                                dx = this.mol.atomX(i) - nx;
                                dy = this.mol.atomY(i) - ny;
                                score += 1.0 / Math.min(1000.0, dx * dx + dy * dy);
                            }
                            if (best >= 0 && !(score < bestScore)) continue;
                            best = n6;
                            bestScore = score;
                        }
                        ang = (Double)poss.get(best);
                    }
                    dx = 1.5 * Math.cos(ang * Math.PI / 180.0);
                    dy = 1.5 * Math.sin(ang * Math.PI / 180.0);
                    this.toolBondToX = ax + dx;
                    this.toolBondToY = ay + dy;
                }
                if (dx * dx + dy * dy > 0.5) {
                    this.cacheUndo();
                    this.mol.addAtom("C", this.toolBondToX, this.toolBondToY);
                    this.mol.addBond(this.toolBondFrom, this.mol.numAtoms(), this.toolBondOrder);
                    this.mol.setBondType(this.mol.numBonds(), this.toolBondType);
                    this.clearTemporary();
                    this.determineSize();
                }
            }
            this.toolBondDrag = false;
            this.toolBondFrom = 0;
            this.toolBondHit = 0;
            this.repaint();
        }
        this.checkDirtiness();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean redraw = false;
        if ((this.trackX != e.getX() || this.trackY != e.getY()) && this.tool == 7) {
            redraw = true;
        }
        this.trackX = e.getX();
        this.trackY = e.getY();
        if (e.getButton() == 0) {
            int mx = e.getX();
            int my = e.getY();
            int newAtom = 0;
            int newBond = 0;
            newAtom = this.pickAtom(mx, my);
            if (newAtom == 0) {
                newBond = this.pickBond(mx, my);
            }
            if (this.tool == 7 && this.templateIdx > 0) {
                newBond = 0;
            }
            if (this.tool == 7 && this.templateIdx < 0) {
                newAtom = 0;
            }
            if (newAtom != this.highlightAtom || newBond != this.highlightBond) {
                this.highlightAtom = newAtom;
                this.highlightBond = newBond;
                redraw = true;
            }
        }
        if (redraw) {
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean redraw = false;
        if (this.tool == 7 && (this.trackX != e.getX() || this.trackY != e.getY())) {
            redraw = true;
        }
        this.trackX = e.getX();
        this.trackY = e.getY();
        if (this.tool == 1 && this.toolDragReason != 0 || this.tool == 3 && this.toolDragReason != 0 || this.tool == 2 && this.toolDragReason == 1) {
            this.toolDragX2 = e.getX();
            this.toolDragY2 = e.getY();
            if (this.toolDragReason == 1) {
                int x = (int)this.toolDragX1;
                int y = (int)this.toolDragY1;
                int w = (int)this.toolDragX2 - x;
                int h = (int)this.toolDragY2 - y;
                if (w < 0) {
                    w = -w;
                    x -= w;
                }
                if (h < 0) {
                    h = -h;
                    y -= h;
                }
                this.dragged = new boolean[this.mol.numAtoms()];
                for (int n = 0; n < this.mol.numAtoms(); ++n) {
                    this.dragged[n] = this.px[n] >= (double)x && this.px[n] <= (double)(x + w) && this.py[n] >= (double)y && this.py[n] <= (double)(y + h);
                }
            }
            redraw = true;
        } else if (this.tool == 2 && this.toolDragReason == 5) {
            this.toolDragX2 = e.getX();
            this.toolDragY2 = e.getY();
            redraw = true;
        } else if (this.tool == 4 && this.toolBondFrom != 0) {
            double dy;
            double dx;
            if (!this.toolAtomDrag && (dx = this.xToAng(e.getX()) - this.mol.atomX(this.toolBondFrom)) * dx + (dy = this.yToAng(e.getY()) - this.mol.atomY(this.toolBondFrom)) * dy > 0.6400000000000001) {
                this.toolAtomDrag = true;
                this.toolBondOrder = 1;
                this.toolBondType = 0;
            }
            if (this.toolAtomDrag) {
                this.toolBondToX = this.xToAng(e.getX());
                this.toolBondToY = this.yToAng(e.getY());
                if (this.toolAtomSnap) {
                    this.snapToolBond();
                }
                redraw = true;
            }
        } else if (this.tool == 5) {
            this.toolBondToX = this.xToAng(e.getX());
            this.toolBondToY = this.yToAng(e.getY());
            int joinTo = this.pickAtom(e.getX(), e.getY());
            if (!this.toolBondDrag && (Math.abs(this.toolBondToX - this.toolBondFromX) > 2.0 / this.scale || Math.abs(this.toolBondToY - this.toolBondFromY) > 2.0 / this.scale)) {
                this.toolBondDrag = true;
            }
            if (joinTo > 0) {
                this.toolBondToX = this.mol.atomX(joinTo);
                this.toolBondToY = this.mol.atomY(joinTo);
            } else if (this.toolSnap) {
                this.snapToolBond();
            }
            redraw = true;
        }
        if (redraw) {
            this.repaint();
        }
        this.checkDirtiness();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.tool == 7) {
            double accel;
            double cx = 0.0;
            double cy = 0.0;
            for (int n = 1; n <= this.template.numAtoms(); ++n) {
                cx += this.template.atomX(n);
                cy += this.template.atomY(n);
            }
            cx /= (double)this.template.numAtoms();
            cy /= (double)this.template.numAtoms();
            double d = accel = e.isShiftDown() ? 3.0 : 1.0;
            if (e.isControlDown()) {
                double factor = 1.0 - 0.1 * accel * (double)e.getWheelRotation();
                for (int n = 1; n <= this.template.numAtoms(); ++n) {
                    this.template.setAtomPos(n, cx + (this.template.atomX(n) - cx) * factor, cy + (this.template.atomY(n) - cy) * factor);
                }
            } else {
                double radians = 5.0 * accel * Math.PI / 180.0 * (double)e.getWheelRotation();
                for (int n = 1; n <= this.template.numAtoms(); ++n) {
                    double dx = this.template.atomX(n) - cx;
                    double dy = this.template.atomY(n) - cy;
                    double dist = Math.sqrt(dx * dx + dy * dy);
                    double theta = Math.atan2(dy, dx);
                    this.template.setAtomPos(n, cx + dist * Math.cos(theta + radians), cy + dist * Math.sin(theta + radians));
                }
            }
            this.templDraw = this.template.clone();
            this.repaint();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.toolAtomEditBox) {
            this.completeAtomEdit();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getSource() == this.toolAtomEditBox && e.getKeyChar() == '\n') {
            this.completeAtomEdit();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.autoScale) {
            this.scaleToFit();
            this.repaint();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.autoScale) {
            this.scaleToFit();
            this.repaint();
        }
    }

    public void RotateMolecule() {
        int degrees = MainApplet.rotation;
        if (degrees != 0) {
            double radians = (double)degrees * Math.PI / 180.0;
            for (int n = 1; n <= this.mol.numAtoms(); ++n) {
                double dx = this.mol.atomX(n);
                double dy = this.mol.atomY(n);
                double dist = Math.sqrt(dx * dx + dy * dy);
                double theta = Math.atan2(dy, dx);
                try {
                    this.mol.setAtomPos(n, dist * Math.cos(theta + radians), dist * Math.sin(theta + radians));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("problem with rotation : " + e.toString());
                }
            }
            this.repaint();
        }
    }

    public static boolean[] GrowArray(boolean[] array, int newlength) {
        int oldlength = array.length;
        boolean[] grow = new boolean[newlength];
        for (int i = 0; i < oldlength; ++i) {
            grow[i] = array[i];
        }
        return grow;
    }

    class TransferMoleculeDest
    extends TransferHandler {
        EditorPane dest;

        public TransferMoleculeDest(EditorPane dest) {
            this.dest = dest;
        }

        public boolean canImport(TransferHandler.TransferSupport info) {
            if (!info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            try {
                String data = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
                Molecule mol = MoleculeStream.readUnknown(new BufferedReader(new StringReader(data)));
                return mol != null;
            }
            catch (InvalidDnDOperationException e) {
                return true;
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }

        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            try {
                String data = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
                Molecule mol = MoleculeStream.readUnknown(new BufferedReader(new StringReader(data)));
                if (mol == null || mol.numAtoms() == 0) {
                    return false;
                }
                Point pos = info.getDropLocation().getDropPoint();
                this.dest.addFragmentPosition(mol, (int)pos.getX(), (int)pos.getY());
                return true;
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    private class EditState {
        Molecule Molecule;
        boolean[] Selected;

        private EditState() {
        }
    }
}

