#!/usr/bin/env python
# Copyright (c) 2001-2004 Twisted Matrix Laboratories.
# See LICENSE for details.


"""
An example of reading a line at a time from standard input
without blocking the reactor.
"""

from twisted.internet import stdio
from twisted.protocols import basic

class Echo(basic.LineReceiver):
    from os import linesep as delimiter
    assert delimiter

    def connectionMade(self):
        print "connectionMade"
        self.transport.write('>>> ')

    def lineReceived(self, line):
        print "lineReceived"
        self.sendLine('Echo: ' + line)
        self.transport.write('>>> ')

def main():
    stdio.StandardIO(Echo())
    from twisted.internet import reactor
    reactor.run()               #@UndefinedVariable

if __name__ == '__main__':
    main()
