// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_test_ESSL_autogen.cpp:
//   Tests for matching script-generated hashes with runtime computed hashes.

#include "compiler/translator/ImmutableString.h"
#include "gtest/gtest.h"

namespace sh
{

TEST(ImmutableStringTest, ScriptGeneratedHashesMatch)
{
    ASSERT_EQ(0x00000283u, ImmutableString("radians(00B").mangledNameHash());
    ASSERT_EQ(0x00000154u, ImmutableString("radians(10B").mangledNameHash());
    ASSERT_EQ(0x00000111u, ImmutableString("radians(20B").mangledNameHash());
    ASSERT_EQ(0x000003bbu, ImmutableString("radians(30B").mangledNameHash());
    ASSERT_EQ(0x000001ecu, ImmutableString("degrees(00B").mangledNameHash());
    ASSERT_EQ(0x00000339u, ImmutableString("degrees(10B").mangledNameHash());
    ASSERT_EQ(0x000001deu, ImmutableString("degrees(20B").mangledNameHash());
    ASSERT_EQ(0x00000178u, ImmutableString("degrees(30B").mangledNameHash());
    ASSERT_EQ(0x00000365u, ImmutableString("sin(00B").mangledNameHash());
    ASSERT_EQ(0x00000218u, ImmutableString("sin(10B").mangledNameHash());
    ASSERT_EQ(0x0000023au, ImmutableString("sin(20B").mangledNameHash());
    ASSERT_EQ(0x00000117u, ImmutableString("sin(30B").mangledNameHash());
    ASSERT_EQ(0x00000224u, ImmutableString("cos(00B").mangledNameHash());
    ASSERT_EQ(0x00000374u, ImmutableString("cos(10B").mangledNameHash());
    ASSERT_EQ(0x000003b9u, ImmutableString("cos(20B").mangledNameHash());
    ASSERT_EQ(0x000002cfu, ImmutableString("cos(30B").mangledNameHash());
    ASSERT_EQ(0x0000021bu, ImmutableString("tan(00B").mangledNameHash());
    ASSERT_EQ(0x0000036bu, ImmutableString("tan(10B").mangledNameHash());
    ASSERT_EQ(0x000003bdu, ImmutableString("tan(20B").mangledNameHash());
    ASSERT_EQ(0x000000fbu, ImmutableString("tan(30B").mangledNameHash());
    ASSERT_EQ(0x00000248u, ImmutableString("asin(00B").mangledNameHash());
    ASSERT_EQ(0x00000397u, ImmutableString("asin(10B").mangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("asin(20B").mangledNameHash());
    ASSERT_EQ(0x00000142u, ImmutableString("asin(30B").mangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("acos(00B").mangledNameHash());
    ASSERT_EQ(0x00000303u, ImmutableString("acos(10B").mangledNameHash());
    ASSERT_EQ(0x000002a3u, ImmutableString("acos(20B").mangledNameHash());
    ASSERT_EQ(0x00000176u, ImmutableString("acos(30B").mangledNameHash());
    ASSERT_EQ(0x00000206u, ImmutableString("atan(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("atan(10B10B").mangledNameHash());
    ASSERT_EQ(0x000001dau, ImmutableString("atan(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000013du, ImmutableString("atan(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001f4u, ImmutableString("atan(00B").mangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("atan(10B").mangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("atan(20B").mangledNameHash());
    ASSERT_EQ(0x00000340u, ImmutableString("atan(30B").mangledNameHash());
    ASSERT_EQ(0x000002a5u, ImmutableString("sinh(00B").mangledNameHash());
    ASSERT_EQ(0x0000033fu, ImmutableString("sinh(10B").mangledNameHash());
    ASSERT_EQ(0x0000018fu, ImmutableString("sinh(20B").mangledNameHash());
    ASSERT_EQ(0x000000f3u, ImmutableString("sinh(30B").mangledNameHash());
    ASSERT_EQ(0x00000167u, ImmutableString("cosh(00B").mangledNameHash());
    ASSERT_EQ(0x00000322u, ImmutableString("cosh(10B").mangledNameHash());
    ASSERT_EQ(0x00000353u, ImmutableString("cosh(20B").mangledNameHash());
    ASSERT_EQ(0x0000027eu, ImmutableString("cosh(30B").mangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("tanh(00B").mangledNameHash());
    ASSERT_EQ(0x00000177u, ImmutableString("tanh(10B").mangledNameHash());
    ASSERT_EQ(0x00000296u, ImmutableString("tanh(20B").mangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("tanh(30B").mangledNameHash());
    ASSERT_EQ(0x00000278u, ImmutableString("asinh(00B").mangledNameHash());
    ASSERT_EQ(0x000003c1u, ImmutableString("asinh(10B").mangledNameHash());
    ASSERT_EQ(0x000000f8u, ImmutableString("asinh(20B").mangledNameHash());
    ASSERT_EQ(0x0000021fu, ImmutableString("asinh(30B").mangledNameHash());
    ASSERT_EQ(0x0000018bu, ImmutableString("acosh(00B").mangledNameHash());
    ASSERT_EQ(0x000000b1u, ImmutableString("acosh(10B").mangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("acosh(20B").mangledNameHash());
    ASSERT_EQ(0x000002bfu, ImmutableString("acosh(30B").mangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("atanh(00B").mangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("atanh(10B").mangledNameHash());
    ASSERT_EQ(0x000002e6u, ImmutableString("atanh(20B").mangledNameHash());
    ASSERT_EQ(0x000001a5u, ImmutableString("atanh(30B").mangledNameHash());
    ASSERT_EQ(0x0000019fu, ImmutableString("pow(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("pow(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000031au, ImmutableString("pow(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000022du, ImmutableString("pow(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000327u, ImmutableString("exp(00B").mangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("exp(10B").mangledNameHash());
    ASSERT_EQ(0x00000188u, ImmutableString("exp(20B").mangledNameHash());
    ASSERT_EQ(0x000002b0u, ImmutableString("exp(30B").mangledNameHash());
    ASSERT_EQ(0x000002b7u, ImmutableString("log(00B").mangledNameHash());
    ASSERT_EQ(0x0000018cu, ImmutableString("log(10B").mangledNameHash());
    ASSERT_EQ(0x00000141u, ImmutableString("log(20B").mangledNameHash());
    ASSERT_EQ(0x000000d2u, ImmutableString("log(30B").mangledNameHash());
    ASSERT_EQ(0x000003bau, ImmutableString("exp2(00B").mangledNameHash());
    ASSERT_EQ(0x00000100u, ImmutableString("exp2(10B").mangledNameHash());
    ASSERT_EQ(0x00000152u, ImmutableString("exp2(20B").mangledNameHash());
    ASSERT_EQ(0x0000026fu, ImmutableString("exp2(30B").mangledNameHash());
    ASSERT_EQ(0x00000172u, ImmutableString("log2(00B").mangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("log2(10B").mangledNameHash());
    ASSERT_EQ(0x00000333u, ImmutableString("log2(20B").mangledNameHash());
    ASSERT_EQ(0x000001c7u, ImmutableString("log2(30B").mangledNameHash());
    ASSERT_EQ(0x000001e8u, ImmutableString("sqrt(00B").mangledNameHash());
    ASSERT_EQ(0x000000bfu, ImmutableString("sqrt(10B").mangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("sqrt(20B").mangledNameHash());
    ASSERT_EQ(0x00000323u, ImmutableString("sqrt(30B").mangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("inversesqrt(00B").mangledNameHash());
    ASSERT_EQ(0x00000301u, ImmutableString("inversesqrt(10B").mangledNameHash());
    ASSERT_EQ(0x00000255u, ImmutableString("inversesqrt(20B").mangledNameHash());
    ASSERT_EQ(0x0000017eu, ImmutableString("inversesqrt(30B").mangledNameHash());
    ASSERT_EQ(0x0000029bu, ImmutableString("abs(00B").mangledNameHash());
    ASSERT_EQ(0x00000175u, ImmutableString("abs(10B").mangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("abs(20B").mangledNameHash());
    ASSERT_EQ(0x00000307u, ImmutableString("abs(30B").mangledNameHash());
    ASSERT_EQ(0x0000029au, ImmutableString("abs(00D").mangledNameHash());
    ASSERT_EQ(0x00000174u, ImmutableString("abs(10D").mangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("abs(20D").mangledNameHash());
    ASSERT_EQ(0x00000304u, ImmutableString("abs(30D").mangledNameHash());
    ASSERT_EQ(0x000002b6u, ImmutableString("sign(00B").mangledNameHash());
    ASSERT_EQ(0x000003acu, ImmutableString("sign(10B").mangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("sign(20B").mangledNameHash());
    ASSERT_EQ(0x0000019du, ImmutableString("sign(30B").mangledNameHash());
    ASSERT_EQ(0x000002bau, ImmutableString("sign(00D").mangledNameHash());
    ASSERT_EQ(0x00000325u, ImmutableString("sign(10D").mangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("sign(20D").mangledNameHash());
    ASSERT_EQ(0x0000019eu, ImmutableString("sign(30D").mangledNameHash());
    ASSERT_EQ(0x000003c3u, ImmutableString("floor(00B").mangledNameHash());
    ASSERT_EQ(0x00000217u, ImmutableString("floor(10B").mangledNameHash());
    ASSERT_EQ(0x00000234u, ImmutableString("floor(20B").mangledNameHash());
    ASSERT_EQ(0x00000118u, ImmutableString("floor(30B").mangledNameHash());
    ASSERT_EQ(0x000000f1u, ImmutableString("trunc(00B").mangledNameHash());
    ASSERT_EQ(0x00000399u, ImmutableString("trunc(10B").mangledNameHash());
    ASSERT_EQ(0x00000361u, ImmutableString("trunc(20B").mangledNameHash());
    ASSERT_EQ(0x0000020eu, ImmutableString("trunc(30B").mangledNameHash());
    ASSERT_EQ(0x000000d7u, ImmutableString("round(00B").mangledNameHash());
    ASSERT_EQ(0x00000381u, ImmutableString("round(10B").mangledNameHash());
    ASSERT_EQ(0x0000023cu, ImmutableString("round(20B").mangledNameHash());
    ASSERT_EQ(0x00000114u, ImmutableString("round(30B").mangledNameHash());
    ASSERT_EQ(0x000002e3u, ImmutableString("roundEven(00B").mangledNameHash());
    ASSERT_EQ(0x000001a3u, ImmutableString("roundEven(10B").mangledNameHash());
    ASSERT_EQ(0x00000148u, ImmutableString("roundEven(20B").mangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("roundEven(30B").mangledNameHash());
    ASSERT_EQ(0x00000249u, ImmutableString("ceil(00B").mangledNameHash());
    ASSERT_EQ(0x00000342u, ImmutableString("ceil(10B").mangledNameHash());
    ASSERT_EQ(0x0000009du, ImmutableString("ceil(20B").mangledNameHash());
    ASSERT_EQ(0x0000015au, ImmutableString("ceil(30B").mangledNameHash());
    ASSERT_EQ(0x00000185u, ImmutableString("fract(00B").mangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("fract(10B").mangledNameHash());
    ASSERT_EQ(0x00000306u, ImmutableString("fract(20B").mangledNameHash());
    ASSERT_EQ(0x000001cau, ImmutableString("fract(30B").mangledNameHash());
    ASSERT_EQ(0x000001a0u, ImmutableString("mod(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000163u, ImmutableString("mod(10B00B").mangledNameHash());
    ASSERT_EQ(0x000000bau, ImmutableString("mod(20B00B").mangledNameHash());
    ASSERT_EQ(0x000001b1u, ImmutableString("mod(30B00B").mangledNameHash());
    ASSERT_EQ(0x000002c6u, ImmutableString("mod(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000021cu, ImmutableString("mod(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000019bu, ImmutableString("mod(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001e4u, ImmutableString("min(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000335u, ImmutableString("min(10B00B").mangledNameHash());
    ASSERT_EQ(0x000000b4u, ImmutableString("min(20B00B").mangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("min(30B00B").mangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("min(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000225u, ImmutableString("min(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("min(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000035eu, ImmutableString("min(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("min(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000287u, ImmutableString("min(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000257u, ImmutableString("min(30D30D").mangledNameHash());
    ASSERT_EQ(0x000002dfu, ImmutableString("min(10D00D").mangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("min(20D00D").mangledNameHash());
    ASSERT_EQ(0x000003aau, ImmutableString("min(30D00D").mangledNameHash());
    ASSERT_EQ(0x00000328u, ImmutableString("min(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000037au, ImmutableString("min(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("min(20E20E").mangledNameHash());
    ASSERT_EQ(0x000001dfu, ImmutableString("min(30E30E").mangledNameHash());
    ASSERT_EQ(0x000000d1u, ImmutableString("min(10E00E").mangledNameHash());
    ASSERT_EQ(0x000001eeu, ImmutableString("min(20E00E").mangledNameHash());
    ASSERT_EQ(0x00000187u, ImmutableString("min(30E00E").mangledNameHash());
    ASSERT_EQ(0x00000147u, ImmutableString("max(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000268u, ImmutableString("max(10B00B").mangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("max(20B00B").mangledNameHash());
    ASSERT_EQ(0x00000286u, ImmutableString("max(30B00B").mangledNameHash());
    ASSERT_EQ(0x00000391u, ImmutableString("max(10B10B").mangledNameHash());
    ASSERT_EQ(0x000002abu, ImmutableString("max(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000127u, ImmutableString("max(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000158u, ImmutableString("max(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000229u, ImmutableString("max(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000227u, ImmutableString("max(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000329u, ImmutableString("max(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000113u, ImmutableString("max(10D00D").mangledNameHash());
    ASSERT_EQ(0x000000c3u, ImmutableString("max(20D00D").mangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("max(30D00D").mangledNameHash());
    ASSERT_EQ(0x000003adu, ImmutableString("max(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000126u, ImmutableString("max(10E10E").mangledNameHash());
    ASSERT_EQ(0x0000016au, ImmutableString("max(20E20E").mangledNameHash());
    ASSERT_EQ(0x000001d6u, ImmutableString("max(30E30E").mangledNameHash());
    ASSERT_EQ(0x000001fdu, ImmutableString("max(10E00E").mangledNameHash());
    ASSERT_EQ(0x000002e1u, ImmutableString("max(20E00E").mangledNameHash());
    ASSERT_EQ(0x00000151u, ImmutableString("max(30E00E").mangledNameHash());
    ASSERT_EQ(0x00000181u, ImmutableString("clamp(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000003a2u, ImmutableString("clamp(10B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000295u, ImmutableString("clamp(20B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000107u, ImmutableString("clamp(30B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("clamp(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000358u, ImmutableString("clamp(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("clamp(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000116u, ImmutableString("clamp(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("clamp(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002e9u, ImmutableString("clamp(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000003a1u, ImmutableString("clamp(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000009fu, ImmutableString("clamp(10D10D10D").mangledNameHash());
    ASSERT_EQ(0x000001fau, ImmutableString("clamp(20D20D20D").mangledNameHash());
    ASSERT_EQ(0x0000030eu, ImmutableString("clamp(30D30D30D").mangledNameHash());
    ASSERT_EQ(0x00000013u, ImmutableString("clamp(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x000002e7u, ImmutableString("clamp(10E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000314u, ImmutableString("clamp(20E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000247u, ImmutableString("clamp(30E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000128u, ImmutableString("clamp(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x000000c1u, ImmutableString("clamp(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x000000a9u, ImmutableString("clamp(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x00000236u, ImmutableString("mix(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000030cu, ImmutableString("mix(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("mix(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x00000336u, ImmutableString("mix(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x000001c2u, ImmutableString("mix(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000266u, ImmutableString("mix(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000375u, ImmutableString("mix(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("mix(00B00B00F").mangledNameHash());
    ASSERT_EQ(0x000001c1u, ImmutableString("mix(10B10B10F").mangledNameHash());
    ASSERT_EQ(0x00000263u, ImmutableString("mix(20B20B20F").mangledNameHash());
    ASSERT_EQ(0x00000317u, ImmutableString("mix(30B30B30F").mangledNameHash());
    ASSERT_EQ(0x00000198u, ImmutableString("mix(00D00D00F").mangledNameHash());
    ASSERT_EQ(0x0000013cu, ImmutableString("mix(10D10D10F").mangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("mix(20D20D20F").mangledNameHash());
    ASSERT_EQ(0x000002d8u, ImmutableString("mix(30D30D30F").mangledNameHash());
    ASSERT_EQ(0x00000196u, ImmutableString("mix(00E00E00F").mangledNameHash());
    ASSERT_EQ(0x0000020du, ImmutableString("mix(10E10E10F").mangledNameHash());
    ASSERT_EQ(0x000003a3u, ImmutableString("mix(20E20E20F").mangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("mix(30E30E30F").mangledNameHash());
    ASSERT_EQ(0x000002b8u, ImmutableString("mix(00F00F00F").mangledNameHash());
    ASSERT_EQ(0x00000338u, ImmutableString("mix(10F10F10F").mangledNameHash());
    ASSERT_EQ(0x0000032fu, ImmutableString("mix(20F20F20F").mangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("mix(30F30F30F").mangledNameHash());
    ASSERT_EQ(0x000001a9u, ImmutableString("step(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000289u, ImmutableString("step(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000029du, ImmutableString("step(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000028cu, ImmutableString("step(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("step(00B10B").mangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("step(00B20B").mangledNameHash());
    ASSERT_EQ(0x000002b3u, ImmutableString("step(00B30B").mangledNameHash());
    ASSERT_EQ(0x00000350u, ImmutableString("smoothstep(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000022fu, ImmutableString("smoothstep(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000003b0u, ImmutableString("smoothstep(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000356u, ImmutableString("smoothstep(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000001feu, ImmutableString("smoothstep(00B00B10B").mangledNameHash());
    ASSERT_EQ(0x000000d8u, ImmutableString("smoothstep(00B00B20B").mangledNameHash());
    ASSERT_EQ(0x00000331u, ImmutableString("smoothstep(00B00B30B").mangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("modf(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("modf(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000250u, ImmutableString("modf(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000144u, ImmutableString("modf(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000243u, ImmutableString("isnan(00B").mangledNameHash());
    ASSERT_EQ(0x0000038fu, ImmutableString("isnan(10B").mangledNameHash());
    ASSERT_EQ(0x00000146u, ImmutableString("isnan(20B").mangledNameHash());
    ASSERT_EQ(0x000001d7u, ImmutableString("isnan(30B").mangledNameHash());
    ASSERT_EQ(0x000001acu, ImmutableString("isinf(00B").mangledNameHash());
    ASSERT_EQ(0x000002ebu, ImmutableString("isinf(10B").mangledNameHash());
    ASSERT_EQ(0x00000373u, ImmutableString("isinf(20B").mangledNameHash());
    ASSERT_EQ(0x000000c8u, ImmutableString("isinf(30B").mangledNameHash());
    ASSERT_EQ(0x000003abu, ImmutableString("floatBitsToInt(00B").mangledNameHash());
    ASSERT_EQ(0x00000267u, ImmutableString("floatBitsToInt(10B").mangledNameHash());
    ASSERT_EQ(0x000000bdu, ImmutableString("floatBitsToInt(20B").mangledNameHash());
    ASSERT_EQ(0x0000014du, ImmutableString("floatBitsToInt(30B").mangledNameHash());
    ASSERT_EQ(0x000003b5u, ImmutableString("floatBitsToUint(00B").mangledNameHash());
    ASSERT_EQ(0x000000e8u, ImmutableString("floatBitsToUint(10B").mangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("floatBitsToUint(20B").mangledNameHash());
    ASSERT_EQ(0x00000275u, ImmutableString("floatBitsToUint(30B").mangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("intBitsToFloat(00D").mangledNameHash());
    ASSERT_EQ(0x000001bau, ImmutableString("intBitsToFloat(10D").mangledNameHash());
    ASSERT_EQ(0x00000184u, ImmutableString("intBitsToFloat(20D").mangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("intBitsToFloat(30D").mangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("uintBitsToFloat(00E").mangledNameHash());
    ASSERT_EQ(0x00000164u, ImmutableString("uintBitsToFloat(10E").mangledNameHash());
    ASSERT_EQ(0x000002c2u, ImmutableString("uintBitsToFloat(20E").mangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("uintBitsToFloat(30E").mangledNameHash());
    ASSERT_EQ(0x0000038cu, ImmutableString("fma(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000190u, ImmutableString("fma(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000002a9u, ImmutableString("fma(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000033eu, ImmutableString("fma(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("frexp(00B00D").mangledNameHash());
    ASSERT_EQ(0x000001fcu, ImmutableString("frexp(10B10D").mangledNameHash());
    ASSERT_EQ(0x00000183u, ImmutableString("frexp(20B20D").mangledNameHash());
    ASSERT_EQ(0x000001ddu, ImmutableString("frexp(30B30D").mangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("ldexp(00B00D").mangledNameHash());
    ASSERT_EQ(0x00000334u, ImmutableString("ldexp(10B10D").mangledNameHash());
    ASSERT_EQ(0x0000036eu, ImmutableString("ldexp(20B20D").mangledNameHash());
    ASSERT_EQ(0x00000285u, ImmutableString("ldexp(30B30D").mangledNameHash());
    ASSERT_EQ(0x00000274u, ImmutableString("packSnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x000002f1u, ImmutableString("packHalf2x16(10B").mangledNameHash());
    ASSERT_EQ(0x00000203u, ImmutableString("unpackSnorm2x16(00E").mangledNameHash());
    ASSERT_EQ(0x0000010cu, ImmutableString("unpackHalf2x16(00E").mangledNameHash());
    ASSERT_EQ(0x000002cbu, ImmutableString("packUnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("unpackUnorm2x16(00E").mangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("packUnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x0000030bu, ImmutableString("packSnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x000002c3u, ImmutableString("unpackUnorm4x8(00E").mangledNameHash());
    ASSERT_EQ(0x0000013eu, ImmutableString("unpackSnorm4x8(00E").mangledNameHash());
    ASSERT_EQ(0x00000210u, ImmutableString("length(00B").mangledNameHash());
    ASSERT_EQ(0x000000f4u, ImmutableString("length(10B").mangledNameHash());
    ASSERT_EQ(0x0000039du, ImmutableString("length(20B").mangledNameHash());
    ASSERT_EQ(0x0000025fu, ImmutableString("length(30B").mangledNameHash());
    ASSERT_EQ(0x0000024bu, ImmutableString("distance(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000161u, ImmutableString("distance(10B10B").mangledNameHash());
    ASSERT_EQ(0x000001aeu, ImmutableString("distance(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000edu, ImmutableString("distance(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000f7u, ImmutableString("dot(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000010au, ImmutableString("dot(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000349u, ImmutableString("dot(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000f9u, ImmutableString("dot(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000293u, ImmutableString("cross(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000adu, ImmutableString("normalize(00B").mangledNameHash());
    ASSERT_EQ(0x00000202u, ImmutableString("normalize(10B").mangledNameHash());
    ASSERT_EQ(0x000001e9u, ImmutableString("normalize(20B").mangledNameHash());
    ASSERT_EQ(0x00000355u, ImmutableString("normalize(30B").mangledNameHash());
    ASSERT_EQ(0x000002ccu, ImmutableString("faceforward(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000002d7u, ImmutableString("faceforward(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000002a1u, ImmutableString("faceforward(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000245u, ImmutableString("faceforward(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000000b9u, ImmutableString("reflect(00B00B").mangledNameHash());
    ASSERT_EQ(0x000000bcu, ImmutableString("reflect(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000162u, ImmutableString("reflect(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000191u, ImmutableString("reflect(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001beu, ImmutableString("refract(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000dfu, ImmutableString("refract(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x000001bcu, ImmutableString("refract(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x00000232u, ImmutableString("refract(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x00000385u, ImmutableString("matrixCompMult(50B50B").mangledNameHash());
    ASSERT_EQ(0x0000010du, ImmutableString("matrixCompMult(A0BA0B").mangledNameHash());
    ASSERT_EQ(0x00000298u, ImmutableString("matrixCompMult(F0BF0B").mangledNameHash());
    ASSERT_EQ(0x0000023du, ImmutableString("matrixCompMult(90B90B").mangledNameHash());
    ASSERT_EQ(0x00000200u, ImmutableString("matrixCompMult(60B60B").mangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("matrixCompMult(D0BD0B").mangledNameHash());
    ASSERT_EQ(0x0000016bu, ImmutableString("matrixCompMult(70B70B").mangledNameHash());
    ASSERT_EQ(0x0000020fu, ImmutableString("matrixCompMult(E0BE0B").mangledNameHash());
    ASSERT_EQ(0x00000291u, ImmutableString("matrixCompMult(B0BB0B").mangledNameHash());
    ASSERT_EQ(0x0000035fu, ImmutableString("outerProduct(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000013bu, ImmutableString("outerProduct(20B20B").mangledNameHash());
    ASSERT_EQ(0x000002adu, ImmutableString("outerProduct(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000195u, ImmutableString("outerProduct(20B10B").mangledNameHash());
    ASSERT_EQ(0x00000103u, ImmutableString("outerProduct(10B20B").mangledNameHash());
    ASSERT_EQ(0x0000014cu, ImmutableString("outerProduct(30B10B").mangledNameHash());
    ASSERT_EQ(0x00000220u, ImmutableString("outerProduct(10B30B").mangledNameHash());
    ASSERT_EQ(0x00000192u, ImmutableString("outerProduct(30B20B").mangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("outerProduct(20B30B").mangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("transpose(50B").mangledNameHash());
    ASSERT_EQ(0x00000319u, ImmutableString("transpose(A0B").mangledNameHash());
    ASSERT_EQ(0x000000a2u, ImmutableString("transpose(F0B").mangledNameHash());
    ASSERT_EQ(0x000002bcu, ImmutableString("transpose(60B").mangledNameHash());
    ASSERT_EQ(0x0000034au, ImmutableString("transpose(90B").mangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("transpose(70B").mangledNameHash());
    ASSERT_EQ(0x000001c6u, ImmutableString("transpose(D0B").mangledNameHash());
    ASSERT_EQ(0x0000032du, ImmutableString("transpose(B0B").mangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("transpose(E0B").mangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("determinant(50B").mangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("determinant(A0B").mangledNameHash());
    ASSERT_EQ(0x00000318u, ImmutableString("determinant(F0B").mangledNameHash());
    ASSERT_EQ(0x00000108u, ImmutableString("inverse(50B").mangledNameHash());
    ASSERT_EQ(0x000001d4u, ImmutableString("inverse(A0B").mangledNameHash());
    ASSERT_EQ(0x000001edu, ImmutableString("inverse(F0B").mangledNameHash());
    ASSERT_EQ(0x00000308u, ImmutableString("lessThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("lessThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000292u, ImmutableString("lessThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000012fu, ImmutableString("lessThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x000000bbu, ImmutableString("lessThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000205u, ImmutableString("lessThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000009cu, ImmutableString("lessThan(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000109u, ImmutableString("lessThan(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("lessThan(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("lessThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("lessThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("lessThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000360u, ImmutableString("lessThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x0000031fu, ImmutableString("lessThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000276u, ImmutableString("lessThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000254u, ImmutableString("lessThanEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x000002aeu, ImmutableString("lessThanEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x000000cfu, ImmutableString("lessThanEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000396u, ImmutableString("greaterThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("greaterThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000f0u, ImmutableString("greaterThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000e2u, ImmutableString("greaterThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x000000eeu, ImmutableString("greaterThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x000000e1u, ImmutableString("greaterThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x000003a6u, ImmutableString("greaterThan(10E10E").mangledNameHash());
    ASSERT_EQ(0x000001b7u, ImmutableString("greaterThan(20E20E").mangledNameHash());
    ASSERT_EQ(0x000001fbu, ImmutableString("greaterThan(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000346u, ImmutableString("greaterThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000238u, ImmutableString("greaterThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x000002f7u, ImmutableString("greaterThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000016eu, ImmutableString("greaterThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("greaterThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x0000036fu, ImmutableString("greaterThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000027au, ImmutableString("greaterThanEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x0000012eu, ImmutableString("greaterThanEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000260u, ImmutableString("greaterThanEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000038bu, ImmutableString("equal(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000189u, ImmutableString("equal(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000388u, ImmutableString("equal(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("equal(10D10D").mangledNameHash());
    ASSERT_EQ(0x000002d4u, ImmutableString("equal(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000271u, ImmutableString("equal(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000379u, ImmutableString("equal(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000235u, ImmutableString("equal(20E20E").mangledNameHash());
    ASSERT_EQ(0x000002b5u, ImmutableString("equal(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000166u, ImmutableString("equal(10F10F").mangledNameHash());
    ASSERT_EQ(0x00000386u, ImmutableString("equal(20F20F").mangledNameHash());
    ASSERT_EQ(0x000002fbu, ImmutableString("equal(30F30F").mangledNameHash());
    ASSERT_EQ(0x00000209u, ImmutableString("notEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000370u, ImmutableString("notEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x000001a2u, ImmutableString("notEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x000002c8u, ImmutableString("notEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("notEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x000000deu, ImmutableString("notEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000383u, ImmutableString("notEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x000001d2u, ImmutableString("notEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000252u, ImmutableString("notEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000034du, ImmutableString("notEqual(10F10F").mangledNameHash());
    ASSERT_EQ(0x0000019au, ImmutableString("notEqual(20F20F").mangledNameHash());
    ASSERT_EQ(0x000002feu, ImmutableString("notEqual(30F30F").mangledNameHash());
    ASSERT_EQ(0x0000026bu, ImmutableString("any(10F").mangledNameHash());
    ASSERT_EQ(0x00000211u, ImmutableString("any(20F").mangledNameHash());
    ASSERT_EQ(0x000000ecu, ImmutableString("any(30F").mangledNameHash());
    ASSERT_EQ(0x00000294u, ImmutableString("all(10F").mangledNameHash());
    ASSERT_EQ(0x000002eau, ImmutableString("all(20F").mangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("all(30F").mangledNameHash());
    ASSERT_EQ(0x0000009au, ImmutableString("not(10F").mangledNameHash());
    ASSERT_EQ(0x00000134u, ImmutableString("not(20F").mangledNameHash());
    ASSERT_EQ(0x0000034bu, ImmutableString("not(30F").mangledNameHash());
    ASSERT_EQ(0x000002fcu, ImmutableString("bitfieldExtract(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000019cu, ImmutableString("bitfieldExtract(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000207u, ImmutableString("bitfieldExtract(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002deu, ImmutableString("bitfieldExtract(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000020bu, ImmutableString("bitfieldExtract(00E00D00D").mangledNameHash());
    ASSERT_EQ(0x000000e5u, ImmutableString("bitfieldExtract(10E00D00D").mangledNameHash());
    ASSERT_EQ(0x000002c1u, ImmutableString("bitfieldExtract(20E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000016cu, ImmutableString("bitfieldExtract(30E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("bitfieldInsert(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000357u, ImmutableString("bitfieldInsert(10D10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("bitfieldInsert(20D20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000dbu, ImmutableString("bitfieldInsert(30D30D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("bitfieldInsert(00E00E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000030au, ImmutableString("bitfieldInsert(10E10E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000233u, ImmutableString("bitfieldInsert(20E20E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000039eu, ImmutableString("bitfieldInsert(30E30E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000168u, ImmutableString("bitfieldReverse(00D").mangledNameHash());
    ASSERT_EQ(0x0000028eu, ImmutableString("bitfieldReverse(10D").mangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("bitfieldReverse(20D").mangledNameHash());
    ASSERT_EQ(0x0000017du, ImmutableString("bitfieldReverse(30D").mangledNameHash());
    ASSERT_EQ(0x00000169u, ImmutableString("bitfieldReverse(00E").mangledNameHash());
    ASSERT_EQ(0x0000028du, ImmutableString("bitfieldReverse(10E").mangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("bitfieldReverse(20E").mangledNameHash());
    ASSERT_EQ(0x0000017cu, ImmutableString("bitfieldReverse(30E").mangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("bitCount(00D").mangledNameHash());
    ASSERT_EQ(0x000002b4u, ImmutableString("bitCount(10D").mangledNameHash());
    ASSERT_EQ(0x000001a8u, ImmutableString("bitCount(20D").mangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("bitCount(30D").mangledNameHash());
    ASSERT_EQ(0x000000fau, ImmutableString("bitCount(00E").mangledNameHash());
    ASSERT_EQ(0x0000015du, ImmutableString("bitCount(10E").mangledNameHash());
    ASSERT_EQ(0x000002d2u, ImmutableString("bitCount(20E").mangledNameHash());
    ASSERT_EQ(0x0000013fu, ImmutableString("bitCount(30E").mangledNameHash());
    ASSERT_EQ(0x000002f4u, ImmutableString("findLSB(00D").mangledNameHash());
    ASSERT_EQ(0x000001bfu, ImmutableString("findLSB(10D").mangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("findLSB(20D").mangledNameHash());
    ASSERT_EQ(0x000002d0u, ImmutableString("findLSB(30D").mangledNameHash());
    ASSERT_EQ(0x000002f3u, ImmutableString("findLSB(00E").mangledNameHash());
    ASSERT_EQ(0x000001c0u, ImmutableString("findLSB(10E").mangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("findLSB(20E").mangledNameHash());
    ASSERT_EQ(0x000002d1u, ImmutableString("findLSB(30E").mangledNameHash());
    ASSERT_EQ(0x000002bdu, ImmutableString("findMSB(00D").mangledNameHash());
    ASSERT_EQ(0x000000f6u, ImmutableString("findMSB(10D").mangledNameHash());
    ASSERT_EQ(0x00000136u, ImmutableString("findMSB(20D").mangledNameHash());
    ASSERT_EQ(0x0000025du, ImmutableString("findMSB(30D").mangledNameHash());
    ASSERT_EQ(0x000002c0u, ImmutableString("findMSB(00E").mangledNameHash());
    ASSERT_EQ(0x000000f5u, ImmutableString("findMSB(10E").mangledNameHash());
    ASSERT_EQ(0x00000137u, ImmutableString("findMSB(20E").mangledNameHash());
    ASSERT_EQ(0x0000025cu, ImmutableString("findMSB(30E").mangledNameHash());
    ASSERT_EQ(0x00000239u, ImmutableString("uaddCarry(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x0000036au, ImmutableString("uaddCarry(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x00000390u, ImmutableString("uaddCarry(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x000001b0u, ImmutableString("uaddCarry(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x000001dbu, ImmutableString("usubBorrow(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x0000038au, ImmutableString("usubBorrow(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x000000feu, ImmutableString("usubBorrow(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x00000282u, ImmutableString("usubBorrow(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x0000032au, ImmutableString("umulExtended(00E00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000197u, ImmutableString("umulExtended(10E10E10E10E").mangledNameHash());
    ASSERT_EQ(0x000002cdu, ImmutableString("umulExtended(20E20E20E20E").mangledNameHash());
    ASSERT_EQ(0x00000244u, ImmutableString("umulExtended(30E30E30E30E").mangledNameHash());
    ASSERT_EQ(0x000001d8u, ImmutableString("imulExtended(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("imulExtended(10D10D10D10D").mangledNameHash());
    ASSERT_EQ(0x000000ebu, ImmutableString("imulExtended(20D20D20D20D").mangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("imulExtended(30D30D30D30D").mangledNameHash());
    ASSERT_EQ(0x00000099u, ImmutableString("texture2D(00I10B").mangledNameHash());
    ASSERT_EQ(0x00000132u, ImmutableString("texture2DProj(00I20B").mangledNameHash());
    ASSERT_EQ(0x0000024fu, ImmutableString("texture2DProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x00000221u, ImmutableString("textureCube(00K20B").mangledNameHash());
    ASSERT_EQ(0x0000035du, ImmutableString("texture2D(00M10B").mangledNameHash());
    ASSERT_EQ(0x000002c4u, ImmutableString("texture2DProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x000002c9u, ImmutableString("texture2DProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x000000eau, ImmutableString("texture2DRect(00O10B").mangledNameHash());
    ASSERT_EQ(0x000003bcu, ImmutableString("texture2DRectProj(00O20B").mangledNameHash());
    ASSERT_EQ(0x00000110u, ImmutableString("texture2DRectProj(00O30B").mangledNameHash());
    ASSERT_EQ(0x000000a1u, ImmutableString("texture(00O10B").mangledNameHash());
    ASSERT_EQ(0x00000101u, ImmutableString("textureProj(00O20B").mangledNameHash());
    ASSERT_EQ(0x00000230u, ImmutableString("textureProj(00O30B").mangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("texture2DGradEXT(00I10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000031bu, ImmutableString("texture2DProjGradEXT(00I20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("texture2DProjGradEXT(00I30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001e2u, ImmutableString("textureCubeGradEXT(00K20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000001f8u, ImmutableString("texture2D(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x000002f2u, ImmutableString("texture2DProj(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000001e1u, ImmutableString("texture2DProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000348u, ImmutableString("textureCube(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x00000297u, ImmutableString("dFdx(00B").mangledNameHash());
    ASSERT_EQ(0x0000017au, ImmutableString("dFdx(10B").mangledNameHash());
    ASSERT_EQ(0x00000123u, ImmutableString("dFdx(20B").mangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("dFdx(30B").mangledNameHash());
    ASSERT_EQ(0x000003a9u, ImmutableString("dFdy(00B").mangledNameHash());
    ASSERT_EQ(0x0000014bu, ImmutableString("dFdy(10B").mangledNameHash());
    ASSERT_EQ(0x000001a6u, ImmutableString("dFdy(20B").mangledNameHash());
    ASSERT_EQ(0x000002e5u, ImmutableString("dFdy(30B").mangledNameHash());
    ASSERT_EQ(0x00000149u, ImmutableString("fwidth(00B").mangledNameHash());
    ASSERT_EQ(0x000000dcu, ImmutableString("fwidth(10B").mangledNameHash());
    ASSERT_EQ(0x0000032eu, ImmutableString("fwidth(20B").mangledNameHash());
    ASSERT_EQ(0x00000261u, ImmutableString("fwidth(30B").mangledNameHash());
    ASSERT_EQ(0x000002e4u, ImmutableString("texture2DLodEXT(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x000002fdu, ImmutableString("texture2DProjLodEXT(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000001a4u, ImmutableString("texture2DProjLodEXT(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000367u, ImmutableString("textureCubeLodEXT(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000001c4u, ImmutableString("texture3D(00J20B").mangledNameHash());
    ASSERT_EQ(0x0000028fu, ImmutableString("texture3DProj(00J30B").mangledNameHash());
    ASSERT_EQ(0x0000024au, ImmutableString("texture3D(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x00000272u, ImmutableString("texture3DProj(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000003c7u, ImmutableString("texture3DLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x00000133u, ImmutableString("texture3DProjLod(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000002a7u, ImmutableString("texture2DLod(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x0000010eu, ImmutableString("texture2DProjLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x0000038eu, ImmutableString("texture2DProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x000003b1u, ImmutableString("textureCubeLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000001e3u, ImmutableString("texture(00I10B").mangledNameHash());
    ASSERT_EQ(0x00000280u, ImmutableString("texture(00R10B").mangledNameHash());
    ASSERT_EQ(0x00000315u, ImmutableString("texture(00X10B").mangledNameHash());
    ASSERT_EQ(0x00000120u, ImmutableString("texture(00J20B").mangledNameHash());
    ASSERT_EQ(0x00000194u, ImmutableString("texture(00S20B").mangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("texture(00Y20B").mangledNameHash());
    ASSERT_EQ(0x0000033cu, ImmutableString("texture(00K20B").mangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("texture(00T20B").mangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("texture(00Z20B").mangledNameHash());
    ASSERT_EQ(0x0000012bu, ImmutableString("texture(00L20B").mangledNameHash());
    ASSERT_EQ(0x000000e3u, ImmutableString("texture(00U20B").mangledNameHash());
    ASSERT_EQ(0x0000024cu, ImmutableString("texture(00a20B").mangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("texture(00d20B").mangledNameHash());
    ASSERT_EQ(0x00000376u, ImmutableString("texture(00e30B").mangledNameHash());
    ASSERT_EQ(0x0000034fu, ImmutableString("texture(00f30B").mangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("textureProj(00I20B").mangledNameHash());
    ASSERT_EQ(0x000003a4u, ImmutableString("textureProj(00R20B").mangledNameHash());
    ASSERT_EQ(0x00000125u, ImmutableString("textureProj(00X20B").mangledNameHash());
    ASSERT_EQ(0x00000228u, ImmutableString("textureProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x00000384u, ImmutableString("textureProj(00R30B").mangledNameHash());
    ASSERT_EQ(0x0000039bu, ImmutableString("textureProj(00X30B").mangledNameHash());
    ASSERT_EQ(0x0000014eu, ImmutableString("textureProj(00J30B").mangledNameHash());
    ASSERT_EQ(0x000002e2u, ImmutableString("textureProj(00S30B").mangledNameHash());
    ASSERT_EQ(0x000001a7u, ImmutableString("textureProj(00Y30B").mangledNameHash());
    ASSERT_EQ(0x00000316u, ImmutableString("textureProj(00d30B").mangledNameHash());
    ASSERT_EQ(0x0000016du, ImmutableString("textureLod(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x0000029cu, ImmutableString("textureLod(00R10B00B").mangledNameHash());
    ASSERT_EQ(0x000002afu, ImmutableString("textureLod(00X10B00B").mangledNameHash());
    ASSERT_EQ(0x000000beu, ImmutableString("textureLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x00000320u, ImmutableString("textureLod(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("textureLod(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x000003b7u, ImmutableString("textureLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000000fcu, ImmutableString("textureLod(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x000002b9u, ImmutableString("textureLod(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("textureLod(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x00000389u, ImmutableString("textureLod(00U20B00B").mangledNameHash());
    ASSERT_EQ(0x0000026au, ImmutableString("textureLod(00a20B00B").mangledNameHash());
    ASSERT_EQ(0x00000153u, ImmutableString("textureLod(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x000000c4u, ImmutableString("textureSize(00I00D").mangledNameHash());
    ASSERT_EQ(0x000000abu, ImmutableString("textureSize(00R00D").mangledNameHash());
    ASSERT_EQ(0x00000395u, ImmutableString("textureSize(00X00D").mangledNameHash());
    ASSERT_EQ(0x000001ccu, ImmutableString("textureSize(00J00D").mangledNameHash());
    ASSERT_EQ(0x00000343u, ImmutableString("textureSize(00S00D").mangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("textureSize(00Y00D").mangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("textureSize(00K00D").mangledNameHash());
    ASSERT_EQ(0x00000377u, ImmutableString("textureSize(00T00D").mangledNameHash());
    ASSERT_EQ(0x000002dcu, ImmutableString("textureSize(00Z00D").mangledNameHash());
    ASSERT_EQ(0x000001d0u, ImmutableString("textureSize(00L00D").mangledNameHash());
    ASSERT_EQ(0x000002f8u, ImmutableString("textureSize(00U00D").mangledNameHash());
    ASSERT_EQ(0x000000e4u, ImmutableString("textureSize(00a00D").mangledNameHash());
    ASSERT_EQ(0x00000364u, ImmutableString("textureSize(00d00D").mangledNameHash());
    ASSERT_EQ(0x000001d1u, ImmutableString("textureSize(00e00D").mangledNameHash());
    ASSERT_EQ(0x00000310u, ImmutableString("textureSize(00f00D").mangledNameHash());
    ASSERT_EQ(0x00000345u, ImmutableString("textureProjLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000000ddu, ImmutableString("textureProjLod(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x00000240u, ImmutableString("textureProjLod(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x000001bdu, ImmutableString("textureProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x000001efu, ImmutableString("textureProjLod(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("textureProjLod(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x000000e9u, ImmutableString("textureProjLod(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000000c0u, ImmutableString("textureProjLod(00S30B00B").mangledNameHash());
    ASSERT_EQ(0x00000321u, ImmutableString("textureProjLod(00Y30B00B").mangledNameHash());
    ASSERT_EQ(0x0000023eu, ImmutableString("textureProjLod(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("texelFetch(00I10D00D").mangledNameHash());
    ASSERT_EQ(0x00000352u, ImmutableString("texelFetch(00R10D00D").mangledNameHash());
    ASSERT_EQ(0x000002a4u, ImmutableString("texelFetch(00X10D00D").mangledNameHash());
    ASSERT_EQ(0x000003b3u, ImmutableString("texelFetch(00J20D00D").mangledNameHash());
    ASSERT_EQ(0x00000264u, ImmutableString("texelFetch(00S20D00D").mangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("texelFetch(00Y20D00D").mangledNameHash());
    ASSERT_EQ(0x000001aau, ImmutableString("texelFetch(00L20D00D").mangledNameHash());
    ASSERT_EQ(0x00000155u, ImmutableString("texelFetch(00U20D00D").mangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("texelFetch(00a20D00D").mangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("textureGrad(00I10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000035au, ImmutableString("textureGrad(00R10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000025eu, ImmutableString("textureGrad(00X10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001c8u, ImmutableString("textureGrad(00J20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000112u, ImmutableString("textureGrad(00S20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000011au, ImmutableString("textureGrad(00Y20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000262u, ImmutableString("textureGrad(00K20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000037cu, ImmutableString("textureGrad(00T20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000165u, ImmutableString("textureGrad(00Z20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("textureGrad(00d20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000259u, ImmutableString("textureGrad(00e30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000359u, ImmutableString("textureGrad(00L20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001afu, ImmutableString("textureGrad(00U20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001b8u, ImmutableString("textureGrad(00a20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000024eu, ImmutableString("textureGrad(00f30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000035bu, ImmutableString("textureProjGrad(00I20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000034eu, ImmutableString("textureProjGrad(00R20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001d5u, ImmutableString("textureProjGrad(00X20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("textureProjGrad(00I30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000000ffu, ImmutableString("textureProjGrad(00R30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000003c2u, ImmutableString("textureProjGrad(00X30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000014au, ImmutableString("textureProjGrad(00J30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("textureProjGrad(00S30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("textureProjGrad(00Y30B20B20B").mangledNameHash());
    ASSERT_EQ(0x000001c9u, ImmutableString("textureProjGrad(00d30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001f0u, ImmutableString("textureSize(00P").mangledNameHash());
    ASSERT_EQ(0x000002cau, ImmutableString("textureSize(00V").mangledNameHash());
    ASSERT_EQ(0x00000223u, ImmutableString("textureSize(00b").mangledNameHash());
    ASSERT_EQ(0x0000023bu, ImmutableString("textureSize(00Q").mangledNameHash());
    ASSERT_EQ(0x0000023fu, ImmutableString("textureSize(00W").mangledNameHash());
    ASSERT_EQ(0x00000222u, ImmutableString("textureSize(00c").mangledNameHash());
    ASSERT_EQ(0x0000009bu, ImmutableString("texelFetch(00P10D00D").mangledNameHash());
    ASSERT_EQ(0x0000013au, ImmutableString("texelFetch(00V10D00D").mangledNameHash());
    ASSERT_EQ(0x000002a8u, ImmutableString("texelFetch(00b10D00D").mangledNameHash());
    ASSERT_EQ(0x000002e0u, ImmutableString("texelFetch(00Q20D00D").mangledNameHash());
    ASSERT_EQ(0x0000010fu, ImmutableString("texelFetch(00W20D00D").mangledNameHash());
    ASSERT_EQ(0x000001e6u, ImmutableString("texelFetch(00c20D00D").mangledNameHash());
    ASSERT_EQ(0x000000b8u, ImmutableString("texture(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("texture(00R10B00B").mangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("texture(00X10B00B").mangledNameHash());
    ASSERT_EQ(0x000001bbu, ImmutableString("texture(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x0000015eu, ImmutableString("texture(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x000001a1u, ImmutableString("texture(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x000001b2u, ImmutableString("texture(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000000cdu, ImmutableString("texture(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x000000f2u, ImmutableString("texture(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x00000208u, ImmutableString("texture(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x00000193u, ImmutableString("texture(00U20B00B").mangledNameHash());
    ASSERT_EQ(0x000003aeu, ImmutableString("texture(00a20B00B").mangledNameHash());
    ASSERT_EQ(0x000003a5u, ImmutableString("textureProj(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000002a0u, ImmutableString("textureProj(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x000001f9u, ImmutableString("textureProj(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x000000b0u, ImmutableString("textureProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000000u, ImmutableString("textureProj(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x00000213u, ImmutableString("textureProj(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("textureProj(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x00000119u, ImmutableString("textureProj(00S30B00B").mangledNameHash());
    ASSERT_EQ(0x000001c3u, ImmutableString("textureProj(00Y30B00B").mangledNameHash());
    ASSERT_EQ(0x000002c7u, ImmutableString("texture(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x00000170u, ImmutableString("texture(00e30B00B").mangledNameHash());
    ASSERT_EQ(0x00000313u, ImmutableString("textureProj(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x000003afu, ImmutableString("texture(00M10B00B").mangledNameHash());
    ASSERT_EQ(0x000003b4u, ImmutableString("textureProj(00M20B00B").mangledNameHash());
    ASSERT_EQ(0x000000b5u, ImmutableString("textureProj(00M30B00B").mangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("texture(00N10B00B").mangledNameHash());
    ASSERT_EQ(0x00000311u, ImmutableString("textureProj(00N20B00B").mangledNameHash());
    ASSERT_EQ(0x000000aau, ImmutableString("textureProj(00N30B00B").mangledNameHash());
    ASSERT_EQ(0x000000aeu, ImmutableString("textureOffset(00I10B10D").mangledNameHash());
    ASSERT_EQ(0x00000279u, ImmutableString("textureOffset(00R10B10D").mangledNameHash());
    ASSERT_EQ(0x0000027du, ImmutableString("textureOffset(00X10B10D").mangledNameHash());
    ASSERT_EQ(0x000003b2u, ImmutableString("textureOffset(00J20B20D").mangledNameHash());
    ASSERT_EQ(0x0000039fu, ImmutableString("textureOffset(00S20B20D").mangledNameHash());
    ASSERT_EQ(0x000002bbu, ImmutableString("textureOffset(00Y20B20D").mangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("textureOffset(00d20B10D").mangledNameHash());
    ASSERT_EQ(0x000000ceu, ImmutableString("textureOffset(00L20B10D").mangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("textureOffset(00U20B10D").mangledNameHash());
    ASSERT_EQ(0x000000efu, ImmutableString("textureOffset(00a20B10D").mangledNameHash());
    ASSERT_EQ(0x000000e0u, ImmutableString("textureProjOffset(00I20B10D").mangledNameHash());
    ASSERT_EQ(0x000000a7u, ImmutableString("textureProjOffset(00R20B10D").mangledNameHash());
    ASSERT_EQ(0x000003a0u, ImmutableString("textureProjOffset(00X20B10D").mangledNameHash());
    ASSERT_EQ(0x0000017bu, ImmutableString("textureProjOffset(00I30B10D").mangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("textureProjOffset(00R30B10D").mangledNameHash());
    ASSERT_EQ(0x000002f5u, ImmutableString("textureProjOffset(00X30B10D").mangledNameHash());
    ASSERT_EQ(0x0000037eu, ImmutableString("textureProjOffset(00J30B20D").mangledNameHash());
    ASSERT_EQ(0x000000d5u, ImmutableString("textureProjOffset(00S30B20D").mangledNameHash());
    ASSERT_EQ(0x00000299u, ImmutableString("textureProjOffset(00Y30B20D").mangledNameHash());
    ASSERT_EQ(0x00000382u, ImmutableString("textureProjOffset(00d30B10D").mangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("textureLodOffset(00I10B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000009eu, ImmutableString("textureLodOffset(00R10B00B10D").mangledNameHash());
    ASSERT_EQ(0x000000ccu, ImmutableString("textureLodOffset(00X10B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000256u, ImmutableString("textureLodOffset(00J20B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("textureLodOffset(00S20B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000171u, ImmutableString("textureLodOffset(00Y20B00B20D").mangledNameHash());
    ASSERT_EQ(0x000001d3u, ImmutableString("textureLodOffset(00d20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000036cu, ImmutableString("textureLodOffset(00L20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000029fu, ImmutableString("textureLodOffset(00U20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("textureLodOffset(00a20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000034cu, ImmutableString("textureProjLodOffset(00I20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000140u, ImmutableString("textureProjLodOffset(00R20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000018au, ImmutableString("textureProjLodOffset(00X20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000354u, ImmutableString("textureProjLodOffset(00I30B00B10D").mangledNameHash());
    ASSERT_EQ(0x000001f3u, ImmutableString("textureProjLodOffset(00R30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000372u, ImmutableString("textureProjLodOffset(00X30B00B10D").mangledNameHash());
    ASSERT_EQ(0x000001dcu, ImmutableString("textureProjLodOffset(00J30B00B20D").mangledNameHash());
    ASSERT_EQ(0x0000018eu, ImmutableString("textureProjLodOffset(00S30B00B20D").mangledNameHash());
    ASSERT_EQ(0x0000010bu, ImmutableString("textureProjLodOffset(00Y30B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000351u, ImmutableString("textureProjLodOffset(00d30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000138u, ImmutableString("texelFetchOffset(00I10D00D10D").mangledNameHash());
    ASSERT_EQ(0x000000c7u, ImmutableString("texelFetchOffset(00R10D00D10D").mangledNameHash());
    ASSERT_EQ(0x000002c5u, ImmutableString("texelFetchOffset(00X10D00D10D").mangledNameHash());
    ASSERT_EQ(0x0000021au, ImmutableString("texelFetchOffset(00J20D00D20D").mangledNameHash());
    ASSERT_EQ(0x00000129u, ImmutableString("texelFetchOffset(00S20D00D20D").mangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("texelFetchOffset(00Y20D00D20D").mangledNameHash());
    ASSERT_EQ(0x00000270u, ImmutableString("texelFetchOffset(00L20D00D10D").mangledNameHash());
    ASSERT_EQ(0x000001cfu, ImmutableString("texelFetchOffset(00U20D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000130u, ImmutableString("texelFetchOffset(00a20D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000251u, ImmutableString("textureGradOffset(00I10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000002f9u, ImmutableString("textureGradOffset(00R10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("textureGradOffset(00X10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("textureGradOffset(00J20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x000000a5u, ImmutableString("textureGradOffset(00S20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000246u, ImmutableString("textureGradOffset(00Y20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x000001f1u, ImmutableString("textureGradOffset(00d20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000341u, ImmutableString("textureGradOffset(00L20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000265u, ImmutableString("textureGradOffset(00U20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000199u, ImmutableString("textureGradOffset(00a20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000226u, ImmutableString("textureGradOffset(00f30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000038du,
              ImmutableString("textureProjGradOffset(00I20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000005au,
              ImmutableString("textureProjGradOffset(00R20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000131u,
              ImmutableString("textureProjGradOffset(00X20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000027bu,
              ImmutableString("textureProjGradOffset(00I30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000003b6u,
              ImmutableString("textureProjGradOffset(00R30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000105u,
              ImmutableString("textureProjGradOffset(00X30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000003c0u,
              ImmutableString("textureProjGradOffset(00J30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x0000011du,
              ImmutableString("textureProjGradOffset(00S30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x0000037bu,
              ImmutableString("textureProjGradOffset(00Y30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x0000026cu,
              ImmutableString("textureProjGradOffset(00d30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000106u, ImmutableString("textureOffset(00I10B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000258u, ImmutableString("textureOffset(00R10B10D00B").mangledNameHash());
    ASSERT_EQ(0x000002ceu, ImmutableString("textureOffset(00X10B10D00B").mangledNameHash());
    ASSERT_EQ(0x000000d0u, ImmutableString("textureOffset(00J20B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000281u, ImmutableString("textureOffset(00S20B20D00B").mangledNameHash());
    ASSERT_EQ(0x000000a3u, ImmutableString("textureOffset(00Y20B20D00B").mangledNameHash());
    ASSERT_EQ(0x0000027fu, ImmutableString("textureOffset(00d20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000000cbu, ImmutableString("textureOffset(00L20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000001b9u, ImmutableString("textureOffset(00U20B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000022au, ImmutableString("textureOffset(00a20B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("textureProjOffset(00I20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000284u, ImmutableString("textureProjOffset(00R20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000102u, ImmutableString("textureProjOffset(00X20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000363u, ImmutableString("textureProjOffset(00I30B10D00B").mangledNameHash());
    ASSERT_EQ(0x000003a8u, ImmutableString("textureProjOffset(00R30B10D00B").mangledNameHash());
    ASSERT_EQ(0x000003b8u, ImmutableString("textureProjOffset(00X30B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("textureProjOffset(00J30B20D00B").mangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("textureProjOffset(00S30B20D00B").mangledNameHash());
    ASSERT_EQ(0x000002d5u, ImmutableString("textureProjOffset(00Y30B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000380u, ImmutableString("textureProjOffset(00d30B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("texture(00M10B").mangledNameHash());
    ASSERT_EQ(0x000000b7u, ImmutableString("textureProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x00000326u, ImmutableString("textureProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x00000332u, ImmutableString("textureSize(00M00D").mangledNameHash());
    ASSERT_EQ(0x000000a0u, ImmutableString("texelFetch(00M10D00D").mangledNameHash());
    ASSERT_EQ(0x0000012au, ImmutableString("texture(00N10B").mangledNameHash());
    ASSERT_EQ(0x00000369u, ImmutableString("textureProj(00N20B").mangledNameHash());
    ASSERT_EQ(0x0000026du, ImmutableString("textureProj(00N30B").mangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("rgb_2_yuv(20B00H").mangledNameHash());
    ASSERT_EQ(0x000001b5u, ImmutableString("yuv_2_rgb(20B00H").mangledNameHash());
    ASSERT_EQ(0x00000219u, ImmutableString("textureSize(00N00D").mangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("texelFetch(00N10D00D").mangledNameHash());
    ASSERT_EQ(0x00000253u, ImmutableString("textureGather(00I10B").mangledNameHash());
    ASSERT_EQ(0x0000031eu, ImmutableString("textureGather(00R10B").mangledNameHash());
    ASSERT_EQ(0x0000022bu, ImmutableString("textureGather(00X10B").mangledNameHash());
    ASSERT_EQ(0x00000139u, ImmutableString("textureGather(00I10B00D").mangledNameHash());
    ASSERT_EQ(0x000002dau, ImmutableString("textureGather(00R10B00D").mangledNameHash());
    ASSERT_EQ(0x000001ceu, ImmutableString("textureGather(00X10B00D").mangledNameHash());
    ASSERT_EQ(0x00000215u, ImmutableString("textureGather(00L20B").mangledNameHash());
    ASSERT_EQ(0x000002ddu, ImmutableString("textureGather(00U20B").mangledNameHash());
    ASSERT_EQ(0x0000022eu, ImmutableString("textureGather(00a20B").mangledNameHash());
    ASSERT_EQ(0x0000011cu, ImmutableString("textureGather(00L20B00D").mangledNameHash());
    ASSERT_EQ(0x0000030fu, ImmutableString("textureGather(00U20B00D").mangledNameHash());
    ASSERT_EQ(0x000003bfu, ImmutableString("textureGather(00a20B00D").mangledNameHash());
    ASSERT_EQ(0x000000dau, ImmutableString("textureGather(00K20B").mangledNameHash());
    ASSERT_EQ(0x000003beu, ImmutableString("textureGather(00T20B").mangledNameHash());
    ASSERT_EQ(0x0000027cu, ImmutableString("textureGather(00Z20B").mangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("textureGather(00K20B00D").mangledNameHash());
    ASSERT_EQ(0x00000368u, ImmutableString("textureGather(00T20B00D").mangledNameHash());
    ASSERT_EQ(0x0000031du, ImmutableString("textureGather(00Z20B00D").mangledNameHash());
    ASSERT_EQ(0x00000182u, ImmutableString("textureGather(00d10B").mangledNameHash());
    ASSERT_EQ(0x00000398u, ImmutableString("textureGather(00d10B00B").mangledNameHash());
    ASSERT_EQ(0x00000143u, ImmutableString("textureGather(00f20B").mangledNameHash());
    ASSERT_EQ(0x000001b6u, ImmutableString("textureGather(00f20B00B").mangledNameHash());
    ASSERT_EQ(0x0000035cu, ImmutableString("textureGather(00e20B").mangledNameHash());
    ASSERT_EQ(0x0000015fu, ImmutableString("textureGather(00e20B00B").mangledNameHash());
    ASSERT_EQ(0x00000347u,
              ImmutableString("textureGatherOffsets(00I10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x000003c5u,
              ImmutableString("textureGatherOffsets(00R10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x0000002bu,
              ImmutableString("textureGatherOffsets(00X10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x0000028bu,
              ImmutableString("textureGatherOffsets(00L20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000012u,
              ImmutableString("textureGatherOffsets(00U20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x0000020cu,
              ImmutableString("textureGatherOffsets(00a20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000241u, ImmutableString("textureGatherOffsets(00I10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000001f2u, ImmutableString("textureGatherOffsets(00R10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("textureGatherOffsets(00X10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x0000022cu, ImmutableString("textureGatherOffsets(00L20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000344u, ImmutableString("textureGatherOffsets(00U20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000122u, ImmutableString("textureGatherOffsets(00a20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x0000014fu,
              ImmutableString("textureGatherOffsets(00d10B00B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000288u,
              ImmutableString("textureGatherOffsets(00f20B00B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000001cdu, ImmutableString("textureGatherOffset(00I10B10D00D").mangledNameHash());
    ASSERT_EQ(0x000001f6u, ImmutableString("textureGatherOffset(00R10B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000378u, ImmutableString("textureGatherOffset(00X10B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("textureGatherOffset(00L20B10D00D").mangledNameHash());
    ASSERT_EQ(0x000000e7u, ImmutableString("textureGatherOffset(00U20B10D00D").mangledNameHash());
    ASSERT_EQ(0x000000c9u, ImmutableString("textureGatherOffset(00a20B10D00D").mangledNameHash());
    ASSERT_EQ(0x000000cau, ImmutableString("textureGatherOffset(00I10B10D").mangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("textureGatherOffset(00R10B10D").mangledNameHash());
    ASSERT_EQ(0x00000309u, ImmutableString("textureGatherOffset(00X10B10D").mangledNameHash());
    ASSERT_EQ(0x00000269u, ImmutableString("textureGatherOffset(00L20B10D").mangledNameHash());
    ASSERT_EQ(0x000002d6u, ImmutableString("textureGatherOffset(00U20B10D").mangledNameHash());
    ASSERT_EQ(0x0000024du, ImmutableString("textureGatherOffset(00a20B10D").mangledNameHash());
    ASSERT_EQ(0x00000231u, ImmutableString("textureGatherOffset(00d10B00B10D").mangledNameHash());
    ASSERT_EQ(0x000002acu, ImmutableString("textureGatherOffset(00f20B00B10D").mangledNameHash());
    ASSERT_EQ(0x000000d4u, ImmutableString("atomicCounter(00G").mangledNameHash());
    ASSERT_EQ(0x0000036du, ImmutableString("atomicCounterIncrement(00G").mangledNameHash());
    ASSERT_EQ(0x000000a4u, ImmutableString("atomicCounterDecrement(00G").mangledNameHash());
    ASSERT_EQ(0x0000025au, ImmutableString("atomicAdd(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("atomicAdd(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000015bu, ImmutableString("atomicMin(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000394u, ImmutableString("atomicMin(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000392u, ImmutableString("atomicMax(00E00E").mangledNameHash());
    ASSERT_EQ(0x000000b6u, ImmutableString("atomicMax(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000c2u, ImmutableString("atomicAnd(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("atomicAnd(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000b3u, ImmutableString("atomicOr(00E00E").mangledNameHash());
    ASSERT_EQ(0x000003c6u, ImmutableString("atomicOr(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000a6u, ImmutableString("atomicXor(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("atomicXor(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000afu, ImmutableString("atomicExchange(00E00E").mangledNameHash());
    ASSERT_EQ(0x000001f5u, ImmutableString("atomicExchange(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000033du, ImmutableString("atomicCompSwap(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x000001b4u, ImmutableString("atomicCompSwap(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001adu, ImmutableString("imageSize(00z").mangledNameHash());
    ASSERT_EQ(0x000002a6u, ImmutableString("imageSize(01A").mangledNameHash());
    ASSERT_EQ(0x00000237u, ImmutableString("imageSize(01B").mangledNameHash());
    ASSERT_EQ(0x000002f6u, ImmutableString("imageSize(01C").mangledNameHash());
    ASSERT_EQ(0x000002b2u, ImmutableString("imageSize(01D").mangledNameHash());
    ASSERT_EQ(0x000002a2u, ImmutableString("imageSize(01E").mangledNameHash());
    ASSERT_EQ(0x0000016fu, ImmutableString("imageSize(01F").mangledNameHash());
    ASSERT_EQ(0x000002fau, ImmutableString("imageSize(01G").mangledNameHash());
    ASSERT_EQ(0x000002efu, ImmutableString("imageSize(01H").mangledNameHash());
    ASSERT_EQ(0x000002f0u, ImmutableString("imageSize(01I").mangledNameHash());
    ASSERT_EQ(0x000002edu, ImmutableString("imageSize(01J").mangledNameHash());
    ASSERT_EQ(0x000002eeu, ImmutableString("imageSize(01K").mangledNameHash());
    ASSERT_EQ(0x00000204u, ImmutableString("imageLoad(00z10D").mangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("imageLoad(01A10D").mangledNameHash());
    ASSERT_EQ(0x000001e0u, ImmutableString("imageLoad(01B10D").mangledNameHash());
    ASSERT_EQ(0x000002ecu, ImmutableString("imageLoad(01C20D").mangledNameHash());
    ASSERT_EQ(0x00000371u, ImmutableString("imageLoad(01D20D").mangledNameHash());
    ASSERT_EQ(0x0000030du, ImmutableString("imageLoad(01E20D").mangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("imageLoad(01F20D").mangledNameHash());
    ASSERT_EQ(0x0000020au, ImmutableString("imageLoad(01G20D").mangledNameHash());
    ASSERT_EQ(0x000000d9u, ImmutableString("imageLoad(01H20D").mangledNameHash());
    ASSERT_EQ(0x000000d6u, ImmutableString("imageLoad(01I20D").mangledNameHash());
    ASSERT_EQ(0x0000021du, ImmutableString("imageLoad(01J20D").mangledNameHash());
    ASSERT_EQ(0x000003a7u, ImmutableString("imageLoad(01K20D").mangledNameHash());
    ASSERT_EQ(0x000000fdu, ImmutableString("imageStore(00z10D30B").mangledNameHash());
    ASSERT_EQ(0x0000011eu, ImmutableString("imageStore(01A10D30D").mangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("imageStore(01B10D30E").mangledNameHash());
    ASSERT_EQ(0x000002e8u, ImmutableString("imageStore(01C20D30B").mangledNameHash());
    ASSERT_EQ(0x00000273u, ImmutableString("imageStore(01D20D30D").mangledNameHash());
    ASSERT_EQ(0x00000179u, ImmutableString("imageStore(01E20D30E").mangledNameHash());
    ASSERT_EQ(0x00000124u, ImmutableString("imageStore(01F20D30B").mangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("imageStore(01G20D30D").mangledNameHash());
    ASSERT_EQ(0x000002dbu, ImmutableString("imageStore(01H20D30E").mangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("imageStore(01I20D30B").mangledNameHash());
    ASSERT_EQ(0x000000d3u, ImmutableString("imageStore(01J20D30D").mangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("imageStore(01K20D30E").mangledNameHash());
    ASSERT_EQ(0x000002b1u, ImmutableString("memoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("memoryBarrierAtomicCounter(").mangledNameHash());
    ASSERT_EQ(0x000001abu, ImmutableString("memoryBarrierBuffer(").mangledNameHash());
    ASSERT_EQ(0x0000037du, ImmutableString("memoryBarrierImage(").mangledNameHash());
    ASSERT_EQ(0x0000012cu, ImmutableString("barrier(").mangledNameHash());
    ASSERT_EQ(0x00000201u, ImmutableString("memoryBarrierShared(").mangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("groupMemoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x0000037fu, ImmutableString("EmitVertex(").mangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("EndPrimitive(").mangledNameHash());
    ASSERT_EQ(0x0000018du, ImmutableString("textureVideoWEBGL(00y10B").mangledNameHash());
    ASSERT_EQ(0x00000145u, ImmutableString("texture(00y10B").mangledNameHash());
    ASSERT_EQ(0x00000160u, ImmutableString("gl_DepthRangeParameters").mangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("gl_DepthRange").mangledNameHash());
    ASSERT_EQ(0x0000032bu, ImmutableString("gl_MaxVertexAttribs").mangledNameHash());
    ASSERT_EQ(0x00000366u, ImmutableString("gl_MaxVertexUniformVectors").mangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("gl_MaxVertexTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000015cu, ImmutableString("gl_MaxCombinedTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000033au, ImmutableString("gl_MaxTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000305u, ImmutableString("gl_MaxFragmentUniformVectors").mangledNameHash());
    ASSERT_EQ(0x00000362u, ImmutableString("gl_MaxVaryingVectors").mangledNameHash());
    ASSERT_EQ(0x000000e6u, ImmutableString("gl_MaxDrawBuffers").mangledNameHash());
    ASSERT_EQ(0x0000028au, ImmutableString("gl_MaxDualSourceDrawBuffersEXT").mangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("gl_MaxVertexOutputVectors").mangledNameHash());
    ASSERT_EQ(0x00000387u, ImmutableString("gl_MaxFragmentInputVectors").mangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("gl_MinProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x0000026eu, ImmutableString("gl_MaxProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("gl_MaxImageUnits").mangledNameHash());
    ASSERT_EQ(0x000001e7u, ImmutableString("gl_MaxVertexImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000000acu, ImmutableString("gl_MaxFragmentImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("gl_MaxComputeImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000001b3u, ImmutableString("gl_MaxCombinedImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000000b2u,
              ImmutableString("gl_MaxCombinedShaderOutputResources").mangledNameHash());
    ASSERT_EQ(0x00000302u, ImmutableString("gl_MaxComputeWorkGroupCount").mangledNameHash());
    ASSERT_EQ(0x00000156u, ImmutableString("gl_MaxComputeWorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x000002d9u, ImmutableString("gl_MaxComputeUniformComponents").mangledNameHash());
    ASSERT_EQ(0x00000115u, ImmutableString("gl_MaxComputeTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000039au, ImmutableString("gl_MaxComputeAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x000000c5u, ImmutableString("gl_MaxComputeAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000039cu, ImmutableString("gl_MaxVertexAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x0000029eu, ImmutableString("gl_MaxFragmentAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x0000011bu, ImmutableString("gl_MaxCombinedAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("gl_MaxAtomicCounterBindings").mangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("gl_MaxVertexAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x000001eau, ImmutableString("gl_MaxFragmentAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000242u, ImmutableString("gl_MaxCombinedAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x000002aau, ImmutableString("gl_MaxAtomicCounterBufferSize").mangledNameHash());
    ASSERT_EQ(0x0000025bu, ImmutableString("gl_MaxGeometryInputComponents").mangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("gl_MaxGeometryOutputComponents").mangledNameHash());
    ASSERT_EQ(0x00000277u, ImmutableString("gl_MaxGeometryImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("gl_MaxGeometryTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000011fu, ImmutableString("gl_MaxGeometryOutputVertices").mangledNameHash());
    ASSERT_EQ(0x000002beu,
              ImmutableString("gl_MaxGeometryTotalOutputComponents").mangledNameHash());
    ASSERT_EQ(0x0000012du, ImmutableString("gl_MaxGeometryUniformComponents").mangledNameHash());
    ASSERT_EQ(0x000001f7u, ImmutableString("gl_MaxGeometryAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000104u, ImmutableString("gl_MaxGeometryAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x000000a8u, ImmutableString("gl_FragCoord").mangledNameHash());
    ASSERT_EQ(0x000002ffu, ImmutableString("gl_FrontFacing").mangledNameHash());
    ASSERT_EQ(0x00000121u, ImmutableString("gl_PointCoord").mangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("gl_FragColor").mangledNameHash());
    ASSERT_EQ(0x00000312u, ImmutableString("gl_FragData").mangledNameHash());
    ASSERT_EQ(0x00000186u, ImmutableString("gl_FragDepth").mangledNameHash());
    ASSERT_EQ(0x00000214u, ImmutableString("gl_HelperInvocation").mangledNameHash());
    ASSERT_EQ(0x00000300u, ImmutableString("gl_SecondaryFragColorEXT").mangledNameHash());
    ASSERT_EQ(0x000001c5u, ImmutableString("gl_SecondaryFragDataEXT").mangledNameHash());
    ASSERT_EQ(0x00000290u, ImmutableString("gl_FragDepthEXT").mangledNameHash());
    ASSERT_EQ(0x00000159u, ImmutableString("gl_LastFragData").mangledNameHash());
    ASSERT_EQ(0x00000173u, ImmutableString("gl_LastFragColor").mangledNameHash());
    ASSERT_EQ(0x0000031cu, ImmutableString("gl_LastFragColorARM").mangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("gl_PrimitiveID").mangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("gl_Layer").mangledNameHash());
    ASSERT_EQ(0x0000033bu, ImmutableString("gl_Position").mangledNameHash());
    ASSERT_EQ(0x00000393u, ImmutableString("gl_PointSize").mangledNameHash());
    ASSERT_EQ(0x000001e5u, ImmutableString("gl_InstanceID").mangledNameHash());
    ASSERT_EQ(0x00000324u, ImmutableString("gl_VertexID").mangledNameHash());
    ASSERT_EQ(0x000003c4u, ImmutableString("gl_DrawID").mangledNameHash());
    ASSERT_EQ(0x00000157u, ImmutableString("gl_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x0000032cu, ImmutableString("gl_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("angle_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x00000337u, ImmutableString("angle_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x000002d3u, ImmutableString("gl_NumWorkGroups").mangledNameHash());
    ASSERT_EQ(0x0000021eu, ImmutableString("gl_WorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x000001ebu, ImmutableString("gl_WorkGroupID").mangledNameHash());
    ASSERT_EQ(0x0000017fu, ImmutableString("gl_LocalInvocationID").mangledNameHash());
    ASSERT_EQ(0x000001ffu, ImmutableString("gl_GlobalInvocationID").mangledNameHash());
    ASSERT_EQ(0x000001cbu, ImmutableString("gl_LocalInvocationIndex").mangledNameHash());
    ASSERT_EQ(0x000000c6u, ImmutableString("gl_PrimitiveIDIn").mangledNameHash());
    ASSERT_EQ(0x00000150u, ImmutableString("gl_InvocationID").mangledNameHash());
    ASSERT_EQ(0x00000212u, ImmutableString("gl_PerVertex").mangledNameHash());
    ASSERT_EQ(0x000001d9u, ImmutableString("gl_in").mangledNameHash());
    ASSERT_EQ(0x00000216u, ImmutableString("gl_ViewID_OVR").mangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("radians").unmangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("degrees").unmangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("sin").unmangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("cos").unmangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("tan").unmangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("asin").unmangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("acos").unmangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("atan").unmangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("sinh").unmangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("cosh").unmangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("tanh").unmangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("asinh").unmangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("acosh").unmangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("atanh").unmangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("pow").unmangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("exp").unmangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("log").unmangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("exp2").unmangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("log2").unmangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("sqrt").unmangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("inversesqrt").unmangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("abs").unmangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("sign").unmangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("floor").unmangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("trunc").unmangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("round").unmangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("roundEven").unmangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("ceil").unmangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("fract").unmangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("mod").unmangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("min").unmangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("max").unmangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("clamp").unmangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("mix").unmangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("step").unmangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("smoothstep").unmangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("modf").unmangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("isnan").unmangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("isinf").unmangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("floatBitsToInt").unmangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("floatBitsToUint").unmangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("intBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("uintBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("fma").unmangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("frexp").unmangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("ldexp").unmangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("packSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("packHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("unpackSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("unpackHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("packUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("unpackUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("packUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("packSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("unpackUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("unpackSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("length").unmangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("distance").unmangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("dot").unmangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("cross").unmangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("normalize").unmangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("faceforward").unmangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("reflect").unmangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("refract").unmangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("matrixCompMult").unmangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("outerProduct").unmangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("transpose").unmangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("determinant").unmangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("inverse").unmangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("lessThan").unmangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("lessThanEqual").unmangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("greaterThan").unmangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("greaterThanEqual").unmangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("equal").unmangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("notEqual").unmangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("any").unmangledNameHash());
    ASSERT_EQ(0x00000000u, ImmutableString("all").unmangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("not").unmangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("bitfieldExtract").unmangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("bitfieldInsert").unmangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("bitfieldReverse").unmangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("bitCount").unmangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("findLSB").unmangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("findMSB").unmangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("uaddCarry").unmangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("usubBorrow").unmangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("umulExtended").unmangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("imulExtended").unmangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("texture2D").unmangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("texture2DProj").unmangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("textureCube").unmangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("texture2DRect").unmangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("texture2DRectProj").unmangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("texture").unmangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("textureProj").unmangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("texture2DGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("texture2DProjGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("textureCubeGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("dFdx").unmangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("dFdy").unmangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("fwidth").unmangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("texture2DLodEXT").unmangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("texture2DProjLodEXT").unmangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("textureCubeLodEXT").unmangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("texture3D").unmangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("texture3DProj").unmangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("texture3DLod").unmangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("texture3DProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("texture2DLod").unmangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("texture2DProjLod").unmangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("textureCubeLod").unmangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("textureLod").unmangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("textureSize").unmangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("textureProjLod").unmangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("texelFetch").unmangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("textureGrad").unmangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("textureProjGrad").unmangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("textureOffset").unmangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("textureProjOffset").unmangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("textureLodOffset").unmangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("textureProjLodOffset").unmangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("texelFetchOffset").unmangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("textureGradOffset").unmangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("textureProjGradOffset").unmangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("rgb_2_yuv").unmangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("yuv_2_rgb").unmangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("textureGather").unmangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("textureGatherOffsets").unmangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("textureGatherOffset").unmangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("atomicCounter").unmangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("atomicCounterIncrement").unmangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("atomicCounterDecrement").unmangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("atomicAdd").unmangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("atomicMin").unmangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("atomicMax").unmangledNameHash());
    ASSERT_EQ(0x00000013u, ImmutableString("atomicAnd").unmangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("atomicOr").unmangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("atomicXor").unmangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("atomicExchange").unmangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("atomicCompSwap").unmangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("imageSize").unmangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("imageLoad").unmangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("imageStore").unmangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("memoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("memoryBarrierAtomicCounter").unmangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("memoryBarrierBuffer").unmangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("memoryBarrierImage").unmangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("barrier").unmangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("memoryBarrierShared").unmangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("groupMemoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("EmitVertex").unmangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("EndPrimitive").unmangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("textureVideoWEBGL").unmangledNameHash());
}

}  // namespace sh
