/*
 *  This file is part of X-File Manager XFM
 *  ----------------------------------------------------------------------
  xfmtype.c

  (c) Juan D. Martin 1995

  modified 2005,2006 by Bernhard R. Link (see Changelog)

  seperate program to determine the xfm magic type of a file
 *  ----------------------------------------------------------------------
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <xfmconfig.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "magic.h"

static void usage(const char *prog)
{
    fprintf(stderr, "Usage: %s [-m magic_file ] [-f] file ...\n", prog);
}

int main(int argc, char **argv)
{
    int i;
    const char *message;
    struct magic_modifiers modifiers;
    struct stat s;
    magic_parse_init(NULL);

    for(i = 1; i < argc; i++)
    {
	if(argv[i][0] == '-')
	{
	    switch (argv[i][1])
	    {
	    case 'm':
		i++;
		if(i < argc)
		    magic_parse_singlefile(argv[i],NULL,65536);
		else
		{
		    fprintf(stderr, "Missing argument: magic file\n");
		    usage(argv[0]);
		    exit(1);
		}
		break;
	    case 'f':
		i++;
		if(i < argc)
		{
		    magic_get_type(argv[i], &message, NULL, &modifiers,&s);
		    printf("%s: %s%s%s%s\n", argv[i], 
				    modifiers.symlink?"symlink to ":"",
				    modifiers.gzipped?"gzipped ":"",
				    modifiers.bzipped?"bzipped ":"",
				    message);
		}
		else
		{
		    fprintf(stderr, "Missing argument: file\n");
		    usage(argv[0]);
		    exit(1);
		}
		break;
	    default:
		fprintf(stderr, "Bad option %s\n", argv[i]);
		usage(argv[0]);
		exit(1);
	    }
	    continue;
	}
	magic_get_type(argv[i], &message, NULL, &modifiers, &s);
	printf("%s: %s%s%s%s\n", argv[i], 
			modifiers.symlink?"symlink to ":"",
			modifiers.gzipped?"gzipped ":"",
			modifiers.bzipped?"bzipped ":"",
			message);
    }
    return 0;
}
