#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from xpdeint.Geometry.BesselDimensionRepresentation import BesselDimensionRepresentation
from xpdeint.CallOnceGuards import callOnceGuard

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.4.4'
__CHEETAH_versionTuple__ = (2, 4, 4, 'development', 0)
__CHEETAH_genTime__ = 1389652443.026056
__CHEETAH_genTimestamp__ = 'Tue Jan 14 09:34:03 2014'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.0/admin/staging/xmds-2.2.0/xpdeint/Geometry/SphericalBesselDimensionRepresentation.tmpl'
__CHEETAH_srcLastModified__ = 'Tue Nov 26 20:52:00 2013'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class SphericalBesselDimensionRepresentation(BesselDimensionRepresentation):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(SphericalBesselDimensionRepresentation, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    @callOnceGuard
    def includes(self, **KWS):



        ## CHEETAH: generated from @def includes at line 31, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write(u'''#include <gsl/gsl_sf_bessel.h>
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def besselJFunctionCall(self, order, argument, **KWS):



        ## CHEETAH: generated from @def besselJFunctionCall($order, $argument) at line 37, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''sqrt(1.0/M_PI_2) * ''')
        if VFFSL(SL,"order",True) in [0, 1, 2]: # generated from line 39, col 3
            write(u'''gsl_sf_bessel_j''')
            _v = VFFSL(SL,"order",True) # u'${order}' on line 40, col 16
            if _v is not None: write(_filter(_v, rawExpr=u'${order}')) # from line 40, col 16.
            write(u'''(''')
            _v = VFFSL(SL,"argument",True) # u'$argument' on line 40, col 25
            if _v is not None: write(_filter(_v, rawExpr=u'$argument')) # from line 40, col 25.
            write(u''')''')
        else: # generated from line 41, col 3
            write(u'''gsl_sf_bessel_jl(''')
            _v = VFFSL(SL,"order",True) # u'$order' on line 42, col 18
            if _v is not None: write(_filter(_v, rawExpr=u'$order')) # from line 42, col 18.
            write(u''', ''')
            _v = VFFSL(SL,"argument",True) # u'$argument' on line 42, col 26
            if _v is not None: write(_filter(_v, rawExpr=u'$argument')) # from line 42, col 26.
            write(u''')''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def stepWeightAtIndex(self, index, **KWS):



        ## CHEETAH: generated from @def stepWeightAtIndex($index) at line 46, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write(u'''2.0 / (besselFactor * besselFactor * _besseljS_''')
        _v = VFFSL(SL,"parent.name",True) # u'${parent.name}' on line 48, col 48
        if _v is not None: write(_filter(_v, rawExpr=u'${parent.name}')) # from line 48, col 48.
        write(u''' * _besseljS_''')
        _v = VFFSL(SL,"parent.name",True) # u'${parent.name}' on line 48, col 75
        if _v is not None: write(_filter(_v, rawExpr=u'${parent.name}')) # from line 48, col 75.
        write(u''' * _besseljS_''')
        _v = VFFSL(SL,"parent.name",True) # u'${parent.name}' on line 48, col 102
        if _v is not None: write(_filter(_v, rawExpr=u'${parent.name}')) # from line 48, col 102.
        write(u''') * ''')
        _v = VFFSL(SL,"name",True) # u'${name}' on line 48, col 120
        if _v is not None: write(_filter(_v, rawExpr=u'${name}')) # from line 48, col 120.
        write(u'''_max * ''')
        _v = VFFSL(SL,"name",True) # u'${name}' on line 48, col 134
        if _v is not None: write(_filter(_v, rawExpr=u'${name}')) # from line 48, col 134.
        write(u'''_max * ''')
        _v = VFFSL(SL,"name",True) # u'${name}' on line 48, col 148
        if _v is not None: write(_filter(_v, rawExpr=u'${name}')) # from line 48, col 148.
        write(u'''_max''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        # SphericalBesselDimensionRepresentation.tmpl
        # 
        # Created by Graham Dennis on 2009-08-11.
        # 
        # Copyright (c) 2009-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write(u'''





''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    uslib = ['gsl']

    orderOffset = 0.5

    _mainCheetahMethod_for_SphericalBesselDimensionRepresentation= 'writeBody'

## END CLASS DEFINITION

if not hasattr(SphericalBesselDimensionRepresentation, '_initCheetahAttributes'):
    templateAPIClass = getattr(SphericalBesselDimensionRepresentation, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(SphericalBesselDimensionRepresentation)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=SphericalBesselDimensionRepresentation()).run()


