#import <Foundation/Foundation.h>
#import "RarTestCase.h"
#import "RarArchive.h"
#import "FileInfo.h"
#import "Preferences.h"

@implementation RarTestCase : ArchiveTestCase

- (void)setUp;
{
	NSDictionary *defaults = [NSDictionary dictionaryWithObjectsAndKeys:
		@"/opt/bin/rar", PREF_KEY_RAR, nil];
	[Preferences usePreferences:defaults];
}

- (Archive *)sampleArchive;
{
	NSString *path;
	
    path = [NSBundle pathForResource:@"sample" ofType:@"rar" inDirectory:@"TestResources"];
    [self assertNotNil:path];
    path = [path stringByStandardizingPath];
    return [RarArchive newWithPath:path];
}

- (void)testSortByRatio
{
	Archive *archive;
	FileInfo *info;
	
	archive = [self sampleArchive];
	[archive sortByRatio];
	info = [archive elementAtIndex:0];
	
	[self assert:[info ratio] equals:@"23%"];
	[self assert:[info filename] equals:@"junk.rc"];
	
	// sort descending
	[archive sortByRatio];
	info = [archive elementAtIndex:0];
	[self assert:[info ratio] equals:@"60%"];
	[self assert:[info filename] equals:@"vacation.rc"];
}

@end
