// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using NuGet.Packaging.Core;
using NuGet.VisualStudio.Internal.Contracts;

namespace NuGet.PackageManagement.VisualStudio
{
    public interface IPackageVulnerabilityService
    {
        Task<List<PackageVulnerabilityMetadataContextInfo>> GetVulnerabilityInfoAsync(PackageIdentity packageId, CancellationToken cancellationToken);
    }
}
