; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=thumb-eabi -mcpu=arm1156t2-s -mattr=+thumb2 | FileCheck %s
; RUN: llc < %s -mtriple=thumb-eabi | FileCheck %s -check-prefix=THUMB1

define i32 @f1(i32 %a) {
; CHECK-LABEL: f1:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    ror.w r0, r0, #22
; CHECK-NEXT:    bx lr
;
; THUMB1-LABEL: f1:
; THUMB1:       @ %bb.0:
; THUMB1-NEXT:    movs r1, #22
; THUMB1-NEXT:    rors r0, r1
; THUMB1-NEXT:    bx lr
    %l8 = shl i32 %a, 10
    %r8 = lshr i32 %a, 22
    %tmp = or i32 %l8, %r8
    ret i32 %tmp
}

define i32 @f2(i32 %v, i32 %nbits) {
; CHECK-LABEL: f2:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    rors r0, r1
; CHECK-NEXT:    bx lr
;
; THUMB1-LABEL: f2:
; THUMB1:       @ %bb.0: @ %entry
; THUMB1-NEXT:    rors r0, r1
; THUMB1-NEXT:    bx lr
entry:
  %and = and i32 %nbits, 31
  %shr = lshr i32 %v, %and
  %sub = sub i32 32, %and
  %shl = shl i32 %v, %sub
  %or = or i32 %shl, %shr
  ret i32 %or
}
