; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=memcpyopt < %s -verify-memoryssa | FileCheck %s

; PR40118: BasicAA didn't realize that stackrestore ends the lifetime of
; unescaped dynamic allocas, such as those that might come from inalloca.

source_filename = "t.cpp"
target datalayout = "e-m:x-p:32:32-i64:64-f80:32-n8:16:32-a:0:32-S32"
target triple = "i686-unknown-windows-msvc19.14.26433"

@str = internal constant [9 x i8] c"abcdxxxxx"


; Test that we can propagate memcpy through an unescaped dynamic alloca across
; a call to @external.

define i32 @test_norestore(i32 %n) {
; CHECK-LABEL: @test_norestore(
; CHECK-NEXT:    [[TMPMEM:%.*]] = alloca [10 x i8], align 4
; CHECK-NEXT:    [[P:%.*]] = alloca i8, i32 [[N:%.*]], align 4
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[P]], ptr align 1 @str, i32 9, i1 false)
; CHECK-NEXT:    [[P10:%.*]] = getelementptr inbounds i8, ptr [[P]], i32 9
; CHECK-NEXT:    store i8 0, ptr [[P10]], align 1
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[TMPMEM]], ptr [[P]], i32 10, i1 false)
; CHECK-NEXT:    call void @external()
; CHECK-NEXT:    [[HEAP:%.*]] = call ptr @malloc(i32 9)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[HEAP]], ptr align 1 @str, i32 9, i1 false)
; CHECK-NEXT:    call void @useit(ptr [[HEAP]])
; CHECK-NEXT:    ret i32 0
;
  %tmpmem = alloca [10 x i8], align 4

  ; Make a dynamic alloca, initialize it.
  %p = alloca i8, i32 %n, align 4
  call void @llvm.memcpy.p0.p0.i32(ptr %p, ptr align 1 @str, i32 9, i1 false)

  ; This extra byte exists to prevent memcpyopt from propagating @str.
  %p10 = getelementptr inbounds i8, ptr %p, i32 9
  store i8 0, ptr %p10

  call void @llvm.memcpy.p0.p0.i32(ptr %tmpmem, ptr %p, i32 10, i1 false)
  call void @external()
  %heap = call ptr @malloc(i32 9)
  call void @llvm.memcpy.p0.p0.i32(ptr %heap, ptr %tmpmem, i32 9, i1 false)
  call void @useit(ptr %heap)
  ret i32 0
}

; Do not propagate memcpy from %p across the stackrestore.

define i32 @test_stackrestore() {
; CHECK-LABEL: @test_stackrestore(
; CHECK-NEXT:    [[TMPMEM:%.*]] = alloca [10 x i8], align 4
; CHECK-NEXT:    [[INALLOCA_SAVE:%.*]] = tail call ptr @llvm.stacksave()
; CHECK-NEXT:    [[ARGMEM:%.*]] = alloca inalloca [10 x i8], align 4
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[ARGMEM]], ptr align 1 @str, i32 9, i1 false)
; CHECK-NEXT:    [[P10:%.*]] = getelementptr inbounds [10 x i8], ptr [[ARGMEM]], i32 0, i32 9
; CHECK-NEXT:    store i8 0, ptr [[P10]], align 1
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[TMPMEM]], ptr [[ARGMEM]], i32 10, i1 false)
; CHECK-NEXT:    call void @llvm.stackrestore(ptr [[INALLOCA_SAVE]])
; CHECK-NEXT:    [[HEAP:%.*]] = call ptr @malloc(i32 9)
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[HEAP]], ptr [[TMPMEM]], i32 9, i1 false)
; CHECK-NEXT:    call void @useit(ptr [[HEAP]])
; CHECK-NEXT:    ret i32 0
;
  %tmpmem = alloca [10 x i8], align 4
  %inalloca.save = tail call ptr @llvm.stacksave()
  %argmem = alloca inalloca [10 x i8], align 4
  call void @llvm.memcpy.p0.p0.i32(ptr %argmem, ptr align 1 @str, i32 9, i1 false)

  ; This extra byte exists to prevent memcpyopt from propagating @str.
  %p10 = getelementptr inbounds [10 x i8], ptr %argmem, i32 0, i32 9
  store i8 0, ptr %p10

  call void @llvm.memcpy.p0.p0.i32(ptr %tmpmem, ptr %argmem, i32 10, i1 false)
  call void @llvm.stackrestore(ptr %inalloca.save)
  %heap = call ptr @malloc(i32 9)
  call void @llvm.memcpy.p0.p0.i32(ptr %heap, ptr %tmpmem, i32 9, i1 false)
  call void @useit(ptr %heap)
  ret i32 0
}

declare void @llvm.memcpy.p0.p0.i32(ptr nocapture writeonly, ptr nocapture readonly, i32, i1)
declare ptr @llvm.stacksave()
declare void @llvm.stackrestore(ptr)
declare ptr @malloc(i32)
declare void @useit(ptr)
declare void @external()
