/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import java.util.Iterator;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ComplementClass;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.impl.OntClassImpl;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public class ComplementClassImpl
extends OntClassImpl
implements ComplementClass {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new ComplementClassImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to ComplementClass");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            Property comp = profile == null ? null : profile.COMPLEMENT_OF();
            return profile != null && profile.isSupported(node, eg, OntClass.class) && comp != null && eg.asGraph().contains(node, comp.asNode(), Node.ANY);
        }
    };

    public ComplementClassImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setOperands(RDFList operands) {
        throw new UnsupportedOperationException("ComplementClass takes a single operand, not a list.");
    }

    @Override
    public void setOperand(Resource cls) {
        this.setPropertyValue(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", cls);
    }

    @Override
    public void addOperand(Resource cls) {
        throw new UnsupportedOperationException("ComplementClass is only defined for  a single operand.");
    }

    @Override
    public void addOperands(Iterator<? extends Resource> classes) {
        throw new UnsupportedOperationException("ComplementClass is only defined for  a single operand.");
    }

    @Override
    public RDFList getOperands() {
        throw new UnsupportedOperationException("ComplementClass takes a single operand, not a list.");
    }

    @Override
    public ExtendedIterator<? extends OntClass> listOperands() {
        return this.listAs(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", OntClass.class);
    }

    @Override
    public boolean hasOperand(Resource cls) {
        return this.hasPropertyValue(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", cls);
    }

    @Override
    public OntClass getOperand() {
        return this.objectAs(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", OntClass.class);
    }

    @Override
    public void removeOperand(Resource res) {
        this.removePropertyValue(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", res);
    }

    @Override
    public Property operator() {
        return this.getProfile().COMPLEMENT_OF();
    }
}

