/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util.iterator;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.util.iterator.ClosableIterator;

public interface ExtendedIterator<T>
extends ClosableIterator<T> {
    public T removeNext();

    public <X extends T> ExtendedIterator<T> andThen(Iterator<X> var1);

    public ExtendedIterator<T> filterKeep(Predicate<T> var1);

    public ExtendedIterator<T> filterDrop(Predicate<T> var1);

    public <U> ExtendedIterator<U> mapWith(Function<T, U> var1);

    public List<T> toList();

    public Set<T> toSet();

    default public Optional<T> nextOptional() {
        if (!this.hasNext()) {
            return Optional.empty();
        }
        Object obj = this.next();
        Objects.requireNonNull(obj, "ExtendedIterator.next is null");
        return Optional.of(obj);
    }
}

