#include "apt-cache-generator.h"
#include <stdio.h>

gint
main (gint argc, gchar **argv)
{
  AptCacheGenerator *generator;
  gchar *available;
  
  generator = apt_cache_generator_new ();

  apt_cache_generator_add_application (generator, "Foo");
  apt_cache_generator_add_webapp (generator, "unity-webapps-angrybirds",
				  "AngryBirds", "test.ts",
				  "http://chrome.angrybirds.com/*",
				  NULL);
  apt_cache_generator_add_application (generator, "Bar");
  
  available = apt_cache_generator_get_available (generator);
  printf("%s", available);
  
  g_free (available);
  apt_cache_generator_free (generator);
}
