.TH "ZIP_OPEN" "3" "November 9, 2014" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_open\fP,
\fBzip_open_from_source\fP
\- open zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
zip_t *
zip_open const char *path int flags int *errorp
zip_t *
zip_open_from_source zip_source_t *zs int flags zip_error_t *ze
.SH "DESCRIPTION"
The
zip_open
function opens the zip archive specified by
\fIpath\fP
and returns a pointer to a
struct zip,
used to manipulate the archive.
The
flags
are specified by
\fIor\fP'ing
the following values, or 0 for none of them.
.TP ZIP_CHECKCONS
\fRZIP_CHECKCONS\fP
Perform additional stricter consistency checks on the archive, and
error if they fail.
.TP ZIP_CHECKCONS
\fRZIP_CREATE\fP
Create the archive if it does not exist.
.TP ZIP_CHECKCONS
\fRZIP_EXCL\fP
Error if archive already exists.
.TP ZIP_CHECKCONS
\fRZIP_TRUNCATE\fP
If archive exists, ignore its current contents.
In other words, handle it the same way as an empty archive.
.TP ZIP_CHECKCONS
\fRZIP_RDONLY\fP
Open archive in read-only mode.
.PP
If an error occurs and
\fIerrorp\fP
is
non-\fRNULL\fP,
it will be set to the corresponding error code.
.PP
The
zip_open_from_source
function opens a zip archive encapsulated by the zip_source
zs
using the provided
flags.
In case of error, the zip_error
ze
is filled in.
.SH "RETURN VALUES"
Upon successful completion
zip_open
and
zip_open_from_source
return a
struct zip
pointer.
Otherwise,
\fRNULL\fP
is returned and
zip_open
sets
\fI*errorp\fP
to indicate the error, while
zip_open_from source
sets
\fIze\fP
to indicate the error.
.SH "ERRORS"
The archive specified by
\fIpath\fP
is opened unless:
.TP 17n
[\fRZIP_ER_EXISTS\fP]
The file specified by
\fIpath\fP
exists and
\fRZIP_EXCL\fP
is set.
.TP 17n
[\fRZIP_ER_INCONS\fP]
Inconsistencies were found in the file specified by
\fIpath\fP.
This error is often caused by specifying
\fRZIP_CHECKCONS\fP
but can also happen without it.
.TP 17n
[\fRZIP_ER_INVAL\fP]
The
\fIpath\fP
argument is
\fRNULL\fP.
.TP 17n
[\fRZIP_ER_MEMORY\fP]
Required memory could not be allocated.
.TP 17n
[\fRZIP_ER_NOENT\fP]
The file specified by
\fIpath\fP
does not exist and
\fRZIP_CREATE\fP
is not set.
.TP 17n
[\fRZIP_ER_NOZIP\fP]
The file specified by
\fIpath\fP
is not a zip archive.
.TP 17n
[\fRZIP_ER_OPEN\fP]
The file specified by
\fIpath\fP
could not be opened.
.TP 17n
[\fRZIP_ER_READ\fP]
A read error occurred; see
errno
for details.
.TP 17n
[\fRZIP_ER_SEEK\fP]
The file specified by
\fIpath\fP
does not allow seeks.
.SH "SEE ALSO"
libzip(3),
zip_close(3),
zip_error_to_str(3),
zip_fdopen(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
