/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.Platform;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

@GwtCompatible
public class CollectionToArrayTester<E>
extends AbstractCollectionTester<E> {
    public void testToArray_noArgs() {
        Object[] array = this.collection.toArray();
        this.expectArrayContentsAnyOrder(this.createSamplesArray(), array);
    }

    public void testToArray_isPlainObjectArray() {
        Object[] array = this.collection.toArray();
        CollectionToArrayTester.assertEquals(Object[].class, array.getClass());
    }

    public void testToArray_emptyArray() {
        E[] empty = ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).createArray(0);
        Object[] array = this.collection.toArray(empty);
        CollectionToArrayTester.assertEquals((String)"toArray(emptyT[]) should return an array of type T", empty.getClass(), array.getClass());
        CollectionToArrayTester.assertEquals((String)"toArray(emptyT[]).length:", (int)this.getNumElements(), (int)array.length);
        this.expectArrayContentsAnyOrder(this.createSamplesArray(), array);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testToArray_emptyArray_ordered() {
        E[] empty = ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).createArray(0);
        Object[] array = this.collection.toArray(empty);
        CollectionToArrayTester.assertEquals((String)"toArray(emptyT[]) should return an array of type T", empty.getClass(), array.getClass());
        CollectionToArrayTester.assertEquals((String)"toArray(emptyT[]).length:", (int)this.getNumElements(), (int)array.length);
        this.expectArrayContentsInOrder(this.getOrderedElements(), array);
    }

    public void testToArray_emptyArrayOfObject() {
        Object[] in = new Object[]{};
        Object[] array = this.collection.toArray(in);
        CollectionToArrayTester.assertEquals((String)"toArray(emptyObject[]) should return an array of type Object", Object[].class, array.getClass());
        CollectionToArrayTester.assertEquals((String)"toArray(emptyObject[]).length", (int)this.getNumElements(), (int)array.length);
        this.expectArrayContentsAnyOrder(this.createSamplesArray(), array);
    }

    public void testToArray_rightSizedArray() {
        Object[] array = ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).createArray(this.getNumElements());
        CollectionToArrayTester.assertSame((String)"toArray(sameSizeE[]) should return the given array", array, this.collection.toArray(array));
        this.expectArrayContentsAnyOrder(this.createSamplesArray(), array);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testToArray_rightSizedArray_ordered() {
        Object[] array = ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).createArray(this.getNumElements());
        CollectionToArrayTester.assertSame((String)"toArray(sameSizeE[]) should return the given array", array, this.collection.toArray(array));
        this.expectArrayContentsInOrder(this.getOrderedElements(), array);
    }

    public void testToArray_rightSizedArrayOfObject() {
        Object[] array = new Object[this.getNumElements()];
        CollectionToArrayTester.assertSame((String)"toArray(sameSizeObject[]) should return the given array", (Object)array, (Object)this.collection.toArray(array));
        this.expectArrayContentsAnyOrder(this.createSamplesArray(), array);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testToArray_rightSizedArrayOfObject_ordered() {
        Object[] array = new Object[this.getNumElements()];
        CollectionToArrayTester.assertSame((String)"toArray(sameSizeObject[]) should return the given array", (Object)array, (Object)this.collection.toArray(array));
        this.expectArrayContentsInOrder(this.getOrderedElements(), array);
    }

    public void testToArray_oversizedArray() {
        E[] array = ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).createArray(this.getNumElements() + 2);
        array[this.getNumElements()] = this.samples.e3;
        array[this.getNumElements() + 1] = this.samples.e3;
        CollectionToArrayTester.assertSame((String)"toArray(overSizedE[]) should return the given array", array, this.collection.toArray(array));
        List subArray = Arrays.asList(array).subList(0, this.getNumElements());
        E[] expectedSubArray = this.createSamplesArray();
        for (int i = 0; i < this.getNumElements(); ++i) {
            CollectionToArrayTester.assertTrue((String)("toArray(overSizedE[]) should contain element " + expectedSubArray[i]), (boolean)subArray.contains(expectedSubArray[i]));
        }
        CollectionToArrayTester.assertNull((String)"The array element immediately following the end of the collection should be nulled", array[this.getNumElements()]);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testToArray_oversizedArray_ordered() {
        E[] array = ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).createArray(this.getNumElements() + 2);
        array[this.getNumElements()] = this.samples.e3;
        array[this.getNumElements() + 1] = this.samples.e3;
        CollectionToArrayTester.assertSame((String)"toArray(overSizedE[]) should return the given array", array, this.collection.toArray(array));
        List expected = this.getOrderedElements();
        for (int i = 0; i < this.getNumElements(); ++i) {
            CollectionToArrayTester.assertEquals(expected.get(i), array[i]);
        }
        CollectionToArrayTester.assertNull((String)"The array element immediately following the end of the collection should be nulled", array[this.getNumElements()]);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testToArray_emptyArrayOfWrongTypeForNonEmptyCollection() {
        try {
            WrongType[] array = new WrongType[]{};
            this.collection.toArray(array);
            CollectionToArrayTester.fail((String)"toArray(notAssignableTo[]) should throw");
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testToArray_emptyArrayOfWrongTypeForEmptyCollection() {
        WrongType[] array = new WrongType[]{};
        CollectionToArrayTester.assertSame((String)"toArray(sameSizeNotAssignableTo[]) should return the given array", (Object)array, (Object)this.collection.toArray(array));
    }

    private void expectArrayContentsAnyOrder(Object[] expected, Object[] actual) {
        Helpers.assertEqualIgnoringOrder(Arrays.asList(expected), Arrays.asList(actual));
    }

    private void expectArrayContentsInOrder(List<E> expected, Object[] actual) {
        CollectionToArrayTester.assertEquals((String)"toArray() ordered contents: ", expected, Arrays.asList(actual));
    }

    public static Method getToArrayIsPlainObjectArrayMethod() {
        return Platform.getMethod(CollectionToArrayTester.class, "testToArray_isPlainObjectArray");
    }
}

