/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

var sampleTree = new XULTreeView();

function SampleRecord (name, gender) 
{
    this.setColumnPropertyName ("sample-name", "name");
    this.setColumnPropertyName ("sample-gender", "gender");    
    this.name = name;
    this.gender = gender;
}

SampleRecord.prototype = new XULTreeViewRecord(sampleTree.share);

sampleTree.childData.appendChild (new SampleRecord ("vinnie", "male"));
var betty = new SampleRecord ("betty", "female");
betty.reserveChildren();
betty.open()
betty.appendChild (new SampleRecord ("kid1", "male"));
var kid2 = new SampleRecord ("kid2", "male");
kid2.reserveChildren();
var kid22 = new SampleRecord ("kid22", "female");
kid2.appendChild (kid22);
betty.appendChild (kid2);
sampleTree.childData.appendChild (betty);
sampleTree.childData.appendChild (new SampleRecord ("joey", "male"));

function onload ()
{

    var tree = document.getElementById("sample-tree");
    tree.treeBoxObject.view = sampleTree;
    dt();
    //    debugger;
}

function toggleBetty ()
{
    if (betty.isHidden)
        betty.unHide();
    else
        betty.hide();
}

function formatRecord (rec, indent)
{
    var str = "";
    
    for (var i in rec._colValues)
        str += rec._colValues[i] + ", ";
    
    str += "[";
    
    str += rec.calculateVisualRow() + ", ";
    str += rec.childIndex + ", ";
    str += rec.level + ", ";
    str += rec.visualFootprint + ", ";
    str += rec.isHidden + "]";
    
    dd (indent + str);
}

function formatBranch (rec, indent)
{
    for (var i = 0; i < rec.childData.length; ++i)
    {
        formatRecord (rec.childData[i], indent);
        if ("childData" in rec.childData[i])
            formatBranch(rec.childData[i], indent + "  ");
    }
}

function nativeFrameTest()
{
    function compare(a, b)
    {
        if (a > b)
            return 1;

        if (a < b)
            return -1;

        return 0;
    };
    
    var ary = [2, 1];
    ary.sort(compare);
}

function dbg()
{
    var a = 0;
    dbg2();
    nativeFrameTest();
    var c = 0;
}

function dbg2()
{
    dd("dbg2");
    var nothere;
    var nope = null;
    var f = false;
    var i = 4;
    //@JSD_BREAK
    var d = Number.MAX_VALUE;
    var s = "hello world";
    var fun = dbg;
    //@JSD_BREAK s == "hello world"
    var obj = new Object();
    debugger;

    try
    {        
        guessThis();
        throwSomething();    
    }
    catch (ex)
    {
        dd ("caught " + ex);
    }
    
    //@JSD_EVAL alert("foo");
    var rv = returnSomething();

    //@JSD_LOG "this is a log message";

    dd ("returned " + rv);

}

function throwSomething()
{
    var str = "this is a test";
    var obj = { message: "this is only a test" };
    throw "momma from the train";
}

function returnSomething()
{
    var str = "this is a test";
    var obj = { message: "this is only a test" };
    return "your library books on time!";
}

function dt()
{
    formatBranch(sampleTree.childData, "");
}

var guessThis = 
function () 
{
    var x = 1;
    switchTest();
    observer.onFoo();
}

var observer = {
    onFoo: function (){ returnSomething(); }
}

function switchTest ()
{
    var x = 1;
    
    switch (x)
    {
        case 1:
            ++x;
            break;
            
        case 2:
            --x;
            break;
            
        default:
            x += 3;
            break;
    }
}
