/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.server;

import com.google.gwt.dev.asm.AnnotationVisitor;
import com.google.gwt.dev.asm.Attribute;
import com.google.gwt.dev.asm.ClassAdapter;
import com.google.gwt.dev.asm.ClassReader;
import com.google.gwt.dev.asm.ClassVisitor;
import com.google.gwt.dev.asm.ClassWriter;
import com.google.gwt.dev.asm.FieldVisitor;
import com.google.gwt.dev.asm.Label;
import com.google.gwt.dev.asm.MethodAdapter;
import com.google.gwt.dev.asm.MethodVisitor;
import com.google.gwt.dev.asm.Type;
import com.google.gwt.dev.asm.commons.Method;
import com.google.gwt.dev.util.Name;
import com.google.gwt.dev.util.Util;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.google.web.bindery.requestfactory.server.DefaultExceptionHandler;
import com.google.web.bindery.requestfactory.server.ExceptionHandler;
import com.google.web.bindery.requestfactory.server.Logging;
import com.google.web.bindery.requestfactory.server.RequestFactoryInterfaceValidator;
import com.google.web.bindery.requestfactory.server.RequestFactoryServlet;
import com.google.web.bindery.requestfactory.server.ServiceLayer;
import com.google.web.bindery.requestfactory.server.ServiceLayerDecorator;
import com.google.web.bindery.requestfactory.server.SimpleRequestProcessor;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.DefaultProxyStore;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyChange;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.InstanceRequest;
import com.google.web.bindery.requestfactory.shared.JsonRpcContent;
import com.google.web.bindery.requestfactory.shared.JsonRpcProxy;
import com.google.web.bindery.requestfactory.shared.JsonRpcService;
import com.google.web.bindery.requestfactory.shared.JsonRpcWireName;
import com.google.web.bindery.requestfactory.shared.Locator;
import com.google.web.bindery.requestfactory.shared.LoggingRequest;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.ProxyForName;
import com.google.web.bindery.requestfactory.shared.ProxySerializer;
import com.google.web.bindery.requestfactory.shared.ProxyStore;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.RequestTransport;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.ServiceLocator;
import com.google.web.bindery.requestfactory.shared.ServiceName;
import com.google.web.bindery.requestfactory.shared.ValueProxy;
import com.google.web.bindery.requestfactory.shared.Violation;
import com.google.web.bindery.requestfactory.shared.WriteOperation;
import com.google.web.bindery.requestfactory.vm.RequestFactorySource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestFactoryJarExtractor {
    private static final boolean VERBOSE = false;
    private static final String CODE_AND_SOURCE = "+src";
    private static final String SOURCE_ONLY = "-src";
    private static final String NATIVE_METHOD_ERROR = "Cannot call native method";
    private static final Map<String, List<Class<?>>> SEEDS = new LinkedHashMap();
    private static final Class<?>[] SERVER_CLASSES = new Class[]{DefaultExceptionHandler.class, ExceptionHandler.class, Logging.class, LoggingRequest.class, RequestFactoryServlet.class, ServiceLayer.class, ServiceLayerDecorator.class, SimpleRequestProcessor.class};
    private static final Class<?>[] SHARED_CLASSES = new Class[]{BaseProxy.class, DefaultProxyStore.class, EntityProxy.class, EntityProxyChange.class, EntityProxyId.class, InstanceRequest.class, JsonRpcContent.class, JsonRpcProxy.class, JsonRpcService.class, JsonRpcWireName.class, Locator.class, ProxyFor.class, ProxyForName.class, ProxySerializer.class, ProxyStore.class, Receiver.class, Request.class, RequestContext.class, RequestFactory.class, RequestTransport.class, ServerFailure.class, Service.class, ServiceLocator.class, ServiceName.class, ValueProxy.class, Violation.class, WriteOperation.class, RequestFactorySource.class, SimpleEventBus.class};
    private static final int MAX_THREADS = 4;
    private boolean executionFailed = false;
    private final Emitter emitter;
    private final ExecutorService ex;
    private final BlockingQueue<Future<?>> inProcess = new LinkedBlockingQueue();
    private final RequestFactoryInterfaceValidator.ErrorContext logger;
    private final RequestFactoryInterfaceValidator.Loader loader;
    private final Mode mode;
    private final List<Class<?>> seeds;
    private final Map<Type, Type> seen = new ConcurrentHashMap<Type, Type>();
    private final Set<String> sources = new ConcurrentSkipListSet<String>();
    private final ExecutorService writerService;

    public static void main(String[] args) throws IOException {
        String target;
        List<Class<?>> seeds;
        if (args.length < 2) {
            System.err.println("Usage: java -cp gwt-dev.jar:gwt-user.jar:json.jar" + RequestFactoryJarExtractor.class.getCanonicalName() + " <target-name> outfile.jar");
            System.err.println("Valid targets:");
            for (String target2 : SEEDS.keySet()) {
                System.err.println("  " + target2);
            }
            System.exit(1);
        }
        if ((seeds = SEEDS.get(target = args[0])) == null) {
            System.err.println("Unknown target: " + target);
            System.exit(1);
        }
        Mode mode = Mode.match(target);
        Logger errorContext = Logger.getLogger(RequestFactoryJarExtractor.class.getName());
        RequestFactoryInterfaceValidator.ClassLoaderLoader classLoader = new RequestFactoryInterfaceValidator.ClassLoaderLoader(Thread.currentThread().getContextClassLoader());
        JarEmitter jarEmitter = new JarEmitter(new File(args[1]));
        RequestFactoryJarExtractor extractor = new RequestFactoryJarExtractor(errorContext, classLoader, jarEmitter, seeds, mode);
        extractor.run();
        System.exit(extractor.isExecutionFailed() ? 1 : 0);
    }

    private static String getPackagePath(Type t) {
        String name = t.getInternalName();
        return name.substring(0, name.lastIndexOf(47) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean visit(RequestFactoryInterfaceValidator.ErrorContext logger, RequestFactoryInterfaceValidator.Loader loader, String internalName, ClassVisitor visitor) {
        block17: {
            boolean bl;
            assert (Name.isInternalName(internalName)) : "internalName";
            logger.spam("Visiting " + internalName, new Object[0]);
            InputStream inputStream = null;
            try {
                inputStream = loader.getResourceAsStream(internalName + ".class");
                if (inputStream == null) {
                    System.err.println("Could not find class file for " + internalName);
                    logger.poison("Could not find class file for " + internalName, new Object[0]);
                    boolean bl2 = false;
                    return bl2;
                }
                ClassReader reader = new ClassReader(inputStream);
                reader.accept(visitor, 0);
                bl = true;
            }
            catch (IOException e) {
                logger.poison("Unable to open " + internalName, e);
                break block17;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return bl;
        }
        return false;
    }

    public RequestFactoryJarExtractor(Logger logger, RequestFactoryInterfaceValidator.Loader loader, Emitter emitter, List<Class<?>> seeds, Mode mode) {
        this.logger = new RequestFactoryInterfaceValidator.ErrorContext(logger);
        this.loader = loader;
        this.emitter = emitter;
        this.seeds = seeds;
        this.mode = mode;
        int numThreads = Math.min(4, Runtime.getRuntime().availableProcessors());
        this.ex = Executors.newFixedThreadPool(numThreads);
        this.writerService = Executors.newSingleThreadExecutor();
    }

    public void run() throws IOException {
        for (Class<?> seed : this.seeds) {
            this.processType("seeds", Type.getType(seed));
        }
        while (!this.inProcess.isEmpty()) {
            try {
                Future<?> task = this.inProcess.take();
                task.get();
            }
            catch (InterruptedException retry) {
            }
            catch (ExecutionException e) {
                e.getCause().printStackTrace();
                this.executionFailed = true;
            }
        }
        this.emitter.close();
    }

    private void emit(State state) {
        this.inProcess.add(this.writerService.submit(new EmitOneType(state)));
    }

    private boolean isExecutionFailed() {
        return this.executionFailed;
    }

    private Object processConstant(String sourceType, Object value) {
        if (value instanceof Type) {
            value = this.processType(sourceType, (Type)value);
        }
        return value;
    }

    private String processDescriptor(String sourceType, String desc) {
        if (desc == null) {
            return null;
        }
        return this.processType(sourceType, Type.getType(desc)).getDescriptor();
    }

    private String processInternalName(String sourceType, String internalName) {
        if (internalName == null) {
            return null;
        }
        return this.processType(sourceType, Type.getObjectType(internalName)).getInternalName();
    }

    private Method processMethod(String sourceType, String name, String desc) {
        Method method = new Method(name, desc);
        Type[] argumentTypes = method.getArgumentTypes();
        int j = argumentTypes.length;
        for (int i = 0; i < j; ++i) {
            argumentTypes[i] = this.processType(sourceType, argumentTypes[i]);
        }
        method = new Method(name, this.processType(sourceType, method.getReturnType()), argumentTypes);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type processType(String sourceType, Type type) {
        Type toReturn;
        Map<Type, Type> map = this.seen;
        synchronized (map) {
            toReturn = this.seen.get(type);
            if (toReturn != null) {
                return toReturn;
            }
            toReturn = Type.getType(type.getDescriptor());
            this.seen.put(type, toReturn);
        }
        int sort = type.getSort();
        if (sort != 10 && sort != 9) {
            return toReturn;
        }
        if (sort == 9) {
            this.processType(sourceType, type.getElementType());
            return toReturn;
        }
        assert (type.getInternalName().charAt(0) != 'L');
        if (type.getInternalName().startsWith("java/") || type.getInternalName().startsWith("javax/")) {
            return toReturn;
        }
        Future<State> future = this.ex.submit(new ProcessOneType(type));
        this.inProcess.add(future);
        return toReturn;
    }

    static {
        List<Class<?>> sharedClasses = Arrays.asList(SHARED_CLASSES);
        ArrayList clientClasses = new ArrayList();
        clientClasses.addAll(sharedClasses);
        ArrayList serverClasses = new ArrayList();
        serverClasses.addAll(Arrays.asList(SERVER_CLASSES));
        serverClasses.addAll(sharedClasses);
        SEEDS.put("client", Collections.unmodifiableList(clientClasses));
        SEEDS.put("server", Collections.unmodifiableList(serverClasses));
        LinkedHashSet all = new LinkedHashSet();
        for (List<Class<?>> value : SEEDS.values()) {
            all.addAll(value);
        }
        SEEDS.put("all", Collections.unmodifiableList(new ArrayList(all)));
        for (String target : new ArrayList<String>(SEEDS.keySet())) {
            SEEDS.put(target + SOURCE_ONLY, SEEDS.get(target));
            SEEDS.put(target + CODE_AND_SOURCE, SEEDS.get(target));
        }
        try {
            SEEDS.put("test+src", Collections.unmodifiableList(Arrays.asList(Class.forName("com.google.web.bindery.requestfactory.vm.RequestFactoryJreSuite"), Class.forName("com.google.web.bindery.requestfactory.server.SimpleBar"))));
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
    }

    private static class State {
        boolean containsNativeMethods;
        InputStream contents;
        String source;
        Type type;
        final Type originalType;

        public State(Type type) {
            this.originalType = this.type = type;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.type.getInternalName());
            if (this.containsNativeMethods) {
                sb.append(" NATIVE");
            }
            if (this.source != null) {
                sb.append(" ").append(this.source);
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessOneType
    implements Callable<State> {
        private final State state;
        private final String typeName;

        public ProcessOneType(Type type) {
            this.state = new State(type);
            this.typeName = type.getClassName();
        }

        @Override
        public State call() {
            ClassWriter writer;
            ClassVisitor cv = writer = new ClassWriter(0);
            cv = new ClassProcessor(this.typeName, cv, this.state);
            cv = new NativeMethodDefanger(cv);
            RequestFactoryJarExtractor.visit(RequestFactoryJarExtractor.this.logger.setType(this.state.type), RequestFactoryJarExtractor.this.loader, this.state.type.getInternalName(), cv);
            this.state.contents = new ByteArrayInputStream(writer.toByteArray());
            assert (RequestFactoryJarExtractor.this.seen.containsKey(this.state.originalType)) : "No type for " + this.state.type.getClassName();
            this.state.type = (Type)RequestFactoryJarExtractor.this.seen.get(this.state.originalType);
            RequestFactoryJarExtractor.this.emit(this.state);
            return this.state;
        }
    }

    private class NativeMethodDefanger
    extends ClassAdapter {
        public NativeMethodDefanger(ClassVisitor cv) {
            super(cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 0x100) != 0) {
                MethodVisitor mv = super.visitMethod(access & 0xFFFFFEFF, name, desc, signature, exceptions);
                if (mv != null) {
                    mv.visitCode();
                    String exceptionName = Type.getInternalName(RuntimeException.class);
                    mv.visitTypeInsn(187, exceptionName);
                    mv.visitInsn(89);
                    mv.visitLdcInsn(RequestFactoryJarExtractor.NATIVE_METHOD_ERROR);
                    mv.visitMethodInsn(183, exceptionName, "<init>", "(Ljava/lang/String;)V");
                    mv.visitInsn(191);
                    int numSlots = 0;
                    for (Type t : Type.getArgumentTypes(desc)) {
                        numSlots += t.getSize();
                    }
                    if ((access & 8) == 0) {
                        ++numSlots;
                    }
                    mv.visitMaxs(3, numSlots);
                    mv.visitEnd();
                }
                return null;
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }

    private class MethodProcessor
    extends MethodAdapter {
        private final String sourceType;

        public MethodProcessor(String sourceType, MethodVisitor mv) {
            super(mv);
            this.sourceType = sourceType;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            return super.visitAnnotation(desc, visible);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationProcessor(this.sourceType, super.visitAnnotationDefault());
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            owner = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, owner);
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            int i;
            int j = local.length;
            for (i = 0; i < j; ++i) {
                if (!(local[i] instanceof String)) continue;
                local[i] = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, (String)local[i]);
            }
            j = stack.length;
            for (i = 0; i < j; ++i) {
                if (!(stack[i] instanceof String)) continue;
                stack[i] = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, (String)stack[i]);
            }
            super.visitFrame(type, nLocal, local, nStack, stack);
        }

        public void visitLdcInsn(Object cst) {
            cst = RequestFactoryJarExtractor.this.processConstant(this.sourceType, cst);
            super.visitLdcInsn(cst);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            owner = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, owner);
            desc = RequestFactoryJarExtractor.this.processMethod(this.sourceType, name, desc).getDescriptor();
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            super.visitMultiANewArrayInsn(desc, dims);
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            return super.visitParameterAnnotation(parameter, desc, visible);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            type = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, type);
            super.visitTryCatchBlock(start, end, handler, type);
        }

        public void visitTypeInsn(int opcode, String type) {
            type = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, type);
            super.visitTypeInsn(opcode, type);
        }
    }

    private class FieldProcessor
    implements FieldVisitor {
        private final String sourceType;
        private final FieldVisitor fv;

        public FieldProcessor(String sourceType, FieldVisitor fv) {
            this.sourceType = sourceType;
            this.fv = fv;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationProcessor(this.sourceType, this.fv.visitAnnotation(desc, visible));
        }

        public void visitAttribute(Attribute attr) {
            this.fv.visitAttribute(attr);
        }

        public void visitEnd() {
            this.fv.visitEnd();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmitOneType
    implements Callable<Void> {
        private final State state;

        private EmitOneType(State state) {
            this.state = state;
        }

        @Override
        public Void call() throws Exception {
            if (RequestFactoryJarExtractor.this.mode.isEmitClasses()) {
                String fileName = this.state.type.getInternalName();
                if (fileName == null) {
                    System.err.println("Got null filename from " + this.state.type);
                    return null;
                }
                fileName = fileName + ".class";
                RequestFactoryJarExtractor.this.emitter.emit(fileName, this.state.contents);
            }
            if (RequestFactoryJarExtractor.this.mode.isEmitSource()) {
                String sourcePath = RequestFactoryJarExtractor.getPackagePath(this.state.originalType) + this.state.source;
                String destPath = RequestFactoryJarExtractor.getPackagePath(this.state.type) + this.state.source;
                if (RequestFactoryJarExtractor.this.sources.add(sourcePath) && RequestFactoryJarExtractor.this.loader.exists(sourcePath)) {
                    String contents = Util.readStreamAsString((InputStream)RequestFactoryJarExtractor.this.loader.getResourceAsStream(sourcePath));
                    RequestFactoryJarExtractor.this.emitter.emit(destPath, new ByteArrayInputStream(Util.getBytes((String)contents)));
                }
            }
            return null;
        }
    }

    private class ClassProcessor
    extends ClassAdapter {
        private State state;
        private String sourceType;

        public ClassProcessor(String sourceType, ClassVisitor cv, State state) {
            super(cv);
            this.sourceType = sourceType;
            this.state = state;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            name = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, name);
            superName = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, superName);
            if (interfaces != null) {
                int j = interfaces.length;
                for (int i = 0; i < j; ++i) {
                    interfaces[i] = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, interfaces[i]);
                }
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            return new AnnotationProcessor(this.sourceType, super.visitAnnotation(desc, visible));
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            return new FieldProcessor(this.sourceType, super.visitField(access, name, desc, signature, value));
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            name = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, name);
            outerName = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, outerName);
            super.visitInnerClass(name, outerName, innerName, access);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv;
            Method method = RequestFactoryJarExtractor.this.processMethod(this.sourceType, name, desc);
            desc = method.getDescriptor();
            if (exceptions != null) {
                int j = exceptions.length;
                for (int i = 0; i < j; ++i) {
                    exceptions[i] = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, exceptions[i]);
                }
            }
            if ((mv = super.visitMethod(access, name, desc, signature, exceptions)) != null) {
                mv = new MethodProcessor(this.sourceType, mv);
            }
            return mv;
        }

        public void visitOuterClass(String owner, String name, String desc) {
            owner = RequestFactoryJarExtractor.this.processInternalName(this.sourceType, owner);
            if (desc != null) {
                desc = RequestFactoryJarExtractor.this.processMethod(this.sourceType, name, desc).getDescriptor();
            }
            super.visitOuterClass(owner, name, desc);
        }

        public void visitSource(String source, String debug) {
            if (source != null) {
                this.state.source = source;
            }
            super.visitSource(source, debug);
        }
    }

    private class AnnotationProcessor
    implements AnnotationVisitor {
        private final String sourceType;
        private final AnnotationVisitor av;

        public AnnotationProcessor(String sourceType, AnnotationVisitor av) {
            this.sourceType = sourceType;
            this.av = av;
        }

        public void visit(String name, Object value) {
            value = RequestFactoryJarExtractor.this.processConstant(this.sourceType, value);
            this.av.visit(name, value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            return new AnnotationProcessor(desc, this.av.visitAnnotation(name, desc));
        }

        public AnnotationVisitor visitArray(String name) {
            return new AnnotationProcessor(name, this.av.visitArray(name));
        }

        public void visitEnd() {
            this.av.visitEnd();
        }

        public void visitEnum(String name, String desc, String value) {
            desc = RequestFactoryJarExtractor.this.processDescriptor(this.sourceType, desc);
            this.av.visitEnum(name, desc, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        BOTH(true, true){

            protected boolean matches(String target) {
                return target.endsWith(RequestFactoryJarExtractor.CODE_AND_SOURCE);
            }
        }
        ,
        SOURCE(false, true){

            protected boolean matches(String target) {
                return target.endsWith(RequestFactoryJarExtractor.SOURCE_ONLY);
            }
        }
        ,
        CLASSES(true, false){

            protected boolean matches(String target) {
                return true;
            }
        };

        private final boolean emitClasses;
        private final boolean emitSource;

        public static Mode match(String target) {
            for (Mode mode : Mode.values()) {
                if (!mode.matches(target)) continue;
                return mode;
            }
            return null;
        }

        private Mode(boolean emitClasses, boolean emitSource) {
            this.emitClasses = emitClasses;
            this.emitSource = emitSource;
        }

        public boolean isEmitClasses() {
            return this.emitClasses;
        }

        public boolean isEmitSource() {
            return this.emitSource;
        }

        protected abstract boolean matches(String var1);
    }

    public static class JarEmitter
    implements Emitter {
        private int rawByteSize;
        private final JarOutputStream out;

        public JarEmitter(File outFile) throws IOException {
            Manifest m = new Manifest();
            m.getMainAttributes().putValue("Created-By", RequestFactoryJarExtractor.class.getCanonicalName());
            m.getMainAttributes();
            this.out = new JarOutputStream((OutputStream)new FileOutputStream(outFile), m);
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void emit(String path, InputStream contents) throws IOException {
            int read;
            ZipEntry entry = new ZipEntry(path);
            this.out.putNextEntry(entry);
            byte[] bytes = new byte[4096];
            while ((read = contents.read(bytes)) != -1) {
                this.rawByteSize += read;
                this.out.write(bytes, 0, read);
            }
            this.out.closeEntry();
        }
    }

    public static interface Emitter {
        public void close() throws IOException;

        public void emit(String var1, InputStream var2) throws IOException;
    }
}

