/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.RoleDelRequest;
import com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteRoleRequest;
import com.amazonaws.services.identitymanagement.model.InstanceProfile;
import com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest;
import com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleResult;
import com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListRolePoliciesResult;
import com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMRoleDelDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMRoleDelDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof RoleDelRequest) {
            LOG.debug((Object)("Deleting role " + request));
            RoleDelRequest req = (RoleDelRequest)request;
            boolean noop = req.isNoop();
            if (req.isRecursive()) {
                ListInstanceProfilesForRoleRequest iipListRequest = new ListInstanceProfilesForRoleRequest();
                iipListRequest.setRoleName(req.getRoleName());
                ListInstanceProfilesForRoleResult iipListResult = this.getClient().listInstanceProfilesForRole(iipListRequest);
                if (iipListResult.getInstanceProfiles() != null && !iipListResult.getInstanceProfiles().isEmpty()) {
                    if (noop) {
                        LOG.info((Object)"instance profiles");
                        for (InstanceProfile iProfile : iipListResult.getInstanceProfiles()) {
                            LOG.info((Object)("\t" + iProfile.getArn()));
                        }
                    } else {
                        LOG.debug((Object)"Removing roles from instance profiles");
                        RemoveRoleFromInstanceProfileRequest roleRemoveRequest = new RemoveRoleFromInstanceProfileRequest();
                        roleRemoveRequest.setRoleName(req.getRoleName());
                        for (InstanceProfile iProfile : iipListResult.getInstanceProfiles()) {
                            roleRemoveRequest.setInstanceProfileName(iProfile.getInstanceProfileName());
                            LOG.debug((Object)("Removing from instance profile " + iProfile.getInstanceProfileName()));
                            this.getClient().removeRoleFromInstanceProfile(roleRemoveRequest);
                        }
                    }
                }
                ListRolePoliciesRequest listPoliciesRequest = new ListRolePoliciesRequest();
                listPoliciesRequest.setRoleName(req.getRoleName());
                LOG.debug((Object)"Listing policies in role");
                ListRolePoliciesResult listPoliciesResult = this.getClient().listRolePolicies(listPoliciesRequest);
                if (!listPoliciesResult.getPolicyNames().isEmpty()) {
                    if (noop) {
                        LOG.info((Object)"Policies");
                        for (String policy : listPoliciesResult.getPolicyNames()) {
                            LOG.info((Object)("\t" + policy));
                        }
                    } else {
                        DeleteRolePolicyRequest deletePolicyRequest = new DeleteRolePolicyRequest();
                        deletePolicyRequest.setRoleName(req.getRoleName());
                        for (String policy : listPoliciesResult.getPolicyNames()) {
                            deletePolicyRequest.setPolicyName(policy);
                            LOG.debug((Object)("Deleting policy " + policy));
                            this.getClient().deleteRolePolicy(deletePolicyRequest);
                        }
                    }
                }
            }
            if (!noop) {
                DeleteRoleRequest deleteRoleRequest = new DeleteRoleRequest();
                deleteRoleRequest.setRoleName(req.getRoleName());
                LOG.debug((Object)"Deleting role");
                this.getClient().deleteRole(deleteRoleRequest);
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

